/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.JComboButtonCell;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisPlotInfo;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;
import se.prediktera.map.plot.plotgenerator.PlotTypePanel;

public class AxisChooseWizard
extends WizardPageClass {
    private static final String[] names = new String[]{"Observation classes", "Variables classes"};
    private final JPanel axisPanel = new JPanel(new GridBagLayout());
    private PlotInit plotInit;
    private String[] axisNames = null;
    private final JComboBox boxObsOrVar = new JComboBox();
    private final JComboBoxCell boxClassType = new JComboBoxCell();
    private final JComboBox boxClass = new JComboBox();
    private final int axisCount;
    private final int startAxis;
    private PlotTypePanel plotTypePanel = new PlotTypePanel(this);
    private int currentType = -1;
    private final JComboBoxCell scriptComboBox = new JComboBoxCell();
    private int maxdefaultindex = 0;

    public AxisChooseWizard(AbstractAxisPlotInfo abstractAxisPlotInfo, int n, int n2) {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.axisCount = n;
        this.startAxis = n2;
        if (n > 0) {
            this.axisPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Data Range"));
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Create from Class"));
        ComboBoxChanged comboBoxChanged = new ComboBoxChanged();
        this.boxClassType.addItemListener(comboBoxChanged);
        this.boxClassType.setEnabled(false);
        this.boxClass.addItem(new ComboItem("None", 0, Boolean.TRUE));
        this.boxClass.addItem(new ComboItem("Layer", 1, Boolean.FALSE));
        this.boxClass.addItem(new ComboItem("Color", 2, Boolean.TRUE));
        this.boxClass.addItem(new ComboItem("Shape", 3, Boolean.TRUE));
        this.boxClass.addItemListener(comboBoxChanged);
        this.boxClass.addItemListener(itemEvent -> {
            boolean bl = this.boxClass.getSelectedIndex() > 0;
            this.boxObsOrVar.setEnabled(bl && this.boxObsOrVar.getItemCount() > 1);
            this.boxClassType.setEnabled(bl && this.boxClassType.getItemCount() > 1);
            this.updateWizardButtons(false);
        });
        this.boxClass.setPreferredSize(new Dimension(100, 20));
        this.boxObsOrVar.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1 && this.plotInit.filterRoot instanceof AbstractDataNode) {
                this.setClasses((AbstractDataNode)this.plotInit.filterRoot);
                this.updateWizardButtons(false);
            }
        });
        this.boxObsOrVar.setEnabled(false);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(EvinceBorderFactory.createEvinceBorder("Choose template"));
        jPanel3.add((Component)new JLabel("Template:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel3.add((Component)this.scriptComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 6, 12), 0, 0));
        if (abstractAxisPlotInfo.supportScript()) {
            this.scriptComboBox.addItemListener(itemEvent -> {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = this.scriptComboBox.getSelectedItem()) instanceof AbstractScriptInfo) {
                    AbstractScriptInfo abstractScriptInfo;
                    this.plotInit.scriptInfo = abstractScriptInfo = (AbstractScriptInfo)object;
                }
            });
        } else {
            this.scriptComboBox.setEnabled(false);
        }
        if (n > 0) {
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Select Data Range(s) and Options"));
        } else {
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Options"));
        }
        jPanel2.add((Component)new JLabel("Create:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)this.boxClass, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)new JLabel("From:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        jPanel2.add((Component)this.boxObsOrVar, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel2.add((Component)new JLabel("Category:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 6, 0), 0, 0));
        jPanel2.add((Component)this.boxClassType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        jPanel.add((Component)this.axisPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.plotTypePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(""), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, "Center");
    }

    public void beginWizard(PlotInit plotInit, String[] stringArray) {
        this.plotInit = plotInit;
        this.axisNames = stringArray;
        this.plotTypePanel.setPlotInit(plotInit);
        this.setWithData(plotInit);
        String string = EvinceScriptCommands.removeSpace(plotInit.plotName);
        this.maxdefaultindex = ScriptManager.addScriptInfoComboBox(this.scriptComboBox, "plot", string, plotInit);
    }

    @Override
    public boolean canNext() {
        if (this.boxClass.getSelectedIndex() >= 1 && this.boxClassType.getItemCount() == 0) {
            return false;
        }
        return super.canNext();
    }

    public void saveTemplate() {
        if (this.plotInit != null && this.plotInit.plotName != null && this.plotInit.scriptInfo != null) {
            String string = EvinceScriptCommands.removeSpace(this.plotInit.plotName);
            IniManager.setScriptSettings("SCRIPT_PLOT_" + string.toUpperCase() + "_DEFAULT_" + this.maxdefaultindex, this.plotInit.scriptInfo.toString());
        }
    }

    public void setWithData(PlotInit plotInit) {
        this.boxObsOrVar.removeAllItems();
        int n = plotInit.getPlotIndex();
        if (plotInit.supportSecondaryIndex && plotInit.isSecondaryMatrixTagObsVar() && !plotInit.dofold) {
            this.boxObsOrVar.addItem(names[0]);
            this.boxObsOrVar.addItem(names[1]);
        } else {
            this.boxObsOrVar.addItem(names[n]);
        }
        if (this.axisCount > 0) {
            this.boxObsOrVar.setEnabled(false);
            if (plotInit.getPlotIndex() == 0) {
                this.boxObsOrVar.setSelectedItem(names[0]);
            } else {
                this.boxObsOrVar.setSelectedItem(names[1]);
            }
        } else {
            this.boxObsOrVar.setEnabled(this.boxClass.getSelectedIndex() > 0);
        }
        this.setAxis();
    }

    @Override
    protected void cleanUpChild() {
        this.plotTypePanel = null;
        this.plotInit = null;
    }

    private String getAxisName(int n) {
        if (this.axisNames == null || n < 0 || n >= this.axisNames.length) {
            return switch (n) {
                case 0 -> "X Axis:";
                case 1 -> "Y Axis:";
                case 2 -> "Z Axis:";
                default -> "? Axis:";
            };
        }
        return this.axisNames[n];
    }

    private byte getClassBy() {
        byte by = (byte)((ComboItem)this.boxClass.getSelectedItem()).getType();
        if (by == 1 && this.boxObsOrVar.getSelectedIndex() == 1) {
            return 4;
        }
        return by;
    }

    private void setAxis() {
        if (this.plotInit.plotType == this.currentType) {
            return;
        }
        this.currentType = this.plotInit.plotType;
        this.axisPanel.removeAll();
        for (int i = this.startAxis; i < this.startAxis + this.axisCount; ++i) {
            AxisComboBox axisComboBox = new AxisComboBox(this.plotInit.getMatrix(i), i, this.plotInit.axisPos[i]);
            int n = i + 1 == this.axisCount ? 6 : 0;
            this.axisPanel.add((Component)new JLabel(this.getAxisName(i)), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, n, 6), 0, 0));
            this.axisPanel.add((Component)axisComboBox, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 15, 2, new Insets(6, 6, n, 6), 0, 0));
        }
        this.axisPanel.validate();
        if (this.plotInit.filterRoot instanceof AbstractDataNode) {
            this.setClasses((AbstractDataNode)this.plotInit.filterRoot);
        }
    }

    private void setClasses(AbstractDataNode abstractDataNode) {
        DataSet dataSet = (DataSet)DataTreeManager.getAncestorNull(abstractDataNode, DataSet.class);
        Case case_ = abstractDataNode.getCase();
        if (dataSet != null || case_ != null) {
            String string = (String)this.boxObsOrVar.getSelectedItem();
            int n = names[0].equals(string) ? 0 : 1;
            AbstractDataInfo abstractDataInfo = dataSet != null ? dataSet.getDataInfo(n) : case_.getDataInfo(n);
            Transformations transformations = (Transformations)abstractDataInfo.getGroupColumnByType(10);
            int n2 = this.boxClassType.getSelectedIndex();
            this.boxClassType.removeAllItems();
            int n3 = transformations.getColumnCount();
            for (int i = 0; i < n3; ++i) {
                if (transformations.getColumnType(i) != 4) continue;
                this.boxClassType.addItem(transformations.getInnerColumn(i));
            }
            PredictionClasses predictionClasses = (PredictionClasses)abstractDataInfo.getGroupColumnByType(11);
            if (predictionClasses != null && predictionClasses.getColumnCount() > 0) {
                if (this.boxClassType.getItemCount() > 0) {
                    this.boxClassType.addSeparator();
                }
                for (int i = 0; i < predictionClasses.getColumnCount(); ++i) {
                    this.boxClassType.addItem(predictionClasses.getInnerColumn(i));
                }
            }
            if (n2 >= 0 && n2 < this.boxClassType.getItemCount()) {
                this.boxClassType.setSelectedIndex(n2);
            }
        }
        boolean bl = this.boxClass.getSelectedIndex() > 0;
        this.boxClassType.setEnabled(bl && this.boxClassType.getItemCount() > 1);
    }

    private class ComboBoxChanged
    implements ItemListener {
        private ComboBoxChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (AxisChooseWizard.this.plotInit != null) {
                AxisChooseWizard.this.plotInit.createclassby = AxisChooseWizard.this.getClassBy();
                AxisChooseWizard.this.plotInit.classColumn = (InnerColumnClass)AxisChooseWizard.this.boxClassType.getSelectedItem();
                AxisChooseWizard.this.plotInit.classColumnIndex = AxisChooseWizard.this.boxClassType.getSelectedIndex();
            }
        }
    }

    private class AxisComboBox
    extends JComboButtonCell
    implements ItemListener {
        private final int axis;

        public AxisComboBox(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
            super(new BoxModel(abstractDataMatrix));
            this.axis = n;
            this.setSelectedIndex(n2 + 2);
            this.addItemListener(this);
            this.button.setVisible(false);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (this.getSelectedIndex() == 1) {
                    this.setSelectedIndex(0);
                } else {
                    AxisChooseWizard.this.plotInit.axisPos[this.axis] = ((JComboBox)itemEvent.getSource()).getSelectedIndex() - 2;
                }
            }
        }
    }

    private class BoxModel
    implements ComboBoxModel {
        private final AbstractDataMatrix matrix;
        private String selected = null;

        public BoxModel(AbstractDataMatrix abstractDataMatrix) {
            this.matrix = abstractDataMatrix;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public Object getElementAt(int n) {
            if (n == 0) {
                return SettingsBoxInterface.INDEXSTRING;
            }
            if (n == 1) {
                return "%SEPARATOR#";
            }
            n -= 2;
            String string = "N/A";
            if (this.matrix.isModel()) {
                string = this.matrix.getRowDescription(n, 0);
            } else {
                int n2 = AxisChooseWizard.this.plotInit.plotType;
                if (n2 == 1) {
                    string = this.matrix.getColumnDescription(n, 0);
                } else if (n2 == 2) {
                    string = this.matrix.getRowDescription(n, 0);
                }
            }
            return string;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            int n = 0;
            if (this.matrix != null) {
                if (this.matrix.isModel()) {
                    n = this.matrix.getN();
                } else {
                    int n2 = AxisChooseWizard.this.plotInit.plotType;
                    if (n2 == 1) {
                        n = this.matrix.getK();
                    } else if (n2 == 2) {
                        n = this.matrix.getN();
                    }
                }
            }
            if (n > 0) {
                ++n;
            }
            return n + 1;
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object instanceof String) {
                this.selected = (String)object;
            }
        }
    }
}

