/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.ActionToolbar;
import se.prediktera.map.plot.axisplot.PlotSelectionToolbar;
import se.prediktera.map.plot.axisplot.PlotZoomToolbar;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandEllipse;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandFreehand;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandLine;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandRectangle;

public abstract class AxisPlotRubberband
extends AbstractAxisPlot {
    protected PlotZoomToolbar zoomToolbar;
    protected ActionToolbar actionToolbar;
    protected PlotSelectionToolbar plotSelectionToolbar;
    protected boolean panview = false;
    protected byte zoomType = (byte)-1;
    protected byte selectionType = 0;

    public AxisPlotRubberband(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.init();
    }

    public AxisPlotRubberband(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init();
    }

    @Override
    public void getToolbars(Vector<JToolBar> vector) {
        super.getToolbars(vector);
        vector.add(this.plotSelectionToolbar);
        vector.add(this.zoomToolbar);
        if (this.actionToolbar != null) {
            vector.add(this.actionToolbar);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        ZoneLeaf zoneLeaf;
        if (mouseEvent != null && (zoneLeaf = this.getLeafAt(mouseEvent.getPoint())) != null) {
            this.doQuickInteraction(zoneLeaf);
            return this.getToolTip(zoneLeaf);
        }
        return null;
    }

    public boolean isOverPlot(int n, int n2) {
        return true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.doQuickInteraction(null);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        this.setCursorBasedOnMouse(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
            if (this.rubberband != null && this.rubberband.isReady()) {
                this.rubberbandEnded(this.rubberband, mouseEvent.getModifiersEx());
                this.rubberband.clear();
            }
            this.setCursorBasedOnMouse(mouseEvent);
            mouseEvent.consume();
        }
    }

    public void rubberbandEnded(AbstractRubberband abstractRubberband, int n) {
        Object object;
        boolean bl;
        Rectangle rectangle = abstractRubberband.getBoundingBox();
        boolean bl2 = (n & 0x40) == 64;
        boolean bl3 = bl = (n & 0x80) == 128;
        if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            if (!bl && !bl2) {
                this.selectedItems(this.selectionList, false, false);
            }
            object = this.collectRectangleFromScreen(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false, abstractRubberband.getRubberType());
            Iterator iterator = ((AbstractSequentialList)object).iterator();
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            boolean bl4 = this.mustBeBoundedInSelection();
            while (iterator.hasNext()) {
                ZoneLeaf zoneLeaf = (ZoneLeaf)iterator.next();
                this.translateToScreenInt(zoneLeaf, nArray, 0);
                if (bl4 && !abstractRubberband.isInside(nArray[0], nArray[1])) continue;
                if (bl && zoneLeaf.isSelected()) {
                    if (!bl2) continue;
                    zoneLeaf.setSelected(false);
                    this.selectionList.remove(zoneLeaf);
                    continue;
                }
                if (bl && bl2 || zoneLeaf.isSelected() || !zoneLeaf.isVisible()) continue;
                if (abstractRubberband.multipleSelection() || this.selectionList.isEmpty()) {
                    this.selectionList.add(zoneLeaf);
                    continue;
                }
                int n2 = rectangle.x + rectangle.width / 2;
                int n3 = rectangle.y + rectangle.height / 2;
                ZoneLeaf zoneLeaf2 = (ZoneLeaf)this.selectionList.get(0);
                this.translateToScreenInt(zoneLeaf2, nArray2, 0);
                int n4 = Math.abs(nArray2[0] - n2) + Math.abs(nArray2[1] - n3);
                int n5 = Math.abs(nArray[0] - n2) + Math.abs(nArray[1] - n3);
                if (n5 >= n4) continue;
                this.selectionList.set(0, zoneLeaf);
            }
            this.selectedItems(this.selectionList, true, true);
            this.repaintPlot((byte)2);
        } else if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Zoom) {
            if (abstractRubberband instanceof RubberbandNormal) {
                object = (RubberbandNormal)abstractRubberband;
                double d = ((RubberbandNormal)object).getBWidth() == 0 ? -3.0 : 3.0;
                double[] dArray = this.translateToPlot(rectangle.x, rectangle.y, this.getPlotUnderCoords(rectangle.x, rectangle.y));
                this.ZoomContinues(dArray[0], dArray[1], d, this.getPlotUnderCoords(rectangle.x, rectangle.y));
            } else {
                double[] dArray;
                int n6 = this.getPlotUnderCoords(rectangle.x, rectangle.y);
                double[] dArray2 = this.translateToPlot(rectangle.x, rectangle.y + rectangle.height, n6);
                if (Double.compare(dArray2[0], (dArray = this.translateToPlot(rectangle.x + rectangle.width, rectangle.y, n6))[0]) == 0 || Double.compare(dArray2[1], dArray[1]) == 0) {
                    double d = bl2 || bl ? 3.0 : -3.0;
                    double[] dArray3 = this.translateToPlot(rectangle.x, rectangle.y, n6);
                    this.ZoomContinues(dArray3[0], dArray3[1], d, n6);
                } else {
                    this.getRange(0, 0).setMinMax(dArray2[0], dArray[0]);
                    this.getRange(1, 0).setMinMax(dArray2[1], dArray[1]);
                    this.getRange(0, 0).adjust(true);
                    this.getRange(1, 0).adjust(false);
                }
            }
            this.calculateAndRepaintSetAxis(true, false);
        }
        object = this.getDataTreeManager();
        if (object != null) {
            ((DataTreeManager)object).setProjectChanged();
        }
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        return switch (by) {
            case 1 -> this.zoomToolbar.sendGlobalMessage(by2);
            case 2 -> this.plotSelectionToolbar.sendGlobalMessage(by2);
            default -> super.SendGlobalMessage(by, by2);
        };
    }

    @Override
    public void setPanview(boolean bl) {
        this.setPanview(bl, true);
    }

    public void setPanview(boolean bl, boolean bl2) {
        this.panview = bl;
        if (bl) {
            this.setCursor(this.zoomToolbar.getCursor((byte)5));
            if (bl2) {
                this.PostGlobalMessage((byte)1, (byte)5);
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setSelection(byte by) {
        if (by == 8) {
            this.selectionType = (byte)8;
            this.setRubberband(null);
            return;
        }
        if (by == 0) {
            this.setRubberband(new RubberbandNormal(this, this.getHandWidth(), AbstractRubberband.RubberAction.Selection));
        } else if (by == 1) {
            this.setRubberband(new RubberbandRectangle(this, AbstractRubberband.RubberAction.Selection));
        } else if (by == 2) {
            this.setRubberband(new RubberbandEllipse(this));
        } else if (by == 5) {
            this.setRubberband(new RubberbandFreehand(this));
        } else if (by == 6) {
            this.setRubberband(new RubberbandLine(this));
        }
        if (this.selectionType != by) {
            this.selectionType = by;
            this.PostGlobalMessage((byte)2, by);
        }
    }

    @Override
    public void setSelectionTool(String string) {
        this.plotSelectionToolbar.setSelectionTool(string);
    }

    @Override
    public void setZooming(byte by) {
        this.zoomType = by;
        if (by == -1) {
            this.setRubberband(null);
            return;
        }
        this.PostGlobalMessage((byte)1, by);
    }

    protected double calcDistance(int[] nArray, int n, int n2, int n3, int n4) {
        double d = (double)nArray[0] - ((double)n + (double)n3 * 0.5);
        double d2 = (double)nArray[1] - ((double)n2 + (double)n4 * 0.5);
        return d * d + d2 * d2;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.plotSelectionToolbar != null) {
            this.plotSelectionToolbar.cleanUp();
            this.plotSelectionToolbar = null;
        }
        if (this.zoomToolbar != null) {
            this.zoomToolbar.cleanUp();
            this.zoomToolbar = null;
        }
        if (this.actionToolbar != null) {
            this.actionToolbar.cleanUp();
            this.actionToolbar = null;
        }
    }

    protected abstract LinkedList<ZoneLeaf> collectRectangleFromScreen(int var1, int var2, int var3, int var4, boolean var5, AbstractRubberband.RubberType var6);

    protected void doQuickInteraction(ZoneLeaf zoneLeaf) {
        int n = this.getPrimaryMatrixTag();
        int n2 = this.getSecondaryMatrixTag();
        Project_GUI project_GUI = this.plot.getPlot_GUI().getProject_GUI();
        if (project_GUI != null) {
            if (zoneLeaf != null) {
                project_GUI.doQuickInteraction(this, n, zoneLeaf.getPrimaryIndex(), n2, zoneLeaf.getSecondaryIndex());
            } else {
                project_GUI.doQuickInteraction(this, n, -1, n2, -1);
            }
        }
    }

    protected abstract String getToolTip(ZoneLeaf var1);

    protected abstract boolean mustBeBoundedInSelection();

    protected double[] translateToPlot(double d, double d2) {
        return this.translateToPlot(d, d2, this.getPlotUnderCoords(d, d2));
    }

    protected abstract double[] translateToPlot(double var1, double var3, int var5);

    protected abstract void translateToScreenInt(ZoneLeaf var1, int[] var2, int var3);

    private void init() {
        if (this.plot != null) {
            this.zoomToolbar = new PlotZoomToolbar(this, this.plot.getButtonGroup());
            if (Evince.touchscreen) {
                this.actionToolbar = new ActionToolbar(this, this.plot.getButtonGroup());
            }
            this.plotSelectionToolbar = new PlotSelectionToolbar(this, this.plot.getButtonGroup());
        }
    }

    private void setCursorBasedOnMouse(MouseEvent mouseEvent) {
        if (!(this.panview || this.zoomType != -1 || this.selectionType != 8 && this.selectionType != 0)) {
            return;
        }
        if (this.isOverPlot(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.panview) {
                this.setCursor(this.zoomToolbar.getCursor((byte)5));
            } else if (this.selectionType != 8) {
                if (this.rubberband == null) {
                    this.setSelection(this.selectionType);
                }
                this.setCursor(this.rubberband.getCursor());
            } else if (this.zoomType != -1) {
                if (this instanceof FloatWindowPlot2D) {
                    if (this.rubberband == null) {
                        this.setZooming(this.zoomType);
                    }
                    this.setCursor(this.rubberband.getCursor());
                } else {
                    this.setCursor(this.zoomToolbar.getCursor(this.zoomType));
                }
            }
        } else {
            this.setRubberband(null);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

