/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.plot.axisplot.TickInfo;

public final class AxisRange
implements Cloneable {
    private double min;
    private double max;
    private double abs;
    private double divAbs;
    private double dataMin;
    private double dataMax;
    private List<TickInfo> axisTickList = Collections.synchronizedList(new LinkedList());
    private double minFactor = AxisRange.getDefaultFactor();
    private double maxFactor = AxisRange.getDefaultFactor();
    private boolean doublePrecision = true;

    public static int firstValuePosAbs(double d) {
        if (Double.compare(d, 0.0) == 0 || Double.isInfinite(d)) {
            return 0;
        }
        double d2 = Math.abs(d);
        int n = 0;
        if (d2 < 1.0) {
            while (d2 < 1.0) {
                d2 *= 10.0;
                --n;
            }
        } else {
            while (d2 >= 10.0) {
                d2 *= 0.1;
                ++n;
            }
        }
        return n;
    }

    private static double getDefaultFactor() {
        return UpdateHelper.Product.isRunningProductEvince() ? 0.1 : 0.05;
    }

    public AxisRange(double d, double d2) {
        this.dataMin = this.min = d;
        this.dataMax = this.max = d2;
        this.setAbs(d2 - d);
    }

    public AxisRange(Double[] doubleArray) {
        this(doubleArray[0] == null ? 0.0 : doubleArray[0], doubleArray[1] == null ? 0.0 : doubleArray[1]);
    }

    public AxisRange(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        if (mapProperty.hasProperty("min")) {
            this.min = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("max")) {
            this.max = mapProperty.getLVDouble();
        }
        this.setAbs(this.max - this.min);
        if (mapProperty.hasProperty("pMin")) {
            this.dataMin = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("pMax")) {
            this.dataMax = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("minF")) {
            this.minFactor = mapProperty.getLVDouble();
        }
        if (mapProperty.hasProperty("maxF")) {
            this.maxFactor = mapProperty.getLVDouble();
        }
        this.doublePrecision = mapProperty.getPropertyBoolean("dP", true);
    }

    public void adjust(boolean bl) {
        if (bl) {
            if (this.abs > this.dataMax - this.dataMin) {
                this.max = this.dataMax;
                this.min = this.dataMin;
            }
            if (this.max > this.dataMax) {
                this.max = this.dataMax;
            }
            if (this.min < this.dataMin || this.min > this.max) {
                this.min = this.dataMin;
            }
            this.setAbs(this.max - this.min);
        } else {
            double d;
            if (this.max > this.dataMax) {
                d = this.max - this.dataMax;
                this.min -= d;
                this.max -= d;
            }
            if (this.min < this.dataMin) {
                d = this.min - this.dataMin;
                this.min -= d;
                this.max -= d;
            }
        }
    }

    public void calculate(double[] dArray, boolean bl) {
        double d = 0.0;
        boolean bl2 = false;
        if (Double.compare(dArray[0], dArray[1]) == 0) {
            d = Math.abs(dArray[0] * 0.1);
            if (Double.compare(d, 0.0) == 0) {
                d = 1.0;
            }
            bl2 = true;
        }
        this.dataMin = dArray[0] - d;
        this.dataMax = dArray[1] + d;
        double d2 = this.dataMax - this.dataMin;
        this.dataMin -= d2 * this.minFactor;
        this.dataMax += d2 * this.maxFactor;
        if (bl2 && bl) {
            this.min = this.dataMin;
        }
        if (bl2 && bl) {
            this.max = this.dataMax;
        }
        this.setAbs(this.max - this.min);
    }

    public Object clone() throws CloneNotSupportedException {
        AxisRange axisRange = (AxisRange)super.clone();
        axisRange.axisTickList = Collections.synchronizedList(new LinkedList());
        return axisRange;
    }

    public double getAbs() {
        return this.abs;
    }

    public double getDataAbs() {
        return this.dataMax - this.dataMin;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public double getDivAbs() {
        return this.divAbs;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getTickGap() {
        if (this.axisTickList.size() > 1) {
            TickInfo tickInfo = this.axisTickList.get(0);
            TickInfo tickInfo2 = this.axisTickList.get(1);
            return tickInfo2.pos - tickInfo.pos;
        }
        return 0.0;
    }

    public List<TickInfo> getTickList() {
        return this.axisTickList;
    }

    public double invTransform(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return -this.divAbs;
        }
        return (d - this.min) * this.divAbs;
    }

    public boolean isDoublePrecision() {
        return this.doublePrecision;
    }

    public boolean isInside(double d) {
        return d >= this.min && d <= this.max;
    }

    public boolean isInside(double d, double d2) {
        return (d >= this.min || d2 >= this.min) && (d <= this.max || d2 <= this.max);
    }

    public void pan(double d) {
        if (this.max > this.dataMax && this.min < this.dataMin) {
            return;
        }
        this.min += d;
        this.max += d;
        this.adjust(false);
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyDouble("min", this.min);
        randomOutputStream.writePropertyDouble("max", this.max);
        randomOutputStream.writePropertyDouble("pMin", this.dataMin);
        randomOutputStream.writePropertyDouble("pMax", this.dataMax);
        randomOutputStream.writePropertyDouble("minF", this.minFactor);
        randomOutputStream.writePropertyDouble("maxF", this.maxFactor);
        randomOutputStream.writePropertyBoolean("dP", this.doublePrecision);
    }

    public double scale(double d) {
        return d * this.abs;
    }

    public double setAxisTicks(double d) {
        return this.setAxisTicks(d, 65, 6, false, true);
    }

    public double setAxisTicks(double d, int n, int n2, boolean bl, boolean bl2) {
        double d2;
        this.axisTickList.clear();
        int n3 = 0;
        double d3 = 0.0;
        d3 = d <= 1.0E-7 || this.abs < 1.0E-7 ? 1.0E-7 : AxisRange.findSuitableGap(this.abs, d, n, this.doublePrecision);
        double d4 = d3 / 10.0;
        for (double d5 = d2 = (double)Math.round(this.min / d3) * d3; d5 <= this.max; d5 += d3) {
            if (d5 >= this.min && d5 <= this.max) {
                if (Math.abs(d5) < d4) {
                    this.axisTickList.add(new TickInfo(d5, "0"));
                } else if (bl) {
                    this.axisTickList.add(new TickInfo(d5, NiceDataFormat.toPercent(d5)));
                } else {
                    this.axisTickList.add(new TickInfo(d5, NiceDataFormat.toString(d5, n2, bl2)));
                }
            }
            if (++n3 > 1000) break;
        }
        return d3;
    }

    public void setDoublePrecition(boolean bl) {
        this.doublePrecision = bl;
    }

    public void setMaxFactor(double d) {
        this.maxFactor = d;
    }

    public void setMinFactor(double d) {
        this.minFactor = d;
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.setAbs(d2 - d);
    }

    public void setMinMaxFromCoords(double d, double d2) {
        this.max = this.min + this.abs * d2;
        this.min += this.abs * d;
        this.setAbs(this.max - this.min);
        this.adjust(false);
    }

    public double transform(double d) {
        return d * this.abs + this.min;
    }

    public void zoom(double d) {
        this.zoomNoAdjust(d);
        this.adjust(false);
        if (d > 0.0) {
            this.adjust(true);
        }
    }

    public void zoom(double d, double d2) {
        double d3 = 1.0 + d2 / 40.0;
        double d4 = (d - this.min) / this.abs;
        this.setAbs(this.abs * d3);
        this.min = d - d4 * this.abs;
        this.max = d + (1.0 - d4) * this.abs;
        this.adjust(false);
        if (d2 > 0.0) {
            this.adjust(true);
        }
    }

    public void zoomAll() {
        this.min = this.dataMin;
        this.max = this.dataMax;
        this.setAbs(this.max - this.min);
    }

    public void zoomNoAdjust(double d) {
        this.max += this.abs * d;
        this.min -= this.abs * d;
        this.setAbs(this.max - this.min);
    }

    public boolean hasZoomed() {
        return this.min != this.dataMin || this.max != this.dataMax;
    }

    public static double findSuitableGap(double d, double d2, int n, boolean bl) {
        double d3 = d / (d2 / (double)n);
        double d4 = AxisRange.firstValuePosAbs(d3);
        double d5 = d3 * Math.pow(10.0, -d4 + 1.0);
        boolean bl2 = d4 - 1.0 < 0.0;
        double d6 = Math.round(d5);
        d6 = d6 < 15.0 ? 10.0 : (d6 < 35.0 && (bl || !bl2) ? 25.0 : (d6 < 65.0 ? 50.0 : (d6 < 85.0 && (bl || !bl2) ? 75.0 : 100.0)));
        double d7 = d6 * Math.pow(10.0, d4 - 1.0);
        if (Double.compare(d7, 0.0) == 0) {
            return d;
        }
        return d7;
    }

    private void setAbs(double d) {
        this.abs = d;
        this.divAbs = Double.compare(d, 0.0) == 0 ? 0.0 : 1.0 / d;
    }
}

