/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import se.prediktera.map.common.error.Logg;

public class ImageSelection
implements Transferable {
    private final DataFlavor[] flavors;
    private final BufferedImage image;

    public ImageSelection(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
        Iterator<ImageWriterSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, false);
        while (iterator.hasNext()) {
            String[] stringArray;
            ImageWriterSpi imageWriterSpi = iterator.next();
            for (String string : stringArray = imageWriterSpi.getMIMETypes()) {
                try {
                    arrayList.add(new DataFlavor(string, imageWriterSpi.getFormatNames()[0]));
                }
                catch (Exception exception) {
                    Logg.error("Cannot add flavor", exception.getMessage());
                }
            }
        }
        arrayList.add(DataFlavor.imageFlavor);
        this.flavors = arrayList.toArray(new DataFlavor[arrayList.size()]);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            return this.image;
        }
        for (int i = 0; i < this.flavors.length - 1; ++i) {
            if (!this.flavors[i].equals(dataFlavor)) continue;
            try {
                String string = dataFlavor.getHumanPresentableName();
                File file = File.createTempFile("evince", string);
                file.deleteOnExit();
                ImageIO.write((RenderedImage)this.image, string, file);
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : this.flavors) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }
}

