/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButtonComboBox;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.plot.axisplot.AxisPlotRubberband;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.register.RegisterKeyManager;

public class PlotSelectionToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    public static final byte NORMSELECTION = 0;
    public static final byte RECTSELECTION = 1;
    public static final byte ELLIPSSELECTION = 2;
    public static final byte VERTICALSELECTION = 3;
    public static final byte HORIZONTALSELECTION = 4;
    public static final byte FRIHANDSELECTION = 5;
    public static final byte LINESELECTION = 6;
    public static final byte SIMILARSELECTION = 7;
    public static final byte NOSELECTION = 8;
    private final JFlatToggleButtonComboBox toggleButtonComboBox = new JFlatToggleButtonComboBox();
    private final JFlatToggleButton normSelection = new JFlatToggleButton();
    private final JFlatToggleButton rectSelection = new JFlatToggleButton();
    private final JFlatToggleButton ellipsSelection = new JFlatToggleButton();
    private final JFlatToggleButton verticalSelection = new JFlatToggleButton();
    private final JFlatToggleButton horizontalSelection = new JFlatToggleButton();
    private final JFlatToggleButton frihandSelection = new JFlatToggleButton();
    private final JFlatToggleButton lineSelection = new JFlatToggleButton();
    private final JFlatToggleButton similarSelection = new JFlatToggleButton();
    private AxisPlotRubberband floatPlotWindow;

    public PlotSelectionToolbar(AxisPlotRubberband axisPlotRubberband, ButtonGroup buttonGroup) {
        this.floatPlotWindow = axisPlotRubberband;
        this.normSelection.setToolTipText("Point Selection");
        this.normSelection.setActionCommand("norm");
        this.normSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/selection/hand.png")));
        this.normSelection.addItemListener(itemEvent -> this.setSelection(itemEvent, (byte)0));
        this.rectSelection.setToolTipText("Rectangle Selection");
        this.rectSelection.setActionCommand("rect");
        this.rectSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("button/selrec.png")));
        this.rectSelection.addItemListener(itemEvent -> this.setSelection(itemEvent, (byte)1));
        this.ellipsSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("button/selellips.png")));
        this.ellipsSelection.addItemListener(itemEvent -> this.setSelection(itemEvent, (byte)2));
        this.ellipsSelection.setToolTipText("Elliptical Selection");
        this.ellipsSelection.setActionCommand("ellipse");
        this.frihandSelection.setActionCommand("frihand");
        this.frihandSelection.setToolTipText("Freehand Selection");
        this.frihandSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("button/frihand.png")));
        this.frihandSelection.addItemListener(itemEvent -> this.setSelection(itemEvent, (byte)5));
        this.lineSelection.setActionCommand("line");
        this.lineSelection.setToolTipText("Line Selection");
        this.lineSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("button/line.gif")));
        this.lineSelection.addItemListener(itemEvent -> this.setSelection(itemEvent, (byte)6));
        if (axisPlotRubberband.getPlotInit() != null && DataTreeManager.isOrigMatrixLayer(axisPlotRubberband.getPlotInit().getDataTreeInterface())) {
            this.frihandSelection.setSelected(true);
        } else {
            this.normSelection.setSelected(true);
        }
        this.toggleButtonComboBox.setButtonGroup(buttonGroup);
        this.toggleButtonComboBox.addButton(this.normSelection);
        this.toggleButtonComboBox.addButton(this.rectSelection);
        this.toggleButtonComboBox.addButton(this.ellipsSelection);
        this.toggleButtonComboBox.addButton(this.frihandSelection);
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            this.toggleButtonComboBox.addButton(this.lineSelection);
        }
        if (this.floatPlotWindow instanceof FloatWindowPlot2D) {
            this.verticalSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("button/selvertical.png")));
            this.verticalSelection.addItemListener(itemEvent -> this.setSelection(itemEvent, (byte)3));
            this.verticalSelection.setToolTipText("Vertical Selection");
            this.verticalSelection.setActionCommand("vertical");
            this.horizontalSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("button/selhorizontal.png")));
            this.horizontalSelection.addItemListener(itemEvent -> this.setSelection(itemEvent, (byte)4));
            this.horizontalSelection.setToolTipText("Horizontal Selection");
            this.horizontalSelection.setActionCommand("horizontal");
            this.toggleButtonComboBox.addButton(this.verticalSelection);
            this.toggleButtonComboBox.addButton(this.horizontalSelection);
        }
        if (RegisterKeyManager.isPredikteraDevelopmentLicense() && this.floatPlotWindow instanceof FloatWindowContour2D) {
            this.similarSelection.setActionCommand("similar");
            this.similarSelection.setToolTipText("Similar Selection");
            this.similarSelection.setIcon(new ImageIcon(Main_GUI.class.getResource("button/similar.gif")));
            this.similarSelection.addItemListener(itemEvent -> this.floatPlotWindow.setSelection(itemEvent.getStateChange() == 1 ? (byte)7 : (byte)8));
            this.toggleButtonComboBox.addButton(this.similarSelection);
        }
        this.toggleButtonComboBox.setToolTipText("Selections");
        this.setBorder(null);
        this.setFloatable(false);
        this.addSeparator();
        this.add((Component)this.toggleButtonComboBox, null);
    }

    public byte sendGlobalMessage(byte by) {
        switch (by) {
            case 0: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.normSelection);
                break;
            }
            case 1: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.rectSelection);
                break;
            }
            case 2: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.ellipsSelection);
                break;
            }
            case 3: {
                if (!(this.floatPlotWindow instanceof FloatWindowPlot2D)) break;
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.verticalSelection);
                break;
            }
            case 4: {
                if (!(this.floatPlotWindow instanceof FloatWindowPlot2D)) break;
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.horizontalSelection);
                break;
            }
            case 5: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.frihandSelection);
                break;
            }
            case 6: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.lineSelection);
                break;
            }
            case 7: {
                if (!(this.floatPlotWindow instanceof FloatWindowContour2D)) break;
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.similarSelection);
                break;
            }
            default: {
                assert (false) : "Strange message " + by;
                break;
            }
        }
        return 1;
    }

    public void setSelectionTool(String string) {
        if ((string = string.toLowerCase()).equals("none")) {
            this.floatPlotWindow.setSelection((byte)8);
        } else if (string.equals("normal")) {
            this.floatPlotWindow.setSelection((byte)0);
        } else if (string.equals("freehand")) {
            this.floatPlotWindow.setSelection((byte)5);
        } else if (string.equals("ellipse")) {
            this.floatPlotWindow.setSelection((byte)2);
        } else if (string.equals("rectangle")) {
            this.floatPlotWindow.setSelection((byte)1);
        } else {
            for (int i = 0; i < this.toggleButtonComboBox.getButtonCount(); ++i) {
                AbstractButton abstractButton = this.toggleButtonComboBox.getButtonAt(i);
                if (!abstractButton.getText().toLowerCase().startsWith(string)) continue;
                abstractButton.doClick();
                break;
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        this.floatPlotWindow = null;
    }

    private void setSelection(ItemEvent itemEvent, byte by) {
        if (this.floatPlotWindow != null) {
            int n = itemEvent.getStateChange();
            this.floatPlotWindow.setSelection(n == 1 ? by : (byte)8);
        }
    }
}

