/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButtonComboBox;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.plot.axisplot.AxisPlotRubberband;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;

public class PlotZoomToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    public static final byte ZOOMNONE = -1;
    public static final byte ZOOMAREA = 0;
    public static final byte ZOOMIN = 1;
    public static final byte ZOOMOUT = 2;
    public static final byte ZOOMVERTICAL = 3;
    public static final byte ZOOMHORIZONTAL = 4;
    public static final byte PANVIEW = 5;
    private final JFlatToggleButtonComboBox toggleButtonComboBox = new JFlatToggleButtonComboBox();
    private final JFlatToggleButton zoomArea = new JFlatToggleButton();
    private final JFlatToggleButton zoomIn = new JFlatToggleButton();
    private final JFlatToggleButton zoomOut = new JFlatToggleButton();
    private final JFlatToggleButton zoomVertical = new JFlatToggleButton();
    private final JFlatToggleButton zoomHorizontal = new JFlatToggleButton();
    private final JFlatToggleButton panView = new JFlatToggleButton();
    private AxisPlotRubberband floatPlotWindow;
    private final Cursor zoomareacursor;
    private final Cursor zoomincursor;
    private final Cursor zoomoutcursor;
    private final Cursor panviewcursor;

    private static Cursor createCursor(Icon icon, String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        BufferedImage bufferedImage = new BufferedImage(32, 32, 3);
        icon.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        return toolkit.createCustomCursor(bufferedImage, new Point(0, 0), string);
    }

    public PlotZoomToolbar(AxisPlotRubberband axisPlotRubberband, ButtonGroup buttonGroup) {
        this.floatPlotWindow = axisPlotRubberband;
        JFlatButton jFlatButton = new JFlatButton();
        jFlatButton.setToolTipText("Zoom to Fit All");
        jFlatButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/zoom.png")));
        jFlatButton.addActionListener(actionEvent -> this.floatPlotWindow.zoomAll());
        this.zoomArea.setIcon(new ImageIcon(Main_GUI.class.getResource("button/zoomarea.png")));
        this.zoomArea.addItemListener(itemEvent -> this.zoomArea_itemStateChanged(itemEvent));
        this.zoomArea.setToolTipText("Zoom Area");
        this.zoomareacursor = Cursor.getPredefinedCursor(1);
        if (this.floatPlotWindow instanceof FloatWindowPlot2D) {
            this.zoomVertical.setIcon(new ImageIcon(Main_GUI.class.getResource("button/zoomvertical.png")));
            this.zoomVertical.addItemListener(itemEvent -> this.zoomVertical_itemStateChanged(itemEvent));
            this.zoomVertical.setToolTipText("Zoom Vertical");
            this.zoomHorizontal.setIcon(new ImageIcon(Main_GUI.class.getResource("button/zoomhorizontal.png")));
            this.zoomHorizontal.addItemListener(itemEvent -> this.zoomHorizontal_itemStateChanged(itemEvent));
            this.zoomHorizontal.setToolTipText("Zoom Horizontal");
        }
        this.zoomIn.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/zoomin.png")));
        this.zoomIn.addItemListener(itemEvent -> this.zoomIn_itemStateChanged(itemEvent));
        this.zoomIn.setToolTipText("Zoom In");
        this.zoomincursor = PlotZoomToolbar.createCursor(this.zoomIn.getIcon(), "Zoomin Icon");
        this.zoomOut.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/zoomout.png")));
        this.zoomOut.addItemListener(itemEvent -> this.zoomOut_itemStateChanged(itemEvent));
        this.zoomOut.setToolTipText("Zoom Out");
        this.zoomoutcursor = PlotZoomToolbar.createCursor(this.zoomOut.getIcon(), "Zoomout Icon");
        this.panView.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/pan_view.png")));
        this.panView.addItemListener(itemEvent -> this.panView_itemStateChanged(itemEvent));
        this.panView.setToolTipText("Pan View");
        this.panviewcursor = PlotZoomToolbar.createCursor(this.panView.getIcon(), "Panview Icon");
        this.toggleButtonComboBox.setButtonGroup(buttonGroup);
        this.toggleButtonComboBox.addButton(this.zoomArea);
        if (this.floatPlotWindow instanceof FloatWindowPlot2D) {
            this.toggleButtonComboBox.addButton(this.zoomVertical);
            this.toggleButtonComboBox.addButton(this.zoomHorizontal);
        }
        this.toggleButtonComboBox.addButton(this.zoomIn);
        this.toggleButtonComboBox.addButton(this.zoomOut);
        this.toggleButtonComboBox.setToolTipText("Zoom");
        buttonGroup.add(this.panView);
        this.setBorder(null);
        this.setFloatable(false);
        this.addSeparator();
        this.add((Component)jFlatButton, null);
        this.add((Component)this.toggleButtonComboBox, null);
        this.add((Component)this.panView, null);
    }

    public Cursor getCursor(byte by) {
        return switch (by) {
            case 1 -> this.zoomincursor;
            case 2 -> this.zoomoutcursor;
            case 0, 3, 4 -> this.zoomareacursor;
            case 5 -> this.panviewcursor;
            default -> Cursor.getDefaultCursor();
        };
    }

    public byte sendGlobalMessage(byte by) {
        switch (by) {
            case 0: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.zoomArea);
                break;
            }
            case 3: {
                if (!(this.floatPlotWindow instanceof FloatWindowPlot2D)) break;
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.zoomVertical);
                break;
            }
            case 4: {
                if (!(this.floatPlotWindow instanceof FloatWindowPlot2D)) break;
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.zoomHorizontal);
                break;
            }
            case 1: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.zoomIn);
                break;
            }
            case 2: {
                this.toggleButtonComboBox.setSelectedButtonAndClick(this.zoomOut);
                break;
            }
            case 5: {
                this.panView.setSelected(true);
                break;
            }
            default: {
                assert (false) : "Strange message " + by;
                break;
            }
        }
        return 1;
    }

    @Override
    protected void cleanUpChild() {
        this.floatPlotWindow = null;
    }

    private final void panView_itemStateChanged(ItemEvent itemEvent) {
        this.floatPlotWindow.setPanview(itemEvent.getStateChange() == 1);
    }

    private final void zoomArea_itemStateChanged(ItemEvent itemEvent) {
        this.floatPlotWindow.setZooming(itemEvent.getStateChange() == 1 ? (byte)0 : -1);
    }

    private final void zoomHorizontal_itemStateChanged(ItemEvent itemEvent) {
        this.floatPlotWindow.setZooming(itemEvent.getStateChange() == 1 ? (byte)4 : -1);
    }

    private final void zoomIn_itemStateChanged(ItemEvent itemEvent) {
        this.floatPlotWindow.setZooming(itemEvent.getStateChange() == 1 ? (byte)1 : -1);
    }

    private final void zoomOut_itemStateChanged(ItemEvent itemEvent) {
        this.floatPlotWindow.setZooming(itemEvent.getStateChange() == 1 ? (byte)2 : -1);
    }

    private final void zoomVertical_itemStateChanged(ItemEvent itemEvent) {
        this.floatPlotWindow.setZooming(itemEvent.getStateChange() == 1 ? (byte)3 : -1);
    }
}

