/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.plot.ColorCache;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.ZoneLeaf;

public class ZoneArray
extends ZoneLeaf {
    private byte[] sizeArray = null;
    private int[] colorArray = null;
    private byte[] flagsArray = null;
    private byte[] shapeTypeArray = null;
    private AbstractAxisLayer[] layerArray = null;

    public ZoneArray(AbstractAxisLayer abstractAxisLayer, int n) {
        super(Color.red, (byte)0, 0, n, abstractAxisLayer);
    }

    public ZoneArray(AbstractAxisLayer abstractAxisLayer, RandomInputStream randomInputStream) throws IOException {
        super(abstractAxisLayer, randomInputStream);
        int n;
        this.sizeArray = randomInputStream.ReadBlockByteArray();
        this.colorArray = randomInputStream.ReadBlockIntArray();
        this.flagsArray = randomInputStream.ReadBlockByteArray();
        if (this.flagsArray != null && randomInputStream.getSaveVersion() < 98L) {
            for (n = 0; n < this.flagsArray.length; ++n) {
                this.flagsArray[n] = ZoneArray.setVisible(this.flagsArray[n], !ZoneArray.isVisible(this.flagsArray[n]));
            }
        }
        if (this.flagsArray != null && this.flagsArray.length > 0 && this.flagsArray.length < this.getNoChildren()) {
            byte[] byArray = new byte[this.getNoChildren()];
            System.arraycopy(this.flagsArray, 0, byArray, 0, this.flagsArray.length);
            this.flagsArray = byArray;
        }
        this.shapeTypeArray = randomInputStream.ReadBlockByteArray();
        if (randomInputStream.getSaveVersion() >= 67L) {
            n = randomInputStream.ReadBlockInt();
            if (n > 0) {
                this.layerArray = new AbstractAxisLayer[n];
            }
            for (int i = 0; i < n; ++i) {
                this.layerArray[i] = (AbstractAxisLayer)randomInputStream.getDataTreeManager().getDataTreeInterface(randomInputStream.ReadBlockInt());
            }
        }
    }

    public boolean belongsToMultipleLayers() {
        return this.layerArray != null;
    }

    public final void checkLayerArray() {
        if (this.layerArray == null) {
            return;
        }
        AbstractAxisLayer abstractAxisLayer = null;
        for (AbstractAxisLayer abstractAxisLayer2 : this.layerArray) {
            if (abstractAxisLayer != null && (abstractAxisLayer.isSubLayer() || abstractAxisLayer != abstractAxisLayer2)) {
                return;
            }
            if (abstractAxisLayer != null) continue;
            abstractAxisLayer = abstractAxisLayer2;
        }
        this.setLayer(abstractAxisLayer);
        this.layerArray = null;
    }

    public int getChildWithIndex(int n) {
        return Arrays.binarySearch(this.getLayer().getPrimaryIndexArray(), n);
    }

    @Override
    public final Color getColor(int n) {
        if (this.colorArray == null) {
            return super.getColor();
        }
        return ColorCache.getColor(this.colorArray[n]);
    }

    public int getColorRGB(int n) {
        if (this.colorArray == null) {
            return this.getRGB();
        }
        return this.colorArray[n];
    }

    public int getFirstTagged() {
        return this.getNextTagged(-1);
    }

    @Override
    public AbstractAxisLayer getLayer(int n) {
        if (this.layerArray == null) {
            return this.getLayer();
        }
        return this.layerArray[n];
    }

    public int getNextTagged(int n) {
        int n2 = this.getNoChildren();
        for (int i = n + 1; i < n2; ++i) {
            if (!this.isTagged(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNoChildren() {
        int[] nArray = this.getLayer().getPrimaryIndexArray();
        if (nArray == null) {
            return 0;
        }
        return nArray.length;
    }

    @Override
    public int getPrimaryIndex(int n) {
        if (n >= 0) {
            return this.getLayer().getPrimaryIndexArray()[n];
        }
        return n;
    }

    public int[] getPrimaryIndexArray() {
        return this.getLayer().getPrimaryIndexArray();
    }

    public int getSelectedChildCount() {
        if (this.flagsArray == null) {
            return 0;
        }
        int n = 0;
        for (byte by : this.flagsArray) {
            if (!ZoneArray.isSelected(by)) continue;
            ++n;
        }
        return n;
    }

    public final byte getSize(int n) {
        if (this.sizeArray == null) {
            return super.getSize();
        }
        return this.sizeArray[n];
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public double getValue(int n, byte by) {
        if (by == 0) {
            return n + 1;
        }
        return this.getLayer().getRangeValue(by, this.getPrimaryIndex(n), this.getSecondaryIndex(), 0);
    }

    @Override
    public double getValue(int n, int n2, int n3, byte by) {
        if (by == 0) {
            return n + 1;
        }
        return this.getLayer().getRangeValue(by, n2, n3, 0);
    }

    public double getValueFromDataIndex(int n, int n2, byte by) {
        if (by == 0) {
            return n + 1;
        }
        return this.getLayer().getRangeValueFromDataIndex(by, n, n2, 0);
    }

    @Override
    public boolean isMissing(int n) {
        if (this.flagsArray == null || n >= this.flagsArray.length) {
            return this.isMissing();
        }
        return ZoneArray.isMissing(this.flagsArray[n]);
    }

    public boolean isMissing(int n, int n2, int n3, byte by) {
        if (by == 0) {
            return false;
        }
        return this.getLayer().isRangeMissing(by, n2, n3, 0);
    }

    @Override
    public boolean isSelected() {
        if (this.flagsArray != null) {
            for (byte by : this.flagsArray) {
                if (!ZoneArray.isSelected(by)) continue;
                return true;
            }
            return false;
        }
        return super.isSelected();
    }

    public boolean isSelected(int n) {
        if (this.flagsArray == null || n >= this.flagsArray.length) {
            return super.isSelected();
        }
        return ZoneArray.isSelected(this.flagsArray[n]);
    }

    public boolean isTagged(int n) {
        if (this.flagsArray == null) {
            return super.isTagged();
        }
        return ZoneArray.isTagged(this.flagsArray[n]);
    }

    @Override
    public boolean isVisible() {
        if (!this.getLayer().isLayerVisible()) {
            return false;
        }
        if (this.flagsArray == null) {
            return super.isVisible();
        }
        for (byte by : this.flagsArray) {
            if (!ZoneArray.isVisible(by)) continue;
            return true;
        }
        return false;
    }

    public final boolean isVisible(int n) {
        if (!this.getLayer().isLayerVisible()) {
            return false;
        }
        if (this.flagsArray == null || n >= this.flagsArray.length) {
            return super.isVisible();
        }
        return ZoneArray.isVisible(this.flagsArray[n]);
    }

    @Override
    public boolean isVisibleAndNotMissing(int n) {
        if (this.flagsArray == null || n >= this.flagsArray.length) {
            return this.isVisibleAndNotMissing();
        }
        return ZoneArray.isVisibleAndNotMissing(this.flagsArray[n]);
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        super.Save(randomOutputStream);
        randomOutputStream.WriteBlockByteArray(this.sizeArray);
        randomOutputStream.WriteBlockIntArray(this.colorArray);
        randomOutputStream.WriteBlockByteArray(this.flagsArray);
        randomOutputStream.WriteBlockByteArray(this.shapeTypeArray);
        if (this.layerArray == null) {
            randomOutputStream.WriteBlockInt(0);
        } else {
            randomOutputStream.WriteBlockInt(this.layerArray.length);
            for (AbstractAxisLayer abstractAxisLayer : this.layerArray) {
                randomOutputStream.WriteBlockInt(abstractAxisLayer.getID());
            }
        }
    }

    public void selectSelectedToVisible() {
        int n = this.getNoChildren();
        for (int i = 0; i < n; ++i) {
            this.setVisible(i, this.isSelected(i));
        }
    }

    public void selectTagged() {
        int n = this.getNoChildren();
        for (int i = 0; i < n; ++i) {
            this.setSelected(i, this.isTagged(i));
        }
    }

    public void selectTagged(boolean bl) {
        int n = this.getNoChildren();
        for (int i = 0; i < n; ++i) {
            if (!this.isTagged(i)) continue;
            this.setSelected(i, bl);
        }
    }

    public void selectVisibleToSelected() {
        int n = this.getNoChildren();
        for (int i = 0; i < n; ++i) {
            this.setSelected(i, this.isVisible(i));
        }
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        this.colorArray = null;
    }

    @Override
    public void setColor(int n) {
        super.setColor(n);
        this.colorArray = null;
    }

    public void setColor(int n, Color color) {
        if (this.colorArray == null) {
            int n2 = this.getNoChildren();
            this.colorArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.colorArray[i] = this.getRGB();
            }
        }
        if (color != null) {
            this.colorArray[n] = color.getRGB();
        }
    }

    public void setLayer(int n, AbstractAxisLayer abstractAxisLayer) {
        if (this.layerArray == null) {
            this.layerArray = new AbstractAxisLayer[this.getNoChildren()];
            for (int i = 0; i < this.layerArray.length; ++i) {
                this.layerArray[i] = this.getLayer();
            }
        }
        this.layerArray[n] = abstractAxisLayer;
    }

    @Override
    public void setMissing(byte by, boolean bl) {
        super.setMissing(by, bl);
        if (this.flagsArray != null) {
            for (int i = 0; i < this.flagsArray.length; ++i) {
                this.flagsArray[i] = ZoneArray.setMissing(this.flagsArray[i], by, bl);
            }
        }
    }

    public void setMissing(int n, byte by, boolean bl) {
        if (this.flagsArray == null) {
            this.flagsArray = new byte[this.getNoChildren()];
        }
        this.flagsArray[n] = ZoneArray.setMissing(this.flagsArray[n], by, bl);
    }

    @Override
    public void setSelected(AbstractAxisLayer abstractAxisLayer, boolean bl) {
        if (this.layerArray == null) {
            super.setSelected(abstractAxisLayer, bl);
            return;
        }
        if (this.flagsArray == null) {
            this.flagsArray = new byte[this.getNoChildren()];
        }
        for (int i = 0; i < this.flagsArray.length; ++i) {
            if (this.layerArray[i] != abstractAxisLayer) continue;
            this.flagsArray[i] = ZoneArray.setSelected(this.flagsArray[i], bl);
        }
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.flagsArray != null) {
            for (int i = 0; i < this.flagsArray.length; ++i) {
                this.flagsArray[i] = ZoneArray.setSelected(this.flagsArray[i], bl);
            }
        }
    }

    public void setSelected(int n, boolean bl) {
        if (this.flagsArray == null) {
            this.flagsArray = new byte[this.getNoChildren()];
        }
        if (n < this.flagsArray.length) {
            this.flagsArray[n] = ZoneArray.setSelected(this.flagsArray[n], bl);
        }
    }

    @Override
    public void setSize(byte by) {
        super.setSize(by);
        this.sizeArray = null;
    }

    public void setSize(int n, byte by) {
        if (this.sizeArray == null) {
            int n2 = this.getNoChildren();
            this.sizeArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                this.sizeArray[i] = this.getSize();
            }
        }
        this.sizeArray[n] = by;
    }

    @Override
    public void setTagged(boolean bl) {
        if (this.flagsArray == null) {
            super.setTagged(bl);
        } else {
            for (int i = 0; i < this.flagsArray.length; ++i) {
                this.flagsArray[i] = ZoneArray.setTagged(this.flagsArray[i], bl);
            }
        }
    }

    @Override
    public void setTagged(int n, boolean bl) {
        if (this.flagsArray == null) {
            if (!bl) {
                return;
            }
            this.flagsArray = new byte[this.getNoChildren()];
        }
        this.flagsArray[n] = ZoneArray.setTagged(this.flagsArray[n], bl);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.flagsArray != null) {
            for (int i = 0; i < this.flagsArray.length; ++i) {
                this.flagsArray[i] = ZoneArray.setVisible(this.flagsArray[i], bl);
            }
        }
    }

    public void setVisible(int n, boolean bl) {
        if (this.flagsArray == null) {
            this.flagsArray = new byte[this.getNoChildren()];
        }
        this.flagsArray[n] = ZoneArray.setVisible(this.flagsArray[n], bl);
    }

    @Override
    public void tagByLayer(AbstractAxisLayer abstractAxisLayer) {
        if (this.layerArray == null) {
            super.tagByLayer(abstractAxisLayer);
            return;
        }
        int n = this.getNoChildren();
        for (int i = 0; i < n; ++i) {
            this.setTagged(i, this.getLayer(i) == abstractAxisLayer);
        }
    }

    public void tagByPrimaryIndex(int n) {
        int n2 = this.getNoChildren();
        for (int i = 0; i < n2; ++i) {
            this.setTagged(i, n == this.getPrimaryIndex(i));
        }
    }

    public void tagSelected() {
        int n = this.getNoChildren();
        for (int i = 0; i < n; ++i) {
            this.setTagged(i, this.isSelected(i));
        }
    }

    public void tagVisible() {
        int n = this.getNoChildren();
        for (int i = 0; i < n; ++i) {
            this.setTagged(i, this.isVisible(i));
        }
    }

    public final boolean[] updateVisibleArray(boolean bl, boolean[] blArray) {
        if (!this.getLayer().isLayerVisible()) {
            Arrays.fill(blArray, false);
        } else if (this.flagsArray == null) {
            Arrays.fill(blArray, true);
        } else {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = bl && ZoneArray.isVisible(this.flagsArray[i]) || this.isVisibleAndNotMissing(i);
            }
        }
        return blArray;
    }
}

