/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.plot.ColorCache;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;

public class ZoneLeaf {
    public static final byte LEAF = 0;
    public static final byte ARRAY = 1;
    public static final byte SURFACE = 2;
    public static final byte CUBE = 3;
    private static final byte INVISIBLE = 1;
    private static final byte SELECTED = 2;
    private static final byte MISSING = 4;
    private static final byte ALLMISSING = 28;
    private static final byte INVISIBLEORALLMISSING = 29;
    private static final byte EXCLUDED = 32;
    private static final byte TAGGED = 64;
    private byte size;
    private int color;
    private byte flags = 0;
    private byte shapeType;
    private AbstractAxisLayer layer;
    private String description = "";
    private int primaryIndex;
    private int secondaryIndex;

    protected static final boolean isExcluded(byte by) {
        return (by & 0x20) != 0;
    }

    protected static final boolean isMissing(byte by) {
        return (by & 0x1C) != 0;
    }

    protected static final boolean isSelected(byte by) {
        return (by & 2) != 0;
    }

    protected static final boolean isTagged(byte by) {
        return (by & 0x40) != 0;
    }

    protected static final boolean isVisible(byte by) {
        return (by & 1) == 0;
    }

    protected static final boolean isVisibleAndNotMissing(byte by) {
        return (by & 0x1D) == 0;
    }

    protected static final byte setExcluded(byte by, boolean bl) {
        by = bl ? (byte)(by | 0x20) : (byte)(by & 0xFFFFFFDF);
        return by;
    }

    protected static final byte setMissing(byte by, byte by2, boolean bl) {
        by = bl ? (byte)(by | 4 << by2) : (byte)(by & ~(4 << by2));
        return by;
    }

    protected static final byte setSelected(byte by, boolean bl) {
        by = bl ? (byte)(by | 2) : (byte)(by & 0xFFFFFFFD);
        return by;
    }

    protected static final byte setTagged(byte by, boolean bl) {
        by = bl ? (byte)(by | 0x40) : (byte)(by & 0xFFFFFFBF);
        return by;
    }

    protected static final byte setVisible(byte by, boolean bl) {
        by = bl ? (byte)(by & 0xFFFFFFFE) : (byte)(by | 1);
        return by;
    }

    public ZoneLeaf(AbstractAxisLayer abstractAxisLayer, RandomInputStream randomInputStream) throws IOException {
        this.size = randomInputStream.ReadBlockByte();
        this.color = randomInputStream.ReadBlockInt();
        this.shapeType = randomInputStream.ReadBlockByte();
        if (randomInputStream.getSaveVersion() < 78L) {
            if (!randomInputStream.ReadBlockBoolean()) {
                this.flags = (byte)(this.flags | 1);
            }
            if (randomInputStream.ReadBlockBoolean()) {
                this.flags = (byte)(this.flags | 2);
            }
        } else {
            this.flags = randomInputStream.ReadBlockByte();
            if (randomInputStream.getSaveVersion() < 98L) {
                this.flags = ZoneLeaf.setVisible(this.flags, !ZoneLeaf.isVisible(this.flags));
            }
        }
        this.description = randomInputStream.ReadBlockUTF();
        this.primaryIndex = randomInputStream.ReadBlockInt();
        this.secondaryIndex = randomInputStream.ReadBlockInt();
        int n = 0;
        int n2 = 0;
        if (randomInputStream.getSaveVersion() < 89L) {
            n = randomInputStream.ReadBlockInt();
            n2 = randomInputStream.ReadBlockInt();
        }
        if (randomInputStream.getSaveVersion() < 67L) {
            this.setLayer(abstractAxisLayer);
        } else {
            this.setLayer((AbstractAxisLayer)randomInputStream.getDataTreeManager().getDataTreeInterface(randomInputStream.ReadBlockInt()));
        }
        if (randomInputStream.getSaveVersion() < 78L && abstractAxisLayer != null) {
            this.setMissing((byte)0, abstractAxisLayer.isMissing((byte)0, n, n2));
            this.setMissing((byte)1, abstractAxisLayer.isMissing((byte)1, n, n2));
            this.setMissing((byte)2, abstractAxisLayer.isMissing((byte)2, n, n2));
        }
    }

    public ZoneLeaf(Color color, byte by, int n, int n2, AbstractAxisLayer abstractAxisLayer) {
        if (color != null) {
            this.color = color.getRGB();
        }
        this.shapeType = by;
        this.size = (byte)7;
        this.primaryIndex = n;
        this.secondaryIndex = n2;
        this.setLayer(abstractAxisLayer);
    }

    public void cleanUp() {
        this.layer = null;
    }

    public final Color getColor() {
        return ColorCache.getColor(this.color);
    }

    public Color getColor(int n) {
        return this.getColor();
    }

    public String getDescription() {
        return this.description;
    }

    public int getIndex(boolean bl) {
        if (bl) {
            return this.getPrimaryIndex();
        }
        return this.getSecondaryIndex();
    }

    public final AbstractAxisLayer getLayer() {
        return this.layer;
    }

    public AbstractAxisLayer getLayer(int n) {
        return this.getLayer();
    }

    public int getNoChildren() {
        return 1;
    }

    public int getPrimaryIndex() {
        return this.primaryIndex;
    }

    public int getPrimaryIndex(int n) {
        return this.getPrimaryIndex();
    }

    public int getRGB() {
        return this.color;
    }

    public int getSecondaryIndex() {
        return this.secondaryIndex;
    }

    public byte getShapeType() {
        return this.shapeType;
    }

    public byte getSize() {
        return this.size;
    }

    public byte getType() {
        return 0;
    }

    public double getValue(byte by) {
        if (this.layer != null) {
            return this.layer.getAxisValue(by, this.primaryIndex, this.secondaryIndex);
        }
        return 0.0;
    }

    public double getValue(int n, byte by) {
        return this.getValue(by);
    }

    public double getValue(int n, int n2, int n3, byte by) {
        return this.getValue(by);
    }

    public boolean isExcluded() {
        return ZoneLeaf.isExcluded(this.flags);
    }

    public boolean isMissing() {
        return ZoneLeaf.isMissing(this.flags);
    }

    public boolean isMissing(int n) {
        return this.isMissing();
    }

    public boolean isSelected() {
        return ZoneLeaf.isSelected(this.flags);
    }

    public boolean isTagged() {
        return ZoneLeaf.isTagged(this.flags);
    }

    public boolean isVisible() {
        return this.layer.isLayerVisible() && ZoneLeaf.isVisible(this.flags);
    }

    public final boolean isVisibleAndNotMissing() {
        return ZoneLeaf.isVisibleAndNotMissing(this.flags);
    }

    public boolean isVisibleAndNotMissing(int n) {
        return this.isVisibleAndNotMissing();
    }

    public final void paintDescription(Graphics2D graphics2D, int n, int n2, double d, Color color) {
        if (this.description.length() > 0) {
            graphics2D.setColor(color);
            AffineTransform affineTransform = graphics2D.getTransform();
            int n3 = (int)((double)this.getSize() * 0.6 * d);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String string = this.getDescription();
            switch (0) {
                case 0: {
                    graphics2D.translate(n, n2 - n3);
                    break;
                }
                case 1: {
                    graphics2D.translate((double)n - (double)fontMetrics.stringWidth(string) * d * 1.1, (double)(n2 - n3));
                    break;
                }
                case 2: {
                    graphics2D.translate((double)n - (double)fontMetrics.stringWidth(string) * d * 1.1, (double)n2 + (double)n3 * 2.1);
                    break;
                }
                case 3: {
                    graphics2D.translate((double)n, (double)n2 + (double)n3 * 2.1);
                }
            }
            graphics2D.scale(d, d);
            graphics2D.drawString(string, 0, 0);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.WriteBlockByte(this.size);
        randomOutputStream.WriteBlockInt(this.color);
        randomOutputStream.WriteBlockByte(this.shapeType);
        randomOutputStream.WriteBlockByte(this.flags);
        randomOutputStream.WriteBlockUTF(this.description);
        randomOutputStream.WriteBlockInt(this.primaryIndex);
        randomOutputStream.WriteBlockInt(this.secondaryIndex);
        if (this.layer == null) {
            randomOutputStream.WriteBlockInt(-1);
        } else {
            randomOutputStream.WriteBlockInt(this.layer.getID());
        }
    }

    public void setColor(Color color) {
        this.color = color != null ? color.getRGB() : Color.red.getRGB();
    }

    public void setColor(int n) {
        this.color = n;
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
    }

    public void setExcluded(boolean bl) {
        this.flags = ZoneLeaf.setExcluded(this.flags, bl);
    }

    public void setIndex(int n, int n2) {
        this.primaryIndex = n;
        this.secondaryIndex = n2;
    }

    public void setLayer(AbstractAxisLayer abstractAxisLayer) {
        this.layer = abstractAxisLayer;
    }

    public void setMissing(byte by, boolean bl) {
        this.flags = ZoneLeaf.setMissing(this.flags, by, bl);
    }

    public void setSelected(AbstractAxisLayer abstractAxisLayer, boolean bl) {
        if (abstractAxisLayer == this.layer) {
            this.setSelected(bl);
        }
    }

    public void setSelected(boolean bl) {
        this.flags = ZoneLeaf.setSelected(this.flags, bl);
    }

    public void setShapeType(byte by) {
        this.shapeType = by;
    }

    public void setSize(byte by) {
        this.size = by;
    }

    public void setTagged(boolean bl) {
        this.flags = ZoneLeaf.setTagged(this.flags, bl);
    }

    public void setTagged(int n, boolean bl) {
        this.setTagged(bl);
    }

    public void setVisible(boolean bl) {
        this.flags = ZoneLeaf.setVisible(this.flags, bl);
    }

    public void tagByLayer(AbstractAxisLayer abstractAxisLayer) {
        this.setTagged(abstractAxisLayer == this.layer);
    }

    public String toString() {
        return this.description.length() == 0 ? super.toString() : this.description;
    }
}

