/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D;

import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractDensityField;
import se.prediktera.map.plot.axisplot.ZoneLeaf;

public class DensityField2D
extends AbstractDensityField {
    private static final int RESOLUTION = 100;
    private final int[] densities = new int[10000];
    private final double xMin;
    private final double xAbs;
    private final double yMin;
    private final double yAbs;
    private double currentX;
    private double currentY;

    public DensityField2D(AbstractAxisLayer abstractAxisLayer) {
        double[] dArray = abstractAxisLayer.getMinmax(0);
        double[] dArray2 = abstractAxisLayer.getMinmax(1);
        this.xMin = Math.min(dArray[0], dArray[1]);
        this.yMin = Math.min(dArray2[0], dArray2[1]);
        this.xAbs = 1.0 / Math.abs(dArray[0] - dArray[1]);
        this.yAbs = 1.0 / Math.abs(dArray2[0] - dArray2[1]);
        this.addFromLayer(abstractAxisLayer);
    }

    @Override
    public void addValue(ZoneLeaf zoneLeaf) {
        int n;
        if (zoneLeaf.isMissing()) {
            return;
        }
        this.getXY(zoneLeaf);
        int n2 = (int)this.currentY;
        int n3 = (int)this.currentX;
        int n4 = n2 * 100 + n3;
        this.densities[n4] = this.densities[n4] + 1;
        int n5 = this.densities[n2 * 100 + n3];
        if (n5 > this.maxDensity) {
            this.maxDensity = n5;
        }
        if (n2 < 99) {
            int n6 = (n2 + 1) * 100 + n3;
            this.densities[n6] = this.densities[n6] + 1;
            n = this.densities[(n2 + 1) * 100 + n3];
            if (n > this.maxDensity) {
                this.maxDensity = n;
            }
        }
        if (n2 < 99 && n3 < 99) {
            int n7 = (n2 + 1) * 100 + n3 + 1;
            this.densities[n7] = this.densities[n7] + 1;
            n = this.densities[(n2 + 1) * 100 + n3 + 1];
            if (n > this.maxDensity) {
                this.maxDensity = n;
            }
        }
        if (n3 < 99) {
            int n8 = n2 * 100 + n3 + 1;
            this.densities[n8] = this.densities[n8] + 1;
            n = this.densities[n2 * 100 + n3 + 1];
            if (n > this.maxDensity) {
                this.maxDensity = n;
            }
        }
    }

    @Override
    public double getDensityAt(ZoneLeaf zoneLeaf) {
        if (zoneLeaf.isMissing()) {
            return 0.0;
        }
        this.getXY(zoneLeaf);
        int n = (int)this.currentY;
        int n2 = (int)this.currentX;
        double d = this.currentY - (double)n;
        double d2 = this.currentX - (double)n2;
        double d3 = (1.0 - d) * (1.0 - d2) * (double)this.densities[n * 100 + n2];
        if (n < 99) {
            d3 += d * (1.0 - d2) * (double)this.densities[(n + 1) * 100 + n2];
        }
        if (n < 99 && n2 < 99) {
            d3 += d * d2 * (double)this.densities[(n + 1) * 100 + n2 + 1];
        }
        if (n2 < 99) {
            d3 += (1.0 - d) * d2 * (double)this.densities[n * 100 + n2 + 1];
        }
        return this.convertValue(d3);
    }

    private void getXY(ZoneLeaf zoneLeaf) {
        this.currentX = 99.0 * (zoneLeaf.getValue((byte)0) - this.xMin) * this.xAbs;
        this.currentY = 99.0 * (zoneLeaf.getValue((byte)1) - this.yMin) * this.yAbs;
        this.currentX = Math.max(0.0, Math.min(this.currentX, 99.0));
        this.currentY = Math.max(0.0, Math.min(this.currentY, 99.0));
    }
}

