/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.datasetcontainer.datainfo.DataImage;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnImageResource;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisPlotRubberband;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandFreehand;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandHorizontal;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandRectangle;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandVertical;
import se.prediktera.map.plot.axisplot.settings.ComboBoxShape;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;
import se.prediktera.map.plot.axisplot.windows.PlotZone;
import se.prediktera.map.plot.axisplot.windows.PlotZoneText;

public abstract class FloatWindowPlot2D
extends AxisPlotRubberband {
    protected Font AxisFont = new Font("SansSerif", 0, 8);
    protected PlotGrid plotGround = null;
    protected PlotXaxis plotXaxis;
    protected PlotYaxis plotYaxis;
    protected double textRelative;
    protected Point panBegin;
    protected int panPlot = -1;
    private AbstractStatisticsInfo selectedStatistics;
    private SimpleDateFormat sdfX = null;
    private boolean usingStatisticCursor;

    public FloatWindowPlot2D(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.init();
    }

    public FloatWindowPlot2D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init();
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneLeaf zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneLeaf);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            int n3 = abstractAxisLayer.getDescriptionCount();
            for (int i = 0; i < n3; ++i) {
                String string2 = abstractAxisLayer.getDescriptionTitle(i);
                String string3 = abstractAxisLayer.getDescription(i, zoneLeaf);
                stringBuilder.append(string2).append(": ");
                stringBuilder.append(string3).append("\n");
            }
            stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)0))).append("\n");
            stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)1))).append("\n");
        }
        return stringBuilder.toString();
    }

    public PlotGrid getPlotGrid() {
        return this.plotGround;
    }

    @Override
    public int getPlotUnderCoords(double d, double d2) {
        return this.plotGround.getPlotUnderCoords(d, d2);
    }

    @Override
    public Point getPointAtCoordsAt(double d, double d2) {
        int[] nArray = this.translateToScreenInt(d, d2);
        return new Point(nArray[0], nArray[1]);
    }

    @Override
    public Point getPointAtCordsAt(AbstractAxisLayer abstractAxisLayer, Point point, int n, int n2) {
        ZoneLeaf zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2);
        if (zoneLeaf != null) {
            int[] nArray = new int[2];
            this.translateToScreenInt(nArray, zoneLeaf);
            if (this.plotGround.isInside(nArray[0], nArray[1])) {
                if (point == null) {
                    point = new Point();
                }
                point.x = (int)((double)nArray[0] + this.getTryOrigoX());
                point.y = (int)((double)nArray[1] + this.getTryOrigoY());
                return point;
            }
        }
        return null;
    }

    @Override
    public boolean isOverPlot(int n, int n2) {
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedStatistics != null) {
            if (this.rubberband != null) {
                this.rubberband.setActive(false);
            }
            this.updateSelectedStatistics(mouseEvent, false);
            this.repaint();
        } else {
            if (this.rubberband != null && !this.rubberband.isActive()) {
                this.rubberband.setActive(true);
                this.rubberband.anchor(mouseEvent.getPoint());
            }
            super.mouseDragged(mouseEvent);
            Point point = mouseEvent.getPoint();
            if (this.panview && this.panPlot == -1) {
                this.panPlot = this.plotGround.getPlotUnderCoords(point.x, point.y);
            }
            if (this.panview && this.panBegin != null) {
                double[] dArray = this.plotGround.translateToPlotOrigo(this.panBegin.getX() - point.getX(), this.panBegin.getY() - point.getY(), this.panPlot);
                this.PanContinues(dArray[0], dArray[1], this.panPlot);
                this.calculateAndRepaintSetAxis(true, false);
            }
            this.panBegin = point;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        AbstractStatisticsInfo abstractStatisticsInfo = this.getStatisticsAt(mouseEvent.getX(), mouseEvent.getY());
        if (abstractStatisticsInfo != null) {
            this.usingStatisticCursor = true;
            int n = abstractStatisticsInfo.getSelectedAxis();
            if (n == 0) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (n == 1) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (n == 2) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else if (this.usingStatisticCursor) {
            this.setCursor(Cursor.getDefaultCursor());
            this.usingStatisticCursor = false;
        } else {
            super.mouseMoved(mouseEvent);
            if (this.rubberband != null && this.rubberband.supportHandSelection() && this.supportHandSelectionFeature && this.rubberband.getType() == AbstractRubberband.RubberAction.Selection) {
                if (this.plotGround.hasLeafAt(mouseEvent.getPoint())) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else if (!(this.rubberband instanceof RubberbandFreehand)) {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.setPanview(true, false);
        }
        if (this.plotGround.isInside(mouseEvent.getX(), mouseEvent.getY())) {
            this.panBegin = mouseEvent.getPoint();
        }
        this.selectedStatistics = this.getStatisticsAt(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.setPanview(false, false);
        }
        if (this.selectedStatistics != null) {
            this.updateSelectedStatistics(mouseEvent, true);
            this.selectedStatistics = null;
        } else {
            super.mouseReleased(mouseEvent);
            this.panBegin = null;
            this.panPlot = -1;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
        int n2 = this.plotGround.getPlotUnderCoords(mouseWheelEvent.getX(), mouseWheelEvent.getY());
        double[] dArray = this.plotGround.translateToPlot(mouseWheelEvent.getX(), mouseWheelEvent.getY(), n2);
        this.ZoomContinues(dArray[0], dArray[1], n, n2);
        this.calculateAndRepaintSetAxis(true, false);
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        super.nodeReplaced(dataTreeEvent);
        if (this.selectionArray != null) {
            this.selectionArray = new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
        }
    }

    public void setPlotGroundClip(Graphics2D graphics2D) {
        graphics2D.setClip(this.plotGround.getOrigoX(), this.plotGround.getOrigoY(), this.plotGround.getWidth(), this.plotGround.getHeight());
    }

    @Override
    public void setSelection(byte by) {
        if (by == 3) {
            this.setRubberband(new RubberbandVertical((Component)this, this.plotGround, AbstractRubberband.RubberAction.Selection));
        } else if (by == 4) {
            this.setRubberband(new RubberbandHorizontal((Component)this, this.plotGround, AbstractRubberband.RubberAction.Selection));
        }
        super.setSelection(by);
    }

    @Override
    public void setXaxisDateFormat(SimpleDateFormat simpleDateFormat) {
        this.sdfX = simpleDateFormat;
    }

    @Override
    public void setZooming(byte by) {
        if (by == 0) {
            this.setRubberband(new RubberbandRectangle(this, AbstractRubberband.RubberAction.Zoom));
        } else if (by == 3) {
            this.setRubberband(new RubberbandVertical((Component)this, this.plotGround, AbstractRubberband.RubberAction.Zoom));
        } else if (by == 4) {
            this.setRubberband(new RubberbandHorizontal((Component)this, this.plotGround, AbstractRubberband.RubberAction.Zoom));
        } else if (by == 1) {
            this.setRubberband(new RubberbandNormal(this, 0, AbstractRubberband.RubberAction.Zoom));
            this.rubberband.setCursor(this.zoomToolbar.getCursor((byte)1));
        } else if (by == 2) {
            this.setRubberband(new RubberbandNormal(this, 1, AbstractRubberband.RubberAction.Zoom));
            this.rubberband.setCursor(this.zoomToolbar.getCursor((byte)2));
        }
        super.setZooming(by);
    }

    @Override
    public double[] translateToPlotRelative(double d, double d2) {
        AxisRange axisRange;
        double d3;
        double d4 = d * (double)this.getWidth();
        double[] dArray = this.plotGround.translateToPlot(d4, d3 = (double)this.getHeight() - d2 * (double)this.getHeight(), 0);
        if (dArray[1] > (axisRange = this.getRange(1, 0)).getDataMax()) {
            dArray[1] = -1.0;
        }
        return dArray;
    }

    public double[] translateToScreenDouble(double d, double d2) {
        double[] dArray = new double[2];
        this.translateToScreenDouble(dArray, d, d2);
        return dArray;
    }

    public void translateToScreenDouble(double[] dArray, double d, double d2) {
        this.plotGround.translateToScreenDouble(dArray, d, d2, 0);
    }

    @Override
    public double[] translateToScreenDouble(double[] dArray, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
        return this.plotGround.translateToScreenDouble(dArray, d, d2, axisRange, axisRange2);
    }

    public int[] translateToScreenInt(double d, double d2) {
        int[] nArray = new int[2];
        this.translateToScreenInt(nArray, d, d2);
        return nArray;
    }

    public void translateToScreenInt(int[] nArray, double d, double d2) {
        this.plotGround.translateToScreenInt(nArray, d, d2, 0);
    }

    @Override
    public void translateToScreenInt(ZoneLeaf zoneLeaf, int[] nArray, int n) {
        this.plotGround.translateToScreenInt(nArray, zoneLeaf.getValue((byte)0), zoneLeaf.getValue((byte)1), n);
    }

    @Override
    protected void adjustToAspectRatio() {
        if (this.plotGround != null) {
            this.plotGround.adjustToAspectRatio();
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.plotGround != null) {
            this.plotGround.cleanUp();
            this.plotGround = null;
        }
        if (this.plotXaxis != null) {
            this.plotXaxis.cleanUp();
            this.plotXaxis = null;
        }
        if (this.plotYaxis != null) {
            this.plotYaxis.cleanUp();
            this.plotYaxis = null;
        }
        this.selectedStatistics = null;
    }

    @Override
    protected LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType) {
        return this.plotGround.collectRectangleFromScreen(n, n2, n3, n4, bl, rubberType);
    }

    protected abstract PlotGrid createPlotGround();

    protected PlotXaxis createXaxis() {
        PlotXaxis plotXaxis = new PlotXaxis(Color.white, 0.0, 0.1);
        plotXaxis.setMinHeight(20);
        return plotXaxis;
    }

    protected PlotYaxis createYaxis() {
        PlotYaxis plotYaxis = new PlotYaxis(Color.white, 0.1, 0.0);
        plotYaxis.setMinWidth(30);
        return plotYaxis;
    }

    protected Font getDescriptionFontX() {
        return null;
    }

    protected Font getDescriptionFontY() {
        return null;
    }

    protected String getDescriptionX(TickInfo tickInfo) {
        if (this.sdfX != null) {
            try {
                return this.sdfX.format(new Date((long)tickInfo.pos));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return tickInfo.text;
    }

    protected String getDescriptionY(TickInfo tickInfo) {
        return tickInfo.text;
    }

    @Override
    protected ZoneLeaf getLeafAt(Point point) {
        return this.plotGround.getLeafAt(point);
    }

    @Override
    protected int getPlotDepth() {
        return 0;
    }

    @Override
    protected int getPlotHeight() {
        if (this.plotGround == null) {
            return 0;
        }
        return this.plotGround.getHeight();
    }

    @Override
    protected int getPlotWidth() {
        if (this.plotGround == null) {
            return 0;
        }
        return this.plotGround.getWidth();
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            AbstractAxisLayer abstractAxisLayer = zoneLeaf.getLayer();
            StringBuilder stringBuilder = new StringBuilder(240);
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer).append("</th></tr>");
            String string = abstractAxisLayer.getComment(zoneLeaf, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            int n = abstractAxisLayer.getDescriptionCount();
            for (int i = 0; i < n; ++i) {
                String string2 = abstractAxisLayer.getDescriptionTitle(i);
                String string3 = abstractAxisLayer.getDescription(i, zoneLeaf);
                stringBuilder.append("<tr><td>").append(string2).append(":</td><td>");
                stringBuilder.append(string3).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>X:</td><td>").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)0))).append("</td></tr>");
            stringBuilder.append("<tr><td>Y:</td><td>").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)1))).append("</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected boolean hasInteractionContent() {
        int n = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer == null || !abstractAxisLayer.isLayerReady() || !abstractAxisLayer.isLayerVisible() || !abstractAxisLayer.hasStatistics()) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        this.plotGround = this.createPlotGround();
        this.addPlotZone(this.plotGround, 4);
        this.plotXaxis = this.createXaxis();
        this.addPlotZone(this.plotXaxis, 1);
        this.plotYaxis = this.createYaxis();
        this.addPlotZone(this.plotYaxis, 2);
        this.addPlotZone(new PlotZoneText(Color.white, 0.05, 0.0, false), 3);
        this.addPlotZone(new PlotZoneText(Color.white, 0.0, 0.05, false), 0);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
        if (this.plotGround == null) {
            return;
        }
        double d2 = 0.0;
        this.textRelative = 1.0;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        AxisRange axisRange = this.getRange(0, 0);
        AxisRange axisRange2 = this.getRange(1, 0);
        double[] dArray = new double[2];
        if (this.plotXaxis != null) {
            Object object;
            double d3 = this.plotGround.translateToScreenDouble(dArray, this.xGap, 0.0, axisRange, axisRange2)[0] - this.plotGround.translateToScreenDouble(dArray, 0.0, 0.0, axisRange, axisRange2)[0];
            Object object2 = object = axisRange.getTickList();
            synchronized (object2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    TickInfo tickInfo = (TickInfo)iterator.next();
                    double d4 = fontMetrics.stringWidth(this.getDescriptionX(tickInfo));
                    if (!(d2 < d4)) continue;
                    d2 = d4;
                }
            }
            this.textRelative = d3 * 0.9 / d2;
            double d5 = ((double)this.plotXaxis.getHeight() - 5.0 * d) * 0.97 / (double)fontMetrics.getHeight();
            if (this.textRelative > d5) {
                this.textRelative = UpdateHelper.Product.isRunningProductEvince() ? d5 : Math.min(2.0, d5);
            }
        }
        if (this.plotYaxis != null) {
            List<TickInfo> list;
            d2 = 0.0;
            List<TickInfo> list2 = list = axisRange2.getTickList();
            synchronized (list2) {
                for (TickInfo tickInfo : list) {
                    double d6 = fontMetrics.stringWidth(this.getDescriptionY(tickInfo));
                    if (!(d2 < d6)) continue;
                    d2 = d6;
                }
            }
            double d7 = ((double)this.plotYaxis.getWidth() - 5.0 * d) * 0.97 / d2;
            if (this.textRelative > d7) {
                this.textRelative = d7;
            }
        }
        if (this.textRelative > d) {
            this.textRelative = d;
        }
        if (this.textRelative < 1.1) {
            this.textRelative = 1.1;
        }
    }

    protected void setCoord(ZoneLeaf zoneLeaf, double[] dArray) {
        dArray[0] = zoneLeaf.getValue((byte)0);
        dArray[1] = zoneLeaf.getValue((byte)1);
    }

    @Override
    protected double[] translateToPlot(double d, double d2, int n) {
        return this.plotGround.translateToPlot(d, d2, n);
    }

    protected void translateToScreenInt(int[] nArray, ZoneLeaf zoneLeaf) {
        this.plotGround.translateToScreenInt(nArray, zoneLeaf.getValue((byte)0), zoneLeaf.getValue((byte)1), 0);
    }

    private AbstractStatisticsInfo getStatisticsAt(int n, int n2) {
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n3; ++i) {
            AbstractStatisticsInfo abstractStatisticsInfo;
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer == null || !abstractAxisLayer.isLayerReady() || !abstractAxisLayer.isLayerVisible() || (abstractStatisticsInfo = abstractAxisLayer.getStatisticsAt(n, n2, this)) == null) continue;
            return abstractStatisticsInfo;
        }
        return null;
    }

    private void updateSelectedStatistics(MouseEvent mouseEvent, boolean bl) {
        double[] dArray = this.plotGround.translateToPlot(mouseEvent.getX(), mouseEvent.getY(), 0);
        int n = this.selectedStatistics.getSelectedAxis();
        if (n == 2) {
            this.selectedStatistics.setValue(n, dArray, this, bl);
        } else {
            double d = dArray[n];
            if (d < 0.0) {
                d = 0.0;
            } else if (d > this.getRange(n, 0).getMax()) {
                d = this.getRange(n, 0).getMax();
            }
            this.selectedStatistics.setValue(n, d, dArray[n], bl);
        }
    }

    public class PlotGrid
    extends PlotZone {
        protected long mark;
        private ResourceNode rootResourceNode;

        public PlotGrid(Color color, double d, double d2) {
            super(color, d, d2, (byte)7);
            this.mark = 100L;
            this.rootResourceNode = null;
        }

        public LinkedList<ZoneLeaf> collectRectangleFromData(final double[] dArray, final double[] dArray2, final boolean bl) {
            final LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            ++this.mark;
            int n = FloatWindowPlot2D.this.plotAxisLayerPanel.getMainLayerCount();
            double[] dArray3 = new double[2];
            for (int i = 0; i < n; ++i) {
                LeafList leafList;
                AbstractAxisLayer abstractAxisLayer = FloatWindowPlot2D.this.plotAxisLayerPanel.getMainLayer(i);
                if (!abstractAxisLayer.isInteraction() || !abstractAxisLayer.isLayerReady() || !abstractAxisLayer.isLayerVisible() || (leafList = abstractAxisLayer.getZoneList()) == null) continue;
                if (leafList.size() > 15000) {
                    new Threader(this){
                        final /* synthetic */ PlotGrid this$1;
                        {
                            this.this$1 = plotGrid;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void doOp(boolean bl2, int n, int n2) {
                            if (bl2) {
                                LinkedList linkedList3 = linkedList;
                                synchronized (linkedList3) {
                                    this.this$1.collectRectangleFromData(linkedList, leafList, n, n2, dArray, dArray2, bl);
                                }
                            }
                            LinkedList<ZoneLeaf> linkedList4 = new LinkedList<ZoneLeaf>();
                            this.this$1.collectRectangleFromData(linkedList4, leafList, n, n2, dArray, dArray2, bl);
                            LinkedList linkedList2 = linkedList;
                            synchronized (linkedList2) {
                                linkedList.addAll(linkedList4);
                            }
                        }
                    }.execute(leafList.size());
                    continue;
                }
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    double d;
                    ZoneLeaf zoneLeaf = list.get(j);
                    if (!zoneLeaf.isVisibleAndNotMissing() || bl && zoneLeaf.isSelected()) continue;
                    FloatWindowPlot2D.this.setCoord(zoneLeaf, dArray3);
                    double d2 = dArray3[0];
                    if (d2 < dArray[0] || d2 > dArray2[0] || !((d = dArray3[1]) >= dArray[1]) || !(d <= dArray2[1])) continue;
                    linkedList.add(zoneLeaf);
                }
            }
            return linkedList;
        }

        public LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType) {
            double[] dArray = this.translateToPlot(n, n2 + n4, 0);
            double[] dArray2 = this.translateToPlot(n + n3, n2, 0);
            return this.collectRectangleFromData(dArray, dArray2, bl);
        }

        public ZoneLeaf getLeafAt(Point point) {
            try {
                int n = FloatWindowPlot2D.this.getHandWidth() * 2;
                int n2 = point.x - n / 2;
                int n3 = point.y - n / 2;
                LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(n2, n3, n, n, false, AbstractRubberband.RubberType.Normal);
                if (linkedList.isEmpty()) {
                    return null;
                }
                int[] nArray = new int[2];
                double d = Double.MAX_VALUE;
                ZoneLeaf zoneLeaf = null;
                for (ZoneLeaf zoneLeaf2 : linkedList) {
                    FloatWindowPlot2D.this.translateToScreenInt(nArray, zoneLeaf2);
                    double d2 = FloatWindowPlot2D.this.calcDistance(nArray, n2, n3, n, n);
                    if (!(d2 < d)) continue;
                    zoneLeaf = zoneLeaf2;
                    d = d2;
                }
                return zoneLeaf;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean hasLeafAt(Point point) {
            try {
                int n = FloatWindowPlot2D.this.getHandWidth();
                int n2 = point.x - n / 2;
                int n3 = point.y - n / 2;
                LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(n2, n3, n, n, false, AbstractRubberband.RubberType.Normal);
                return !linkedList.isEmpty();
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            this.paint(graphics2D, by, d, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics2D graphics2D, byte by, double d, int n) {
            double d2;
            Line2D.Double double_ = new Line2D.Double();
            AxisRange axisRange = FloatWindowPlot2D.this.getRange(0, n);
            AxisRange axisRange2 = FloatWindowPlot2D.this.getRange(1, n);
            double[] dArray = new double[2];
            graphics2D.setColor(FloatWindowPlot2D.this.getPlotBgColor());
            graphics2D.fillRect(this.origoX, this.origoY, this.width, this.height);
            double d3 = d2 = FloatWindowPlot2D.this.plotYaxis.isInverted() ? axisRange2.getDataMin() : 0.0;
            if (FloatWindowPlot2D.this.showGrid()) {
                double d4;
                double d5;
                List<TickInfo> list;
                graphics2D.setColor(FloatWindowPlot2D.this.getGridColor());
                graphics2D.setStroke(FloatWindowPlot2D.this.gridStroke);
                graphics2D.setFont(FloatWindowPlot2D.this.AxisFont);
                List<TickInfo> list2 = list = axisRange.getTickList();
                synchronized (list2) {
                    for (TickInfo tickInfo : list) {
                        d5 = FloatWindowPlot2D.this.plotXaxis.getDataPos(tickInfo.pos);
                        d4 = this.translateToScreenDouble(dArray, d5, 0.0, axisRange, axisRange2)[0];
                        if (!axisRange.isInside(d5) || !this.isInsideX((int)d4)) continue;
                        ((Line2D)double_).setLine(d4, this.origoY, d4, this.origoY + this.height);
                        graphics2D.draw(double_);
                    }
                }
                list2 = list = axisRange2.getTickList();
                synchronized (list2) {
                    for (TickInfo tickInfo : list) {
                        d5 = FloatWindowPlot2D.this.plotYaxis.getDataPos(tickInfo.pos);
                        if (FloatWindowPlot2D.this.plotYaxis.isInverted()) {
                            d5 = axisRange2.getDataMax() - d5 + axisRange2.getDataMin();
                        }
                        d4 = this.translateToScreenDouble(dArray, 0.0, d5 - d2, axisRange, axisRange2)[1];
                        if (!axisRange2.isInside(d5) || !this.isInsideY((int)d4)) continue;
                        ((Line2D)double_).setLine(this.origoX, d4, this.origoX + this.width, d4);
                        graphics2D.draw(double_);
                    }
                }
            }
            graphics2D.setColor(FloatWindowPlot2D.this.getZeroColor());
            if (FloatWindowPlot2D.this.showZeroLines()) {
                graphics2D.setStroke(FloatWindowPlot2D.this.axisStroke);
                double d6 = 0.0;
                if (FloatWindowPlot2D.this.plotYaxis.isInverted()) {
                    d6 = axisRange2.getDataMax() - d6 + axisRange2.getDataMin();
                }
                Iterator<TickInfo> iterator = (Iterator<TickInfo>)this.translateToScreenDouble(dArray, 0.0, d6 - d2, axisRange, axisRange2);
                if (axisRange.isInside(0.0) && this.isInsideX((int)iterator[0])) {
                    ((Line2D)double_).setLine((double)iterator[0], this.origoY, (double)iterator[0], this.origoY + this.height);
                    graphics2D.draw(double_);
                }
                if (axisRange2.isInside(0.0) && this.isInsideY((int)iterator[1])) {
                    ((Line2D)double_).setLine(this.origoX, (double)iterator[1], this.origoX + this.width, (double)iterator[1]);
                    graphics2D.draw(double_);
                }
            }
            if (FloatWindowPlot2D.this.getShapeType() != -1) {
                graphics2D.setColor(FloatWindowPlot2D.this.getBorderColor());
                graphics2D.drawRect(this.origoX, this.origoY, this.width, this.height);
            }
            this.drawStatistic(graphics2D, d, true, by);
        }

        public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        }

        public double[] translateToPlot(double d, double d2, int n) {
            AxisRange axisRange = FloatWindowPlot2D.this.getRange(0, n);
            AxisRange axisRange2 = FloatWindowPlot2D.this.getRange(1, n);
            double d3 = axisRange.transform((d - (double)this.origoX) / (double)this.width);
            double d4 = axisRange2.transform(((double)(this.height + this.origoY) - d2) / (double)this.height);
            return new double[]{d3, d4};
        }

        public double[] translateToPlotOrigo(double d, double d2, int n) {
            double d3 = FloatWindowPlot2D.this.getRange(0, n).scale(d / (double)this.width);
            double d4 = FloatWindowPlot2D.this.getRange(1, n).scale(-d2 / (double)this.height);
            return new double[]{d3, d4};
        }

        public double[] translateToScreenDouble(double d, double d2, int n) {
            return this.translateToScreenDouble(new double[2], d, d2, n);
        }

        public double[] translateToScreenDouble(double[] dArray, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
            dArray[0] = axisRange.invTransform(d) * (double)this.width + (double)this.origoX;
            dArray[1] = (double)this.height - axisRange2.invTransform(d2) * (double)this.height + (double)this.origoY;
            return dArray;
        }

        public double[] translateToScreenDouble(double[] dArray, double d, double d2, int n) {
            return this.translateToScreenDouble(dArray, d, d2, FloatWindowPlot2D.this.getRange(0, n), FloatWindowPlot2D.this.getRange(1, n));
        }

        public int[] translateToScreenInt(double d, double d2) {
            int[] nArray = new int[2];
            this.translateToScreenInt(nArray, d, d2, 0);
            return nArray;
        }

        public void translateToScreenInt(int[] nArray, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
            nArray[0] = (int)(axisRange.invTransform(d) * (double)this.width + (double)this.origoX);
            nArray[1] = (int)((double)this.height - axisRange2.invTransform(d2) * (double)this.height + (double)this.origoY);
        }

        public void translateToScreenInt(int[] nArray, double d, double d2, int n) {
            this.translateToScreenInt(nArray, d, d2, FloatWindowPlot2D.this.getRange(0, n), FloatWindowPlot2D.this.getRange(1, n));
        }

        protected void adjustToAspectRatio() {
            double d;
            AxisRange axisRange = FloatWindowPlot2D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowPlot2D.this.getRange(1, 0);
            double d2 = axisRange.getAbs();
            double d3 = axisRange2.getAbs();
            if (Double.compare(d2, 0.0) == 0 || Double.compare(d3, 0.0) == 0 || this.width == 0 || this.height == 0) {
                return;
            }
            double d4 = axisRange.getDataAbs();
            double d5 = axisRange2.getDataAbs();
            if (d4 < d2) {
                axisRange.zoomAll();
                d2 = d4;
            }
            if (d5 < d3) {
                axisRange2.zoomAll();
                d3 = d5;
            }
            if ((d = (double)this.height * d2 / ((double)this.width * d3)) > 1.0) {
                axisRange2.zoomNoAdjust(0.5 * d - 0.5);
            } else {
                axisRange.zoomNoAdjust(0.5 / d - 0.5);
            }
            FloatWindowPlot2D.this.calculateAxisTicks((byte)0);
            FloatWindowPlot2D.this.calculateAxisTicks((byte)1);
        }

        protected final void drawStatistic(Graphics2D graphics2D, double d, boolean bl, byte by) {
            Shape shape = graphics2D.getClip();
            if ((by & 0x20) != 32) {
                graphics2D.setClip(this.origoX, this.origoY, this.width, this.height);
            }
            int n = FloatWindowPlot2D.this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n; ++i) {
                AbstractAxisLayer abstractAxisLayer = FloatWindowPlot2D.this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractAxisLayer == null || !abstractAxisLayer.isLayerReady() || !abstractAxisLayer.isLayerVisible()) continue;
                abstractAxisLayer.drawStatistics(graphics2D, 0.0, d, bl);
            }
            graphics2D.setClip(shape);
        }

        protected ResourceNode getResourceNode(ZoneLeaf zoneLeaf) {
            DataImage dataImage;
            ComboBoxShape comboBoxShape;
            AbstractAxisLayer abstractAxisLayer = zoneLeaf.getLayer();
            if (zoneLeaf.getShapeType() < 0 && abstractAxisLayer != null && (comboBoxShape = (ComboBoxShape)abstractAxisLayer.getSettingsBoxMap().get((byte)5)).getCurType() == 21 && (dataImage = comboBoxShape.getDataImage()) != null) {
                InnerColumnImageResource innerColumnImageResource = (InnerColumnImageResource)dataImage.getInnerColumn(comboBoxShape.getAxisIndex());
                return innerColumnImageResource.getResourceNode();
            }
            return this.rootResourceNode;
        }

        protected void resolveResourceNode() {
            this.rootResourceNode = FloatWindowPlot2D.this.getRootResourceNode();
        }

        private void collectRectangleFromData(LinkedList<ZoneLeaf> linkedList, LeafList leafList, int n, int n2, double[] dArray, double[] dArray2, boolean bl) {
            for (int i = n; i < n2; ++i) {
                double d;
                double d2;
                ZoneLeaf zoneLeaf = (ZoneLeaf)leafList.get(i);
                if (!zoneLeaf.isVisibleAndNotMissing() || bl && zoneLeaf.isSelected() || (d2 = zoneLeaf.getValue((byte)0)) < dArray[0] || d2 > dArray2[0] || !((d = zoneLeaf.getValue((byte)1)) >= dArray[1]) || !(d <= dArray2[1])) continue;
                linkedList.add(zoneLeaf);
            }
        }
    }

    protected class PlotXaxis
    extends PlotZone {
        public PlotXaxis(Color color, double d, double d2) {
            super(color, d, d2, (byte)1);
        }

        public double getDataPos(double d) {
            return d;
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            this.paint(graphics2D, by, d, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics2D graphics2D, byte by, double d, int n) {
            if ((by & 1) == 1) {
                List<TickInfo> list;
                graphics2D.setFont(FloatWindowPlot2D.this.AxisFont);
                graphics2D.setStroke(FloatWindowPlot2D.this.axisStroke);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                Line2D.Double double_ = new Line2D.Double(0.0, (double)this.origoY + 5.0 * d, 0.0, this.origoY);
                AxisRange axisRange = FloatWindowPlot2D.this.getRange(0, n);
                AxisRange axisRange2 = FloatWindowPlot2D.this.getRange(1, n);
                double[] dArray = new double[2];
                List<TickInfo> list2 = list = axisRange.getTickList();
                synchronized (list2) {
                    for (TickInfo tickInfo : list) {
                        double d2 = this.getDataPos(tickInfo.pos);
                        double d3 = FloatWindowPlot2D.this.plotGround.translateToScreenDouble(dArray, d2, 0.0, axisRange, axisRange2)[0];
                        if (!FloatWindowPlot2D.this.plotGround.isInsideX((int)d3) || FloatWindowPlot2D.this instanceof FloatWindowContour2D && (d2 <= axisRange.getDataMin() || d2 > axisRange.getDataMax())) continue;
                        AffineTransform affineTransform = graphics2D.getTransform();
                        graphics2D.translate(d3, 0.0);
                        if (FloatWindowPlot2D.this.showGrid()) {
                            graphics2D.setColor(FloatWindowPlot2D.this.gridColor);
                            graphics2D.setStroke(FloatWindowPlot2D.this.gridStroke);
                            graphics2D.draw(double_);
                        }
                        if (FloatWindowPlot2D.this.showTicks()) {
                            graphics2D.setColor(FloatWindowPlot2D.this.axisColor);
                            graphics2D.setStroke(FloatWindowPlot2D.this.axisStroke);
                            graphics2D.setFont(FloatWindowPlot2D.this.getDescriptionFontX());
                            String string = FloatWindowPlot2D.this.getDescriptionX(tickInfo);
                            FontMetrics fontMetrics = graphics2D.getFontMetrics();
                            double d4 = fontMetrics.stringWidth(string);
                            graphics2D.translate((double)((float)(-d4)) * FloatWindowPlot2D.this.textRelative / 2.0, (double)this.origoY + (double)fontMetrics.getHeight() * FloatWindowPlot2D.this.textRelative + 6.0 * d);
                            graphics2D.scale(FloatWindowPlot2D.this.textRelative, FloatWindowPlot2D.this.textRelative);
                            graphics2D.drawString(string, 0, 0);
                        }
                        graphics2D.setTransform(affineTransform);
                    }
                }
                graphics2D.setPaint(Color.black);
            }
        }

        public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        }
    }

    protected class PlotYaxis
    extends PlotZone {
        public PlotYaxis(Color color, double d, double d2) {
            super(color, d, d2, (byte)1);
        }

        public double getDataPos(double d) {
            return d;
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            this.paint(graphics2D, by, d, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics2D graphics2D, byte by, double d, int n) {
            if ((by & 1) == 1) {
                graphics2D.setFont(FloatWindowPlot2D.this.AxisFont);
                graphics2D.setStroke(FloatWindowPlot2D.this.axisStroke);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                int n2 = 0;
                Line2D.Double double_ = new Line2D.Double((double)(this.origoX + this.width) - 5.0 * d, 0.0, this.origoX + this.width, 0.0);
                AxisRange axisRange = FloatWindowPlot2D.this.getRange(0, n);
                AxisRange axisRange2 = FloatWindowPlot2D.this.getRange(1, n);
                List<TickInfo> list = axisRange2.getTickList();
                double[] dArray = new double[2];
                List<TickInfo> list2 = list;
                synchronized (list2) {
                    double d2 = this.isInverted() ? axisRange2.getDataMin() : 0.0;
                    for (TickInfo tickInfo : list) {
                        double d3;
                        double d4 = this.getDataPos(tickInfo.pos);
                        if (this.isInverted()) {
                            d4 = axisRange2.getDataMax() - d4 + axisRange2.getDataMin();
                        }
                        if (!FloatWindowPlot2D.this.plotGround.isInsideY((int)(d3 = FloatWindowPlot2D.this.plotGround.translateToScreenDouble(dArray, 0.0, d4 - d2, axisRange, axisRange2)[1]))) continue;
                        AffineTransform affineTransform = graphics2D.getTransform();
                        graphics2D.translate(0.0, d3);
                        if (FloatWindowPlot2D.this.showGrid()) {
                            graphics2D.setColor(FloatWindowPlot2D.this.gridColor);
                            graphics2D.setStroke(FloatWindowPlot2D.this.gridStroke);
                            graphics2D.draw(double_);
                        }
                        if (FloatWindowPlot2D.this.showTicks()) {
                            graphics2D.setColor(FloatWindowPlot2D.this.axisColor);
                            graphics2D.setStroke(FloatWindowPlot2D.this.axisStroke);
                            graphics2D.setFont(FloatWindowPlot2D.this.getDescriptionFontY());
                            String string = FloatWindowPlot2D.this.getDescriptionY(tickInfo);
                            FontMetrics fontMetrics = graphics2D.getFontMetrics();
                            double d5 = fontMetrics.stringWidth(string);
                            graphics2D.translate((double)(this.origoX + this.width) - d5 * FloatWindowPlot2D.this.textRelative - 7.0 * d, (double)fontMetrics.getHeight() * FloatWindowPlot2D.this.textRelative / 3.0);
                            graphics2D.scale(FloatWindowPlot2D.this.textRelative, FloatWindowPlot2D.this.textRelative);
                            graphics2D.drawString(string, 0, 0);
                            int n3 = fontMetrics.stringWidth(string) + 10;
                            if (n3 > n2) {
                                n2 = n3;
                            }
                        }
                        graphics2D.setTransform(affineTransform);
                    }
                    graphics2D.setPaint(Color.black);
                }
            }
        }

        public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        }

        protected boolean isInverted() {
            return false;
        }
    }
}

