/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.List;
import javax.swing.ToolTipManager;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.spectral.SpectralAccessorPanel;
import se.prediktera.map.plot.axisplot.windows.PlotZoneText;

public abstract class FloatWindowPlotRadius2D
extends FloatWindowPlot2D {
    private final SpectralAccessorPanel accessorPanel;
    protected double[][] localminmax = new double[3][2];
    protected final Line2D line = new Line2D.Double();

    public FloatWindowPlotRadius2D(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.accessorPanel = new SpectralAccessorPanel(this, plotInit, null, null);
        this.setAccessorPanel(this.accessorPanel);
    }

    public FloatWindowPlotRadius2D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.accessorPanel = new SpectralAccessorPanel(this, this.getPlotInit(), randomInputStream, mapProperty);
        this.setAccessorPanel(this.accessorPanel);
        this.localminmax = mapProperty.getPropertyDoubleArray2d("lmm", null);
    }

    public SpectralAccessorPanel getAccessorPanel() {
        return this.accessorPanel;
    }

    @Override
    public Font getDescriptionFontX() {
        return this.accessorPanel.getDescriptionFont();
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        double[] dArray = this.localminmax[n];
        double d = 1.5707963267948966;
        boolean bl = true;
        for (int i = 0; i < 4; ++i) {
            double d2 = n == 0 ? Math.cos(d) * 0.5 : Math.sin(d) * 0.5;
            if (bl) {
                dArray[0] = dArray[1] = d2;
                bl = false;
            } else {
                if (dArray[0] > d2) {
                    dArray[0] = d2;
                }
                if (dArray[1] < d2) {
                    dArray[1] = d2;
                }
            }
            d += 2.0943951023931953;
        }
        return dArray;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        this.accessorPanel.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyDoubleArray("lmm", this.localminmax);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.accessorPanel.setCreated(abstractWindow_GUI, bl);
    }

    @Override
    protected void cleanUpChild() {
        if (this.accessorPanel != null) {
            this.accessorPanel.cleanUp();
        }
        super.cleanUpChild();
    }

    protected String getDescription(int n) {
        return this.accessorPanel.getDescription(n);
    }

    protected int getDescriptionCount() {
        return this.accessorPanel.getDescriptionCount();
    }

    @Override
    protected void init() {
        this.plotGround = this.createPlotGround();
        this.addPlotZone(this.plotGround, 4);
        this.addPlotZone(new PlotZoneText(Color.white, 0.05, 0.0, false), 2);
        this.addPlotZone(new PlotZoneText(Color.white, 0.0, 0.05, false), 1);
        this.addPlotZone(new PlotZoneText(Color.white, 0.05, 0.0, false), 3);
        this.addPlotZone(new PlotZoneText(Color.white, 0.0, 0.05, false), 0);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    protected class PlotRadiusGrid
    extends FloatWindowPlot2D.PlotGrid {
        public PlotRadiusGrid(Color color, double d, double d2) {
            super(color, d, d2);
        }

        public void paint(Graphics2D graphics2D, byte by, double d, int n, int n2, boolean bl) {
            AxisRange axisRange = FloatWindowPlotRadius2D.this.getRange(0, n);
            AxisRange axisRange2 = FloatWindowPlotRadius2D.this.getRange(1, n);
            int[] nArray = new int[2];
            this.translateToScreenInt(nArray, 0.0, 0.0, axisRange, axisRange2);
            List<TickInfo> list = this.getTickList();
            if (FloatWindowPlotRadius2D.this.localminmax == null) {
                FloatWindowPlotRadius2D.this.getMinmax(0, 0);
                FloatWindowPlotRadius2D.this.getMinmax(1, 0);
            }
            this.draw(true, graphics2D, list.get(list.size() - 1), n2, bl, false, d);
            graphics2D.setFont(FloatWindowPlotRadius2D.this.AxisFont);
            if (FloatWindowPlotRadius2D.this.showGrid()) {
                graphics2D.setStroke(FloatWindowPlotRadius2D.this.gridStroke);
                graphics2D.setColor(FloatWindowPlotRadius2D.this.getGridColor());
                this.drawGrid(graphics2D, n2, list, d);
            }
            this.draw(false, graphics2D, list.get(list.size() - 1), n2, bl, true, d);
            graphics2D.setColor(FloatWindowPlotRadius2D.this.getBorderColor());
        }

        protected void draw(boolean bl, Graphics2D graphics2D, TickInfo tickInfo, int n, boolean bl2, boolean bl3, double d) {
            AxisRange axisRange = FloatWindowPlotRadius2D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowPlotRadius2D.this.getRange(1, 0);
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[2];
            double d2 = tickInfo.pos;
            boolean bl4 = true;
            double d3 = 1.5707963267948966;
            double d4 = 0.0;
            double d5 = 0.0;
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < n + 1; ++i) {
                if (bl4) {
                    d4 = Math.cos(d3) * d2;
                    d5 = Math.sin(d3) * d2;
                    bl4 = false;
                } else {
                    double d6 = Math.cos(d3) * d2;
                    double d7 = Math.sin(d3) * d2;
                    this.translateToScreenInt(nArray2, d4, d5, axisRange, axisRange2);
                    this.translateToScreenInt(nArray3, d6, d7, axisRange, axisRange2);
                    if (bl3) {
                        graphics2D.setColor(FloatWindowPlotRadius2D.this.getBorderColor());
                        if (FloatWindowPlotRadius2D.this.showTicks()) {
                            this.drawAxisTick(graphics2D, d4, d5, d6, d7, d);
                        }
                    }
                    if (bl2) {
                        this.translateToScreenInt(nArray2, d2, d2, axisRange, axisRange2);
                        graphics2D.drawOval(nArray2[0], nArray2[1], nArray2[0] - nArray[0], nArray[1] - nArray2[1]);
                    } else {
                        if (generalPath.getCurrentPoint() == null) {
                            generalPath.moveTo(nArray2[0], nArray2[1]);
                        }
                        generalPath.lineTo(nArray3[0], nArray3[1]);
                    }
                    if (bl3) {
                        this.drawDescription(graphics2D, i, d4, d5, d6, d7, d3, n, d2, d);
                    }
                    d4 = d6;
                    d5 = d7;
                }
                d3 += Math.PI * 2 / (double)n;
            }
            generalPath.closePath();
            if (bl) {
                graphics2D.setColor(FloatWindowPlotRadius2D.this.getPlotBgColor());
                graphics2D.fill(generalPath);
            } else {
                graphics2D.setColor(FloatWindowPlotRadius2D.this.getZeroColor());
                graphics2D.draw(generalPath);
            }
        }

        protected void drawAxisTick(Graphics2D graphics2D, double d, double d2, double d3, double d4, double d5) {
        }

        protected void drawDescription(Graphics2D graphics2D, int n, double d, double d2, double d3, double d4, double d5, int n2, double d6, double d7) {
            AxisRange axisRange = FloatWindowPlotRadius2D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowPlotRadius2D.this.getRange(1, 0);
            int[] nArray = new int[2];
            Font font = graphics2D.getFont();
            graphics2D.setFont(new Font(font.getName(), 1, (int)((double)(font.getSize() + 2) * d7)));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            double d8 = Math.cos(d5) * d6 * 1.1;
            double d9 = Math.sin(d5) * d6 * 1.2;
            this.translateToScreenInt(nArray, d8, d9, axisRange, axisRange2);
            String string = FloatWindowPlotRadius2D.this.getDescription(n % n2);
            AffineTransform affineTransform = graphics2D.getTransform();
            int n3 = fontMetrics.stringWidth(string);
            if (d8 < -0.001) {
                n3 = 0;
            } else if (d8 > 0.001) {
                n3 *= 2;
            }
            graphics2D.setColor(FloatWindowPlotRadius2D.this.getAxisColor());
            graphics2D.translate(nArray[0] - n3 / 2, nArray[1] + fontMetrics.getHeight());
            graphics2D.drawString(string, 0, 0);
            graphics2D.setTransform(affineTransform);
            graphics2D.setFont(font);
        }

        protected void drawGrid(Graphics2D graphics2D, int n, List<TickInfo> list, double d) {
            for (TickInfo tickInfo : list) {
                this.draw(false, graphics2D, tickInfo, n, false, false, d);
            }
        }

        protected List<TickInfo> getTickList() {
            AxisRange axisRange = FloatWindowPlotRadius2D.this.getRange(0, 0);
            return axisRange.getTickList();
        }
    }
}

