/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.plot.ColorCache;
import se.prediktera.map.plot.axisplot.ZoneLeaf;

public final class PlotImages {
    public static final int IMAGE_TYPES = 14;
    public static final int CIRCLE_IMAGE = 0;
    public static final int RECTANGLE_IMAGE = 1;
    public static final int UPPER_TRIANGLE_IMAGE = 2;
    public static final int LOWER_TRIANGLE_IMAGE = 3;
    public static final int DIAMOND_IMAGE = 4;
    public static final int CIRCLE_IMAGE_BORDER = 5;
    public static final int RECTANGLE_IMAGE_BORDER = 6;
    public static final int UPPER_TRIANGLE_IMAGE_BORDER = 7;
    public static final int LOWER_TRIANGLE_IMAGE_BORDER = 8;
    public static final int DIAMOND_IMAGE_BORDER = 9;
    public static final int PLUS_IMAGE = 10;
    public static final int SQUARE_IMAGE = 11;
    public static final int SQUARE_LINE_IMAGE = 12;
    public static final int LINE_IMAGE = 13;
    public static final String[] IMAGE_DESCRIPTION = new String[]{"Circle", "Square", "Upper Triangle", "Lower Triangle", "Diamond", "Hollow Circle", "Hollow Square", "Hollow Upper Triangle", "Hollow Lower Triangle", "Hollow Diamond", "Plus", "Cross", "Cross and Line", "Line"};
    private static boolean accelerateimage = true;
    private static SpeedUpStack speedUpStack = new SpeedUpStack(30);
    private static Color transparentColor = new Color(0, 0, 0, 0);
    private static byte[][] blockImage;
    private static BasicStroke selectionStroke;
    private static BasicStroke selectionStroke2;
    private static int lastSize;
    private static int sqrtSize;
    private static int blockImageIndex;
    private static int blockImageMax;
    private static Color borderColor;
    private static int excludeColor;

    public static void beginScreenShot() {
        accelerateimage = false;
    }

    public static void calcDistanceToEgde() {
        int n;
        int n2;
        int n3;
        int n4 = blockImage.length;
        int n5 = n4 - 1;
        int n6 = blockImage[0].length;
        int n7 = n6 - 1;
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (blockImage[n2][n3] <= 0) continue;
                PlotImages.blockImage[n2][n3] = 127;
            }
        }
        for (n3 = 1; n3 < n6; ++n3) {
            for (n2 = 1; n2 < n5; ++n2) {
                if (blockImage[n2][n3] <= 0) continue;
                n = blockImage[n2 - 1][n3];
                n = (byte)Math.min(n, blockImage[n2 - 1][n3 - 1]);
                n = (byte)Math.min(n, blockImage[n2][n3 - 1]);
                if ((n = (int)((byte)Math.min(n, blockImage[n2 + 1][n3 - 1]))) >= 127) continue;
                PlotImages.blockImage[n2][n3] = (byte)(n + 1);
            }
        }
        for (n3 = n7; n3 >= 0; --n3) {
            for (n2 = n5; n2 >= 0; --n2) {
                if (blockImage[n2][n3] <= 0) continue;
                n = 127;
                if (n2 < n5) {
                    n = (byte)Math.min(n, blockImage[n2 + 1][n3]);
                    if (n3 < n7) {
                        n = (byte)Math.min(n, blockImage[n2 + 1][n3 + 1]);
                    }
                    if (n3 > 0) {
                        n = (byte)Math.min(n, blockImage[n2 + 1][n3 - 1]);
                    }
                }
                if (n3 < n7) {
                    n = (byte)Math.min(n, blockImage[n2][n3 + 1]);
                    if (n2 > 0) {
                        n = (byte)Math.min(n, blockImage[n2 - 1][n3 + 1]);
                    }
                }
                if (n2 > 0) {
                    n = (byte)Math.min(n, blockImage[n2 - 1][n3]);
                    if (n3 > 0) {
                        n = (byte)Math.min(n, blockImage[n2 - 1][n3 - 1]);
                    }
                }
                if (n3 > 0) {
                    n = (byte)Math.min(n, blockImage[n2][n3 - 1]);
                }
                if (n >= 127) continue;
                PlotImages.blockImage[n2][n3] = (byte)(n + 1);
            }
        }
    }

    public static void draw(ResourceNode resourceNode, Graphics2D graphics2D, ZoneLeaf zoneLeaf, int n, int n2, double d, boolean bl) {
        int n3 = (int)((double)zoneLeaf.getSize() * d);
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = zoneLeaf.getShapeType();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n - n3 / 2, n2 - n3 / 2);
        if (n4 >= 0 && n4 < 14) {
            if (bl) {
                graphics2D.setColor(borderColor);
                PlotImages.paintImage(graphics2D, n4, n3, true, 0);
            }
            graphics2D.setColor(zoneLeaf.getColor());
            PlotImages.paintImage(graphics2D, n4, n3, false, 0);
        } else if (resourceNode != null) {
            n4 = n4 < 0 ? zoneLeaf.getPrimaryIndex() : (n4 -= 14);
            ImageResource imageResource = (ImageResource)resourceNode.getTreeNodeAt(n4);
            if (imageResource != null) {
                BufferedImage bufferedImage = imageResource.getChangedColor(zoneLeaf.getColor(), bl);
                imageResource.draw((Graphics)graphics2D, bufferedImage, n3);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    public static void draw(ResourceNode resourceNode, Graphics2D graphics2D, ZoneLeaf zoneLeaf, int[] nArray, double d, boolean bl) {
        PlotImages.draw(resourceNode, graphics2D, zoneLeaf, nArray[0], nArray[1], d, bl);
    }

    public static boolean drawAccelerated(ResourceNode resourceNode, Graphics2D graphics2D, ZoneLeaf zoneLeaf, int[] nArray, double d, boolean bl) {
        byte by = zoneLeaf.getShapeType();
        if (accelerateimage && blockImage != null && by >= 0 && by < 14) {
            int n = (int)Math.ceil((double)zoneLeaf.getSize() * d);
            if (n == 0) {
                return false;
            }
            if (n < 1) {
                n = 1;
            }
            if (nArray[0] < 0 || nArray[0] >= blockImage.length || nArray[1] < 0 || nArray[1] >= blockImage[0].length) {
                return false;
            }
            if ((double)blockImage[nArray[0]][nArray[1]] < Math.ceil((double)n * 0.5)) {
                if (++blockImageIndex > blockImageMax) {
                    blockImageIndex = 0;
                    blockImageMax = 15000;
                    PlotImages.calcDistanceToEgde();
                }
                if (!speedUpStack.isBlocked(nArray, by, n, bl)) {
                    SpeedUp speedUp;
                    int n2 = zoneLeaf.getRGB();
                    if (zoneLeaf.isExcluded()) {
                        n2 = excludeColor;
                    }
                    if (!speedUpStack.isBlocked(speedUp = speedUpStack.getSpeedUp(by, n, n2, bl), n, nArray)) {
                        if (speedUp == null) {
                            speedUp = speedUpStack.createImage(by, n, n2, bl);
                        }
                        speedUp.paintImage(graphics2D, nArray[0], nArray[1]);
                        return true;
                    }
                }
            }
        } else {
            PlotImages.draw(resourceNode, graphics2D, zoneLeaf, nArray, d, bl);
            return true;
        }
        return false;
    }

    public static void drawSelection(Graphics2D graphics2D, ZoneLeaf zoneLeaf, int[] nArray, double d, Color color, boolean bl) {
        int n = (int)((double)zoneLeaf.getSize() * d);
        if (n < 1) {
            n = 1;
        }
        if (selectionStroke == null || n != lastSize) {
            double d2 = 0.4;
            if (zoneLeaf.getShapeType() < 0) {
                d2 = 0.1;
            }
            selectionStroke = new BasicStroke((float)Math.ceil((double)n * d2), 1, 0);
            selectionStroke2 = new BasicStroke((float)Math.ceil((double)n * d2 / 2.0), 1, 0);
            lastSize = n;
            sqrtSize = (int)Math.sqrt(((double)n + 2.0) * ((double)n + 2.0) * 2.0);
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(color);
        int n2 = (int)((double)sqrtSize / 2.0);
        graphics2D.fillOval(nArray[0] - n2, nArray[1] - n2, sqrtSize, sqrtSize);
        graphics2D.setStroke(selectionStroke);
        graphics2D.setColor(color);
        graphics2D.drawOval(nArray[0] - n2, nArray[1] - n2, sqrtSize, sqrtSize);
        graphics2D.setStroke(selectionStroke2);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(nArray[0] - n2, nArray[1] - n2, sqrtSize, sqrtSize);
        graphics2D.setStroke(stroke);
    }

    public static void endScreenShot() {
        accelerateimage = true;
    }

    public static byte[][] getBlockImage() {
        return blockImage;
    }

    public static String getImageDescription(int n) {
        if (n < IMAGE_DESCRIPTION.length) {
            return IMAGE_DESCRIPTION[n];
        }
        return "None";
    }

    public static void incBlockIndex() {
        PlotImages.incBlockIndex(blockImage);
    }

    private static void incBlockIndex(byte[][] byArray) {
        if (byArray != null) {
            for (byte[] byArray2 : byArray) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
        speedUpStack.reset();
        blockImageIndex = 0;
        blockImageMax = 20000;
    }

    public static void main(String[] stringArray) {
        PlotImages.setBlockImage(10, 10);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                PlotImages.blockImage[j][i] = 127;
            }
        }
        PlotImages.blockImage[1][1] = 0;
        PlotImages.blockImage[8][1] = 0;
        PlotImages.blockImage[8][8] = 0;
        PlotImages.blockImage[1][8] = 0;
        PlotImages.calcDistanceToEgde();
        PlotImages.printBlockImage();
    }

    public static void printBlockImage() {
        int n = blockImage.length;
        int n2 = blockImage[0].length;
        for (int i = 0; i < n2; ++i) {
            System.out.print("{");
            for (int j = 0; j < n; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(blockImage[j][i]);
            }
            if (i == n2 - 1) {
                System.out.println("}");
                continue;
            }
            System.out.println("},");
        }
    }

    public static void setBlockImage(int n, int n2) {
        if (blockImage == null || blockImage.length != n || blockImage[0].length != n2) {
            blockImage = new byte[n][n2];
        }
        PlotImages.incBlockIndex(blockImage);
    }

    public static void setBorderColor(Color color) {
        borderColor = color;
    }

    private static Shape createCircleShape(int n) {
        return new Ellipse2D.Double(0.0, 0.0, n, n);
    }

    private static Shape createDiamondShape(int n) {
        int n2 = n / 2;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n2);
        generalPath.lineTo(n2, n);
        generalPath.lineTo(n, n2);
        generalPath.lineTo(n2, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static Shape createLineShape(int n) {
        int n2 = n / 2;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n2);
        generalPath.lineTo(n, n2);
        return generalPath;
    }

    private static Shape createPlusShape(int n) {
        int n2 = n / 2;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n2);
        generalPath.lineTo(n, n2);
        generalPath.moveTo(n2, 0.0f);
        generalPath.lineTo(n2, n);
        return generalPath;
    }

    private static Shape createRectangleShape(int n) {
        return new Rectangle2D.Double(0.0, 0.0, n, n);
    }

    private static Shape createTriangleLowerShape(int n) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n / 2, n + 1);
        generalPath.lineTo(n, 0.0f);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static Shape createTriangleUpperShape(int n) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n / 2, -1.0f);
        generalPath.lineTo(n, n);
        generalPath.lineTo(0.0f, n);
        generalPath.closePath();
        return generalPath;
    }

    private static Shape createXPlusLineShape(int n) {
        int n2 = n / 2;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(n, n);
        generalPath.moveTo(n, 0.0f);
        generalPath.lineTo(0.0f, n);
        generalPath.moveTo(0.0f, n2);
        generalPath.lineTo(n, n2);
        return generalPath;
    }

    private static Shape createXShape(int n) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(n, n);
        generalPath.moveTo(n, 0.0f);
        generalPath.lineTo(0.0f, n);
        return generalPath;
    }

    private static void paintImage(Graphics2D graphics2D, int n, int n2, boolean bl, int n3) {
        float f;
        Shape shape = null;
        Shape shape2 = null;
        boolean bl2 = false;
        int n4 = n3 > 0 ? n2 - 1 : n2;
        switch (n) {
            case 0: 
            case 5: {
                shape = PlotImages.createCircleShape(n2);
                shape2 = PlotImages.createCircleShape(n4);
                bl2 = n == 5;
                break;
            }
            case 1: 
            case 6: {
                shape = PlotImages.createRectangleShape(n2);
                shape2 = PlotImages.createRectangleShape(n4);
                bl2 = n == 6;
                break;
            }
            case 2: 
            case 7: {
                shape = PlotImages.createTriangleUpperShape(n2);
                shape2 = PlotImages.createTriangleUpperShape(n4);
                bl2 = n == 7;
                break;
            }
            case 3: 
            case 8: {
                shape = PlotImages.createTriangleLowerShape(n2);
                shape2 = PlotImages.createTriangleLowerShape(n4);
                bl2 = n == 8;
                break;
            }
            case 4: 
            case 9: {
                shape = PlotImages.createDiamondShape(n2);
                shape2 = PlotImages.createDiamondShape(n4);
                bl2 = n == 9;
                break;
            }
            case 10: {
                shape = PlotImages.createPlusShape(n2);
                shape2 = PlotImages.createPlusShape(n4);
                bl2 = true;
                break;
            }
            case 11: {
                shape = PlotImages.createXShape(n2);
                bl2 = true;
                break;
            }
            case 12: {
                shape = PlotImages.createXPlusLineShape(n2);
                bl2 = true;
                break;
            }
            case 13: {
                shape = PlotImages.createLineShape(n2);
                bl2 = true;
                break;
            }
            default: {
                return;
            }
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n3, n3);
        if (bl2) {
            f = (float)Math.ceil((double)n2 * 0.1) + 2.0f;
            BasicStroke basicStroke = new BasicStroke(f, 1, 0);
            shape = basicStroke.createStrokedShape(shape);
            graphics2D.translate(f / 2.0f, f / 2.0f);
            double d = (double)n2 / (double)((float)n2 + f);
            graphics2D.scale(d, d);
        }
        if (bl) {
            f = (float)Math.ceil((double)n2 * 0.1) + (float)(n2 > 3 ? 1 : 0);
            if (shape2 != null && !bl2) {
                f = (float)Math.ceil((double)n2 * 0.15) + (float)(n2 > 3 ? 1 : 0);
            }
            graphics2D.setStroke(new BasicStroke(f, 1, 0));
            if (shape2 != null && !bl2) {
                graphics2D.draw(shape2);
            } else {
                graphics2D.draw(shape);
            }
        } else {
            graphics2D.fill(shape);
        }
        graphics2D.setTransform(affineTransform);
    }

    static {
        selectionStroke = null;
        selectionStroke2 = null;
        borderColor = Color.black;
        excludeColor = Color.lightGray.getRGB();
    }

    private static class SpeedUpStack {
        private int stacksize;
        private int startindex = 0;
        private final int maxsize;
        private final SpeedUp[] speedUpImages;

        public SpeedUpStack(int n) {
            this.maxsize = n;
            this.speedUpImages = new SpeedUp[n];
            this.reset();
        }

        public SpeedUp createImage(int n, int n2, int n3, boolean bl) {
            Graphics2D graphics2D;
            if (--this.startindex < 0) {
                this.startindex = this.maxsize - 1;
            }
            if (this.stacksize < this.maxsize) {
                ++this.stacksize;
            }
            boolean bl2 = false;
            SpeedUp speedUp = this.speedUpImages[this.startindex];
            SpeedUp speedUp2 = new SpeedUp(n, n2, n3, bl);
            if (speedUp != null && speedUp.imsize == n2) {
                if (speedUp.imtype == n && speedUp.border == bl) {
                    bl2 = true;
                }
                speedUp2.setPaintImage(speedUp.paintImages);
            }
            this.speedUpImages[this.startindex] = speedUp2;
            int n4 = n2 / 2 + 1;
            n4 += n4 % 2;
            int n5 = n2 + n4;
            speedUp2.corrsize = n5 / 2;
            if (speedUp2.paintImages == null || speedUp2.paintImages.getWidth() != n5) {
                speedUp2.setPaintImage(new BufferedImage(n5, n5, 2));
                graphics2D = (Graphics2D)speedUp2.paintImages.getGraphics();
            } else {
                graphics2D = (Graphics2D)speedUp2.paintImages.getGraphics();
                graphics2D.setBackground(transparentColor);
                graphics2D.clearRect(0, 0, n5, n5);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (bl) {
                graphics2D.setColor(borderColor);
                PlotImages.paintImage(graphics2D, n, n2, true, n4 / 2);
            }
            graphics2D.setColor(ColorCache.getColor(n3));
            PlotImages.paintImage(graphics2D, n, n2, false, n4 / 2);
            if (bl2) {
                speedUp2.boolImage = speedUp.boolImage;
            } else {
                speedUp2.boolImage = new boolean[n2 + n4][n2 + n4];
                for (int i = 0; i < n2 + n4; ++i) {
                    for (int j = 0; j < n2 + n4; ++j) {
                        int n6 = speedUp2.raster.getSample(j, i, 3);
                        speedUp2.boolImage[j][i] = n6 > 0;
                    }
                }
            }
            return speedUp2;
        }

        public SpeedUp getSpeedUp(int n, int n2, int n3, boolean bl) {
            try {
                int n4 = this.startindex;
                int n5 = 0;
                while (n5 < this.stacksize) {
                    if (n4 >= this.maxsize) {
                        n4 = 0;
                    }
                    SpeedUp speedUp = this.speedUpImages[n4];
                    if (speedUp.imtype == n && speedUp.imsize == n2 && speedUp.rgb == n3 && speedUp.border == bl) {
                        if (n5 > 0) {
                            int n6;
                            int n7 = n6 = n4;
                            --n7;
                            int n8 = 0;
                            while (n8 < n5) {
                                if (n7 < 0) {
                                    n7 = this.maxsize - 1;
                                }
                                if (n6 < 0) {
                                    n6 = this.maxsize - 1;
                                }
                                this.speedUpImages[n6] = this.speedUpImages[n7];
                                ++n8;
                                --n7;
                                --n6;
                            }
                            this.speedUpImages[this.startindex] = speedUp;
                        }
                        return speedUp;
                    }
                    ++n5;
                    ++n4;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public boolean isBlocked(int[] nArray, int n, int n2, boolean bl) {
            int n3 = this.startindex;
            int n4 = 0;
            while (n4 < this.stacksize) {
                SpeedUp speedUp;
                if (n3 >= this.maxsize) {
                    n3 = 0;
                }
                if ((speedUp = this.speedUpImages[n3]) != null && speedUp.imtype == n && speedUp.imsize >= n2 && speedUp.border == bl) {
                    int n5;
                    if (n > 4 && speedUp.imsize != n2) {
                        return false;
                    }
                    int n6 = Math.abs(speedUp.xc - nArray[0]);
                    int n7 = n6 = n6 >= (n5 = Math.abs(speedUp.yc - nArray[1])) ? n6 : n5;
                    if (n6 <= (speedUp.imsize - n2) / 2) {
                        return true;
                    }
                }
                ++n4;
                ++n3;
            }
            return false;
        }

        public final boolean isBlocked(SpeedUp speedUp, int n, int[] nArray) {
            block7: {
                int n2 = blockImage.length;
                if (n2 <= 0) break block7;
                int n3 = blockImage[0].length;
                int n4 = (int)((double)n * 0.5) + 1;
                n4 += n4 % 2;
                int n5 = n + n4;
                int n6 = nArray[0] - n5 / 2;
                int n7 = n6 + n5;
                n6 = n6 < 0 ? 0 : n6;
                n7 = n7 >= n2 ? n2 - 1 : n7;
                int n8 = nArray[1] - n5 / 2;
                int n9 = n8 + n5;
                n8 = n8 < 0 ? 0 : n8;
                int n10 = n9 = n9 >= n3 ? n3 - 1 : n9;
                if (speedUp == null || speedUp.boolImage == null) {
                    for (int i = n6; i < n7; ++i) {
                        byte[] byArray = blockImage[i];
                        for (int j = n8; j < n9; ++j) {
                            if (byArray[j] != 0) continue;
                            return false;
                        }
                    }
                } else {
                    int n11 = n6;
                    int n12 = 0;
                    while (n11 < n7) {
                        byte[] byArray = blockImage[n11];
                        boolean[] blArray = speedUp.boolImage[n12];
                        int n13 = n8;
                        int n14 = 0;
                        while (n13 < n9) {
                            if (blArray[n14] && n13 < byArray.length && byArray[n13] == 0) {
                                return false;
                            }
                            ++n13;
                            ++n14;
                        }
                        ++n11;
                        ++n12;
                    }
                }
            }
            return true;
        }

        public void reset() {
            this.startindex = 0;
            this.stacksize = 0;
        }
    }

    private static class SpeedUp {
        private final int imtype;
        private final int imsize;
        private final int rgb;
        private int corrsize;
        private int xc;
        private int yc;
        private final boolean border;
        private BufferedImage paintImages;
        private WritableRaster raster;
        private boolean[][] boolImage;

        public SpeedUp(int n, int n2, int n3, boolean bl) {
            this.imtype = n;
            this.imsize = n2;
            this.rgb = n3;
            this.border = bl;
        }

        public void paintImage(Graphics2D graphics2D, int n, int n2) {
            this.xc = n;
            this.yc = n2;
            graphics2D.drawImage((Image)this.paintImages, n - this.corrsize, n2 - this.corrsize, null);
            int n3 = blockImage.length;
            int n4 = blockImage[0].length;
            int n5 = this.paintImages.getWidth();
            if (this.boolImage != null) {
                int n6 = n - n5 / 2;
                int n7 = n6 + n5;
                n6 = n6 < 0 ? 0 : n6;
                n7 = n7 >= n3 ? n3 - 1 : n7;
                int n8 = n2 - n5 / 2;
                int n9 = n8 + n5;
                n8 = n8 < 0 ? 0 : n8;
                n9 = n9 >= n4 ? n4 - 1 : n9;
                int n10 = n6;
                int n11 = 0;
                while (n10 < n7) {
                    boolean[] blArray = this.boolImage[n11];
                    byte[] byArray = blockImage[n10];
                    int n12 = n8;
                    int n13 = 0;
                    while (n12 < n9) {
                        if (blArray[n13] && n12 < byArray.length) {
                            byArray[n12] = (byte)Math.max(1, byArray[n12]);
                        }
                        ++n12;
                        ++n13;
                    }
                    ++n10;
                    ++n11;
                }
            }
        }

        public void setPaintImage(BufferedImage bufferedImage) {
            this.paintImages = bufferedImage;
            this.raster = bufferedImage.getRaster();
        }
    }
}

