/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.contour2D;

import java.awt.Font;
import java.io.IOException;
import java.util.List;
import se.prediktera.map.common.ComplexName;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRangeSurface;
import se.prediktera.map.plot.axisplot.settings.ComboBoxStatistics;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class Contour2DLayer
extends AbstractAxisLayer {
    private ComboBoxRangeSurface boxRange;

    public Contour2DLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.layerName = "Layer " + n;
        this.jbinit();
    }

    public Contour2DLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.jbinit();
    }

    public void calculatePlotShapeFixed(byte by) {
        List<ZoneLeaf> list = this.getRootList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setShapeType(by);
        }
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new Contour2DLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    @Override
    public Font getDescriptionFont() {
        return null;
    }

    @Override
    public double[] getMinmax(int n) {
        double[] dArray = this.boxRange.getMinmax(1 - n);
        dArray[1] = dArray[1] + 1.0;
        return dArray;
    }

    @Override
    public int getNrObjects() {
        int n = 0;
        if (this.zoneList != null) {
            for (ZoneArray zoneArray : this.zoneList) {
                if (zoneArray.isMissing()) continue;
                int n2 = zoneArray.getNoChildren();
                for (int i = 0; i < n2; ++i) {
                    if (zoneArray.isMissing(i)) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    @Override
    public int getNrVisibleObjects() {
        int n = 0;
        if (!this.isLayerVisible()) {
            return 0;
        }
        if (this.zoneList != null) {
            for (ZoneArray zoneArray : this.zoneList) {
                if (!zoneArray.isVisibleAndNotMissing()) continue;
                int n2 = zoneArray.getNoChildren();
                for (int i = 0; i < n2; ++i) {
                    if (!zoneArray.isVisibleAndNotMissing(i)) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    @Override
    public byte getTreeType() {
        return 9;
    }

    @Override
    public void includePoints(List<ZoneLeaf> list, AbstractAxisLayer abstractAxisLayer) {
        for (int i = 0; i < list.size(); ++i) {
            ZoneArray zoneArray = (ZoneArray)list.get(i);
            int n = zoneArray.getFirstTagged();
            while (n >= 0) {
                zoneArray.setLayer(n, this);
                n = zoneArray.getNextTagged(n);
            }
            zoneArray.checkLayerArray();
        }
        this.updateCalculations(null, true);
        if (this.isCreated) {
            this.axisPlot.contentPaint((byte)7);
        }
    }

    public boolean isShowLines() {
        return false;
    }

    public void reCalc() {
    }

    @Override
    public void setShowLines(boolean bl) {
    }

    @Override
    public String toString() {
        return this.layerName;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxRange = null;
    }

    @Override
    protected void InitLayer() {
        PlotInit plotInit = this.getPlotInit();
        boolean bl = plotInit.plotType == 1 || plotInit.dofold;
        ComplexName complexName = bl ? OBSCATEGORYSTRING : VARCATEGORYSTRING;
        ComplexName complexName2 = bl ? VARCATEGORYSTRING : OBSCATEGORYSTRING;
        AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(OBSVALUESTRING, 0));
        this.boxColor.addItem(new ComboItem(VARVALUESTRING, 100));
        if (!plotInit.dofold) {
            this.boxColor.addItem(new ComboItem(complexName, 7));
            if (plotInit.isSecondaryMatrixTagObsVar()) {
                this.boxColor.addItem(new ComboItem(complexName2, 101));
            }
        } else {
            this.boxColor.addItem(new ComboItem(CATEGORYSTRING, 7));
        }
        if (bl) {
            this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        }
        this.boxColor.addItem(new ComboItem(AMPLITUDESTRING, 11));
        this.boxColor.addItem(new ComboItem(MISSINGVALUESTRING, 14));
        this.boxColor.addItem(new ComboItem("%SEPARATOR#", 3));
        this.boxColor.setAltitudeAxis((byte)2);
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxComment = new ComboBoxComment(abstractDataMatrix, this);
        this.boxComment.addItem(new ComboItem(NONESTRING, 2));
        this.boxComment.addItem(new ComboItem(CUSTOMSTRING, 1));
        this.boxComment.addItem(new ComboItem(complexName, 7));
        if (!plotInit.dofold && plotInit.isSecondaryMatrixTagObsVar()) {
            this.boxComment.addItem(new ComboItem(complexName2, 101));
        }
        this.boxComment.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxComment.getType(), this.boxComment);
        this.boxStatistics = new ComboBoxStatistics(this, 0);
        this.boxStatistics.addItem(new ComboItem(NONESTRING, 2));
        this.settingsBoxMap.put(this.boxStatistics.getType(), this.boxStatistics);
        this.InitLayerChild();
    }

    @Override
    protected void InitLayerChild() {
        this.boxRange = new ComboBoxRangeSurface(this, false);
        this.boxRange.addItem(new ComboItem("[MATRIX]", 10));
        this.boxRange.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxRange.getType(), this.boxRange);
        if (this.isSubLayer()) {
            this.boxRange.setEnabled(false);
        }
    }

    private void jbinit() {
        this.add(SettingsBoxHelper.createRangePanel(this.boxRange));
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createCommentPanel(this.boxComment));
        this.add(SettingsBoxHelper.createStatisticsPanel(this.boxStatistics));
    }
}

