/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.contour2D;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2DLayer;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.ContourAccessorPanel;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandSimilar;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;

public class FloatWindowContour2D
extends FloatWindowPlot2D
implements MouseMotionListener {
    public static final double CORRECTION = 4.656612875245797E-10;
    private static final int excludeColor = Color.lightGray.getRGB();
    private ContourAccessorPanel accessorPanel;

    public FloatWindowContour2D(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.selectionArray = new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
        this.getRange(0, 0).setMinFactor(0.0);
        this.getRange(1, 0).setMinFactor(0.0);
        this.getRange(0, 0).setMaxFactor(0.0);
        this.getRange(1, 0).setMaxFactor(0.0);
        this.getRange(0, 0).setDoublePrecition(false);
        this.getRange(1, 0).setDoublePrecition(false);
        this.accessorPanel = this.createAccessorPanel(plotInit);
        this.setAccessorPanel(this.accessorPanel);
        this.setupDragContribution();
    }

    public FloatWindowContour2D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.selectionArray = mapProperty.hasProperty("selArr") ? new BooleanArray(mapProperty.getLVBooleanArray()) : new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
        try {
            this.accessorPanel = (ContourAccessorPanel)mapProperty.resolveNodeFromName(randomInputStream, "acc");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.accessorPanel == null) {
            this.accessorPanel = this.createAccessorPanel(this.getPlotInit());
        }
        this.setAccessorPanel(this.accessorPanel);
        if (this.isSAM()) {
            this.hideComboBoxOfType((byte)9);
        }
        this.setupDragContribution();
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new Contour2DLayer(this, plotInit, null, null, n);
    }

    @Override
    public Font getDescriptionFontX() {
        return this.accessorPanel.getDescriptionFont();
    }

    @Override
    public Font getDescriptionFontY() {
        return this.accessorPanel.getDescriptionFontY();
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneArray zoneArray = (ZoneArray)this.getLeafAtIndex(abstractAxisLayer, -1, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneArray != null) {
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneArray);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            stringBuilder.append("Row:").append(abstractAxisLayer.getDescription(0, (byte)1, n2)).append("\n");
            int n3 = zoneArray.getNoChildren();
            for (int i = 0; i < n3; ++i) {
                if (zoneArray.getPrimaryIndex(i) != n) continue;
                stringBuilder.append("Column: ").append(abstractAxisLayer.getDescription(0, (byte)0, abstractAxisLayer.getPrimaryIndexArray()[i])).append("\n");
                stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneArray.getValue(i, (byte)0))).append("\n");
                stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneArray.getValue(i, (byte)1) + 1.0)).append("\n");
                break;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        double[] dArray = new double[]{0.0, 0.0};
        if (this.plotAxisLayerPanel == null) {
            return dArray;
        }
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            Contour2DLayer contour2DLayer = (Contour2DLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (UpdateHelper.Product.isRunningProductBreeze() ? contour2DLayer == null || contour2DLayer.isSubLayer() : contour2DLayer == null || contour2DLayer.isSubLayer() || !contour2DLayer.isLayerVisible()) continue;
            List<ZoneLeaf> list = contour2DLayer.getRootList();
            block1: for (int j = 0; j < list.size(); ++j) {
                double d;
                int n4;
                ZoneLeaf zoneLeaf = list.get(j);
                if (n == 1) {
                    if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                    double d2 = zoneLeaf.getSecondaryIndex();
                    if (bl) {
                        dArray[0] = d2;
                        dArray[1] = d2;
                        bl = false;
                        continue;
                    }
                    if (dArray[0] > d2) {
                        dArray[0] = d2;
                        continue;
                    }
                    if (!(dArray[1] < d2)) continue;
                    dArray[1] = d2;
                    continue;
                }
                int n5 = zoneLeaf.getNoChildren();
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!zoneLeaf.isVisibleAndNotMissing(n4)) continue;
                    d = zoneLeaf.getPrimaryIndex(n4);
                    if (bl) {
                        dArray[0] = d;
                        dArray[1] = d;
                        bl = false;
                        break;
                    }
                    if (dArray[0] > d) {
                        dArray[0] = d;
                        break;
                    }
                    if (!(dArray[1] < d)) break;
                    dArray[1] = d;
                    break;
                }
                for (n4 = n5 - 1; n4 > 0; --n4) {
                    if (!zoneLeaf.isVisibleAndNotMissing(n4)) continue;
                    d = zoneLeaf.getPrimaryIndex(n4);
                    if (dArray[0] > d) {
                        dArray[0] = d;
                        continue block1;
                    }
                    if (!(dArray[1] < d)) continue block1;
                    dArray[1] = d;
                    continue block1;
                }
            }
        }
        dArray[1] = dArray[1] + 1.0;
        return dArray;
    }

    @Override
    public Point getPointAtCoordsAt(double d, double d2) {
        AxisRange axisRange = this.getRange(1, 0);
        int n = (int)axisRange.getDataMax() - 1;
        return super.getPointAtCoordsAt(d, (double)n - d2);
    }

    @Override
    public int getSelectedObjectCount() {
        if (this.plotAxisLayerPanel.getFoldN() > 0) {
            int n = 0;
            for (ZoneArray zoneArray : this.selectionList) {
                n += zoneArray.getSelectedChildCount();
            }
            return n;
        }
        return this.selectionList.size() * this.selectionArray.getSetCount();
    }

    @Override
    public byte getTreeType() {
        return 11;
    }

    @Override
    public boolean handleDirectPrintout() {
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband != null && !mouseEvent.isConsumed()) {
                this.rubberbandEnded(this.rubberband, mouseEvent.getModifiersEx(), mouseEvent);
                this.rubberband.clear();
                mouseEvent.consume();
            }
            super.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void moveSelectionIntoLayer(AbstractAxisLayer abstractAxisLayer) {
        for (ZoneArray zoneArray : this.selectionList) {
            zoneArray.tagSelected();
        }
        super.moveSelectionIntoLayer(abstractAxisLayer);
    }

    @Override
    public AbstractAxisLayer moveSelectionIntoNewLayer(AbstractAxisLayer abstractAxisLayer, String string, int n) {
        for (ZoneArray zoneArray : this.selectionList) {
            zoneArray.tagSelected();
        }
        return super.moveSelectionIntoNewLayer(abstractAxisLayer, string, n);
    }

    public boolean needBlockImage() {
        return true;
    }

    public void rubberbandEnded(AbstractRubberband abstractRubberband, int n, MouseEvent mouseEvent) {
        boolean bl;
        Rectangle rectangle = abstractRubberband.getBoundingBox();
        boolean bl2 = (n & 0x40) == 64;
        boolean bl3 = bl = (n & 0x80) == 128;
        if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            Object object;
            if (!bl && !bl2) {
                this.selectedItems(this.selectionList, false, false);
            }
            LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false, abstractRubberband.getRubberType());
            if (abstractRubberband instanceof RubberbandNormal && linkedList.size() == 0) {
                linkedList = this.checkWiderArea(rectangle);
            }
            Iterator iterator = linkedList.iterator();
            AxisRange axisRange = this.getRange(0, 0);
            AxisRange axisRange2 = this.getRange(1, 0);
            int n2 = (int)axisRange2.getDataMax() - 1;
            int[] nArray = new int[2];
            while (iterator.hasNext()) {
                object = (ZoneArray)iterator.next();
                int n3 = ((ZoneLeaf)object).getSecondaryIndex();
                boolean bl4 = false;
                int n4 = ((ZoneArray)object).getFirstTagged();
                while (n4 >= 0) {
                    int n5 = ((ZoneArray)object).getPrimaryIndex(n4);
                    this.plotGround.translateToScreenInt(nArray, (double)n5 + 0.5, n2 - n3, axisRange, axisRange2);
                    if (!this.mustBeBoundedInSelection() || abstractRubberband.isInside(nArray[0], nArray[1])) {
                        if (bl2 || bl && this.selectionArray.get(n5) && ((ZoneArray)object).isSelected(n4)) {
                            if (bl2) {
                                this.selectionArray.set(n5, false);
                                ((ZoneArray)object).setSelected(n4, false);
                            }
                        } else if (((ZoneArray)object).isVisible(n4)) {
                            this.selectionArray.set(n5);
                            ((ZoneArray)object).setSelected(n4, true);
                            if (!bl4 && !this.selectionList.contains(object)) {
                                this.selectionList.add(object);
                            }
                            bl4 = true;
                        }
                    }
                    n4 = ((ZoneArray)object).getNextTagged(n4);
                }
            }
            if (abstractRubberband.getRubberType() == AbstractRubberband.RubberType.Similar) {
                this.selectSimilar((RubberbandSimilar)abstractRubberband);
            }
            if ((object = this.plot.getPlot_GUI().getProject_GUI()) != null) {
                ((Project_GUI)object).doInteraction(this);
            }
            this.repaintPlot((byte)2);
        } else if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Zoom) {
            if (abstractRubberband instanceof RubberbandNormal) {
                RubberbandNormal rubberbandNormal = (RubberbandNormal)abstractRubberband;
                double d = rubberbandNormal.getBWidth() == 0 ? -3.0 : 3.0;
                int n6 = this.plotGround.getPlotUnderCoords(rectangle.x, rectangle.y);
                double[] dArray = this.plotGround.translateToPlot(rectangle.x, rectangle.y, n6);
                this.ZoomContinues(dArray[0], dArray[1], d, n6);
            } else {
                double[] dArray;
                int n7 = rectangle.x;
                int n8 = rectangle.y == mouseEvent.getY() ? rectangle.y + rectangle.height - 1 : rectangle.y;
                int n9 = this.plotGround.getPlotUnderCoords(n7, n8);
                double[] dArray2 = this.plotGround.translateToPlot(rectangle.x, rectangle.y + rectangle.height, n9);
                if (Double.compare(dArray2[0], (dArray = this.plotGround.translateToPlot(rectangle.x + rectangle.width, rectangle.y, n9))[0]) == 0 || Double.compare(dArray2[1], dArray[1]) == 0) {
                    double d = bl2 || bl ? 3.0 : -3.0;
                    double[] dArray3 = this.translateToPlot(rectangle.x, rectangle.y, n9);
                    this.ZoomContinues(dArray3[0], dArray3[1], d, n9);
                } else {
                    this.getRange(0, n9).setMinMax(dArray2[0], dArray[0]);
                    this.getRange(1, n9).setMinMax(dArray2[1], dArray[1]);
                }
            }
            this.calculateAndRepaintSetAxis(true, false);
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("acc", this.accessorPanel);
    }

    @Override
    public void selectedItems(AbstractAxisPlot.SelectionList selectionList, boolean bl, boolean bl2) {
        for (ZoneArray zoneArray : selectionList) {
            zoneArray.setSelected(bl);
        }
        if (!bl) {
            for (int i = 0; i < this.selectionArray.size(); ++i) {
                this.selectionArray.set(i, false);
            }
            selectionList.clear();
        }
        if (bl2 && this.selectionList != null && this.plot.hasInteractivity()) {
            this.plot.getPlot_GUI().getProject_GUI().doInteraction(this);
        }
    }

    public void clearSelectionList() {
        this.selectionList.clear();
    }

    @Override
    public void selectNnearest(int n, int n2) {
    }

    @Override
    public void setAccessorPanel(JPanel jPanel) {
        super.setAccessorPanel(jPanel);
        if (jPanel instanceof AbstractAxisLayer) {
            this.plot.addTreeNode((AbstractAxisLayer)jPanel);
        }
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.accessorPanel.setCreated(abstractWindow_GUI, bl);
    }

    @Override
    public void setSelection(byte by) {
        if (by == 7) {
            this.setRubberband(new RubberbandSimilar(this));
        }
        super.setSelection(by);
    }

    @Override
    protected void addCustomInformation(StringBuilder stringBuilder) {
        if (this.selectionList.isEmpty()) {
            stringBuilder.append("<TR><TD>Min:</TD><TD>").append("N/A");
            stringBuilder.append("<TR><TD>Max:</TD><TD>").append("N/A");
            stringBuilder.append("<TR><TD>Average:</TD><TD>").append("N/A");
        } else {
            double[] dArray = this.calculateAverage();
            stringBuilder.append("<TR><TD>Min:</TD><TD>").append(NiceDataFormat.toString(dArray[0]));
            stringBuilder.append("<TR><TD>Max:</TD><TD>").append(NiceDataFormat.toString(dArray[1]));
            stringBuilder.append("<TR><TD>Average:</TD><TD>").append(NiceDataFormat.toString(dArray[2]));
        }
        stringBuilder.append("</TD></TR>");
    }

    @Override
    protected void cleanUpChild() {
        if (this.accessorPanel != null) {
            this.accessorPanel.cleanUp();
        }
        super.cleanUpChild();
    }

    @Override
    protected void contentPaint(BufferedImage bufferedImage, byte by, boolean bl) {
        ((PlotContour)this.plotGround).image = bufferedImage;
        super.contentPaint(bufferedImage, by, bl);
    }

    protected ContourAccessorPanel createAccessorPanel(PlotInit plotInit) {
        return new ContourAccessorPanel(this, plotInit);
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PlotContour(0.0, 0.0, Color.white);
    }

    @Override
    protected FloatWindowPlot2D.PlotXaxis createXaxis() {
        PlotXaxisContour2D plotXaxisContour2D = new PlotXaxisContour2D(Color.white, 0.0, 0.1);
        plotXaxisContour2D.setMinHeight(20);
        return plotXaxisContour2D;
    }

    @Override
    protected FloatWindowPlot2D.PlotYaxis createYaxis() {
        PlotYaxisContour2D plotYaxisContour2D = new PlotYaxisContour2D(Color.white, 0.1, 0.0);
        plotYaxisContour2D.setMinWidth(30);
        return plotYaxisContour2D;
    }

    @Override
    protected void doQuickInteraction(ZoneLeaf zoneLeaf) {
        ZoneArray zoneArray = (ZoneArray)zoneLeaf;
        Project_GUI project_GUI = this.plot.getPlot_GUI().getProject_GUI();
        if (project_GUI == null) {
            return;
        }
        if (zoneArray != null) {
            int n = zoneArray.getFirstTagged();
            int n2 = this.getPrimaryMatrixTag();
            int n3 = this.plotAxisLayerPanel.getFoldN();
            if (this.isFoldMatrix()) {
                int n4 = zoneArray.getPrimaryIndex(n);
                int n5 = zoneArray.getSecondaryIndex();
                project_GUI.doQuickInteraction(this, n2, n4 * n3 + n5, 16, -1);
            } else {
                int n6 = zoneArray.getSecondaryIndex();
                int n7 = this.getSecondaryMatrixTag();
                int n8 = zoneArray.getPrimaryIndex(n);
                project_GUI.doQuickInteraction(this, n2, n6, n7, n8);
            }
        } else {
            project_GUI.doQuickInteraction(this, -1, -1, -1, -1);
        }
    }

    protected int getDescriptionCountX() {
        return this.accessorPanel.getDescriptionCountX();
    }

    protected int getDescriptionCountY() {
        return this.accessorPanel.getDescriptionCountY();
    }

    @Override
    protected String getDescriptionX(TickInfo tickInfo) {
        return this.accessorPanel.getDescriptionX((int)tickInfo.pos - 1);
    }

    @Override
    protected String getDescriptionY(TickInfo tickInfo) {
        return this.accessorPanel.getDescriptionY((int)tickInfo.pos - 1);
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf instanceof ZoneArray) {
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            int n = zoneArray.getFirstTagged();
            StringBuilder stringBuilder = new StringBuilder(270);
            int n2 = zoneArray.getPrimaryIndex(n);
            int n3 = zoneArray.getSecondaryIndex();
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            AbstractAxisLayer abstractAxisLayer = zoneArray.getLayer();
            if (!abstractAxisLayer.isLayerVisible()) {
                for (int i = 0; i < abstractAxisLayer.getLayerSize(); ++i) {
                    if (this.getLayer(i) == null || !this.getLayer(i).isLayerVisible()) continue;
                    abstractAxisLayer = this.getLayer(i);
                    zoneArray = (ZoneArray)this.getLeafAtIndex(abstractAxisLayer, n2, n3);
                    break;
                }
            }
            if (!abstractAxisLayer.isLayerVisible()) {
                return null;
            }
            stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer).append("</th></tr>");
            String string = abstractAxisLayer.getComment(zoneArray, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            if (!(this.getPlotInit().getMatrix(0) instanceof FoldMatrix)) {
                stringBuilder.append("<tr><td>Row:</td><td>").append(abstractAxisLayer.getDescription(0, (byte)1, n3)).append("</td></tr>");
                stringBuilder.append("<tr><td>Column:</td><td>").append(abstractAxisLayer.getDescription(0, (byte)0, n2)).append("</td></tr>");
            } else {
                stringBuilder.append("<tr><td>X:</td><td>").append(n2 + 1).append("</td></tr>");
                stringBuilder.append("<tr><td>Y:</td><td>").append(n3 + 1).append("</td></tr>");
            }
            double d = abstractAxisLayer.getRangeValueFromIndex((byte)2, n2, n3, 0);
            String string2 = abstractAxisLayer.formatTooltipOrNull(d);
            if (string2 != null) {
                stringBuilder.append("<tr><td>Class:</td><td>").append(string2).append("</td></tr>");
            } else {
                stringBuilder.append("<tr><td>Value:</td><td>").append(NiceDataFormat.toString(d)).append("</td></tr>");
            }
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected float getWhiteBorderSize() {
        return 2.0f;
    }

    @Override
    protected boolean hasZoneArray() {
        return true;
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return this.plotAxisLayerPanel.getFoldN() > 0;
    }

    @Override
    protected void translateToScreenInt(int[] nArray, ZoneLeaf zoneLeaf) {
        int n = zoneLeaf.getSecondaryIndex();
        ZoneArray zoneArray = (ZoneArray)zoneLeaf;
        int n2 = zoneArray.getFirstTagged();
        if (n2 >= 0) {
            int n3 = zoneArray.getPrimaryIndex(zoneArray.getFirstTagged());
            AxisRange axisRange = this.getRange(1, 0);
            int n4 = (int)axisRange.getDataMax() - 0;
            this.plotGround.translateToScreenInt(nArray, (double)n3 + 0.5, (double)(n4 - n) - 0.5, 0);
        }
    }

    private double[] calculateAverage() {
        double[] dArray = new double[3];
        dArray[0] = 2.147483647E9;
        dArray[1] = -2.147483647E9;
        double d = 0.0;
        for (ZoneLeaf zoneLeaf : this.selectionList) {
            if (!zoneLeaf.isSelected()) continue;
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            for (int i = 0; i < zoneArray.getNoChildren(); ++i) {
                if (!zoneArray.isSelected(i)) continue;
                double d2 = zoneArray.getValue(i, (byte)2);
                dArray[0] = Math.min(dArray[0], d2);
                dArray[1] = Math.max(dArray[1], d2);
                dArray[2] = dArray[2] + d2;
                d += 1.0;
            }
        }
        dArray[2] = dArray[2] / d;
        return dArray;
    }

    private LinkedList<ZoneLeaf> checkWiderArea(Rectangle rectangle) {
        LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1, false, this.rubberband.getRubberType());
        int n = linkedList.size() - 1;
        while (n-- > 0) {
            linkedList.remove(0);
        }
        if (linkedList.size() > 0) {
            ZoneArray zoneArray = (ZoneArray)linkedList.get(0);
            int n2 = zoneArray.getFirstTagged();
            zoneArray.setTagged(false);
            zoneArray.setTagged(n2, true);
        }
        return linkedList;
    }

    private int getColorAt(int n, int n2) {
        int n3 = 0;
        int n4 = this.plotAxisLayerPanel.getMainLayerCount();
        for (int i = n4 - 1; i >= 0; --i) {
            Contour2DLayer contour2DLayer = (Contour2DLayer)this.plotAxisLayerPanel.getMainLayer(i);
            if (!contour2DLayer.isLayerReady() || !contour2DLayer.isLayerVisible()) continue;
            ZoneArray zoneArray = (ZoneArray)contour2DLayer.getZoneList().get(n2);
            int n5 = zoneArray.getColorRGB(n);
            n3 += n5;
        }
        return n3;
    }

    private void selectSimilar(RubberbandSimilar rubberbandSimilar) {
        int n;
        int n2;
        LinkedList<Point> linkedList = new LinkedList<Point>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        rubberbandSimilar.setPercent(0.1);
        double d = rubberbandSimilar.getPercent();
        boolean[][] blArray = null;
        for (Object object : this.selectionList) {
            for (n2 = 0; n2 < ((ZoneArray)object).getNoChildren(); ++n2) {
                if (!((ZoneArray)object).isSelected(n2)) continue;
                AbstractAxisLayer abstractAxisLayer = ((ZoneLeaf)object).getLayer();
                if (blArray == null) {
                    blArray = new boolean[((ZoneArray)object).getNoChildren()][abstractAxisLayer.getZoneList().size()];
                }
                n = ((ZoneArray)object).getColorRGB(n2);
                n3 = n >> 16 & 0xFF;
                n4 = n >> 8 & 0xFF;
                n5 = n & 0xFF;
                Point point = new Point(n2, ((ZoneLeaf)object).getSecondaryIndex());
                if (linkedList.contains(point)) continue;
                linkedList.add(point);
            }
        }
        int n6 = this.plotAxisLayerPanel.getMainLayerCount();
        while (!linkedList.isEmpty()) {
            Object object;
            object = (Point)linkedList.removeFirst();
            n2 = ((Point)object).x;
            int n7 = ((Point)object).y;
            if (n2 < 0 || n2 >= blArray.length || n7 < 0 || n7 >= blArray[0].length || blArray[n2][n7]) continue;
            blArray[n2][n7] = true;
            n = this.getColorAt(n2, n7);
            if ((double)Math.abs((n >> 16 & 0xFF) - n3) / 255.0 > d || (double)Math.abs((n >> 8 & 0xFF) - n4) / 255.0 > d || (double)Math.abs((n & 0xFF) - n5) / 255.0 > d) continue;
            for (int i = n6 - 1; i >= 0; --i) {
                Contour2DLayer contour2DLayer = (Contour2DLayer)this.plotAxisLayerPanel.getMainLayer(i);
                ZoneArray zoneArray = (ZoneArray)contour2DLayer.getZoneList().get(n7);
                if (!zoneArray.isVisible(n2)) continue;
                zoneArray.setSelected(n2, true);
                if (this.selectionList.contains(zoneArray)) continue;
                this.selectionList.add(zoneArray);
            }
            linkedList.add(new Point(n2 - 1, n7));
            linkedList.add(new Point(n2 - 1, n7 - 1));
            linkedList.add(new Point(n2, n7 - 1));
            linkedList.add(new Point(n2 + 1, n7 - 1));
            linkedList.add(new Point(n2 + 1, n7));
            linkedList.add(new Point(n2 + 1, n7 + 1));
            linkedList.add(new Point(n2, n7 + 1));
            linkedList.add(new Point(n2 - 1, n7 + 1));
        }
    }

    private class PlotContour
    extends FloatWindowPlot2D.PlotGrid {
        private BufferedImage image;

        public PlotContour(double d, double d2, Color color) {
            super(color, d, d2);
            this.image = null;
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            int n;
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            int n2 = (int)dArray[0] - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = (int)Math.ceil(dArray2[0]) + 1) < 0) {
                n = 0;
            }
            int n3 = (int)FloatWindowContour2D.this.getRange(1, 0).getDataMax() - 1;
            int n4 = FloatWindowContour2D.this.plotAxisLayerPanel.getMainLayerCount();
            for (int i = 0; i < n4; ++i) {
                Contour2DLayer contour2DLayer = (Contour2DLayer)FloatWindowContour2D.this.plotAxisLayerPanel.getMainLayer(i);
                if (!contour2DLayer.isLayerReady()) continue;
                List<ZoneLeaf> list = contour2DLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    ZoneArray zoneArray = (ZoneArray)list.get(j);
                    int n5 = n3 - zoneArray.getSecondaryIndex();
                    int n6 = zoneArray.getNoChildren();
                    boolean bl2 = false;
                    for (int k = 0; k < n6; ++k) {
                        int n7 = zoneArray.getPrimaryIndex(k);
                        if (!(!zoneArray.isVisibleAndNotMissing(k) || FloatWindowContour2D.this.selectionArray.get(n7) && bl)) {
                            boolean bl3;
                            boolean bl4 = bl3 = (double)(n5 + 1) > dArray[1] && (double)n5 < dArray2[1] && (double)(n7 + 1) > dArray[0] && (double)n7 < dArray2[0];
                            if (bl3 && !bl2) {
                                linkedList.add(zoneArray);
                                bl2 = true;
                            }
                            zoneArray.setTagged(k, bl3);
                            continue;
                        }
                        zoneArray.setTagged(k, false);
                    }
                }
            }
            return linkedList;
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType) {
            double[] dArray = this.translateToPlot(n, n2 + n4, 0);
            double[] dArray2 = this.translateToPlot(n + n3, n2, 0);
            double d = FloatWindowContour2D.this.getRange(1, 0).getDataMin();
            dArray[1] = dArray[1] - d;
            dArray2[1] = dArray2[1] - d;
            return this.collectRectangleFromData(dArray, dArray2, bl);
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            Object object;
            boolean bl = (by & 1) == 1;
            boolean bl2 = (by & 0x10) == 16;
            boolean bl3 = (by & 2) == 2;
            AxisRange axisRange = FloatWindowContour2D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowContour2D.this.getRange(1, 0);
            if (bl) {
                super.paint(graphics2D, by, d);
            } else {
                if (FloatWindowContour2D.this.selectionList.isEmpty()) {
                    return;
                }
                object = (ZoneArray)FloatWindowContour2D.this.selectionList.get(0);
                int n = FloatWindowContour2D.this.plotAxisLayerPanel.getMainLayerCount();
                boolean bl4 = false;
                for (int i = n - 1; i >= 0; --i) {
                    Contour2DLayer contour2DLayer = (Contour2DLayer)FloatWindowContour2D.this.plotAxisLayerPanel.getMainLayer(i);
                    if (!contour2DLayer.isLayerReady() || !contour2DLayer.isLayerVisible()) continue;
                    List<ZoneLeaf> list = contour2DLayer.getRootList();
                    for (int j = 0; j < list.size(); ++j) {
                        ZoneArray zoneArray = (ZoneArray)list.get(j);
                        if (zoneArray != object) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) break;
                }
            }
            if (bl2) {
                this.image = new BufferedImage((int)FloatWindowContour2D.this.getTryWidth(), (int)FloatWindowContour2D.this.getTryHeight(), 2);
            }
            if (FloatWindowContour2D.this.hasVisibleLayer() && this.image != null) {
                AbstractAxisLayer abstractAxisLayer;
                int n;
                object = new double[2];
                double[] dArray = new double[2];
                this.translateToScreenDouble((double[])object, axisRange.getMin(), axisRange2.getMin() - axisRange2.getDataMin(), axisRange, axisRange2);
                this.translateToScreenDouble(dArray, axisRange.getMax(), axisRange2.getMax(), axisRange, axisRange2);
                double d2 = (double)this.width / axisRange.getAbs();
                double d3 = (double)(-this.height) / axisRange2.getAbs();
                int[] nArray = new int[2];
                this.translateToScreenInt(nArray, 0.0, 0.0, axisRange, axisRange2);
                int n2 = (int)(1.0 / d2);
                int n3 = (int)(-1.0 / d3);
                if (n2 < 1) {
                    n2 = 1;
                }
                if (n3 < 1) {
                    n3 = 1;
                }
                int n4 = (int)axisRange2.getDataMax() - 1;
                Byte by2 = 3;
                WritableRaster writableRaster = this.image.getRaster();
                int[] nArray2 = new int[]{FloatWindowContour2D.this.selectionColor.getRed(), FloatWindowContour2D.this.selectionColor.getGreen(), FloatWindowContour2D.this.selectionColor.getBlue(), FloatWindowContour2D.this.selectionColor.getAlpha()};
                boolean bl5 = this.image.getColorModel().getNumComponents() > 3;
                int n5 = 0;
                boolean bl6 = true;
                int n6 = FloatWindowContour2D.this.plotAxisLayerPanel.getMainLayerCount();
                for (n = n6 - 1; n >= 0; --n) {
                    Object object2;
                    abstractAxisLayer = (Contour2DLayer)FloatWindowContour2D.this.plotAxisLayerPanel.getMainLayer(n);
                    if (abstractAxisLayer.isLayerReady() && abstractAxisLayer.isLayerVisible()) {
                        object2 = FloatWindowContour2D.this.getIncludeColumn(abstractAxisLayer);
                        PlotInit plotInit = abstractAxisLayer.getPlotInit();
                        var31_38 = plotInit.isSecondaryMatrixTagObsVar();
                        var32_39 = plotInit.ccolorindex;
                        boolean bl7 = var32_39 == Plot_GUI.getCsh().getRgbIndex(0);
                        boolean bl8 = var32_39 == Plot_GUI.getCsh().getRgbIndex(1);
                        boolean bl9 = var32_39 == Plot_GUI.getCsh().getRgbIndex(2);
                        AbstractPlotSettingsBox abstractPlotSettingsBox = abstractAxisLayer.getSettingsBoxMap().get(by2);
                        boolean bl10 = abstractPlotSettingsBox instanceof ComboBoxColor && abstractPlotSettingsBox.getSelectedType() == 14;
                        int n7 = abstractAxisLayer.getFoldN();
                        boolean bl11 = abstractAxisLayer.isRotated();
                        boolean bl12 = FloatWindowContour2D.this.isFoldMatrix();
                        AbstractAxisPlot.SelectionList selectionList = abstractAxisLayer.getRootList();
                        if (bl3) {
                            selectionList = FloatWindowContour2D.this.selectionList;
                        }
                        boolean[] blArray = null;
                        for (int i = 0; i < selectionList.size(); ++i) {
                            int n8;
                            int n9;
                            ZoneArray zoneArray = (ZoneArray)selectionList.get(i);
                            if (blArray == null || blArray.length < zoneArray.getNoChildren()) {
                                blArray = new boolean[zoneArray.getNoChildren()];
                            }
                            zoneArray.updateVisibleArray(bl10, blArray);
                            int n10 = n4 - zoneArray.getSecondaryIndex();
                            if (n10 % n3 != 0 || (n9 = (int)((double)n10 * d3) - (n8 = (int)((double)(n10 + n3) * d3))) < 1) continue;
                            int n11 = Math.max(0, Math.max((int)dArray[1], n8 + nArray[1]));
                            int n12 = Math.min(writableRaster.getHeight() - 1, Math.min((int)object[1], n8 + nArray[1] + n9));
                            if (n12 < n11) continue;
                            int n13 = zoneArray.getNoChildren();
                            for (int j = 0; j < n13; ++j) {
                                int n14;
                                int n15;
                                int n16;
                                int n17 = zoneArray.getPrimaryIndex(j);
                                if (n17 % n2 != 0 || j >= blArray.length || !blArray[j]) continue;
                                if (bl) {
                                    n16 = n17;
                                    if (bl12) {
                                        n16 = bl11 ? zoneArray.getSecondaryIndex() * n7 + n17 : n17 * n7 + zoneArray.getSecondaryIndex();
                                    } else if (var31_38 != 0) {
                                        n16 = zoneArray.getSecondaryIndex();
                                    }
                                    if (object2 != null && !((InnerColumnBoolean)object2).getValueBool(n16)) {
                                        nArray2[0] = excludeColor >> 16 & 0xFF;
                                        nArray2[1] = excludeColor >> 8 & 0xFF;
                                        nArray2[2] = excludeColor & 0xFF;
                                        nArray2[3] = 255;
                                        n5 = excludeColor;
                                    } else {
                                        n15 = zoneArray.getColorRGB(j);
                                        if (n15 != n5) {
                                            nArray2[0] = n15 >> 16 & 0xFF;
                                            nArray2[1] = n15 >> 8 & 0xFF;
                                            nArray2[2] = n15 & 0xFF;
                                            nArray2[3] = n15 >> 24 & 0xFF;
                                            n5 = n15;
                                        }
                                    }
                                } else if (!bl12 && !FloatWindowContour2D.this.selectionArray.get(n17) || bl12 && !zoneArray.isSelected(j)) continue;
                                n16 = (int)((double)n17 * d2);
                                n15 = (int)((double)(n17 + n2) * d2) - n16;
                                int n18 = Math.max(0, Math.max((int)object[0], n16 + nArray[0]));
                                int n19 = Math.min(writableRaster.getWidth() - 1, Math.min((int)dArray[0], n16 + nArray[0] + n15));
                                if (n19 < n18) continue;
                                if (bl6 && (bl7 || bl8 || bl9)) {
                                    for (int k = n11; k <= n12; ++k) {
                                        for (n14 = n18; n14 <= n19; ++n14) {
                                            writableRaster.setPixel(n14, k, nArray2);
                                        }
                                    }
                                    continue;
                                }
                                if (bl7) {
                                    for (int k = n11; k <= n12; ++k) {
                                        for (n14 = n18; n14 <= n19; ++n14) {
                                            writableRaster.setSample(n14, k, 0, nArray2[0]);
                                        }
                                    }
                                    continue;
                                }
                                if (bl8) {
                                    for (int k = n11; k <= n12; ++k) {
                                        for (n14 = n18; n14 <= n19; ++n14) {
                                            writableRaster.setSample(n14, k, 1, nArray2[1]);
                                        }
                                    }
                                    continue;
                                }
                                if (bl9) {
                                    for (int k = n11; k <= n12; ++k) {
                                        for (n14 = n18; n14 <= n19; ++n14) {
                                            writableRaster.setSample(n14, k, 2, nArray2[2]);
                                        }
                                    }
                                    continue;
                                }
                                if (!bl3 && nArray2[3] < 255) {
                                    double d4 = (double)nArray2[3] / 255.0;
                                    for (int k = n11; k <= n12; ++k) {
                                        for (int i2 = n18; i2 <= n19; ++i2) {
                                            writableRaster.setSample(i2, k, 0, (double)nArray2[0] * d4 + (1.0 - d4) * (double)writableRaster.getSample(i2, k, 0));
                                            writableRaster.setSample(i2, k, 1, (double)nArray2[1] * d4 + (1.0 - d4) * (double)writableRaster.getSample(i2, k, 1));
                                            writableRaster.setSample(i2, k, 2, (double)nArray2[2] * d4 + (1.0 - d4) * (double)writableRaster.getSample(i2, k, 2));
                                        }
                                    }
                                    continue;
                                }
                                for (int k = n11; k <= n12; ++k) {
                                    for (n14 = n18; n14 <= n19; ++n14) {
                                        writableRaster.setSample(n14, k, 0, nArray2[0]);
                                        writableRaster.setSample(n14, k, 1, nArray2[1]);
                                        writableRaster.setSample(n14, k, 2, nArray2[2]);
                                        if (!bl5) continue;
                                        writableRaster.setSample(n14, k, 3, nArray2[3]);
                                    }
                                }
                            }
                        }
                        bl6 = false;
                    } else if (bl && UpdateHelper.Product.isRunningProductBreeze()) {
                        object2 = (Graphics2D)this.image.getGraphics();
                        ((Graphics)object2).setColor(Color.black);
                        int n20 = (int)axisRange.getDataMax() - 1;
                        var31_38 = (int)((double)(n20 + n2) * d2);
                        var32_39 = (int)((double)(n4 + n3) * d3) + nArray[1];
                        ((Graphics)object2).fillRect(nArray[0], var32_39, var31_38 + n2, nArray[1] - var32_39 + n3);
                        ((Graphics)object2).dispose();
                    }
                    if (!abstractAxisLayer.isMarkNoneWhiteAreas()) continue;
                    try {
                        object2 = (Graphics2D)this.image.getGraphics();
                        FloatWindowContour2D.this.markSelectionObjects((Graphics2D)object2, this.image, null);
                        ((Graphics)object2).dispose();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl3) {
                    if (bl2) {
                        Graphics2D graphics2D2 = (Graphics2D)this.image.getGraphics();
                        FloatWindowContour2D.this.markSelectionObjects(graphics2D2, this.image, null);
                        graphics2D2.dispose();
                    } else {
                        FloatWindowContour2D.this.markSelectionObjects(graphics2D);
                    }
                }
                if (bl2) {
                    graphics2D.drawImage(this.image, null, 0, 0);
                    this.image = null;
                }
                for (n = 0; n < n6; ++n) {
                    abstractAxisLayer = FloatWindowContour2D.this.plotAxisLayerPanel.getLayerAtIndex(n);
                    if (abstractAxisLayer == null || !abstractAxisLayer.isLayerReady() || !abstractAxisLayer.isLayerVisible()) continue;
                    abstractAxisLayer.drawStatistics(graphics2D, 0.0, d);
                }
            }
        }

        @Override
        public double[] translateToScreenDouble(double[] dArray, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
            return super.translateToScreenDouble(dArray, d, d2 + axisRange2.getDataMin(), axisRange, axisRange2);
        }

        @Override
        public void translateToScreenInt(int[] nArray, double d, double d2, AxisRange axisRange, AxisRange axisRange2) {
            super.translateToScreenInt(nArray, d, d2 + axisRange2.getDataMin(), axisRange, axisRange2);
        }
    }

    protected class PlotXaxisContour2D
    extends FloatWindowPlot2D.PlotXaxis {
        public PlotXaxisContour2D(Color color, double d, double d2) {
            super(color, d, d2);
        }

        @Override
        public double getDataPos(double d) {
            return d - 0.5;
        }
    }

    protected class PlotYaxisContour2D
    extends FloatWindowPlot2D.PlotYaxis {
        public PlotYaxisContour2D(Color color, double d, double d2) {
            super(color, d, d2);
        }

        @Override
        public double getDataPos(double d) {
            return d - 0.5;
        }

        @Override
        protected boolean isInverted() {
            return true;
        }
    }
}

