/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.mandelbrot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import javax.swing.JPanel;
import se.prediktera.map.main.ColorScalesHelper;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class MandelbrotFrame
extends JFrame {
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 512;
    private final BufferedImage image = new BufferedImage(1024, 512, 1);
    private final float[][] fArray;

    public static void main(String[] stringArray) {
        MandelbrotFrame mandelbrotFrame = new MandelbrotFrame();
        mandelbrotFrame.setTitle("Mandelbrot Frame");
        mandelbrotFrame.setDefaultCloseOperation(3);
        mandelbrotFrame.setSize(1024, 562);
        mandelbrotFrame.setLocationRelativeTo(null);
        mandelbrotFrame.setVisible(true);
    }

    public MandelbrotFrame() {
        ColorScalesHelper colorScalesHelper = ColorScalesHelper.getInstance();
        PlotContinuousColor plotContinuousColor = colorScalesHelper.getColorScales().get(4);
        this.fArray = new float[plotContinuousColor.getNrColors()][];
        for (int i = 0; i < plotContinuousColor.getNrColors(); ++i) {
            Color color = plotContinuousColor.getColor(i);
            this.fArray[i] = new float[]{color.getRed(), color.getGreen(), color.getBlue()};
        }
        this.getContentPane().add((Component)new ImagePanel(), "Center");
        this.paintMandelbrot();
    }

    private void paintMandelbrot() {
        WritableRaster writableRaster = this.image.getRaster();
        for (int i = 0; i < 1024; ++i) {
            for (int j = 0; j < 512; ++j) {
                int n;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = (double)i / 1024.0 * 3.5 - 2.5;
                double d4 = (double)j / 512.0 * 2.0 - 1.0;
                for (n = 0; d * d + d2 * d2 <= 4.0 && n < 1000; ++n) {
                    double d5 = d * d - d2 * d2 + d3;
                    d2 = 2.0 * d * d2 + d4;
                    d = d5;
                }
                if (n == 1000) {
                    n = 0;
                }
                writableRaster.setPixel(i, j, this.fArray[n % this.fArray.length]);
            }
        }
    }

    private class ImagePanel
    extends JPanel {
        private ImagePanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)MandelbrotFrame.this.image, 0, 0, null);
        }
    }
}

