/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.pie;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlotRadius2D;
import se.prediktera.map.plot.axisplot.plot2D.pie.PieLayer;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;

public class FloatWindowPie
extends FloatWindowPlotRadius2D {
    public FloatWindowPie(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
    }

    public FloatWindowPie(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new PieLayer(this, plotInit, null, null, n);
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneLeaf zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            PieLayer pieLayer = (PieLayer)abstractAxisLayer;
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneLeaf);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            int n3 = abstractAxisLayer.getDescriptionCount();
            for (int i = 0; i < n3; ++i) {
                String string2 = abstractAxisLayer.getDescriptionTitle(i);
                String string3 = abstractAxisLayer.getDescription(i, zoneLeaf);
                stringBuilder.append(string2).append(": ");
                stringBuilder.append(string3).append("\n");
            }
            double d = zoneLeaf.getValue((byte)0);
            double d2 = 100.0 * d / pieLayer.getSum();
            stringBuilder.append("Value: ").append(NiceDataFormat.toString(d)).append("\n");
            stringBuilder.append("Size: ").append(NiceDataFormat.toString(d2, 4)).append("%\n");
        } else if (zoneLeaf != null) {
            stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)0))).append("\n");
            stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)1))).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        return new double[]{-1.5, 1.5};
    }

    @Override
    public byte getTreeType() {
        return 10;
    }

    @Override
    public void selectNnearest(int n, int n2) {
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PieChart(0.0, 0.0, Color.white);
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            PieLayer pieLayer = (PieLayer)zoneLeaf.getLayer();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(pieLayer).append("</th></tr>");
            String string = pieLayer.getComment(zoneLeaf, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            int n = pieLayer.getDescriptionCount();
            for (int i = 0; i < n; ++i) {
                String string2 = pieLayer.getDescriptionTitle(i);
                String string3 = pieLayer.getDescription(i, zoneLeaf);
                stringBuilder.append("<tr><td>").append(string2).append(":</td><td>");
                stringBuilder.append(string3).append("</td></tr>");
            }
            double d = zoneLeaf.getValue((byte)0);
            double d2 = 100.0 * d / pieLayer.getSum();
            stringBuilder.append("<tr><td>Value:</td><td>").append(NiceDataFormat.toString(d)).append("</td></tr>");
            stringBuilder.append("<tr><td>Size:</td><td>").append(NiceDataFormat.toString(d2, 4)).append("%</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return false;
    }

    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
    }

    @Override
    protected void translateToScreenInt(int[] nArray, ZoneLeaf zoneLeaf) {
        for (PieChart.Slice slice : ((PieChart)this.plotGround).slices) {
            if (slice.getLeaf() != zoneLeaf) continue;
            double d = slice.getAngleStart() + 0.5 * slice.getAngleExtent();
            this.plotGround.translateToScreenInt(nArray, Math.cos(d * Math.PI / 180.0), Math.sin(d * Math.PI / 180.0), 0);
            break;
        }
    }

    private class PieChart
    extends FloatWindowPlotRadius2D.PlotRadiusGrid {
        protected BasicStroke selStroke;
        protected ArrayList<Slice> slices;

        public PieChart(double d, double d2, Color color) {
            super(color, d, d2);
            this.selStroke = new BasicStroke(2.0f, 1, 0, 10.0f);
            this.slices = new ArrayList();
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            double d = dArray[0] * dArray[0] + dArray[1] * dArray[1];
            double d2 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
            double d3 = dArray[0] * dArray[0] + dArray2[1] * dArray2[1];
            double d4 = dArray2[0] * dArray2[0] + dArray[1] * dArray[1];
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            if (d > 1.0 && d2 > 1.0 && d3 > 1.0 && d4 > 1.0) {
                return linkedList;
            }
            int n = FloatWindowPie.this.plotAxisLayerPanel.visibleMainLayers();
            if (n <= 0) {
                return linkedList;
            }
            if (dArray[0] * dArray2[0] < 0.0 && dArray[1] * dArray2[1] < 0.0) {
                int n2 = FloatWindowPie.this.plotAxisLayerPanel.getMainLayerCount();
                for (int i = 0; i < n2; ++i) {
                    PieLayer pieLayer = (PieLayer)FloatWindowPie.this.plotAxisLayerPanel.getMainLayer(i);
                    if (!pieLayer.isLayerReady() || !pieLayer.isLayerVisible()) continue;
                    List<ZoneLeaf> list = pieLayer.getRootList();
                    for (int j = 0; j < list.size(); ++j) {
                        ZoneLeaf zoneLeaf = list.get(j);
                        if (zoneLeaf.getLayer() != pieLayer || zoneLeaf.isMissing() || zoneLeaf.getValue((byte)0) <= 0.0) continue;
                        linkedList.add(zoneLeaf);
                    }
                }
                return linkedList;
            }
            double[] dArray3 = new double[]{0.5 * (dArray[0] + dArray2[0]), 0.5 * (dArray[1] + dArray2[1])};
            double[] dArray4 = dArray3;
            double d5 = 57.29577951308232 * Math.atan2(dArray4[1], dArray4[0]);
            if (d5 < 0.0) {
                d5 += 360.0;
            }
            for (Slice slice : this.slices) {
                if (!(slice.getAngleStart() <= d5) || !(slice.getAngleEnd() >= d5)) continue;
                linkedList.add(slice.getLeaf());
            }
            return linkedList;
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType) {
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            for (Slice slice : this.slices) {
                if (!slice.intersects(n, n2, n3, n4)) continue;
                linkedList.add(slice.getLeaf());
            }
            return linkedList;
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            boolean bl;
            this.calculateSlices();
            boolean bl2 = bl = (by & 1) == 1;
            if (bl) {
                super.paint(graphics2D, by, d, 0, 8, true);
            } else if (FloatWindowPie.this.selectionList.isEmpty()) {
                return;
            }
            int n = FloatWindowPie.this.plotAxisLayerPanel.visibleMainLayers();
            if (n <= 0) {
                return;
            }
            AxisRange axisRange = FloatWindowPie.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowPie.this.getRange(1, 0);
            int[] nArray = this.translateToScreenInt(axisRange.getMin(), axisRange2.getMin());
            int[] nArray2 = this.translateToScreenInt(axisRange.getMax(), axisRange2.getMax());
            graphics2D.setClip(nArray[0], nArray2[1], nArray2[0] - nArray[0], nArray[1] - nArray2[1]);
            boolean bl3 = (by & 2) == 2;
            for (Slice slice : this.slices) {
                ZoneLeaf zoneLeaf = slice.getLeaf();
                double d2 = slice.getAngleStart();
                double d3 = slice.getAngleExtent();
                boolean bl4 = false;
                if (bl3 && zoneLeaf.isSelected()) {
                    graphics2D.setColor(Color.black);
                    graphics2D.setStroke(this.selStroke);
                    graphics2D.draw(slice);
                    graphics2D.setColor(FloatWindowPie.this.selectionColor);
                    bl4 = true;
                } else if (bl) {
                    String string = zoneLeaf.getDescription();
                    if (string.length() > 0) {
                        graphics2D.setColor(Color.black);
                        double d4 = (d2 + d3 * 0.5) * Math.PI / 180.0;
                        double d5 = Math.cos(d4);
                        double d6 = Math.sin(d4);
                        int[] nArray3 = this.translateToScreenInt(d5, d6);
                        int[] nArray4 = this.translateToScreenInt(d5 * 1.1, d6 * 1.1);
                        graphics2D.drawLine(nArray3[0], nArray3[1], nArray4[0], nArray4[1]);
                        AffineTransform affineTransform = graphics2D.getTransform();
                        graphics2D.translate(nArray4[0], nArray4[1]);
                        int n2 = 0;
                        double d7 = -d4;
                        if (d4 > 1.5707963267948966 && d4 < 4.71238898038469) {
                            n2 = -graphics2D.getFontMetrics().stringWidth(string);
                            d7 += Math.PI;
                        }
                        graphics2D.rotate(d7);
                        graphics2D.drawString(string, n2, 0);
                        graphics2D.setTransform(affineTransform);
                    }
                    graphics2D.setColor(zoneLeaf.getColor());
                    bl4 = true;
                }
                if (!bl4) continue;
                graphics2D.fill(slice);
                graphics2D.setColor(Color.black);
                graphics2D.draw(slice);
            }
        }

        private void calculateSlices() {
            this.slices.clear();
            int n = FloatWindowPie.this.plotAxisLayerPanel.visibleMainLayers();
            if (n <= 0) {
                return;
            }
            int[] nArray = this.translateToScreenInt(0.0, 0.0);
            int[] nArray2 = this.translateToScreenInt(1.0, 1.0);
            int n2 = 2 * Math.abs(nArray2[0] - nArray[0]);
            int n3 = 2 * Math.abs(nArray2[1] - nArray[1]);
            int n4 = nArray[0] - n2 / 2;
            int n5 = nArray[1] - n3 / 2;
            double d = 360.0 / (double)n;
            double d2 = 0.0;
            int n6 = FloatWindowPie.this.plotAxisLayerPanel.getMainLayerCount();
            for (int i = 0; i < n6; ++i) {
                double d3;
                PieLayer pieLayer = (PieLayer)FloatWindowPie.this.plotAxisLayerPanel.getMainLayer(i);
                if (!pieLayer.isLayerReady() || !pieLayer.isLayerVisible() || (d3 = pieLayer.getSum()) <= 0.0) continue;
                double d4 = d / d3;
                List<ZoneLeaf> list = pieLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    ZoneLeaf zoneLeaf = list.get(j);
                    if (zoneLeaf.getLayer() != pieLayer || zoneLeaf.isMissing() || !(zoneLeaf.getValue((byte)0) > 0.0)) continue;
                    Slice slice = new Slice(n4, n5, n2, n3, zoneLeaf, d2, d4);
                    this.slices.add(slice);
                    d2 = slice.getAngleEnd();
                }
            }
        }

        private class Slice
        extends Arc2D.Double {
            private final ZoneLeaf leaf;

            public Slice(double d, double d2, double d3, double d4, ZoneLeaf zoneLeaf, double d5, double d6) {
                this.leaf = zoneLeaf;
                double d7 = zoneLeaf.getValue((byte)0);
                if (d7 > 0.0) {
                    double d8 = d7 * d6;
                    this.setArc(d, d2, d3, d4, d5, d8, 2);
                }
            }

            public double getAngleEnd() {
                return this.getAngleStart() + this.getAngleExtent();
            }

            public ZoneLeaf getLeaf() {
                return this.leaf;
            }
        }
    }
}

