/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.pie;

import java.awt.Font;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.plot2D.pie.ComboBoxPie;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class PieLayer
extends AbstractAxisLayer {
    private ComboBoxPie boxAxis;
    private ComboBoxDescription boxDescription;
    private final Font labelFont = new Font("SansSerif", 0, 12);
    private double sum = 0.0;

    public PieLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.layerName = this.isSubLayer() ? "Sub " + n : "Layer " + n;
        this.jbinit();
    }

    public PieLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("sum")) {
            this.sum = mapProperty.getLVDouble();
        }
        this.jbinit();
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new PieLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    @Override
    public double getAxisValue(byte by, int n, int n2) {
        if (this.boxAxis == null) {
            return 0.0;
        }
        return this.boxAxis.getAxisValue(n, n2);
    }

    @Override
    public Font getDescriptionFont() {
        return this.labelFont;
    }

    @Override
    public double[] getMinmax(int n) {
        return new double[]{-1.0, 1.0};
    }

    public double getSum() {
        return this.sum;
    }

    @Override
    public byte getTreeType() {
        return 8;
    }

    @Override
    public boolean isMissing(byte by, int n, int n2) {
        if (this.boxAxis == null) {
            return false;
        }
        return this.boxAxis.isMissingPrimary(n);
    }

    public boolean isShowLines() {
        return false;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyDouble("sum", this.sum);
    }

    @Override
    public void setShowLines(boolean bl) {
    }

    public void setSum(double d) {
        this.sum = d;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxDescription = null;
    }

    @Override
    protected void InitLayer() {
        AbstractDataMatrix abstractDataMatrix = this.getPlotInit().getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxColor.addItem(new ComboItem(VALUESTRING, 0));
        this.boxColor.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxColor.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxComment = new ComboBoxComment(abstractDataMatrix, this);
        this.boxComment.addItem(new ComboItem(NONESTRING, 2));
        this.boxComment.addItem(new ComboItem(CUSTOMSTRING, 1));
        this.boxComment.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxComment.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxComment.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxComment.getType(), this.boxComment);
        this.InitLayerChild();
    }

    @Override
    protected void InitLayerChild() {
        this.boxAxis = new ComboBoxPie(this);
        this.boxAxis.addItem(new ComboItem(VALUESTRING, 0));
        this.boxAxis.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxAxis.getType(), this.boxAxis);
        this.boxDescription = new ComboBoxDescription(this, 0);
        this.boxDescription.addItem(new ComboItem(NONESTRING, 2));
        this.boxDescription.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxDescription.addItem(new ComboItem(DESCRIPTIONSTRING, 5));
        this.boxDescription.addItem(new ComboItem(VALUESTRING, 0));
        this.boxDescription.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxDescription.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxDescription.addItem(new ComboItem("%SEPARATOR#", 3));
        this.boxDescription.setSelectedIndex(2);
        this.settingsBoxMap.put(this.boxDescription.getType(), this.boxDescription);
    }

    private void jbinit() {
        this.add(SettingsBoxHelper.createAxisPanel(this.boxAxis, null, null));
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createLabelPanel(this.boxDescription));
        this.add(SettingsBoxHelper.createCommentPanel(this.boxComment));
    }
}

