/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.quickspectral;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.tools2d.LineTools;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.data.datasettable.table.AbstractControlTable;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractBasicMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.FloatWindowContour2D;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectralLayer;
import se.prediktera.map.plot.axisplot.plot3D.MatrixFuncs;
import se.prediktera.map.plot.axisplot.plot3D.contour3D.FloatWindowContour3D;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescriptionSpectral;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;
import se.prediktera.map.plot.axisplot.settings.Lines.LineStyle;
import se.prediktera.map.plot.axisplot.windows.FloatMainWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class FloatWindowQuickSpectral
extends FloatWindowPlot2D {
    private static final BasicStroke selStroke = new BasicStroke(2.0f, 1, 0, 10.0f);
    protected boolean isObservation = false;
    private final double[] sMin = new double[2];
    private final double[] sMax = new double[2];
    private AbstractDataMatrix matrix;
    private ArrayList<AbstractAxisLayer> interactionLayer = null;
    private AbstractAxisLayer selectedLayer = null;
    private double yAxisMax = -1.0;
    private double yAxisMin = -1.0;
    private InteractionInterface lastInteraction;
    private ComboBoxDescriptionSpectral descriptionBox;
    private QuickZoneArray quickZoneArray = null;
    private boolean sourcePixelExplore = false;
    private boolean useEquidistantOnX = false;

    public FloatWindowQuickSpectral(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.matrix = plotInit.getMatrix(0);
        this.yAxisMin = this.matrix.getLayerMinMax()[0];
        this.yAxisMax = this.matrix.getLayerMinMax()[1];
        this.selectionArray = new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
        this.getRange(0, 0).setDoublePrecition(false);
    }

    public FloatWindowQuickSpectral(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.matrix = (AbstractDataMatrix)mapProperty.resolveNodeFromName(randomInputStream, "mat");
        this.yAxisMin = this.matrix.getLayerMinMax()[0];
        this.yAxisMax = this.matrix.getLayerMinMax()[1];
        this.selectionArray = new BooleanArray(mapProperty.getPropertyBooleanArray("selArr"));
        this.getRange(0, 0).setDoublePrecition(false);
    }

    public void setSourcePixelExplore(boolean bl) {
        this.sourcePixelExplore = bl;
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        CMenuItem cMenuItem = new CMenuItem("Save spectral data", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloatWindowQuickSpectral.this.exportSpectra();
            }
        };
        cMenuItem.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/common/saveFile.png")));
        jPopupMenu.add(cMenuItem);
        return super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
    }

    public void beginCalculations() {
        this.matrix.beginCalculations();
    }

    @Override
    public boolean dataInfoEvent(DataInfoEvent dataInfoEvent) {
        if (this.isCleaned()) {
            return false;
        }
        byte by = dataInfoEvent.getType();
        if (by == 12) {
            this.updatePrimaryIndexArray((QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0));
            this.calculateAndRepaintSetAxis(true, true);
        }
        return super.dataInfoEvent(dataInfoEvent);
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        Object[] objectArray;
        Object object;
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        if (quickSpectralLayer == null) {
            return false;
        }
        quickSpectralLayer.beginCalculations();
        InteractionArray interactionArray = this.getInteractionArray(this.getPrimaryMatrixTag());
        if (interactionArray != null) {
            int n;
            object = new ArrayList();
            objectArray = interactionArray.getInternalArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!objectArray[i] || (n = this.getOrigIndexSecondary(i)) < 0) continue;
                ((ArrayList)object).add(new ZoneArray((AbstractAxisLayer)quickSpectralLayer, this.getReferenceIndexSecondary(n)));
            }
            Object object2 = quickSpectralLayer.getZoneList();
            if (object2 == null) {
                object2 = new LeafList();
                quickSpectralLayer.setZoneList((LeafList)object2);
            } else {
                ((ArrayList)object2).clear();
            }
            if (quickSpectralLayer.showAverageSpectra()) {
                ((ArrayList)object2).addAll(object);
                quickSpectralLayer.getComboBox((byte)3).Calculate();
                quickSpectralLayer.addAverageSpectra();
                ((ArrayList)object2).clear();
            }
            n = Math.max(1, ((ArrayList)object).size() / 50);
            for (int i = 0; i < ((ArrayList)object).size(); i += n) {
                ((ArrayList)object2).add((ZoneLeaf)((ArrayList)object).get(i));
            }
            if (!quickSpectralLayer.showAverageSpectra()) {
                quickSpectralLayer.getComboBox((byte)3).Calculate();
            }
            if (((ArrayList)object2).size() == 0) {
                this.quickZoneArray = null;
            }
        }
        if ((object = this.getInteractionArray(this.getSecondaryMatrixTag())) != null) {
            objectArray = quickSpectralLayer.getPrimaryIndexArray();
            for (boolean bl : objectArray) {
                this.selectionArray.set(bl ? 1 : 0, ((BooleanArray)object).get(bl ? 1 : 0));
            }
        }
        quickSpectralLayer.endCalculations();
        this.setInteractionLayer(interactionInterface);
        return true;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
        int n5;
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        int n6 = -1;
        if (n == 1) {
            n6 = n2;
        } else if (n3 == 1) {
            n6 = n4;
        }
        int n7 = -1;
        if (n == 2) {
            n7 = n2;
        } else if (n3 == 2) {
            n7 = n4;
        }
        if (interactionInterface == this || quickSpectralLayer == null) {
            return;
        }
        this.quickZoneArray = n6 >= 0 ? ((n5 = this.getOrigIndexSecondary(n6)) >= 0 ? new QuickZoneArray((AbstractAxisLayer)quickSpectralLayer, this.getReferenceIndexSecondary(n5)) : null) : null;
        if (n7 >= 0) {
            this.selectionArray.reset();
            this.selectionArray.set(n7, true);
        }
        if (quickSpectralLayer.getSpectraSize() == 0) {
            this.calculateAndRepaintSetAxis(true, true);
        } else {
            this.repaint();
        }
        this.setInteractionLayer(interactionInterface);
    }

    public void endCalculations() {
        this.matrix.endCalculations();
    }

    public AbstractDataMatrix getSpectralMatrix() {
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        Iterator<QuickSpectralLayer.AverageSpectra> iterator = quickSpectralLayer.getSpectraIterator();
        Description description = new Description(quickSpectralLayer.getSpectraSize());
        description.addStringColumn("RowDescr");
        AbstractBasicMatrix abstractBasicMatrix = null;
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            ZoneArray zoneArray = iterator.next();
            int n3 = zoneArray.getSecondaryIndex();
            if (quickSpectralLayer.showAverageSpectra()) {
                description.setValue(n, 0, zoneArray.getDescription());
            } else {
                description.setValue(n, 0, "Spectra " + (n3 + 1));
            }
            if (abstractBasicMatrix == null) {
                abstractBasicMatrix = new MVmatrix(quickSpectralLayer.getSpectraSize(), zoneArray.getNoChildren());
                abstractBasicMatrix.setName("Spectral data" + (quickSpectralLayer.showAverageSpectra() ? " (average)" : ""));
                Description description2 = new Description(zoneArray.getNoChildren());
                description2.addStringColumn("ColDescr");
                for (n2 = 0; n2 < zoneArray.getNoChildren(); ++n2) {
                    description2.setValue(n2, 0, this.getDescription(n2));
                }
                abstractBasicMatrix.setColumnDescription(description2);
            }
            for (int i = 0; i < zoneArray.getNoChildren(); ++i) {
                n2 = zoneArray.getPrimaryIndex(i);
                double d = zoneArray.getValue(i, n2, n3, (byte)1);
                ((AbstractDataMatrix)abstractBasicMatrix).setValue(n, i, d);
            }
            ++n;
        }
        if (abstractBasicMatrix != null) {
            abstractBasicMatrix.setRowDescription(description);
        }
        return abstractBasicMatrix;
    }

    public void exportSpectra() {
        AbstractDataMatrix abstractDataMatrix = this.getSpectralMatrix();
        if (abstractDataMatrix != null) {
            AbstractExportInfo.ExportDataNow(abstractDataMatrix.createTableModel(true), false);
        }
    }

    @Override
    public void finishInteraction() {
        this.calculateAndRepaintSetAxis(true, true);
    }

    public Description getDescColumnFromLastInteraction(int n) {
        Description description = null;
        if (this.lastInteraction != null) {
            DataSet dataSet = null;
            AbstractAxisPlot abstractAxisPlot = null;
            if (this.lastInteraction instanceof AbstractPlotBaseWindow) {
                abstractAxisPlot = ((AbstractPlotBaseWindow)this.lastInteraction).getAxisPlot();
            } else if (this.lastInteraction instanceof AbstractAxisPlot) {
                abstractAxisPlot = (AbstractAxisPlot)this.lastInteraction;
            } else if (this.lastInteraction instanceof AbstractControlTable) {
                DataSetTable dataSetTable = ((AbstractControlTable)this.lastInteraction).getDataSetTable();
                if (dataSetTable == null) {
                    return null;
                }
                dataSet = dataSetTable.getDataSet();
            }
            if (abstractAxisPlot != null) {
                dataSet = abstractAxisPlot.getDataSet();
            }
            if (dataSet != null) {
                description = dataSet.getDescription(n);
            }
        }
        return description;
    }

    @Override
    public int getHandWidth() {
        return 3;
    }

    public LineStyle getLineStyle() {
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        return quickSpectralLayer.getDrawLineStyle();
    }

    @Override
    public void calculateAxisTicks(int n, boolean bl, boolean bl2) {
        super.calculateAxisTicks(n, bl, bl2);
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        if (quickSpectralLayer != null) {
            for (QuickSpectralLayer.AverageSpectra averageSpectra : quickSpectralLayer.getPinnedList()) {
                averageSpectra.update();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double[] getMinmax(int var1_1, int var2_2) {
        block16: {
            block17: {
                block15: {
                    var3_3 = new double[2];
                    var4_4 = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
                    if (var4_4 == null) {
                        return var3_3;
                    }
                    if (var1_1 != 0) break block15;
                    var5_5 = var4_4.getPrimaryIndexArray();
                    if (var5_5 != null) {
                        if (var5_5.length != this.matrix.getK()) {
                            this.updatePrimaryIndexArray(var4_4);
                            var5_5 = var4_4.getPrimaryIndexArray();
                        }
                        var6_7 = var5_5.length - 1;
                        var3_3[0] = 0.0;
                        var3_3[1] = var6_7;
                        if (this.sourcePixelExplore && var6_7 > 0 && (this.useEquidistantOnX = this.isDescriptionConsequtiveNumbers())) {
                            var3_3[0] = NiceDataFormat.toNumber(var4_4.getDescription(0));
                            var3_3[1] = NiceDataFormat.toNumber(var4_4.getDescription(var6_7));
                        }
                    }
                    break block16;
                }
                if (var1_1 != 1) break block16;
                var4_4.beginCalculations();
                var5_6 = var4_4.getSpectraIterator();
                this.yAxisMin = var4_4.getYAxisMin();
                this.yAxisMax = var4_4.getYAxisMax();
                if ((this.yAxisMin != -1.0 || this.yAxisMax != -1.0) && !var4_4.forceDynamicX()) break block17;
                var6_8 = 0.0;
                var8_9 = 0.0;
                var10_10 = true;
                var11_11 = false;
                block0: while (true) {
                    var12_12 = null;
                    if (var5_6.hasNext()) {
                        var12_12 = var5_6.next();
                    } else {
                        if (!var4_4.showInteractionSpectra() || var11_11 || this.quickZoneArray == null) break;
                        var12_12 = this.quickZoneArray;
                        var11_11 = true;
                    }
                    if (var12_12 == null) continue;
                    var13_13 = var12_12.getSecondaryIndex();
                    var14_14 = var12_12.getNoChildren();
                    var15_15 = 0;
                    while (true) {
                        block20: {
                            block19: {
                                block18: {
                                    if (var15_15 < var14_14) ** break;
                                    continue block0;
                                    var16_16 = var12_12.getPrimaryIndex(var15_15);
                                    var17_17 = 0.0;
                                    if (!var4_4.showAverageSpectra()) break block18;
                                    var17_17 = var12_12.getValue(var15_15, var16_16, var13_13, (byte)1);
                                    break block19;
                                }
                                var19_18 = this.isMissing((byte)1, var16_16, var13_13);
                                if (var19_18) break block20;
                                var17_17 = this.getRangeValue((byte)1, var16_16, var13_13);
                            }
                            if (var10_10) {
                                var6_8 = var8_9 = var17_17;
                                var10_10 = false;
                            }
                            if (var17_17 < var6_8) {
                                var6_8 = var17_17;
                            }
                            if (var17_17 > var8_9) {
                                var8_9 = var17_17;
                            }
                        }
                        ++var15_15;
                    }
                    break;
                }
                var4_4.endCalculations();
                var3_3[0] = var6_8;
                var3_3[1] = var8_9;
                break block16;
            }
            var3_3[0] = this.yAxisMin;
            var3_3[1] = this.yAxisMax;
        }
        return var3_3;
    }

    public final double getRangeValue(byte by, int n, int n2) {
        int n3 = this.getOrigIndexPrimary(n);
        if (by == 1) {
            int n4 = this.getOrigIndexSecondary(n2);
            return this.getCoord(n3, n4);
        }
        return n3 + 1;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        ZoneLeaf zoneLeaf;
        Description description = this.getDescColumnFromLastInteraction(1);
        AbstractAxisLayer abstractAxisLayer = this.getLayerAt(mouseEvent.getX());
        if (abstractAxisLayer != null) {
            ZoneLeaf zoneLeaf2;
            ComboBoxRange comboBoxRange = (ComboBoxRange)abstractAxisLayer.getSettingsBoxMap().get((byte)9);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer.getAxisPlot().getPlotLayout().toString()).append("</th></tr>");
            if (description != null && (zoneLeaf2 = this.getLeafAt(mouseEvent.getPoint())) instanceof ZoneArray) {
                int n = ((ZoneArray)zoneLeaf2).getFirstTagged();
                int n2 = (int)((ZoneArray)zoneLeaf2).getValue(n, (byte)0) - 1;
                for (int i = 0; i < description.getColumnCount(); ++i) {
                    InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(i);
                    stringBuilder.append(String.valueOf(innerColumnString) + ":&nbsp;").append("<td>");
                    if (comboBoxRange.getMatrix() instanceof FoldMatrix) {
                        int[] nArray;
                        var11_12 = ((FoldMatrix)comboBoxRange.getMatrix()).getReferencedMatrix();
                        if (var11_12 != null && (nArray = ((AbstractDataMatrix)var11_12).getKref()) != null && n2 >= 0 && n2 < nArray.length) {
                            stringBuilder.append(innerColumnString.getValueLocal(nArray[n2]));
                        }
                    } else {
                        var11_12 = abstractAxisLayer.getPrimaryIndexArray();
                        if (n2 >= 0 && n2 < ((int[])var11_12).length) {
                            stringBuilder.append(innerColumnString.getValueLocal((int)var11_12[n2]));
                        }
                    }
                    stringBuilder.append("</td></tr>");
                }
            }
            stringBuilder.append("<tr><td>").append("Range:").append("</td>");
            stringBuilder.append("<td>").append(abstractAxisLayer).append("</td></tr>");
            stringBuilder.append("<tr><td>").append("Band:").append("</td>");
            stringBuilder.append("<td>").append(comboBoxRange.getDataIndex() + 1).append("</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        if (description != null && (zoneLeaf = this.getLeafAt(mouseEvent.getPoint())) != null) {
            this.doQuickInteraction(zoneLeaf);
            return this.getToolTip(zoneLeaf, description);
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public byte getTreeType() {
        return 14;
    }

    public final boolean isMissing(byte by, int n, int n2) {
        int n3 = this.getOrigIndexPrimary(n);
        if (by == 1) {
            int n4 = this.getOrigIndexSecondary(n2);
            return this.isMissing(n3, n4);
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedLayer != null) {
            if (this.rubberband != null) {
                this.rubberband.setActive(false);
            }
            ComboBoxRange comboBoxRange = (ComboBoxRange)this.selectedLayer.getSettingsBoxMap().get((byte)9);
            double d = this.plotGround.translateToPlot(mouseEvent.getX(), 0.0, 0)[0];
            if (d >= 0.0 && (double)comboBoxRange.getDataIndex() != d) {
                comboBoxRange.updateIndexFromQuickSpectral(this.useEquidistantOnX ? this.getClosestDescriptionIndex(d) : (int)d);
                this.repaint();
            } else {
                super.mouseDragged(mouseEvent);
            }
        } else {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getLayerAt(mouseEvent.getX()) != null) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            super.mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.selectedLayer = this.getLayerAt(mouseEvent.getX());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband != null && !mouseEvent.isConsumed()) {
                this.rubberbandEnded(this.rubberband, mouseEvent.getModifiersEx(), mouseEvent);
                this.rubberband.clear();
                mouseEvent.consume();
            }
            if (this.selectedLayer != null) {
                this.selectedLayer.getAxisPlot().contentPaint((byte)7);
                this.selectedLayer = null;
                this.contentPaint((byte)7);
            }
            super.mouseReleased(mouseEvent);
        }
        if (this.rubberband != null) {
            this.rubberband.setActive(true);
        }
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        super.nodeReplaced(dataTreeEvent);
        this.matrix = (AbstractDataMatrix)dataTreeEvent.getReplaceDataTreeInterface();
        if (this.plotAxisLayerPanel.getMainLayerCount() > 0) {
            this.updatePrimaryIndexArray((QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0));
        }
    }

    public void rubberbandEnded(AbstractRubberband abstractRubberband, int n, MouseEvent mouseEvent) {
        boolean bl;
        if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Zoom) {
            super.rubberbandEnded(abstractRubberband, n);
            return;
        }
        Rectangle rectangle = abstractRubberband.getBoundingBox();
        boolean bl2 = (n & 0x40) == 64;
        boolean bl3 = bl = (n & 0x80) == 128;
        if (!bl && !bl2) {
            this.selectedItems(this.selectionList, false, false);
        }
        LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false, abstractRubberband.getRubberType());
        Iterator iterator = linkedList.iterator();
        int[] nArray = new int[2];
        while (iterator.hasNext()) {
            ZoneArray zoneArray = (ZoneArray)iterator.next();
            int n2 = zoneArray.getSecondaryIndex();
            boolean bl4 = false;
            int n3 = zoneArray.getFirstTagged();
            while (n3 >= 0) {
                int n4 = zoneArray.getPrimaryIndex(n3);
                this.plotGround.translateToScreenInt(nArray, (double)n3 + 1.0, zoneArray.getValue(n3, n4, n2, (byte)1), 0);
                if (!this.mustBeBoundedInSelection() || abstractRubberband.isInside(nArray[0], nArray[1])) {
                    if (bl && this.selectionArray.get(n3)) {
                        if (bl2) {
                            this.selectionArray.set(n4, false);
                        }
                    } else if (!(bl && bl2 || !zoneArray.isVisible(n3))) {
                        this.selectionArray.set(n4);
                        if (!bl4 && !this.selectionList.contains(zoneArray)) {
                            this.selectionList.add(zoneArray);
                        }
                        bl4 = true;
                    }
                }
                n3 = zoneArray.getNextTagged(n3);
            }
        }
        this.selectedItems(this.selectionList, true, true);
        this.repaintPlot((byte)2);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyNode("mat", this.matrix);
        randomOutputStream.writePropertyBooleanArray("selArr", this.selectionArray.getInternalArray());
    }

    @Override
    public void selectedItems(AbstractAxisPlot.SelectionList selectionList, boolean bl, boolean bl2) {
        for (ZoneArray zoneArray : selectionList) {
            zoneArray.setSelected(bl);
        }
        if (!bl) {
            for (int i = 0; i < this.selectionArray.size(); ++i) {
                this.selectionArray.set(i, false);
            }
            selectionList.clear();
        }
        if (bl2 && this.selectionList != null && this.plot.hasInteractivity()) {
            this.plot.getPlot_GUI().getProject_GUI().doInteraction(this);
        }
    }

    @Override
    public void selectNnearest(int n, int n2) {
    }

    public void setCursorBasedOnMouse(MouseEvent mouseEvent) {
    }

    public void setDescriptionBox(ComboBoxDescriptionSpectral comboBoxDescriptionSpectral) {
        this.descriptionBox = comboBoxDescriptionSpectral;
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    @Override
    public void translateToScreenInt(int[] nArray, ZoneLeaf zoneLeaf) {
        int n = zoneLeaf.getSecondaryIndex();
        ZoneArray zoneArray = (ZoneArray)zoneLeaf;
        int n2 = zoneArray.getFirstTagged();
        if (n2 < 0) {
            return;
        }
        int n3 = zoneArray.getPrimaryIndex(n2);
        this.plotGround.translateToScreenInt(nArray, (double)n2 + 1.0, zoneArray.getValue(n2, n3, n, (byte)1), 0);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.matrix = null;
    }

    @Override
    protected AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        QuickSpectralLayer quickSpectralLayer = new QuickSpectralLayer(plotInit, this, null, null, n);
        this.updatePrimaryIndexArray(quickSpectralLayer);
        return quickSpectralLayer;
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PlotSpectral(0.0, 0.0, Color.white);
    }

    @Override
    protected void doQuickInteraction(ZoneLeaf zoneLeaf) {
        if (zoneLeaf == null) {
            this.quickZoneArray = null;
            return;
        }
        ZoneArray zoneArray = (ZoneArray)zoneLeaf;
        int n = zoneArray.getFirstTagged();
        int n2 = this.getPrimaryMatrixTag();
        int n3 = zoneArray.getSecondaryIndex();
        int n4 = this.getSecondaryMatrixTag();
        int n5 = zoneArray.getPrimaryIndex(n);
        this.plot.getPlot_GUI().getProject_GUI().doQuickInteraction(this, n2, n3, n4, n5);
    }

    @Override
    protected float getBlackBorderSize() {
        return 1.5f;
    }

    protected String getDescription(int n) {
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        return quickSpectralLayer.getDescription(n);
    }

    protected int getDescriptionCount() {
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        return quickSpectralLayer.getDescriptionCount();
    }

    private boolean isDescriptionConsequtiveNumbers() {
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        int n = quickSpectralLayer.getDescriptionCount();
        int n2 = 0;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            String string = quickSpectralLayer.getDescription(i);
            if (!NiceDataFormat.isNumber(string)) {
                return false;
            }
            double d2 = NiceDataFormat.toNumber(string);
            if (d2 >= d) {
                ++n2;
            }
            d = Math.max(d2, d);
        }
        double d3 = (double)n2 / (double)n;
        return d3 > 0.9;
    }

    private int getClosestDescriptionIndex(double d) {
        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)this.plotAxisLayerPanel.getMainLayer(0);
        int n = quickSpectralLayer.getDescriptionCount();
        for (int i = 0; i < n; ++i) {
            String string = quickSpectralLayer.getDescription(i);
            double d2 = NiceDataFormat.toNumber(string);
            if (!(d <= d2)) continue;
            return i;
        }
        return n - 1;
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        return this.getToolTip(zoneLeaf, null);
    }

    protected String getToolTip(ZoneLeaf zoneLeaf, Description description) {
        if (zoneLeaf instanceof ZoneArray) {
            String[] stringArray;
            String string;
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            int n = zoneArray.getFirstTagged();
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = (int)zoneArray.getValue(n, (byte)0) - 1;
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)zoneArray.getLayer();
            stringBuilder.append("<tr><th colspan=\"2\">").append(quickSpectralLayer).append("</th></tr>");
            if (description != null) {
                for (int i = 0; i < description.getColumnCount(); ++i) {
                    InnerColumnString innerColumnString = (InnerColumnString)description.getInnerColumn(i);
                    if (i == 0 && UpdateHelper.Product.isRunningProductBreeze()) {
                        stringBuilder.append("Wavelength:&nbsp;").append("<td>");
                    } else {
                        stringBuilder.append(String.valueOf(innerColumnString) + ":&nbsp;").append("<td>");
                    }
                    int[] nArray = quickSpectralLayer.getPrimaryIndexArray();
                    if (n2 >= 0 && n2 < nArray.length) {
                        stringBuilder.append(innerColumnString.getValueLocal(nArray[n2]));
                    }
                    stringBuilder.append("</td></tr>");
                }
            }
            if ((string = quickSpectralLayer.getComment(zoneArray, "<br>")) != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            int n3 = zoneArray.getSecondaryIndex();
            int n4 = this.getPrimaryMatrixTag();
            String string2 = quickSpectralLayer.getDescription(0, n4 == 1 ? (byte)0 : 1, n3);
            int n5 = -1;
            int n6 = -1;
            if (string2 != null && string2.length() > 0 && (stringArray = string2.replace("[", "").split("[\\]]")).length == 2) {
                try {
                    n6 = Integer.parseInt(stringArray[0]);
                    n5 = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (UpdateHelper.Product.isRunningProductEvince()) {
                if (n6 == -1 || n5 == -1) {
                    stringBuilder.append("<tr><td>Spectr:</td><td>").append(string2).append("</td></tr>");
                } else {
                    stringBuilder.append("<tr><td>Spectr:</td><td>").append("X:" + n5 + " Y:" + n6).append("</td></tr>");
                }
            }
            stringBuilder.append("<tr><td>Band:</td><td>").append(NiceDataFormat.toString(zoneArray.getPrimaryIndex(n) + 1)).append("</td></tr>");
            if (UpdateHelper.Product.isRunningProductEvince()) {
                stringBuilder.append("<tr><td>X:</td><td>").append(NiceDataFormat.toString(zoneArray.getValue(n, (byte)0))).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>Y:</td><td>").append(NiceDataFormat.toString(zoneArray.getValue(n, (byte)1))).append("</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected float getWhiteBorderSize() {
        return 0.0f;
    }

    @Override
    protected boolean hasInteractionContent() {
        return true;
    }

    @Override
    protected boolean hasZoneArray() {
        return true;
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
        List<TickInfo> list;
        super.preparePaint(graphics2D, d);
        int n = this.getDescriptionCount();
        int n2 = -1;
        double d2 = this.getXmax();
        double d3 = 0.0;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        AxisRange axisRange = this.getRange(0, 0);
        List<TickInfo> list2 = list = axisRange.getTickList();
        synchronized (list2) {
            Iterator<TickInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                TickInfo tickInfo = iterator.next();
                if (this.useEquidistantOnX) {
                    double d4 = fontMetrics.stringWidth(tickInfo.text);
                    if (!(d3 < d4)) continue;
                    d3 = d4;
                    continue;
                }
                int n3 = (int)Math.round(tickInfo.pos);
                if (n3 != n2 && n3 >= 0 && (this.sourcePixelExplore || n3 <= n) && tickInfo.pos < d2) {
                    tickInfo.text = this.getDescription(n3);
                    double d5 = NiceDataFormat.toNumber(tickInfo.text);
                    if (!Double.isNaN(d5)) {
                        tickInfo.text = NiceDataFormat.toString(d5, 4, false);
                    }
                    tickInfo.pos = n3;
                    n2 = n3;
                    double d6 = fontMetrics.stringWidth(tickInfo.text);
                    if (!(d3 < d6)) continue;
                    d3 = d6;
                    continue;
                }
                iterator.remove();
            }
        }
        double d7 = this.plotGround.translateToScreenDouble(this.xGap, 0.0, 0)[0] - this.plotGround.translateToScreenDouble(0.0, 0.0, 0)[0];
        double d8 = d7 * 0.9 / d3;
        if (this.textRelative > d8) {
            this.textRelative = d8;
        }
        if (this.textRelative > (d8 = ((double)this.plotXaxis.getHeight() - 5.0 * d) * 0.97 / (double)fontMetrics.getHeight())) {
            this.textRelative = d8;
        }
        if (this.textRelative > d) {
            this.textRelative = d;
        }
        if (this.textRelative < 1.2) {
            this.textRelative = 1.2;
        }
    }

    @Override
    protected boolean showLayerPanel() {
        return false;
    }

    public final double getCoord(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return 0.0;
        }
        if (n2 < 0) {
            return n;
        }
        if (this.isRowPrimary()) {
            return this.matrix.getValue(n, n2);
        }
        return this.matrix.getValue(n2, n);
    }

    public AbstractDataMatrix getMatrix() {
        return this.matrix;
    }

    private AbstractAxisLayer getLayerAt(int n) {
        if (this.interactionLayer != null) {
            AxisRange axisRange = this.getRange(0, 0);
            AxisRange axisRange2 = this.getRange(1, 0);
            double[] dArray = new double[2];
            for (AbstractAxisLayer abstractAxisLayer : this.interactionLayer) {
                if (abstractAxisLayer == null || this.sourcePixelExplore && abstractAxisLayer.toString().equals("Xtraining")) continue;
                ComboBoxRange comboBoxRange = (ComboBoxRange)abstractAxisLayer.getSettingsBoxMap().get((byte)9);
                int n2 = comboBoxRange.getDataIndex();
                this.plotGround.translateToScreenDouble(dArray, this.useEquidistantOnX ? NiceDataFormat.toNumber(this.getDescription(n2)) : (double)n2, 0.0, axisRange, axisRange2);
                if (!(dArray[0] - 2.0 <= (double)n) || !(dArray[0] + 2.0 >= (double)n)) continue;
                return abstractAxisLayer;
            }
        }
        return null;
    }

    public final int getOrigIndexPrimary(int n) {
        if (this.isRowPrimary()) {
            return this.matrix.getNrefOrig(n);
        }
        return this.matrix.getKrefOrig(n);
    }

    public final int getOrigIndexSecondary(int n) {
        if (this.isRowPrimary()) {
            return this.matrix.getKrefOrig(n);
        }
        return this.matrix.getNrefOrig(n);
    }

    private final int getReferenceIndexSecondary(int n) {
        int[] nArray = this.getReferenceSecondary();
        if (nArray == null || nArray.length <= n) {
            return n;
        }
        return nArray[n];
    }

    private final int[] getReferencePrimary() {
        if (this.isRowPrimary()) {
            return this.matrix.getNref();
        }
        return this.matrix.getKref();
    }

    private final int[] getReferenceSecondary() {
        if (this.isRowPrimary()) {
            return this.matrix.getKref();
        }
        return this.matrix.getNref();
    }

    private final boolean isMissing(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 < 0) {
            return true;
        }
        if (this.isRowPrimary()) {
            return this.matrix.isMissing(n, n2);
        }
        return this.matrix.isMissing(n2, n);
    }

    private void setInteractionLayer(InteractionInterface interactionInterface) {
        FloatMainWindow floatMainWindow = null;
        if (interactionInterface instanceof AbstractPlotLayout) {
            floatMainWindow = ((AbstractPlotLayout)interactionInterface).getMainWindow();
        } else if (interactionInterface instanceof FloatMainWindow) {
            floatMainWindow = (FloatMainWindow)((Object)interactionInterface);
        }
        if ((floatMainWindow instanceof FloatWindowContour2D || floatMainWindow instanceof FloatWindowContour3D) && floatMainWindow.supportLayerInteraction) {
            this.interactionLayer = null;
            AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)floatMainWindow;
            PlotAxisLayerPanel plotAxisLayerPanel = abstractAxisPlot.getSettingsPanel();
            for (int i = 0; i < plotAxisLayerPanel.getMainLayerCount(); ++i) {
                ComboBoxRange comboBoxRange = (ComboBoxRange)plotAxisLayerPanel.getMainLayer(i).getSettingsBoxMap().get((byte)9);
                AbstractDataMatrix abstractDataMatrix = comboBoxRange.getMatrix();
                if (abstractDataMatrix instanceof FoldMatrix) {
                    abstractDataMatrix = ((FoldMatrix)abstractDataMatrix).getReferencedMatrix();
                }
                Case case_ = abstractDataMatrix.getCase();
                if (abstractDataMatrix instanceof ReferenceMatrix) {
                    abstractDataMatrix = ((ReferenceMatrix)abstractDataMatrix).getRootReferencedMatrix();
                }
                if (case_ == null || !(case_.getOriginalMatrix() instanceof LayerMatrix) || !(abstractDataMatrix instanceof MVmatrix) && !abstractDataMatrix.isOrigMatrix()) continue;
                if (this.interactionLayer == null) {
                    this.interactionLayer = new ArrayList();
                }
                this.interactionLayer.add(plotAxisLayerPanel.getMainLayer(i));
            }
        }
        if (this.lastInteraction != interactionInterface && this.descriptionBox != null) {
            this.lastInteraction = interactionInterface;
            this.descriptionBox.lastInteractionChanged();
        } else {
            this.lastInteraction = interactionInterface;
        }
    }

    private void updatePrimaryIndexArray(QuickSpectralLayer quickSpectralLayer) {
        if (quickSpectralLayer != null) {
            int[] nArray = this.getReferencePrimary();
            if (nArray == null) {
                int[] nArray2 = new int[this.matrix.getK()];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = i;
                }
                quickSpectralLayer.setPrimaryIndexArray(nArray2);
            } else {
                quickSpectralLayer.setPrimaryIndexArray(nArray);
            }
        }
    }

    private static class QuickZoneArray
    extends ZoneArray {
        public QuickZoneArray(AbstractAxisLayer abstractAxisLayer, int n) {
            super(abstractAxisLayer, n);
        }
    }

    protected class PlotSpectral
    extends FloatWindowPlot2D.PlotGrid {
        private final BasicStroke dashedQuickSpectra;

        public PlotSpectral(double d, double d2, Color color) {
            super(color, d, d2);
            this.dashedQuickSpectra = new BasicStroke(1.0f, 0, 0, 10.0f);
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            return this.collectRectangleFromData(dArray, dArray2, bl, -1, AbstractRubberband.RubberType.Normal);
        }

        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl, int n, AbstractRubberband.RubberType rubberType) {
            return this.collectRectangleFromData(dArray, dArray2, bl, n, rubberType, FloatWindowQuickSpectral.this.getRange(0, 0), FloatWindowQuickSpectral.this.getRange(1, 0));
        }

        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl, int n, AbstractRubberband.RubberType rubberType, AxisRange axisRange, AxisRange axisRange2) {
            int n2;
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            LinkedList<ZoneLeaf> linkedList2 = new LinkedList<ZoneLeaf>();
            int n3 = (int)dArray[0] - 1;
            if (n3 < 0) {
                n3 = 0;
            }
            if ((n2 = (int)Math.ceil(dArray2[0])) < 0) {
                n2 = 0;
            }
            if (FloatWindowQuickSpectral.this.useEquidistantOnX) {
                n3 = 0;
            }
            float[] fArray = new float[]{(float)(dArray2[0] + dArray[0]) * 0.5f, (float)(dArray2[1] + dArray[1]) * 0.5f, 0.0f};
            float[] fArray2 = new float[3];
            float[] fArray3 = new float[3];
            QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)FloatWindowQuickSpectral.this.plotAxisLayerPanel.getMainLayer(0);
            if (quickSpectralLayer != null && quickSpectralLayer.isLayerReady()) {
                int n4 = -1;
                List<ZoneLeaf> list = quickSpectralLayer.getRootList();
                for (int i = 0; i < list.size(); ++i) {
                    int n5;
                    ZoneLeaf zoneLeaf = list.get(i);
                    if (n >= 0 && ++n4 != n) continue;
                    int n6 = zoneLeaf.getNoChildren();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n7 = -1;
                    for (n5 = 0; n5 < n3 && n5 < n6; ++n5) {
                        zoneLeaf.setTagged(n5, false);
                    }
                    for (n5 = n2; n5 < n6; ++n5) {
                        zoneLeaf.setTagged(n5, false);
                    }
                    for (n5 = n3; n5 < n2 && n5 < n6; ++n5) {
                        fArray2[0] = (float)(FloatWindowQuickSpectral.this.useEquidistantOnX ? NiceDataFormat.toNumber(FloatWindowQuickSpectral.this.getDescription(n5)) : (double)n5);
                        fArray2[1] = (float)zoneLeaf.getValue(n5, (byte)1);
                        if (!(!zoneLeaf.isVisibleAndNotMissing(n5) || FloatWindowQuickSpectral.this.selectionArray.get(zoneLeaf.getPrimaryIndex(n5)) && bl)) {
                            boolean bl4;
                            boolean bl5 = bl4 = (double)fArray2[0] >= dArray[0] && (double)fArray2[0] <= dArray2[0] && (double)fArray2[1] >= dArray[1] && (double)fArray2[1] <= dArray2[1];
                            if (bl4 && !bl2) {
                                if (bl3) {
                                    linkedList2.clear();
                                    bl3 = false;
                                }
                                linkedList.add(zoneLeaf);
                                bl2 = true;
                            }
                            zoneLeaf.setTagged(n5, bl4);
                            if (n7 >= 0 && linkedList.isEmpty()) {
                                float[] fArray4 = MatrixFuncs.minus(fArray2, fArray3);
                                float[] fArray5 = MatrixFuncs.minus(fArray, fArray3);
                                float f = MatrixFuncs.dot(fArray5, fArray4) / MatrixFuncs.dot(fArray4, fArray4);
                                if (f >= 0.0f && f <= 1.0f) {
                                    float[] fArray6 = MatrixFuncs.plus(fArray3, MatrixFuncs.scale(fArray4, f));
                                    float[] fArray7 = MatrixFuncs.minus(fArray, fArray6);
                                    fArray7[0] = (float)((double)fArray7[0] * axisRange.getDivAbs());
                                    fArray7[1] = (float)((double)fArray7[1] * axisRange2.getDivAbs());
                                    fArray7[0] = fArray7[0] * (float)this.width;
                                    fArray7[1] = fArray7[1] * (float)this.height;
                                    float f2 = (float)Math.sqrt(fArray7[0] * fArray7[0] + fArray7[1] * fArray7[1]);
                                    if (f2 <= 5.0f) {
                                        if (!bl3) {
                                            linkedList2.add(zoneLeaf);
                                            bl3 = true;
                                        }
                                        if (f < 0.5f) {
                                            zoneLeaf.setTagged(n7, true);
                                        } else {
                                            zoneLeaf.setTagged(n5, true);
                                        }
                                    }
                                }
                            }
                            float[] fArray8 = fArray3;
                            fArray3 = fArray2;
                            fArray2 = fArray8;
                            n7 = n5;
                            continue;
                        }
                        zoneLeaf.setTagged(n5, false);
                    }
                }
            }
            if (linkedList.isEmpty()) {
                return linkedList2;
            }
            return linkedList;
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType) {
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            AxisRange axisRange = FloatWindowQuickSpectral.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowQuickSpectral.this.getRange(1, 0);
            this.translateToPlot(dArray, n, n2 + n4, 0, axisRange, axisRange2);
            this.translateToPlot(dArray2, n + n3, n2, 0, axisRange, axisRange2);
            return this.collectRectangleFromData(dArray, dArray2, bl, -1, rubberType, axisRange, axisRange2);
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            int n;
            int n2;
            Object object;
            int n3;
            boolean bl;
            QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)FloatWindowQuickSpectral.this.plotAxisLayerPanel.getMainLayer(0);
            if (quickSpectralLayer == null) {
                return;
            }
            boolean bl2 = (by & 1) == 1;
            boolean bl3 = (by & 2) == 2;
            boolean bl4 = bl = (by & 4) == 4;
            if (bl2) {
                super.paint(graphics2D, by, d);
            }
            AxisRange axisRange = FloatWindowQuickSpectral.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowQuickSpectral.this.getRange(1, 0);
            this.translateToScreenDouble(FloatWindowQuickSpectral.this.sMin, axisRange.getMin(), axisRange2.getMin(), axisRange, axisRange2);
            this.translateToScreenDouble(FloatWindowQuickSpectral.this.sMax, axisRange.getMax(), axisRange2.getMax(), axisRange, axisRange2);
            graphics2D.setClip((int)FloatWindowQuickSpectral.this.sMin[0], (int)FloatWindowQuickSpectral.this.sMax[1], (int)(FloatWindowQuickSpectral.this.sMax[0] - FloatWindowQuickSpectral.this.sMin[0]), (int)(FloatWindowQuickSpectral.this.sMin[1] - FloatWindowQuickSpectral.this.sMax[1]));
            Stroke stroke = graphics2D.getStroke();
            int n4 = (int)axisRange.getMin() - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = (int)axisRange.getMax() + 1) < 0) {
                n3 = 0;
            }
            if (FloatWindowQuickSpectral.this.useEquidistantOnX) {
                n4 = 0;
                n3 = quickSpectralLayer.getDescriptionCount();
            }
            FloatWindowQuickSpectral.this.matrix.beginCalculations();
            Iterator<QuickSpectralLayer.AverageSpectra> iterator = quickSpectralLayer.getSpectraIterator();
            int n5 = quickSpectralLayer.getSpectraSize();
            boolean bl5 = quickSpectralLayer.showAverageSpectra();
            GeneralPath generalPath = new GeneralPath();
            GeneralPath generalPath2 = new GeneralPath();
            int n6 = quickSpectralLayer.getComboBox((byte)3).getCurType();
            LineStyle lineStyle = FloatWindowQuickSpectral.this.getLineStyle();
            graphics2D.setStroke(lineStyle.getStroke());
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double d2 = FloatWindowQuickSpectral.this.getTryWidth();
            double d3 = FloatWindowQuickSpectral.this.getTryHeight();
            boolean bl6 = false;
            int n7 = 0;
            while (true) {
                object = null;
                if (bl && quickSpectralLayer.showInteractionSpectra() && !bl6 && FloatWindowQuickSpectral.this.quickZoneArray != null) {
                    object = FloatWindowQuickSpectral.this.quickZoneArray;
                    graphics2D.setStroke(this.dashedQuickSpectra);
                    bl6 = true;
                } else {
                    if (bl || !iterator.hasNext()) break;
                    object = iterator.next();
                }
                n2 = ((ZoneLeaf)object).getSecondaryIndex();
                if (n2 >= 0 && FloatWindowQuickSpectral.this.getOrigIndexSecondary(n2) < 0) continue;
                generalPath.reset();
                generalPath2.reset();
                boolean bl7 = false;
                boolean bl8 = false;
                int n8 = ((ZoneArray)object).getNoChildren();
                n = 0;
                int n9 = -1;
                for (int i = n4; i < n3 && i < n8; ++i) {
                    int n10 = ((ZoneArray)object).getPrimaryIndex(i);
                    if (!bl5 && ((ZoneArray)object).isMissing(i, n10, n2, (byte)1)) continue;
                    boolean bl9 = FloatWindowQuickSpectral.this.selectionArray.get(i);
                    if (FloatWindowQuickSpectral.this.sourcePixelExplore && n9 + 1 != n10) {
                        bl8 = false;
                    }
                    this.translateToScreenDouble(dArray, FloatWindowQuickSpectral.this.useEquidistantOnX ? NiceDataFormat.toNumber(quickSpectralLayer.getDescription(i)) : (double)i, ((ZoneArray)object).getValue(i, n10, n2, (byte)1), axisRange, axisRange2);
                    if (bl8) {
                        if (bl2 || bl) {
                            bl7 = LineTools.line(generalPath2, by, dArray2, dArray, FloatWindowQuickSpectral.this.sMin, FloatWindowQuickSpectral.this.sMax, d2, d3, null) || bl7;
                        } else if (bl3 && bl9 && n != 0) {
                            graphics2D.setColor(FloatWindowQuickSpectral.this.selectionColor);
                            graphics2D.drawLine((int)dArray2[0], (int)dArray2[1], (int)dArray[0], (int)dArray[1]);
                        }
                    } else {
                        generalPath2.moveTo((float)dArray[0], (float)dArray[1]);
                    }
                    bl8 = true;
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    n = bl9 ? 1 : 0;
                    n9 = n10;
                }
                if (bl7) {
                    if (bl5) {
                        graphics2D.setColor(((ZoneLeaf)object).getColor());
                    } else if (bl6) {
                        graphics2D.setColor(FloatWindowQuickSpectral.this.getAxisColor());
                    } else if (n6 != 101 && n5 < 10) {
                        graphics2D.setColor(PerfectSpread.generateColor(n7));
                    } else {
                        graphics2D.setColor(((ZoneLeaf)object).getColor());
                    }
                    graphics2D.draw(generalPath2);
                }
                ++n7;
            }
            if (bl3) {
                FloatWindowQuickSpectral.this.markSelectionObjects(graphics2D, FloatWindowQuickSpectral.this.selectionColor);
            }
            FloatWindowQuickSpectral.this.matrix.endCalculations();
            if (bl && FloatWindowQuickSpectral.this.interactionLayer != null && !FloatWindowQuickSpectral.this.interactionLayer.isEmpty()) {
                object = new double[2];
                this.translateToScreenDouble((double[])object, 0.0, axisRange2.getMin(), axisRange, axisRange2);
                for (n2 = FloatWindowQuickSpectral.this.interactionLayer.size() - 1; n2 >= 0; --n2) {
                    AbstractAxisLayer abstractAxisLayer;
                    AbstractDataMatrix abstractDataMatrix;
                    AbstractAxisLayer abstractAxisLayer2 = FloatWindowQuickSpectral.this.interactionLayer.get(n2);
                    if (abstractAxisLayer2.isCleaned()) {
                        FloatWindowQuickSpectral.this.interactionLayer.remove(n2);
                        continue;
                    }
                    if (FloatWindowQuickSpectral.this.sourcePixelExplore && abstractAxisLayer2.toString().equals("Xtraining")) continue;
                    ComboBoxRange comboBoxRange = (ComboBoxRange)abstractAxisLayer2.getSettingsBoxMap().get((byte)9);
                    ComboBoxColor comboBoxColor = (ComboBoxColor)abstractAxisLayer2.getSettingsBoxMap().get((byte)3);
                    n = comboBoxRange.getDataIndex();
                    String string = quickSpectralLayer.getDescription(n);
                    double d4 = FloatWindowQuickSpectral.this.useEquidistantOnX ? NiceDataFormat.toNumber(string) : (double)n;
                    this.translateToScreenDouble(dArray, d4, axisRange2.getMax(), axisRange, axisRange2);
                    ContinuousColorInterface continuousColorInterface = comboBoxColor.getContinuesColor();
                    graphics2D.setStroke(selStroke);
                    if (FloatWindowQuickSpectral.this.interactionLayer.size() < 3) {
                        graphics2D.setColor(FloatWindowQuickSpectral.this.getAxisColor());
                    } else {
                        graphics2D.setColor(continuousColorInterface.getColor(continuousColorInterface.getNrColors() - 1));
                    }
                    if (FloatWindowQuickSpectral.this.interactionLayer.size() == 1 && (abstractDataMatrix = (abstractAxisLayer = FloatWindowQuickSpectral.this.interactionLayer.get(0)).getPlotInit().getMatrix(0)) instanceof FoldMatrix && abstractDataMatrix.toString().contains("SAM matrix")) {
                        return;
                    }
                    graphics2D.draw(new Line2D.Double(dArray[0], (double)object[1], dArray[0], dArray[1] + 1.0));
                    if (!FloatWindowQuickSpectral.this.sourcePixelExplore) continue;
                    graphics2D.setColor(FloatWindowQuickSpectral.this.getAxisColor());
                    if (FloatWindowQuickSpectral.this.useEquidistantOnX) {
                        graphics2D.drawString(NiceDataFormat.toString(d4), (int)dArray[0] + 10, (int)dArray[1] + 20);
                        continue;
                    }
                    graphics2D.drawString(NiceDataFormat.tryGetNiceString(string), (int)dArray[0] + 10, (int)dArray[1] + 20);
                }
            }
            graphics2D.setClip(null);
            graphics2D.setStroke(stroke);
        }

        @Override
        public double[] translateToPlot(double d, double d2, int n) {
            return this.translateToPlot(new double[2], d, d2, n, FloatWindowQuickSpectral.this.getRange(0, n), FloatWindowQuickSpectral.this.getRange(1, n));
        }

        public double[] translateToPlot(double[] dArray, double d, double d2, int n, AxisRange axisRange, AxisRange axisRange2) {
            dArray[0] = axisRange.transform((d - (double)this.origoX) / (double)this.width);
            dArray[1] = axisRange2.transform(((double)(this.height + this.origoY) - d2) / (double)this.height);
            return dArray;
        }
    }
}

