/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.quickspectral;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.datasetcontainer.dataset.DataSetMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.transform.TransformMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.FloatWindowQuickSpectral;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescriptionSpectral;
import se.prediktera.map.plot.axisplot.settings.ComboBoxLines;
import se.prediktera.map.plot.axisplot.settings.Lines.LineStyle;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class QuickSpectralLayer
extends AbstractAxisLayer {
    private ComboBoxDescription boxLabelX;
    private ComboBoxLines boxLines;
    private boolean dynamicX = true;
    private JRadioButton dynamicButton;
    private JRadioButton staticButton;
    private JCheckBox quickSpectraCheckBox;
    private JCheckBox avarageCheckBox;
    private ButtonGroup buttonGroup;
    private final JTextFieldButtonUppDown fixedFieldMax = new JTextFieldButtonUppDown(true);
    private final JTextFieldButtonUppDown fixedFieldMin = new JTextFieldButtonUppDown(true);
    private final List<AverageSpectra> averageList = new ArrayList<AverageSpectra>();
    private final List<AverageSpectra> pinnedList = new ArrayList<AverageSpectra>();
    private final JButton exportSpectraButton = new JButton("Save spectral data...");
    private final int maxspectra = 1000;
    private Runnable averageCallback;

    public QuickSpectralLayer(PlotInit plotInit, AbstractAxisPlot abstractAxisPlot, LeafList leafList, LeafList leafList2, int n) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.jbinit();
    }

    public QuickSpectralLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.jbinit();
        if (mapProperty.getPropertyBoolean("di", true)) {
            this.dynamicButton.setSelected(true);
        } else {
            this.staticButton.setSelected(true);
        }
        this.quickSpectraCheckBox.setSelected(mapProperty.getPropertyBoolean("qs", true));
        this.avarageCheckBox.setSelected(mapProperty.getPropertyBoolean("as"));
        this.fixedFieldMin.setNumber(mapProperty.getPropertyDouble("ffmin", 0.0));
        this.fixedFieldMax.setNumber(mapProperty.getPropertyDouble("ffmax", 1.0));
    }

    public void addAverageSpectra() {
        LayerMatrix layerMatrix;
        Object object;
        TransformMatrix transformMatrix;
        AbstractDataMatrix abstractDataMatrix;
        DataSetMatrix dataSetMatrix;
        AbstractDataMatrix abstractDataMatrix2;
        LeafList leafList = this.getZoneList();
        int n = leafList.size();
        if (n == 0 || this.hasAverageSpectra(leafList, n)) {
            this.averageList.clear();
            if (this.averageCallback != null) {
                this.averageCallback.run();
            }
            return;
        }
        ZoneArray zoneArray = (ZoneArray)leafList.get(0);
        int n2 = zoneArray.getNoChildren();
        AverageSpectra averageSpectra = new AverageSpectra(this, n2, n);
        averageSpectra.setColor(PerfectSpread.generateColor(this.pinnedList.size() + this.averageList.size()));
        this.averageList.add(averageSpectra);
        averageSpectra.setDescription("Average (" + this.averageList.size() + ")");
        FloatWindowQuickSpectral floatWindowQuickSpectral = (FloatWindowQuickSpectral)this.getAxisPlot();
        int[] nArray = zoneArray.getPrimaryIndexArray();
        if (UpdateHelper.Product.isRunningProductBreezeSuite() && (abstractDataMatrix2 = floatWindowQuickSpectral.getMatrix()) instanceof DataSetMatrix && (abstractDataMatrix2 = (dataSetMatrix = (DataSetMatrix)abstractDataMatrix2).getReferencedMatrix()) instanceof TransformMatrix && (abstractDataMatrix = (transformMatrix = (TransformMatrix)abstractDataMatrix2).getReferencedMatrix()) instanceof LayerMatrix && ((AbstractDataMatrix[])(object = (layerMatrix = (LayerMatrix)abstractDataMatrix).getMatrixArray())).length > 0) {
            int n3 = ((AbstractDataMatrix)object[0]).getN();
            int n4 = Math.min(100000, n);
            double d = (double)n / (double)n4;
            for (int i = 0; i < n4; ++i) {
                int n5 = (int)((double)i * d);
                if (n5 >= leafList.size()) continue;
                ZoneArray zoneArray2 = (ZoneArray)leafList.get(n5);
                int n6 = zoneArray2.getSecondaryIndex();
                int n7 = n6 % n3;
                int n8 = n6 / n3;
                for (int j = 0; j < n2; ++j) {
                    int n9 = nArray[j];
                    Object object2 = object[n9];
                    double d2 = ((AbstractDataMatrix)object2).getValue(n7, n8);
                    averageSpectra.addValue(j, d2);
                }
                averageSpectra.setSecondaryIndex(i, n6);
            }
            averageSpectra.calcAverage(n4);
            if (this.averageCallback != null) {
                this.averageCallback.run();
            }
            return;
        }
        int n10 = Math.min(1000, n);
        double d = (double)n / (double)n10;
        for (int i = 0; i < n10; ++i) {
            int n11 = (int)((double)i * d);
            if (n11 >= leafList.size()) continue;
            object = (ZoneArray)leafList.get(n11);
            int n12 = ((ZoneLeaf)object).getSecondaryIndex();
            int n13 = floatWindowQuickSpectral.getOrigIndexSecondary(n12);
            for (int j = 0; j < n2; ++j) {
                int n14 = nArray[j];
                int n15 = floatWindowQuickSpectral.getOrigIndexPrimary(n14);
                double d3 = floatWindowQuickSpectral.getCoord(n15, n13);
                averageSpectra.addValue(j, d3);
            }
            averageSpectra.setSecondaryIndex(i, n12);
        }
        averageSpectra.calcAverage(n10);
        if (this.averageCallback != null) {
            this.averageCallback.run();
        }
    }

    private boolean hasAverageSpectra(LeafList leafList, int n) {
        for (AverageSpectra averageSpectra : this.averageList) {
            if (averageSpectra.getSecondarySize() != n) continue;
            boolean bl = true;
            for (int i = 0; i < leafList.size(); ++i) {
                ZoneLeaf zoneLeaf = (ZoneLeaf)leafList.get(i);
                int n2 = zoneLeaf.getSecondaryIndex();
                if (averageSpectra.hasSecondaryIndex(n2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beginCalculations() {
        ((FloatWindowQuickSpectral)this.axisPlot).beginCalculations();
    }

    public void clearAverageList(boolean bl) {
        if (bl) {
            this.pinnedList.clear();
        }
        this.averageList.clear();
    }

    public void setAverageCallback(Runnable runnable) {
        this.averageCallback = runnable;
    }

    public void pinAverages() {
        for (AverageSpectra averageSpectra : this.averageList) {
            double[] dArray = averageSpectra.getValues();
            AverageSpectra averageSpectra2 = new AverageSpectra(this, dArray.length, 1);
            averageSpectra2.setColor(averageSpectra.getColor());
            averageSpectra2.setDescription(averageSpectra.getDescription());
            for (int i = 0; i < dArray.length; ++i) {
                averageSpectra2.addValue(i, dArray[i]);
            }
            this.pinnedList.add(averageSpectra2);
        }
        this.averageList.clear();
    }

    public boolean hasPinnedData() {
        return this.pinnedList.size() > 0;
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return null;
    }

    @Override
    public void endCalculations() {
        ((FloatWindowQuickSpectral)this.axisPlot).endCalculations();
    }

    public boolean forceDynamicX() {
        return this.dynamicX;
    }

    public String getDescription(int n) {
        int n2 = ((ComboBoxDescriptionSpectral)this.boxLabelX).getSelectedSubIndex();
        return this.boxLabelX.getDescription(this.boxLabelX.getReferenceIndexPrimary(n), n2);
    }

    @Override
    public int getDescriptionCount() {
        return this.boxLabelX.getCoordSizePrimary();
    }

    @Override
    public Font getDescriptionFont() {
        return null;
    }

    public LineStyle getDrawLineStyle() {
        return this.boxLines.getDrawLineStyle();
    }

    public Font getLabelFont() {
        return this.boxLabelX.getLabelFont();
    }

    @Override
    public double[] getMinmax(int n) {
        return this.axisPlot.getMinmax(n, 0);
    }

    @Override
    public double getRangeValue(byte by, int n, int n2, int n3) {
        return ((FloatWindowQuickSpectral)this.axisPlot).getRangeValue(by, n, n2);
    }

    public Iterator<AverageSpectra> getSpectraIterator() {
        Iterator<ZoneLeaf> iterator = super.getLeafIterator();
        if (this.avarageCheckBox.isSelected()) {
            return this.getPinnedAndAverage().iterator();
        }
        return iterator;
    }

    public List<AverageSpectra> getPinnedAndAverage() {
        if (this.pinnedList.size() > 0) {
            ArrayList<AverageSpectra> arrayList = new ArrayList<AverageSpectra>(this.pinnedList);
            arrayList.addAll(this.averageList);
            return arrayList;
        }
        return this.averageList;
    }

    public List<AverageSpectra> getPinnedList() {
        return this.pinnedList;
    }

    public List<AverageSpectra> getAverageList() {
        return this.averageList;
    }

    public int getSpectraSize() {
        if (this.avarageCheckBox.isSelected()) {
            return this.getPinnedAndAverage().size();
        }
        return this.getListSize();
    }

    @Override
    public byte getTreeType() {
        return 12;
    }

    public double getYAxisMax() {
        return this.fixedFieldMax.getNumber();
    }

    public double getYAxisMin() {
        return this.fixedFieldMin.getNumber();
    }

    @Override
    public boolean isRangeMissing(byte by, int n, int n2, int n3) {
        return ((FloatWindowQuickSpectral)this.axisPlot).isMissing(by, n, n2);
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("di", this.dynamicButton.isSelected());
        randomOutputStream.writePropertyBoolean("qs", this.quickSpectraCheckBox.isSelected());
        randomOutputStream.writePropertyBoolean("as", this.avarageCheckBox.isSelected());
        randomOutputStream.writePropertyDouble("ffmin", 0.0);
        randomOutputStream.writePropertyDouble("ffmax", 1.0);
    }

    public void setShowAverageSpectra(boolean bl) {
        this.avarageCheckBox.setSelected(bl);
    }

    @Override
    public void setShowLines(boolean bl) {
    }

    public boolean showAverageSpectra() {
        return this.avarageCheckBox.isSelected();
    }

    public boolean showInteractionSpectra() {
        return this.quickSpectraCheckBox.isSelected();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxLabelX = null;
        this.boxLines = null;
    }

    @Override
    protected void InitLayer() {
        this.boxLabelX = new ComboBoxDescriptionSpectral(this, 0);
        this.boxLabelX.addItem(new ComboItem(NONESTRING, 2));
        this.boxLabelX.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxLabelX.addItem(new ComboItem(DESCRIPTIONSTRING, 5));
        this.boxLabelX.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxLabelX.getType(), this.boxLabelX);
        this.boxLabelX.setSelectedIndex(2);
        AbstractDataMatrix abstractDataMatrix = this.getPlotInit().getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(CATEGORYSTRING, 101));
        this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxLines = new ComboBoxLines(this, 0);
        this.boxLines.addItem(new ComboItem(INDEXSTRING, 4));
        this.settingsBoxMap.put(this.boxLines.getType(), this.boxLines);
    }

    @Override
    protected void InitLayerChild() {
    }

    private void initYFields() {
        this.dynamicButton = new JRadioButton("Dynamic");
        this.dynamicButton.setActionCommand("dynamic");
        this.staticButton = new JRadioButton("Fixed");
        this.staticButton.setActionCommand("fixed");
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.dynamicButton);
        this.buttonGroup.add(this.staticButton);
        ActionListener actionListener = actionEvent -> {
            this.dynamicX = actionEvent.getActionCommand().equals("dynamic");
            this.fixedFieldMax.setEnabled(!this.dynamicX);
            this.fixedFieldMin.setEnabled(!this.dynamicX);
            this.axisPlot.calculateAndRepaintSetAxis(true, true);
        };
        this.dynamicButton.addActionListener(actionListener);
        this.staticButton.addActionListener(actionListener);
        this.fixedFieldMax.setEnabled(!this.dynamicX);
        this.fixedFieldMin.setEnabled(!this.dynamicX);
        JValidateNumberField.NumberChangedInterface numberChangedInterface = (n, d) -> {
            AbstractAxisPlot abstractAxisPlot = this.axisPlot;
            abstractAxisPlot.calculateAndRepaintSetAxis(true, true);
        };
        this.fixedFieldMin.setNumberChangedInterface(numberChangedInterface);
        this.fixedFieldMax.setNumberChangedInterface(numberChangedInterface);
        double d2 = this.axisPlot.getPlotInit().getMatrix(0).getLayerMinMax()[1];
        double d3 = this.axisPlot.getPlotInit().getMatrix(0).getLayerMinMax()[0];
        this.fixedFieldMax.setNumber(d2);
        this.fixedFieldMin.setNumber(d3);
        if (d3 == -1.0 && d2 == -1.0 || this.dynamicX) {
            this.dynamicButton.setSelected(true);
        } else {
            this.staticButton.setSelected(true);
        }
    }

    private void jbinit() {
        this.add(SettingsBoxHelper.createAxisLabelPanel(this.boxLabelX, "X"));
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createLinesPanel(this.boxLines));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Y axis"));
        this.add((Component)jPanel, null);
        this.initYFields();
        jPanel.add((Component)this.dynamicButton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this.staticButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        this.fixedFieldMax.setStepSize(0.1);
        this.fixedFieldMin.setStepSize(0.1);
        jPanel.add((Component)new JLabel("Max:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 18, 0, 6), 0, 0));
        jPanel.add((Component)this.fixedFieldMax, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)new JLabel("Min:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 18, 6, 6), 0, 0));
        jPanel.add((Component)this.fixedFieldMin, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Spectra option"));
        this.add((Component)jPanel2, null);
        this.quickSpectraCheckBox = new JCheckBox("Show interaction spectra", true);
        this.quickSpectraCheckBox.addActionListener(actionEvent -> this.getAxisPlot().calculateAndRepaintSetAxis(true, true));
        jPanel2.add((Component)this.quickSpectraCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        this.avarageCheckBox = new JCheckBox("Add average from selection");
        this.avarageCheckBox.addActionListener(actionEvent -> {
            this.averageList.clear();
            if (this.avarageCheckBox.isSelected()) {
                this.addAverageSpectra();
            }
            this.getAxisPlot().calculateAndRepaintSetAxis(true, true);
        });
        jPanel2.add((Component)this.avarageCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 6, 0, 6), 0, 0));
        this.exportSpectraButton.addActionListener(actionEvent -> {
            FloatWindowQuickSpectral floatWindowQuickSpectral = (FloatWindowQuickSpectral)this.getAxisPlot();
            floatWindowQuickSpectral.exportSpectra();
        });
        jPanel2.add((Component)this.exportSpectraButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 6), 0, 0));
        jPanel2.add((Component)new JLabel("(Contains max 50 spectrum)"), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 12, 6, 6), 0, 0));
    }

    public static class AverageSpectra
    extends ZoneArray {
        private final int[] secondaryArray;
        private double[] min;
        private double[] max;
        private double[] values;

        public AverageSpectra(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
            super(abstractAxisLayer, n);
            this.secondaryArray = new int[n2];
            this.setSize(n);
        }

        public void setSize(int n) {
            this.min = new double[n];
            Arrays.fill(this.min, 2.147483647E9);
            this.max = new double[n];
            this.values = new double[n];
        }

        public void addValue(int n, double d) {
            this.min[n] = Math.min(this.min[n], d);
            this.max[n] = Math.max(this.max[n], d);
            int n2 = n;
            this.values[n2] = this.values[n2] + d;
        }

        public void setValue(int n, double d) {
            this.min[n] = Math.min(this.min[n], d);
            this.max[n] = Math.max(this.max[n], d);
            this.values[n] = d;
        }

        public void calcAverage(double d) {
            if (this.secondaryArray.length > 0) {
                int n = 0;
                while (n < this.values.length) {
                    int n2 = n++;
                    this.values[n2] = this.values[n2] / d;
                }
            }
        }

        @Override
        public int getSecondaryIndex() {
            return -1;
        }

        public int getSecondarySize() {
            return this.secondaryArray.length;
        }

        public double[] getMin() {
            return this.min;
        }

        public double[] getMax() {
            return this.max;
        }

        public double[] getValues() {
            return this.values;
        }

        @Override
        public double getValue(int n, int n2, int n3, byte by) {
            if (n < this.values.length) {
                return this.values[n];
            }
            return 0.0;
        }

        public boolean hasSecondaryIndex(int n) {
            for (int n2 : this.secondaryArray) {
                if (n2 != n) continue;
                return true;
            }
            return false;
        }

        public void setSecondaryIndex(int n, int n2) {
            this.secondaryArray[n] = n2;
        }

        public void update() {
        }
    }
}

