/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.radar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlotRadius2D;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;
import se.prediktera.map.plot.axisplot.plot2D.radar.RadarLayer;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;

public class FloatWindowRadar
extends FloatWindowPlotRadius2D {
    private final int[] plotscreen = new int[2];

    public FloatWindowRadar(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
    }

    public FloatWindowRadar(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new RadarLayer(this, plotInit, null, null, n);
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneLeaf zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            RadarLayer radarLayer = (RadarLayer)abstractAxisLayer;
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneLeaf);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            int n3 = abstractAxisLayer.getDescriptionCount();
            for (int i = 0; i < n3; ++i) {
                String string2 = abstractAxisLayer.getDescriptionTitle(i);
                String string3 = abstractAxisLayer.getDescription(i, zoneLeaf);
                stringBuilder.append(string2).append(": ");
                stringBuilder.append(string3).append("\n");
            }
            double d = zoneLeaf.getValue((byte)0);
            double d2 = 100.0 * d / radarLayer.getSum();
            stringBuilder.append("Value: ").append(NiceDataFormat.toString(d)).append("\n");
            stringBuilder.append("Size: ").append(NiceDataFormat.toString(d2, 4)).append("%\n");
        } else if (zoneLeaf != null) {
            stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)0))).append("\n");
            stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)1))).append("\n");
        }
        return stringBuilder.toString();
    }

    public ZoneLeaf getLeaf(int n, int n2, boolean bl) {
        ZoneLeaf zoneLeaf = null;
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        double d = this.getRelative();
        double[] dArray = new double[2];
        AxisRange axisRange = this.getRange(0, 0);
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < n3; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer != null && !abstractAxisLayer.isSubLayer() && abstractAxisLayer.isLayerReady() && abstractAxisLayer.isLayerVisible()) {
                abstractAxisLayer.beginCalculations();
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)0);
                AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
                int n4 = comboBoxAxis.getSelectedType();
                int n5 = comboBoxAxis.getAxisIndex();
                boolean bl2 = comboBoxAxis.getObservationTag();
                double d3 = 1.5707963267948966;
                int n6 = abstractAxisLayer.getNrVisibleObjects();
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    double d4;
                    double d5;
                    double d6;
                    ZoneLeaf zoneLeaf2 = list.get(j);
                    if (!zoneLeaf2.isVisibleAndNotMissing() || !zoneLeaf2.getLayer().isLayerVisible()) continue;
                    int n7 = zoneLeaf2.getPrimaryIndex();
                    int n8 = bl2 ? abstractDataMatrix.getNrefOrig(n7) : abstractDataMatrix.getKrefOrig(n7);
                    double d7 = d6 = FloatWindowScatter.getLeafValueOrigIndex(n8, abstractDataMatrix, n4, n5, bl2);
                    double d8 = Math.cos(d3) * d7;
                    double d9 = Math.sin(d3) * d7;
                    this.plotGround.translateToScreenDouble(dArray, d8, d9, axisRange, axisRange);
                    double d10 = (double)n - dArray[0];
                    double d11 = (double)n2 - dArray[1];
                    double d12 = d10 * d10 + d11 * d11;
                    d3 += Math.PI * 2 / (double)n6;
                    if (bl && d12 > d2 || !(d12 < (d5 = (d4 = (double)zoneLeaf2.getSize() * d * 0.5) * d4))) continue;
                    d2 = d12;
                    if (!bl) {
                        abstractAxisLayer.endCalculations();
                        return zoneLeaf2;
                    }
                    zoneLeaf = zoneLeaf2;
                }
            }
            abstractAxisLayer.endCalculations();
        }
        return zoneLeaf;
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        return new double[]{-1.0, 1.0};
    }

    @Override
    public byte getTreeType() {
        return 18;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband instanceof RubberbandNormal && this.rubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            ZoneLeaf zoneLeaf;
            boolean bl;
            int n = mouseEvent.getModifiersEx();
            boolean bl2 = (n & 0x40) == 64;
            boolean bl3 = bl = (n & 0x80) == 128;
            if (!bl && !bl2) {
                this.selectedItems(this.selectionList, false, false);
            }
            if ((zoneLeaf = this.getLeaf(mouseEvent.getX(), mouseEvent.getY(), true)) != null) {
                if (bl && zoneLeaf.isSelected()) {
                    if (bl2) {
                        zoneLeaf.setSelected(false);
                        this.selectionList.remove(zoneLeaf);
                    }
                } else if (!zoneLeaf.isSelected() && zoneLeaf.isVisible()) {
                    this.selectionList.add(zoneLeaf);
                }
            }
            this.selectedItems(this.selectionList, true, true);
            this.repaintPlot((byte)2);
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void selectNnearest(int n, int n2) {
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new RadarChart(0.0, 0.0, Color.white);
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            RadarLayer radarLayer = (RadarLayer)zoneLeaf.getLayer();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(radarLayer).append("</th></tr>");
            String string = radarLayer.getComment(zoneLeaf, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            int n = radarLayer.getDescriptionCount();
            for (int i = 0; i < n; ++i) {
                String string2 = radarLayer.getDescriptionTitle(i);
                String string3 = radarLayer.getDescription(i, zoneLeaf);
                stringBuilder.append("<tr><td>").append(string2).append(":</td><td>");
                stringBuilder.append(string3).append("</td></tr>");
            }
            double d = zoneLeaf.getValue((byte)0);
            double d2 = 100.0 * d / radarLayer.getSum();
            stringBuilder.append("<tr><td>Value:</td><td>").append(NiceDataFormat.toString(d)).append("</td></tr>");
            stringBuilder.append("<tr><td>Size:</td><td>").append(NiceDataFormat.toString(d2, 4)).append("%</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return false;
    }

    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
    }

    private class RadarChart
    extends FloatWindowPlotRadius2D.PlotRadiusGrid {
        public RadarChart(double d, double d2, Color color) {
            super(color, d, d2);
        }

        @Override
        public ZoneLeaf getLeafAt(Point point) {
            return FloatWindowRadar.this.getLeaf(point.x, point.y, true);
        }

        @Override
        public boolean hasLeafAt(Point point) {
            return FloatWindowRadar.this.getLeaf(point.x, point.y, false) != null;
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            boolean bl;
            Object object;
            this.resolveResourceNode();
            boolean bl2 = false;
            int n = FloatWindowRadar.this.plotAxisLayerPanel.getLayerCount();
            for (int i = n - 1; i >= 0; --i) {
                object = (RadarLayer)FloatWindowRadar.this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (object == null || !((AbstractAxisLayer)object).isLayerReady() || !((AbstractLayer)object).isLayerVisible() || (bl = ((AbstractAxisLayer)object).getNrVisibleObjects()) <= bl2) continue;
                bl2 = bl;
            }
            if ((by & 1) == 1) {
                super.paint(graphics2D, by, d, 0, bl2 ? 1 : 0, false);
                PlotImages.setBorderColor(FloatWindowRadar.this.getObjectBorderColor());
            } else if ((by & 2) == 2 && FloatWindowRadar.this.selectionList.isEmpty()) {
                return;
            }
            if (bl2 > false) {
                double d2;
                double d3;
                Object object2;
                Iterator<ZoneLeaf> iterator;
                Serializable serializable;
                PlotImages.setBlockImage((int)FloatWindowRadar.this.getTryWidth(), (int)FloatWindowRadar.this.getTryHeight());
                AxisRange axisRange = FloatWindowRadar.this.getRange(0, 0);
                object = FloatWindowRadar.this.getRange(0, 0);
                bl = FloatWindowRadar.this.showBorders();
                int[] nArray = new int[2];
                int[] nArray2 = new int[2];
                for (int i = 0; i < n; ++i) {
                    serializable = FloatWindowRadar.this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (serializable == null) continue;
                    serializable.beginCalculations();
                }
                if ((by & 1) == 1) {
                    if ((by & 0x20) != 32) {
                        graphics2D.setClip(this.origoX, this.origoY, this.width, this.height);
                    }
                    double d4 = 1.5707963267948966;
                    for (int i = n - 1; i >= 0; --i) {
                        double d5;
                        double d6;
                        double d7;
                        ZoneLeaf zoneLeaf;
                        RadarLayer radarLayer = (RadarLayer)FloatWindowRadar.this.plotAxisLayerPanel.getLayerAtIndex(i);
                        if (radarLayer == null || !radarLayer.isLayerReady() || !radarLayer.isShowLines() || !radarLayer.isLayerVisible()) continue;
                        iterator = radarLayer.getLeafIterator();
                        object2 = null;
                        d3 = 0.0;
                        d2 = 0.0;
                        while (iterator.hasNext()) {
                            zoneLeaf = (ZoneLeaf)iterator.next();
                            if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                            if (object2 == null) {
                                d7 = zoneLeaf.getValue((byte)0);
                                d3 = Math.cos(d4) * d7;
                                d2 = Math.sin(d4) * d7;
                            } else {
                                d7 = zoneLeaf.getValue((byte)0);
                                d6 = Math.cos(d4) * d7;
                                d5 = Math.sin(d4) * d7;
                                if (axisRange.isInside(d6, d3) && ((AxisRange)object).isInside(d5, d2)) {
                                    this.translateToScreenInt(nArray, d6, d5, axisRange, (AxisRange)object);
                                    this.translateToScreenInt(nArray2, d3, d2, axisRange, (AxisRange)object);
                                    radarLayer.drawLineNoSet(graphics2D, nArray[0], nArray[1], nArray2[0], nArray2[1]);
                                }
                                d3 = d6;
                                d2 = d5;
                            }
                            object2 = zoneLeaf;
                            d4 += Math.PI * 2 / (double)bl2;
                        }
                        iterator = radarLayer.getLeafIterator();
                        if (!iterator.hasNext()) continue;
                        zoneLeaf = iterator.next();
                        d7 = zoneLeaf.getValue((byte)0);
                        d6 = Math.cos(d4) * d7;
                        d5 = Math.sin(d4) * d7;
                        if (!axisRange.isInside(d6, d3) || !((AxisRange)object).isInside(d5, d2)) continue;
                        this.translateToScreenInt(nArray, d6, d5, axisRange, (AxisRange)object);
                        this.translateToScreenInt(nArray2, d3, d2, axisRange, (AxisRange)object);
                        radarLayer.drawLineNoSet(graphics2D, nArray[0], nArray[1], nArray2[0], nArray2[1]);
                    }
                    graphics2D.setClip(null);
                }
                if ((by & 2) == 2) {
                    PlotImages.incBlockIndex();
                    Iterator iterator2 = FloatWindowRadar.this.selectionList.iterator();
                    serializable = new Color(FloatWindowRadar.this.selectionColor.getRed(), FloatWindowRadar.this.selectionColor.getGreen(), FloatWindowRadar.this.selectionColor.getBlue(), 150);
                    double d8 = 1.5707963267948966;
                    while (iterator2.hasNext()) {
                        iterator = (ZoneLeaf)iterator2.next();
                        object2 = ((ZoneLeaf)((Object)iterator)).getLayer();
                        if (!((ZoneLeaf)((Object)iterator)).isVisibleAndNotMissing() || !((AbstractAxisLayer)object2).isLayerReady() || !((AbstractLayer)object2).isLayerVisible()) continue;
                        d3 = ((ZoneLeaf)((Object)iterator)).getValue((byte)0);
                        d8 = (double)((ZoneLeaf)((Object)iterator)).getPrimaryIndex() * (Math.PI * 2) / (double)bl2 + 1.5707963267948966;
                        d2 = Math.cos(d8) * d3;
                        double d9 = Math.sin(d8) * d3;
                        this.paintLeaf(graphics2D, axisRange, axisRange, (ZoneLeaf)((Object)iterator), d2, d9, true, (Color)serializable, d, bl);
                    }
                } else if ((by & 1) == 1) {
                    this.paintLayers(graphics2D, d, true, bl2 ? 1 : 0);
                    PlotImages.setBlockImage((int)FloatWindowRadar.this.getTryWidth(), (int)FloatWindowRadar.this.getTryHeight());
                    this.paintLayers(graphics2D, d, false, bl2 ? 1 : 0);
                } else if ((by & 4) == 4) {
                    if ((by & 0x20) != 32) {
                        graphics2D.setClip(this.origoX, this.origoY, this.width, this.height);
                    }
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(stroke);
                    for (int i = 0; i < n; ++i) {
                        RadarLayer radarLayer = (RadarLayer)FloatWindowRadar.this.plotAxisLayerPanel.getLayerAtIndex(i);
                        if (radarLayer == null || !radarLayer.isLayerReady() || !radarLayer.isLayerVisible()) continue;
                        radarLayer.drawStatistics(graphics2D, 0.0, d);
                    }
                    graphics2D.setClip(null);
                }
                for (int i = 0; i < n; ++i) {
                    AbstractAxisLayer abstractAxisLayer = FloatWindowRadar.this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (abstractAxisLayer == null) continue;
                    abstractAxisLayer.endCalculations();
                }
            }
        }

        private final void paintLayers(Graphics2D graphics2D, double d, boolean bl, int n) {
            AxisRange axisRange = FloatWindowRadar.this.getRange(0, 0);
            boolean bl2 = FloatWindowRadar.this.showBorders();
            int n2 = FloatWindowRadar.this.plotAxisLayerPanel.getMainLayerCount();
            for (int i = n2 - 1; i >= 0; --i) {
                RadarLayer radarLayer = (RadarLayer)FloatWindowRadar.this.plotAxisLayerPanel.getMainLayer(i);
                if (!radarLayer.isLayerReady()) continue;
                InnerColumnBoolean innerColumnBoolean = FloatWindowRadar.this.getIncludeColumn(radarLayer);
                if (bl && innerColumnBoolean == null) continue;
                graphics2D.setFont(radarLayer.getDescriptionFont());
                radarLayer.beginCalculations();
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)radarLayer.getSettingsBoxMap().get((byte)0);
                AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
                int n3 = comboBoxAxis.getSelectedType();
                int n4 = comboBoxAxis.getAxisIndex();
                boolean bl3 = comboBoxAxis.getObservationTag();
                PlotImages.incBlockIndex();
                AbstractAxisLayer abstractAxisLayer = radarLayer;
                double d2 = 1.5707963267948966;
                List<ZoneLeaf> list = radarLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    double d3;
                    ZoneLeaf zoneLeaf = list.get(j);
                    int n5 = zoneLeaf.getPrimaryIndex();
                    if (bl) {
                        zoneLeaf.setExcluded(innerColumnBoolean != null && !innerColumnBoolean.getValueBool(n5));
                        if (!zoneLeaf.isExcluded()) {
                            continue;
                        }
                    } else if (zoneLeaf.isExcluded()) continue;
                    if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                    if (abstractAxisLayer != zoneLeaf.getLayer() && zoneLeaf.getLayer().isLayerReady()) {
                        abstractAxisLayer = zoneLeaf.getLayer();
                        graphics2D.setFont(abstractAxisLayer.getDescriptionFont());
                    }
                    if (!abstractAxisLayer.isLayerVisible()) continue;
                    int n6 = bl3 ? abstractDataMatrix.getNrefOrig(n5) : abstractDataMatrix.getKrefOrig(n5);
                    double d4 = d3 = FloatWindowScatter.getLeafValueOrigIndex(n6, abstractDataMatrix, n3, n4, bl3);
                    double d5 = Math.cos(d2) * d4;
                    double d6 = Math.sin(d2) * d4;
                    this.paintLeaf(graphics2D, axisRange, axisRange, zoneLeaf, d5, d6, false, null, d, bl2);
                    d2 += Math.PI * 2 / (double)n;
                }
                radarLayer.endCalculations();
            }
        }

        private final void paintLeaf(Graphics2D graphics2D, AxisRange axisRange, AxisRange axisRange2, ZoneLeaf zoneLeaf, double d, double d2, boolean bl, Color color, double d3, boolean bl2) {
            if (axisRange.isInside(d) && axisRange2.isInside(d2)) {
                this.translateToScreenInt(FloatWindowRadar.this.plotscreen, d, d2, axisRange, axisRange2);
                boolean bl3 = PlotImages.drawAccelerated(this.getResourceNode(zoneLeaf), graphics2D, zoneLeaf, FloatWindowRadar.this.plotscreen, d3, bl2);
                if (bl) {
                    if (bl3) {
                        PlotImages.drawSelection(graphics2D, zoneLeaf, FloatWindowRadar.this.plotscreen, d3, color, true);
                    }
                } else {
                    zoneLeaf.paintDescription(graphics2D, FloatWindowRadar.this.plotscreen[0], FloatWindowRadar.this.plotscreen[1], d3, FloatWindowRadar.this.axisColor);
                }
            }
        }
    }
}

