/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.radar;

import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;
import se.prediktera.map.plot.axisplot.settings.ComboBoxLines;
import se.prediktera.map.plot.axisplot.settings.ComboBoxShape;
import se.prediktera.map.plot.axisplot.settings.ComboBoxSize;
import se.prediktera.map.plot.axisplot.settings.ComboBoxStatistics;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class RadarLayer
extends AbstractAxisLayer {
    private ComboBoxAxis boxAxis;
    private ComboBoxSize boxSize;
    private ComboBoxShape boxShape;
    private ComboBoxDescription boxLabel;
    private ComboBoxLines boxLines;
    private boolean showlines;
    private final Font labelFont = new Font("SansSerif", 0, 12);
    private double sum = 0.0;

    public RadarLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.layerName = this.isSubLayer() ? "Sub " + n : "Layer " + n;
        this.jbinit();
    }

    public RadarLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("sum")) {
            this.sum = mapProperty.getLVDouble();
        }
        this.jbinit();
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new RadarLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    public void drawLineNoSet(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.boxLines.getDrawLineStyle().drawLineNoSet(graphics2D, n, n2, n3, n4);
    }

    @Override
    public double getAxisValue(byte by, int n, int n2) {
        if (this.boxAxis == null) {
            return 0.0;
        }
        return this.boxAxis.getAxisValue(n, n2);
    }

    @Override
    public Font getDescriptionFont() {
        return this.labelFont;
    }

    @Override
    public double[] getMinmax(int n) {
        return new double[]{0.0, 1.0};
    }

    public double getSum() {
        return this.sum;
    }

    @Override
    public byte getTreeType() {
        return 13;
    }

    @Override
    public boolean isMissing(byte by, int n, int n2) {
        if (this.boxAxis == null) {
            return false;
        }
        return this.boxAxis.isMissingPrimary(n);
    }

    public boolean isShowLines() {
        return this.showlines;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyDouble("sum", this.sum);
    }

    @Override
    public void setShowLines(boolean bl) {
        this.showlines = bl;
    }

    public void setSum(double d) {
        this.sum = d;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxAxis = null;
        this.boxSize = null;
        this.boxShape = null;
        this.boxLabel = null;
        this.boxLines = null;
        this.boxStatistics = null;
    }

    @Override
    protected void InitLayer() {
        AbstractDataMatrix abstractDataMatrix = this.getPlotInit().getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxColor.addItem(new ComboItem(VALUESTRING, 0));
        this.boxColor.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxColor.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxComment = new ComboBoxComment(abstractDataMatrix, this);
        this.boxComment.addItem(new ComboItem(NONESTRING, 2));
        this.boxComment.addItem(new ComboItem(CUSTOMSTRING, 1));
        this.boxComment.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxComment.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxComment.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxComment.getType(), this.boxComment);
        this.InitLayerChild();
    }

    @Override
    protected void InitLayerChild() {
        this.boxAxis = new ComboBoxAxis(this, 0);
        this.boxAxis.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxAxis.addItem(new ComboItem(VALUESTRING, 0));
        this.boxAxis.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxAxis.getType(), this.boxAxis);
        this.boxSize = new ComboBoxSize(this, 0);
        this.boxSize.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxSize.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxSize.addItem(new ComboItem(VALUESTRING, 0));
        this.boxSize.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxSize.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxSize.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxSize.getType(), this.boxSize);
        this.boxShape = new ComboBoxShape(this, 0);
        this.boxShape.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxShape.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxShape.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxShape.addItem(new ComboItem(DATAIMAGESTRING, 21));
        this.boxShape.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxShape.getType(), this.boxShape);
        this.boxLabel = new ComboBoxDescription(this, 0);
        this.boxLabel.addItem(new ComboItem(NONESTRING, 2));
        this.boxLabel.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxLabel.addItem(new ComboItem(DESCRIPTIONSTRING, 5));
        this.boxLabel.addItem(new ComboItem(VALUESTRING, 0));
        this.boxLabel.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxLabel.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxLabel.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxLabel.getType(), this.boxLabel);
        this.boxLines = new ComboBoxLines(this, 0);
        this.boxLines.addItem(new ComboItem(NONESTRING, 2));
        this.boxLines.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxLines.addItem(new ComboItem(VALUESTRING, 0));
        this.boxLines.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxLines.getType(), this.boxLines);
        this.boxStatistics = new ComboBoxStatistics(this, 0);
        this.boxStatistics.addItem(new ComboItem(NONESTRING, 2));
        this.settingsBoxMap.put(this.boxStatistics.getType(), this.boxStatistics);
    }

    private void jbinit() {
        if (this.isSubLayer()) {
            this.boxAxis.setEnabled(false);
        }
        this.add(SettingsBoxHelper.createAxisPanel(this.boxAxis, null, null));
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createSizePanel(this.boxSize));
        this.add(SettingsBoxHelper.createShapePanel(this.boxShape));
        this.add(SettingsBoxHelper.createLabelPanel(this.boxLabel));
        this.add(SettingsBoxHelper.createLinesPanel(this.boxLines));
        this.add(SettingsBoxHelper.createStatisticsPanel(this.boxStatistics));
        this.add(SettingsBoxHelper.createCommentPanel(this.boxComment));
    }
}

