/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.radar.design;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlotRadius2D;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;
import se.prediktera.map.plot.axisplot.plot2D.radar.design.DesignLayer;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;

public class FloatWindowDesign
extends FloatWindowPlotRadius2D {
    private final int[] plotscreen = new int[2];

    public FloatWindowDesign(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
    }

    public FloatWindowDesign(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new DesignLayer(this, plotInit, null, null, n);
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneLeaf zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            DesignLayer designLayer = (DesignLayer)abstractAxisLayer;
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneLeaf);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            int n3 = abstractAxisLayer.getDescriptionCount();
            for (int i = 0; i < n3; ++i) {
                String string2 = abstractAxisLayer.getDescriptionTitle(i);
                String string3 = abstractAxisLayer.getDescription(i, zoneLeaf);
                stringBuilder.append(string2).append(": ");
                stringBuilder.append(string3).append("\n");
            }
            double d = zoneLeaf.getValue((byte)0);
            double d2 = 100.0 * d / designLayer.getSum();
            stringBuilder.append("Value: ").append(NiceDataFormat.toString(d)).append("\n");
            stringBuilder.append("Size: ").append(NiceDataFormat.toString(d2, 4)).append("%\n");
        } else if (zoneLeaf != null) {
            stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)0))).append("\n");
            stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)1))).append("\n");
        }
        return stringBuilder.toString();
    }

    public ZoneLeaf getLeaf(int n, int n2, boolean bl) {
        ZoneLeaf zoneLeaf = null;
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        double d = this.getRelative();
        double[] dArray = new double[2];
        AxisRange axisRange = this.getRange(0, 0);
        AxisRange axisRange2 = this.getRange(1, 0);
        double d2 = Double.MAX_VALUE;
        double[] dArray2 = new double[2];
        for (int i = 0; i < n3; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer != null && !abstractAxisLayer.isSubLayer() && abstractAxisLayer.isLayerReady() && abstractAxisLayer.isLayerVisible()) {
                abstractAxisLayer.beginCalculations();
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)0);
                ComboBoxAxis comboBoxAxis2 = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)1);
                ComboBoxAxis comboBoxAxis3 = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)2);
                AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
                int n4 = comboBoxAxis.getSelectedType();
                int n5 = comboBoxAxis.getAxisIndex();
                AbstractDataMatrix abstractDataMatrix2 = comboBoxAxis2.getMatrix();
                int n6 = comboBoxAxis2.getSelectedType();
                int n7 = comboBoxAxis2.getAxisIndex();
                AbstractDataMatrix abstractDataMatrix3 = comboBoxAxis3.getMatrix();
                int n8 = comboBoxAxis3.getSelectedType();
                int n9 = comboBoxAxis3.getAxisIndex();
                boolean bl2 = comboBoxAxis.getObservationTag();
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    double d3;
                    double d4;
                    ZoneLeaf zoneLeaf2 = list.get(j);
                    if (!zoneLeaf2.isVisibleAndNotMissing() || !zoneLeaf2.getLayer().isLayerVisible()) continue;
                    int n10 = zoneLeaf2.getPrimaryIndex();
                    int n11 = bl2 ? abstractDataMatrix.getNrefOrig(n10) : abstractDataMatrix.getKrefOrig(n10);
                    double d5 = FloatWindowScatter.getLeafValueOrigIndex(n11, abstractDataMatrix, n4, n5, bl2);
                    double d6 = FloatWindowScatter.getLeafValueOrigIndex(n11, abstractDataMatrix2, n6, n7, bl2);
                    double d7 = FloatWindowScatter.getLeafValueOrigIndex(n11, abstractDataMatrix3, n8, n9, bl2);
                    this.setCoord(d5, d6, d7, dArray2);
                    this.plotGround.translateToScreenDouble(dArray, dArray2[0], dArray2[1], axisRange, axisRange2);
                    double d8 = (double)n - dArray[0];
                    double d9 = (double)n2 - dArray[1];
                    double d10 = d8 * d8 + d9 * d9;
                    if (bl && d10 > d2 || !(d10 < (d4 = (d3 = (double)zoneLeaf2.getSize() * d * 0.5) * d3))) continue;
                    d2 = d10;
                    if (!bl) {
                        abstractAxisLayer.endCalculations();
                        return zoneLeaf2;
                    }
                    zoneLeaf = zoneLeaf2;
                }
            }
            abstractAxisLayer.endCalculations();
        }
        return zoneLeaf;
    }

    @Override
    public byte getTreeType() {
        return 19;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband instanceof RubberbandNormal && this.rubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            ZoneLeaf zoneLeaf;
            ZoneLeaf zoneLeaf2;
            boolean bl;
            int n = mouseEvent.getModifiersEx();
            boolean bl2 = (n & 0x40) == 64;
            boolean bl3 = bl = (n & 0x80) == 128;
            if (!bl && !bl2) {
                this.selectedItems(this.selectionList, false, false);
            }
            if ((zoneLeaf2 = this.getLeaf(mouseEvent.getX(), mouseEvent.getY(), true)) != null) {
                if (bl && zoneLeaf2.isSelected()) {
                    if (bl2) {
                        zoneLeaf2.setSelected(false);
                        this.selectionList.remove(zoneLeaf2);
                    }
                } else if (!zoneLeaf2.isSelected() && zoneLeaf2.isVisible()) {
                    this.selectionList.add(zoneLeaf2);
                }
            }
            this.selectedItems(this.selectionList, true, true);
            this.repaintPlot((byte)2);
            if (mouseEvent.getClickCount() > 1 && (zoneLeaf = this.selectionList.getFirst()) != null) {
                this.openProjectLink(this.selectionList.getFirst());
            }
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void selectNnearest(int n, int n2) {
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new RadarChart(0.0, 0.0, Color.white);
    }

    @Override
    protected String getDescription(int n) {
        Object object = "";
        int n2 = this.plotAxisLayerPanel.getLayerCount();
        for (int i = 0; i < n2; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)n);
            String string = comboBoxAxis.getSelectedItem().toString();
            if (string.startsWith("Ypred.")) {
                int n3 = string.lastIndexOf(".");
                string = string.substring(6, n3);
            }
            if (((String)object).equals(string)) continue;
            if (((String)object).length() > 0) {
                object = (String)object + "/";
            }
            object = (String)object + string;
        }
        return object;
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            DesignLayer designLayer = (DesignLayer)zoneLeaf.getLayer();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(designLayer).append("</th></tr>");
            String string = designLayer.getComment(zoneLeaf, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            int n = designLayer.getDescriptionCount();
            for (int i = 0; i < n; ++i) {
                String string2 = designLayer.getDescriptionTitle(i);
                String string3 = designLayer.getDescription(i, zoneLeaf);
                stringBuilder.append("<tr><td>").append(string2).append(":</td><td>");
                stringBuilder.append(string3).append("</td></tr>");
            }
            double d = zoneLeaf.getValue((byte)0);
            double d2 = zoneLeaf.getValue((byte)1);
            double d3 = zoneLeaf.getValue((byte)2);
            stringBuilder.append("<tr><td>").append(this.getDescription(0)).append(":</td><td>").append(NiceDataFormat.toString(d, 4)).append("</td></tr>");
            stringBuilder.append("<tr><td>").append(this.getDescription(1)).append(":</td><td>").append(NiceDataFormat.toString(d2, 4)).append("</td></tr>");
            stringBuilder.append("<tr><td>").append(this.getDescription(2)).append(":</td><td>").append(NiceDataFormat.toString(d3, 4)).append("</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return false;
    }

    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
    }

    @Override
    protected final void setCoord(ZoneLeaf zoneLeaf, double[] dArray) {
        double d = zoneLeaf.getValue((byte)0);
        double d2 = zoneLeaf.getValue((byte)1);
        double d3 = zoneLeaf.getValue((byte)2);
        this.setCoord(d, d2, d3, dArray);
    }

    private final void setCoord(double d, double d2, double d3, double[] dArray) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        double d4 = (this.localminmax[0][1] - this.localminmax[0][0]) / 2.0;
        double d5 = this.localminmax[1][1] - this.localminmax[1][0];
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = d + d2 + d3;
        double d8 = d2 / d7 * d6 * Math.cos(1.0471975511965976);
        double d9 = d2 / d7 * d6 * Math.sin(1.0471975511965976);
        double d10 = d3 / d7 * d6 * Math.cos(1.0471975511965976);
        double d11 = d3 / d7 * d6 * Math.sin(1.0471975511965976);
        dArray[0] = 0.0 - d8 + d10;
        dArray[1] = this.localminmax[1][1] - d9 - d11;
    }

    private class RadarChart
    extends FloatWindowPlotRadius2D.PlotRadiusGrid {
        public RadarChart(double d, double d2, Color color) {
            super(color, d, d2);
        }

        @Override
        public ZoneLeaf getLeafAt(Point point) {
            return FloatWindowDesign.this.getLeaf(point.x, point.y, true);
        }

        @Override
        public boolean hasLeafAt(Point point) {
            return FloatWindowDesign.this.getLeaf(point.x, point.y, false) != null;
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            Iterator<ZoneLeaf> iterator;
            Object object;
            int n;
            Object object2;
            if ((by & 1) == 1) {
                super.paint(graphics2D, by, d, 0, 3, false);
                PlotImages.setBorderColor(FloatWindowDesign.this.getObjectBorderColor());
            } else if ((by & 2) == 2 && FloatWindowDesign.this.selectionList.isEmpty()) {
                return;
            }
            PlotImages.setBlockImage((int)FloatWindowDesign.this.getTryWidth(), (int)FloatWindowDesign.this.getTryHeight());
            AxisRange axisRange = FloatWindowDesign.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowDesign.this.getRange(1, 0);
            boolean bl = FloatWindowDesign.this.showBorders();
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            int n2 = FloatWindowDesign.this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n2; ++i) {
                object2 = FloatWindowDesign.this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (object2 == null) continue;
                ((AbstractAxisLayer)object2).beginCalculations();
            }
            double[] dArray = new double[2];
            if ((by & 1) == 1) {
                if ((by & 0x20) != 32) {
                    graphics2D.setClip(this.origoX, this.origoY, this.width, this.height);
                }
                object2 = new double[2];
                for (n = n2 - 1; n >= 0; --n) {
                    ZoneLeaf zoneLeaf;
                    object = (DesignLayer)FloatWindowDesign.this.plotAxisLayerPanel.getLayerAtIndex(n);
                    if (object == null || !((AbstractAxisLayer)object).isLayerReady() || !((DesignLayer)object).isShowLines() || !((AbstractLayer)object).isLayerVisible()) continue;
                    iterator = ((AbstractAxisLayer)object).getLeafIterator();
                    ZoneLeaf zoneLeaf2 = null;
                    while (iterator.hasNext()) {
                        zoneLeaf = (ZoneLeaf)iterator.next();
                        if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                        if (zoneLeaf2 == null) {
                            FloatWindowDesign.this.setCoord(zoneLeaf, (double[])object2);
                        } else {
                            FloatWindowDesign.this.setCoord(zoneLeaf, dArray);
                            if (axisRange.isInside(dArray[0], (double)object2[0]) && axisRange2.isInside(dArray[1], (double)object2[1])) {
                                this.translateToScreenInt(nArray, dArray[0], dArray[1], axisRange, axisRange2);
                                this.translateToScreenInt(nArray2, (double)object2[0], (double)object2[1], axisRange, axisRange2);
                                ((DesignLayer)object).drawLineNoSet(graphics2D, nArray[0], nArray[1], nArray2[0], nArray2[1]);
                            }
                            object2 = dArray;
                        }
                        zoneLeaf2 = zoneLeaf;
                    }
                    iterator = ((AbstractAxisLayer)object).getLeafIterator();
                    if (!iterator.hasNext()) continue;
                    zoneLeaf = iterator.next();
                    FloatWindowDesign.this.setCoord(zoneLeaf, dArray);
                    if (!axisRange.isInside(dArray[0], (double)object2[0]) || !axisRange2.isInside(dArray[1], (double)object2[1])) continue;
                    this.translateToScreenInt(nArray, dArray[0], dArray[1], axisRange, axisRange2);
                    this.translateToScreenInt(nArray2, (double)object2[0], (double)object2[1], axisRange, axisRange2);
                    ((DesignLayer)object).drawLineNoSet(graphics2D, nArray[0], nArray[1], nArray2[0], nArray2[1]);
                }
                graphics2D.setClip(null);
            }
            if ((by & 2) == 2) {
                PlotImages.incBlockIndex();
                object2 = FloatWindowDesign.this.selectionList.iterator();
                Color color = new Color(FloatWindowDesign.this.selectionColor.getRed(), FloatWindowDesign.this.selectionColor.getGreen(), FloatWindowDesign.this.selectionColor.getBlue(), 150);
                while (object2.hasNext()) {
                    object = (ZoneLeaf)object2.next();
                    iterator = ((ZoneLeaf)object).getLayer();
                    if (!((ZoneLeaf)object).isVisibleAndNotMissing() || !((AbstractAxisLayer)((Object)iterator)).isLayerReady() || !((AbstractLayer)((Object)iterator)).isLayerVisible()) continue;
                    FloatWindowDesign.this.setCoord((ZoneLeaf)object, dArray);
                    this.paintLeaf(graphics2D, axisRange, axisRange2, (ZoneLeaf)object, dArray[0], dArray[1], true, color, d, bl);
                }
            } else if ((by & 1) == 1) {
                this.paintLayers(graphics2D, d, true);
                PlotImages.setBlockImage((int)FloatWindowDesign.this.getTryWidth(), (int)FloatWindowDesign.this.getTryHeight());
                this.paintLayers(graphics2D, d, false);
            } else if ((by & 4) == 4) {
                if ((by & 0x20) != 32) {
                    graphics2D.setClip(this.origoX, this.origoY, this.width, this.height);
                }
                object2 = graphics2D.getStroke();
                graphics2D.setStroke((Stroke)object2);
                for (n = 0; n < n2; ++n) {
                    object = (DesignLayer)FloatWindowDesign.this.plotAxisLayerPanel.getLayerAtIndex(n);
                    if (object == null || !((AbstractAxisLayer)object).isLayerReady() || !((AbstractLayer)object).isLayerVisible()) continue;
                    ((AbstractAxisLayer)object).drawStatistics(graphics2D, 0.0, d);
                }
                graphics2D.setClip(null);
            }
            for (int i = 0; i < n2; ++i) {
                AbstractAxisLayer abstractAxisLayer = FloatWindowDesign.this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractAxisLayer == null) continue;
                abstractAxisLayer.endCalculations();
            }
        }

        @Override
        protected void drawAxisTick(Graphics2D graphics2D, double d, double d2, double d3, double d4, double d5) {
            double d6;
            AxisRange axisRange = FloatWindowDesign.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowDesign.this.getRange(1, 0);
            double d7 = d3 - d;
            double d8 = d4 - d2;
            double d9 = 0.0;
            if (Math.abs(d8) > 0.001) {
                d9 = d8 / d7;
            } else {
                d6 = d;
                d = d3;
                d3 = d6;
            }
            d6 = Math.sqrt(d7 * d7 + d8 * d8);
            double d10 = Math.atan(d9);
            double d11 = d10 + 1.5707963267948966;
            double d12 = Math.cos(d11) * d6 * 0.005;
            double d13 = Math.sin(d11) * d6 * 0.005;
            if (d9 == 0.0) {
                d13 *= -1.0;
            }
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            List<TickInfo> list = this.getTickList();
            for (TickInfo tickInfo : list) {
                double d14 = tickInfo.pos * 2.0;
                if (d9 != 0.0) {
                    d14 = 1.0 - d14;
                }
                double d15 = d3 + Math.cos(d10) * d6 * d14;
                double d16 = d4 + Math.sin(d10) * d6 * d14;
                this.translateToScreenInt(nArray, d15 + d12, d16 + d13, axisRange, axisRange2);
                this.translateToScreenInt(nArray2, d15 - d12, d16 - d13, axisRange, axisRange2);
                graphics2D.setColor(FloatWindowDesign.this.getGridColor());
                graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
                this.translateToScreenInt(nArray, d15 + d12 * 8.0, d16 + d13 * 5.0, axisRange, axisRange2);
                Font font = graphics2D.getFont();
                graphics2D.setFont(new Font(font.getName(), 0, (int)((double)(font.getSize() - 6) * d5)));
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                AffineTransform affineTransform = graphics2D.getTransform();
                int n = fontMetrics.stringWidth(tickInfo.text);
                graphics2D.setColor(FloatWindowDesign.this.getAxisColor());
                graphics2D.translate(nArray[0] - n, nArray[1] + fontMetrics.getHeight());
                graphics2D.scale(3.0, 3.0);
                graphics2D.drawString(tickInfo.text, 0, 0);
                graphics2D.setTransform(affineTransform);
                graphics2D.setFont(font);
            }
        }

        @Override
        protected void drawGrid(Graphics2D graphics2D, int n, List<TickInfo> list, double d) {
            AxisRange axisRange = FloatWindowDesign.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowDesign.this.getRange(1, 0);
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            graphics2D.setColor(FloatWindowDesign.this.getGridColor());
            for (TickInfo tickInfo : list) {
                double d2 = tickInfo.pos * 2.0;
                FloatWindowDesign.this.setCoord(d2, 0.0, 1.0 - d2, dArray);
                FloatWindowDesign.this.setCoord(0.0, d2, 1.0 - d2, dArray2);
                this.translateToScreenInt(nArray, dArray[0], dArray[1], axisRange, axisRange2);
                this.translateToScreenInt(nArray2, dArray2[0], dArray2[1], axisRange, axisRange2);
                graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
                FloatWindowDesign.this.setCoord(1.0 - d2, d2, 0.0, dArray);
                FloatWindowDesign.this.setCoord(1.0 - d2, 0.0, d2, dArray2);
                this.translateToScreenInt(nArray, dArray[0], dArray[1], axisRange, axisRange2);
                this.translateToScreenInt(nArray2, dArray2[0], dArray2[1], axisRange, axisRange2);
                graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
                FloatWindowDesign.this.setCoord(0.0, 1.0 - d2, d2, dArray);
                FloatWindowDesign.this.setCoord(d2, 1.0 - d2, 0.0, dArray2);
                this.translateToScreenInt(nArray, dArray[0], dArray[1], axisRange, axisRange2);
                this.translateToScreenInt(nArray2, dArray2[0], dArray2[1], axisRange, axisRange2);
                graphics2D.drawLine(nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
        }

        @Override
        protected List<TickInfo> getTickList() {
            ArrayList<TickInfo> arrayList = new ArrayList<TickInfo>();
            for (double d = 0.0; d <= 10.0; d += 1.0) {
                arrayList.add(new TickInfo(d / 20.0, String.valueOf(d / 10.0)));
            }
            return arrayList;
        }

        private final void paintLayers(Graphics2D graphics2D, double d, boolean bl) {
            AxisRange axisRange = FloatWindowDesign.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowDesign.this.getRange(1, 0);
            boolean bl2 = FloatWindowDesign.this.showBorders();
            int n = FloatWindowDesign.this.plotAxisLayerPanel.getMainLayerCount();
            double[] dArray = new double[2];
            for (int i = n - 1; i >= 0; --i) {
                DesignLayer designLayer = (DesignLayer)FloatWindowDesign.this.plotAxisLayerPanel.getMainLayer(i);
                if (!designLayer.isLayerReady()) continue;
                InnerColumnBoolean innerColumnBoolean = FloatWindowDesign.this.getIncludeColumn(designLayer);
                if (bl && innerColumnBoolean == null) continue;
                graphics2D.setFont(designLayer.getDescriptionFont());
                designLayer.beginCalculations();
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)designLayer.getSettingsBoxMap().get((byte)0);
                ComboBoxAxis comboBoxAxis2 = (ComboBoxAxis)designLayer.getSettingsBoxMap().get((byte)1);
                ComboBoxAxis comboBoxAxis3 = (ComboBoxAxis)designLayer.getSettingsBoxMap().get((byte)2);
                AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
                int n2 = comboBoxAxis.getSelectedType();
                int n3 = comboBoxAxis.getAxisIndex();
                AbstractDataMatrix abstractDataMatrix2 = comboBoxAxis2.getMatrix();
                int n4 = comboBoxAxis2.getSelectedType();
                int n5 = comboBoxAxis2.getAxisIndex();
                AbstractDataMatrix abstractDataMatrix3 = comboBoxAxis3.getMatrix();
                int n6 = comboBoxAxis3.getSelectedType();
                int n7 = comboBoxAxis3.getAxisIndex();
                boolean bl3 = comboBoxAxis.getObservationTag();
                PlotImages.incBlockIndex();
                AbstractAxisLayer abstractAxisLayer = designLayer;
                List<ZoneLeaf> list = designLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    ZoneLeaf zoneLeaf = list.get(j);
                    int n8 = zoneLeaf.getPrimaryIndex();
                    if (bl) {
                        zoneLeaf.setExcluded(innerColumnBoolean != null && !innerColumnBoolean.getValueBool(n8));
                        if (!zoneLeaf.isExcluded()) {
                            continue;
                        }
                    } else if (zoneLeaf.isExcluded()) continue;
                    if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                    if (abstractAxisLayer != zoneLeaf.getLayer() && zoneLeaf.getLayer().isLayerReady()) {
                        abstractAxisLayer = zoneLeaf.getLayer();
                        graphics2D.setFont(abstractAxisLayer.getDescriptionFont());
                    }
                    if (!abstractAxisLayer.isLayerVisible()) continue;
                    int n9 = bl3 ? abstractDataMatrix.getNrefOrig(n8) : abstractDataMatrix.getKrefOrig(n8);
                    double d2 = FloatWindowScatter.getLeafValueOrigIndex(n9, abstractDataMatrix, n2, n3, bl3);
                    double d3 = FloatWindowScatter.getLeafValueOrigIndex(n9, abstractDataMatrix2, n4, n5, bl3);
                    double d4 = FloatWindowScatter.getLeafValueOrigIndex(n9, abstractDataMatrix3, n6, n7, bl3);
                    FloatWindowDesign.this.setCoord(d2, d3, d4, dArray);
                    this.paintLeaf(graphics2D, axisRange, axisRange2, zoneLeaf, dArray[0], dArray[1], false, null, d, bl2);
                }
                designLayer.endCalculations();
            }
        }

        private final void paintLeaf(Graphics2D graphics2D, AxisRange axisRange, AxisRange axisRange2, ZoneLeaf zoneLeaf, double d, double d2, boolean bl, Color color, double d3, boolean bl2) {
            if (axisRange.isInside(d) && axisRange2.isInside(d2)) {
                this.translateToScreenInt(FloatWindowDesign.this.plotscreen, d, d2, axisRange, axisRange2);
                boolean bl3 = PlotImages.drawAccelerated(this.getResourceNode(zoneLeaf), graphics2D, zoneLeaf, FloatWindowDesign.this.plotscreen, d3, bl2);
                if (bl) {
                    if (bl3) {
                        PlotImages.drawSelection(graphics2D, zoneLeaf, FloatWindowDesign.this.plotscreen, d3, color, true);
                    }
                } else {
                    zoneLeaf.paintDescription(graphics2D, FloatWindowDesign.this.plotscreen[0], FloatWindowDesign.this.plotscreen[1], d3, FloatWindowDesign.this.axisColor);
                }
            }
        }
    }
}

