/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.scatter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;
import se.prediktera.map.plot.axisplot.plot2D.scatter.ScatterLayer;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComponent;

public class FloatWindowScatter
extends FloatWindowPlot2D {
    public static final double CORRECTION = 4.656612875245797E-10;
    private final int[] plotscreen = new int[2];
    private boolean paintReverse = true;

    public static final double getLeafValue(int n, AbstractDataMatrix abstractDataMatrix, int n2, int n3, boolean bl) {
        int n4 = bl ? abstractDataMatrix.getNrefOrig(n) : abstractDataMatrix.getKrefOrig(n);
        return FloatWindowScatter.getLeafValueOrigIndex(n4, abstractDataMatrix, n2, n3, bl);
    }

    public static final double getLeafValueOrigIndex(int n, AbstractDataMatrix abstractDataMatrix, int n2, int n3, boolean bl) {
        if (n2 == 4) {
            return n + 1;
        }
        if (n2 == 27) {
            if (bl) {
                return abstractDataMatrix.getNref()[n] + 1;
            }
            return abstractDataMatrix.getKref()[n] + 1;
        }
        if (n < 0) {
            return 0.0;
        }
        if (n3 < 0) {
            return n;
        }
        if (bl) {
            return abstractDataMatrix.getValue(n, n3);
        }
        return abstractDataMatrix.getValue(n3, n);
    }

    public FloatWindowScatter(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.setupDragContribution();
    }

    public FloatWindowScatter(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.setupDragContribution();
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new ScatterLayer(this, plotInit, null, null, n);
    }

    public void setPaintReverse(boolean bl) {
        this.paintReverse = bl;
    }

    public ZoneLeaf getLeaf(int n, int n2, boolean bl) {
        ZoneLeaf zoneLeaf = null;
        int n3 = this.plotAxisLayerPanel.getLayerCount();
        double d = this.getRelative();
        double[] dArray = new double[2];
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < n3; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
            if (abstractAxisLayer == null || abstractAxisLayer.isSubLayer() || !abstractAxisLayer.isLayerReady() || !abstractAxisLayer.isLayerVisible()) continue;
            abstractAxisLayer.beginCalculations();
            ComboBoxAxis comboBoxAxis = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)0);
            ComboBoxAxis comboBoxAxis2 = (ComboBoxAxis)abstractAxisLayer.getSettingsBoxMap().get((byte)1);
            AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
            AbstractDataMatrix abstractDataMatrix2 = comboBoxAxis2.getMatrix();
            int n4 = comboBoxAxis.getSelectedType();
            int n5 = comboBoxAxis2.getSelectedType();
            int n6 = comboBoxAxis.getAxisIndex();
            int n7 = comboBoxAxis2.getAxisIndex();
            boolean bl2 = comboBoxAxis.getObservationTag();
            boolean bl3 = comboBoxAxis2.getObservationTag();
            boolean bl4 = abstractDataMatrix == abstractDataMatrix2 && bl2 == bl3;
            List<ZoneLeaf> list = abstractAxisLayer.getRootList();
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                double d4;
                double d5;
                double d6;
                ZoneLeaf zoneLeaf2 = list.get(j);
                if (zoneLeaf2 == null || !zoneLeaf2.isVisibleAndNotMissing() || !zoneLeaf2.getLayer().isLayerVisible()) continue;
                int n8 = zoneLeaf2.getPrimaryIndex();
                if (bl4) {
                    int n9 = bl2 ? abstractDataMatrix.getNrefOrig(n8) : abstractDataMatrix.getKrefOrig(n8);
                    d6 = FloatWindowScatter.getLeafValueOrigIndex(n9, abstractDataMatrix, n4, n6, bl2);
                    d5 = FloatWindowScatter.getLeafValueOrigIndex(n9, abstractDataMatrix2, n5, n7, bl3);
                } else {
                    d6 = FloatWindowScatter.getLeafValue(n8, abstractDataMatrix, n4, n6, bl2);
                    d5 = FloatWindowScatter.getLeafValue(n8, abstractDataMatrix2, n5, n7, bl3);
                }
                this.plotGround.translateToScreenDouble(dArray, d6, d5, 0);
                double d7 = (double)n - dArray[0];
                double d8 = (double)n2 - dArray[1];
                double d9 = d7 * d7 + d8 * d8;
                if (bl && d9 > d2 || !(d9 < (d4 = (d3 = (double)zoneLeaf2.getSize() * d * 0.5) * d3))) continue;
                d2 = d9;
                if (!bl) {
                    abstractAxisLayer.endCalculations();
                    return zoneLeaf2;
                }
                zoneLeaf = zoneLeaf2;
            }
            abstractAxisLayer.endCalculations();
        }
        return zoneLeaf;
    }

    @Override
    public byte getTreeType() {
        return 2;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband instanceof RubberbandNormal && this.rubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            ZoneLeaf zoneLeaf;
            boolean bl;
            int n = mouseEvent.getModifiersEx();
            boolean bl2 = (n & 0x40) == 64;
            boolean bl3 = bl = (n & 0x80) == 128;
            if (!bl && !bl2) {
                this.selectedItems(this.selectionList, false, false);
            }
            if ((zoneLeaf = this.getLeaf(mouseEvent.getX(), mouseEvent.getY(), true)) != null) {
                if (bl && zoneLeaf.isSelected()) {
                    if (bl2) {
                        zoneLeaf.setSelected(false);
                        this.selectionList.remove(zoneLeaf);
                    }
                } else if (!zoneLeaf.isSelected() && zoneLeaf.isVisible()) {
                    this.selectionList.add(zoneLeaf);
                }
            }
            this.selectedItems(this.selectionList, true, true);
            this.repaintPlot((byte)2);
            if (mouseEvent.getClickCount() > 1 && this.selectionList.size() > 0) {
                this.openProjectLink(this.selectionList.getFirst());
            }
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    public boolean needBlockImage() {
        return true;
    }

    @Override
    public void selectNnearest(int n, int n2) {
        if (n == 2) {
            return;
        }
        Iterator iterator = this.selectionList.iterator();
        LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
        AxisRange axisRange = this.getRange(0, 0);
        AxisRange axisRange2 = this.getRange(1, 0);
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0};
        double d = axisRange.getAbs();
        double d2 = axisRange2.getAbs();
        SortItems sortItems = new SortItems();
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = (ZoneLeaf)iterator.next();
            double d3 = zoneLeaf.getValue((byte)0);
            double d4 = zoneLeaf.getValue((byte)1);
            LinkedList<ZoneLeaf> linkedList2 = null;
            for (int i = 1; i <= 10; ++i) {
                double d5 = d * (double)i * (double)i * 0.01;
                double d6 = d2 * (double)i * (double)i * 0.01;
                dArray[0] = d3 - d5;
                dArray[1] = d4 - d6;
                dArray2[0] = d3 + d5;
                dArray2[1] = d4 + d6;
                linkedList2 = this.plotGround.collectRectangleFromData(dArray, dArray2, true);
                if (linkedList2.size() > n2 * 2) break;
            }
            sortItems.setLeaf(zoneLeaf);
            Collections.sort(linkedList2, sortItems);
            Iterator iterator2 = linkedList2.iterator();
            int n3 = 0;
            while (iterator2.hasNext() && n3 < n2) {
                ZoneLeaf zoneLeaf2 = (ZoneLeaf)iterator2.next();
                if (zoneLeaf2.isSelected()) continue;
                ++n3;
                linkedList.add(zoneLeaf2);
                zoneLeaf2.setSelected(true);
            }
        }
        if (n == 0) {
            this.selectedItems(this.selectionList, false, true);
        }
        this.selectionList.addAll(linkedList);
        this.repaintPlot((byte)2);
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PlotScatter(0.0, 0.0, Color.white);
    }

    @Override
    protected float getBlackBorderSize() {
        return 1.0f;
    }

    @Override
    protected float getWhiteBorderSize() {
        return 0.0f;
    }

    @Override
    protected boolean hasInteractionContent() {
        if (this.quickLeaf.getPrimaryIndex() >= 0) {
            return true;
        }
        return super.hasInteractionContent();
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return true;
    }

    static class SortItems
    implements Comparator<ZoneLeaf> {
        private ZoneLeaf leaf;

        SortItems() {
        }

        @Override
        public int compare(ZoneLeaf zoneLeaf, ZoneLeaf zoneLeaf2) {
            double d = this.distSq(this.leaf, zoneLeaf);
            double d2 = this.distSq(this.leaf, zoneLeaf2);
            return Double.compare(d, d2);
        }

        public double distSq(ZoneLeaf zoneLeaf, ZoneLeaf zoneLeaf2) {
            double d = zoneLeaf.getValue((byte)0);
            double d2 = zoneLeaf.getValue((byte)1);
            double d3 = zoneLeaf2.getValue((byte)0);
            double d4 = zoneLeaf2.getValue((byte)1);
            double d5 = d - d3;
            double d6 = d2 - d4;
            return d5 * d5 + d6 * d6;
        }

        public void setLeaf(ZoneLeaf zoneLeaf) {
            this.leaf = zoneLeaf;
        }
    }

    private class PlotScatter
    extends FloatWindowPlot2D.PlotGrid {
        public PlotScatter(double d, double d2, Color color) {
            super(color, d, d2);
        }

        private List<ScatterLayer> getMainLayers() {
            ArrayList<ScatterLayer> arrayList = new ArrayList<ScatterLayer>();
            int n = FloatWindowScatter.this.plotAxisLayerPanel.getMainLayerCount();
            if (FloatWindowScatter.this.paintReverse) {
                for (int i = n - 1; i >= 0; --i) {
                    arrayList.add((ScatterLayer)FloatWindowScatter.this.plotAxisLayerPanel.getMainLayer(i));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    arrayList.add((ScatterLayer)FloatWindowScatter.this.plotAxisLayerPanel.getMainLayer(i));
                }
            }
            return arrayList;
        }

        private List<ScatterLayer> getLayers() {
            ArrayList<ScatterLayer> arrayList = new ArrayList<ScatterLayer>();
            int n = FloatWindowScatter.this.plotAxisLayerPanel.getLayerCount();
            if (FloatWindowScatter.this.paintReverse) {
                for (int i = n - 1; i >= 0; --i) {
                    arrayList.add((ScatterLayer)FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(i));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    arrayList.add((ScatterLayer)FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(i));
                }
            }
            return arrayList;
        }

        @Override
        public ZoneLeaf getLeafAt(Point point) {
            return FloatWindowScatter.this.getLeaf(point.x, point.y, true);
        }

        @Override
        public boolean hasLeafAt(Point point) {
            return FloatWindowScatter.this.getLeaf(point.x, point.y, false) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            if (this.isYvsYcalc() && !this.shouldUpdateYvsYcalc()) {
                return;
            }
            this.resolveResourceNode();
            if ((by & 1) == 1) {
                super.paint(graphics2D, by, d);
                PlotImages.setBorderColor(FloatWindowScatter.this.getObjectBorderColor());
            } else if ((by & 2) == 2 && FloatWindowScatter.this.selectionList.isEmpty()) {
                return;
            }
            if (FloatWindowScatter.this.hasVisibleLayer()) {
                Object object;
                Object object2;
                boolean bl = (by & 1) == 1;
                boolean bl2 = (by & 2) == 2;
                boolean bl3 = (by & 4) == 4;
                PlotImages.setBlockImage((int)FloatWindowScatter.this.getTryWidth(), (int)FloatWindowScatter.this.getTryHeight());
                AxisRange axisRange = FloatWindowScatter.this.getRange(0, 0);
                AxisRange axisRange2 = FloatWindowScatter.this.getRange(1, 0);
                boolean bl4 = FloatWindowScatter.this.showBorders();
                int n = FloatWindowScatter.this.plotAxisLayerPanel.getLayerCount();
                int[] nArray = new int[2];
                int[] nArray2 = new int[2];
                for (int i = 0; i < n; ++i) {
                    AbstractAxisLayer abstractAxisLayer = FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (abstractAxisLayer == null) continue;
                    abstractAxisLayer.beginCalculations();
                }
                if (bl) {
                    if ((by & 0x20) != 32) {
                        graphics2D.setClip(this.origoX, this.origoY, this.width, this.height);
                    }
                    for (ScatterLayer d6 : this.getLayers()) {
                        if (d6 == null || !d6.isLayerReady() || !d6.isShowLines() || !d6.isLayerVisible()) continue;
                        d6.beginLines(graphics2D);
                        object2 = d6.getLeafIterator();
                        object = null;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        while (object2.hasNext()) {
                            ZoneLeaf zoneLeaf = (ZoneLeaf)object2.next();
                            if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                            double d4 = zoneLeaf.getValue((byte)0);
                            double d5 = zoneLeaf.getValue((byte)1);
                            if (Double.isNaN(d5)) continue;
                            if (object == null) {
                                d2 = d4;
                                d3 = d5;
                            } else if (axisRange.isInside(d4, d2) && axisRange2.isInside(d5, d3)) {
                                this.translateToScreenInt(nArray, d4, d5, axisRange, axisRange2);
                                this.translateToScreenInt(nArray2, d2, d3, axisRange, axisRange2);
                                d6.drawLineNoSet(graphics2D, nArray[0], nArray[1], nArray2[0], nArray2[1]);
                                d2 = d4;
                                d3 = d5;
                            }
                            object = zoneLeaf;
                        }
                    }
                    graphics2D.setClip(null);
                }
                if (bl2) {
                    void var15_22;
                    PlotImages.incBlockIndex();
                    Color color = new Color(FloatWindowScatter.this.selectionColor.getRed(), FloatWindowScatter.this.selectionColor.getGreen(), FloatWindowScatter.this.selectionColor.getBlue(), 150);
                    boolean abstractAxisLayer = false;
                    while (var15_22 < FloatWindowScatter.this.selectionList.size()) {
                        object2 = (ZoneLeaf)FloatWindowScatter.this.selectionList.get((int)var15_22);
                        if (object2 != null) {
                            object = ((ZoneLeaf)object2).getLayer();
                            if (((ZoneLeaf)object2).isVisibleAndNotMissing() && ((AbstractAxisLayer)object).isLayerReady() && ((AbstractLayer)object).isLayerVisible()) {
                                this.paintLeaf(graphics2D, axisRange, axisRange2, (ZoneLeaf)object2, ((ZoneLeaf)object2).getValue((byte)0), ((ZoneLeaf)object2).getValue((byte)1), true, color, d, bl4);
                            }
                        }
                        ++var15_22;
                    }
                } else if (bl) {
                    this.paintLayers(graphics2D, d, true);
                    PlotImages.setBlockImage((int)FloatWindowScatter.this.getTryWidth(), (int)FloatWindowScatter.this.getTryHeight());
                    this.paintLayers(graphics2D, d, false);
                } else if (bl3) {
                    if ((by & 0x20) != 32) {
                        graphics2D.setClip(this.origoX, this.origoY, this.width, this.height);
                    }
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(stroke);
                    this.drawStatistic(graphics2D, d, false, by);
                    if (FloatWindowScatter.this.quickLeaf.getPrimaryIndex() >= 0) {
                        double d6 = FloatWindowScatter.this.quickLeaf.getValue((byte)0);
                        double d7 = FloatWindowScatter.this.quickLeaf.getValue((byte)1);
                        if (d6 != 0.0 && d7 != 0.0) {
                            Color color = new Color(0, 255, 255, 150);
                            this.paintLeaf(graphics2D, axisRange, axisRange2, FloatWindowScatter.this.quickLeaf, d6, d7, true, color, d, false);
                        }
                    }
                    graphics2D.setClip(null);
                }
                for (int i = 0; i < n; ++i) {
                    AbstractAxisLayer abstractAxisLayer = FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (abstractAxisLayer == null) continue;
                    abstractAxisLayer.endCalculations();
                }
            }
        }

        private boolean isYvsYcalc() {
            if (FloatWindowScatter.this.plotAxisLayerPanel.getLayerCount() == 2) {
                AbstractAxisLayer abstractAxisLayer = FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(0);
                AbstractAxisLayer abstractAxisLayer2 = FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(1);
                if (abstractAxisLayer != null && abstractAxisLayer2 != null && abstractAxisLayer.getPlotInit() != null && abstractAxisLayer2.getPlotInit() != null && abstractAxisLayer.getPlotInit().plotSettings.contains("ycalc") && abstractAxisLayer2.getPlotInit().plotSettings.contains("ycalc")) {
                    return true;
                }
            }
            return false;
        }

        private final void paintLayers(Graphics2D graphics2D, double d, boolean bl) {
            AxisRange axisRange = FloatWindowScatter.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowScatter.this.getRange(1, 0);
            boolean bl2 = FloatWindowScatter.this.showBorders();
            for (ScatterLayer scatterLayer : this.getMainLayers()) {
                if (!scatterLayer.isLayerReady()) continue;
                InnerColumnBoolean innerColumnBoolean = FloatWindowScatter.this.getIncludeColumn(scatterLayer);
                if (bl && innerColumnBoolean == null) continue;
                graphics2D.setFont(scatterLayer.getDescriptionFont());
                scatterLayer.beginCalculations();
                ComboBoxAxis comboBoxAxis = (ComboBoxAxis)scatterLayer.getSettingsBoxMap().get((byte)0);
                ComboBoxAxis comboBoxAxis2 = (ComboBoxAxis)scatterLayer.getSettingsBoxMap().get((byte)1);
                AbstractDataMatrix abstractDataMatrix = comboBoxAxis.getMatrix();
                AbstractDataMatrix abstractDataMatrix2 = comboBoxAxis2.getMatrix();
                int n = comboBoxAxis.getSelectedType();
                int n2 = comboBoxAxis2.getSelectedType();
                int n3 = comboBoxAxis.getAxisIndex();
                int n4 = comboBoxAxis2.getAxisIndex();
                boolean bl3 = comboBoxAxis.getObservationTag();
                boolean bl4 = comboBoxAxis2.getObservationTag();
                boolean bl5 = abstractDataMatrix == abstractDataMatrix2 && bl3 == bl4;
                PlotImages.incBlockIndex();
                AbstractAxisLayer abstractAxisLayer = scatterLayer;
                List<ZoneLeaf> list = scatterLayer.getRootList();
                for (int i = 0; i < list.size(); ++i) {
                    double d2;
                    double d3;
                    ZoneLeaf zoneLeaf = list.get(i);
                    int n5 = zoneLeaf.getPrimaryIndex();
                    if (bl) {
                        zoneLeaf.setExcluded(innerColumnBoolean != null && !innerColumnBoolean.getValueBool(n5));
                        if (!zoneLeaf.isExcluded()) {
                            continue;
                        }
                    } else if (zoneLeaf.isExcluded()) continue;
                    if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                    if (abstractAxisLayer != zoneLeaf.getLayer() && zoneLeaf.getLayer().isLayerReady()) {
                        abstractAxisLayer = zoneLeaf.getLayer();
                        graphics2D.setFont(abstractAxisLayer.getDescriptionFont());
                    }
                    if (!abstractAxisLayer.isLayerVisible()) continue;
                    if (bl5) {
                        int n6 = bl3 ? abstractDataMatrix.getNrefOrig(n5) : abstractDataMatrix.getKrefOrig(n5);
                        d3 = FloatWindowScatter.getLeafValueOrigIndex(n6, abstractDataMatrix, n, n3, bl3);
                        d2 = FloatWindowScatter.getLeafValueOrigIndex(n6, abstractDataMatrix2, n2, n4, bl4);
                    } else {
                        d3 = FloatWindowScatter.getLeafValue(n5, abstractDataMatrix, n, n3, bl3);
                        d2 = FloatWindowScatter.getLeafValue(n5, abstractDataMatrix2, n2, n4, bl4);
                    }
                    this.paintLeaf(graphics2D, axisRange, axisRange2, zoneLeaf, d3, d2, false, null, d, bl2);
                }
                scatterLayer.endCalculations();
            }
        }

        private final void paintLeaf(Graphics2D graphics2D, AxisRange axisRange, AxisRange axisRange2, ZoneLeaf zoneLeaf, double d, double d2, boolean bl, Color color, double d3, boolean bl2) {
            if (axisRange.isInside(d) && axisRange2.isInside(d2)) {
                this.translateToScreenInt(FloatWindowScatter.this.plotscreen, d, d2, axisRange, axisRange2);
                boolean bl3 = PlotImages.drawAccelerated(this.getResourceNode(zoneLeaf), graphics2D, zoneLeaf, FloatWindowScatter.this.plotscreen, d3, bl2);
                if (bl) {
                    if (bl3) {
                        PlotImages.drawSelection(graphics2D, zoneLeaf, FloatWindowScatter.this.plotscreen, d3, color, true);
                    }
                } else {
                    zoneLeaf.paintDescription(graphics2D, FloatWindowScatter.this.plotscreen[0], FloatWindowScatter.this.plotscreen[1], d3, FloatWindowScatter.this.axisColor);
                }
            }
        }

        private boolean shouldUpdateYvsYcalc() {
            AbstractAxisLayer abstractAxisLayer = FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(0);
            AbstractAxisLayer abstractAxisLayer2 = FloatWindowScatter.this.plotAxisLayerPanel.getLayerAtIndex(1);
            if (abstractAxisLayer != null && abstractAxisLayer2 != null) {
                Map<Byte, AbstractPlotSettingsBox> map = abstractAxisLayer.getSettingsBoxMap();
                Map<Byte, AbstractPlotSettingsBox> map2 = abstractAxisLayer2.getSettingsBoxMap();
                ComboBoxComponent comboBoxComponent = (ComboBoxComponent)map.get((byte)0);
                ComboBoxComponent comboBoxComponent2 = (ComboBoxComponent)map2.get((byte)0);
                return comboBoxComponent.shouldRefresh && comboBoxComponent2.shouldRefresh;
            }
            return false;
        }
    }
}

