/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.scatter;

import java.io.IOException;
import java.util.Map;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.plot2D.scatter.ScatterLayer;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComponent;

public class Scatter2D
extends AbstractPlotBaseWindow {
    public Scatter2D(Plot_GUI plot_GUI, PlotInit plotInit) {
        super(plot_GUI, plotInit);
        try {
            FloatWindowScatter floatWindowScatter = this.createWindow(plotInit);
            this.floatPlotWindow = floatWindowScatter;
            this.addWindow(this.floatPlotWindow, 0, 4);
            floatWindowScatter.setTitle(plotInit.title);
            floatWindowScatter.setLabel((byte)1, plotInit.axislable[1]);
            floatWindowScatter.setLabel((byte)0, plotInit.axislable[0]);
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public Scatter2D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.setUpComboBoxConnection();
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
        if (interactionInterface != this && this.floatPlotWindow instanceof InteractionInterface) {
            ((InteractionInterface)((Object)this.floatPlotWindow)).doQuickInteraction(interactionInterface, n, n2, n3, n4);
        }
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public void setUpComboBoxConnection() {
        PlotAxisLayerPanel plotAxisLayerPanel = (PlotAxisLayerPanel)this.getSettingsPanel();
        if (plotAxisLayerPanel.getLayerCount() == 2) {
            try {
                ScatterLayer scatterLayer = (ScatterLayer)plotAxisLayerPanel.getMainLayer(0);
                ScatterLayer scatterLayer2 = (ScatterLayer)plotAxisLayerPanel.getMainLayer(1);
                if (scatterLayer.getPlotInit().plotSettings.contains("ycalc") && scatterLayer2.getPlotInit().plotSettings.contains("ycalc")) {
                    Map<Byte, AbstractPlotSettingsBox> map = scatterLayer.getSettingsBoxMap();
                    Map<Byte, AbstractPlotSettingsBox> map2 = scatterLayer2.getSettingsBoxMap();
                    ComboBoxComponent comboBoxComponent = (ComboBoxComponent)map.get((byte)0);
                    ComboBoxComponent comboBoxComponent2 = (ComboBoxComponent)map2.get((byte)0);
                    comboBoxComponent.setOtherComponentBox(comboBoxComponent2, true);
                    comboBoxComponent2.setOtherComponentBox(comboBoxComponent, false);
                    comboBoxComponent.setSelectedIndex(comboBoxComponent.getItemCount() - 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected FloatWindowScatter createWindow(PlotInit plotInit) {
        return new FloatWindowScatter(this, plotInit, 0.1, 0.1, 0.9, 0.9);
    }

    @Override
    protected String getDefaultTitle() {
        return "Scatter 2D";
    }

    @Override
    protected String getHelpID() {
        return "evinceScatter2d";
    }
}

