/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.scatter;

import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractDensityField;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.plot2D.DensityField2D;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxisModel;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComponent;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;
import se.prediktera.map.plot.axisplot.settings.ComboBoxLines;
import se.prediktera.map.plot.axisplot.settings.ComboBoxShape;
import se.prediktera.map.plot.axisplot.settings.ComboBoxSize;
import se.prediktera.map.plot.axisplot.settings.ComboBoxStatistics;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class ScatterLayer
extends AbstractAxisLayer {
    private ComboBoxAxis boxXaxis;
    private ComboBoxAxis boxYaxis;
    private ComboBoxSize boxSize;
    private ComboBoxShape boxShape;
    private ComboBoxDescription boxLabel;
    private ComboBoxLines boxLines;
    private boolean showlines;

    public ScatterLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.showlines = false;
        this.layerName = this.isSubLayer() ? "Sub " + n : "Layer " + n;
        this.jbinit();
    }

    public ScatterLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("shl")) {
            this.showlines = mapProperty.getLVBoolean();
        }
        this.jbinit();
    }

    public void beginLines(Graphics2D graphics2D) {
        this.boxLines.getDrawLineStyle().beginDraw(graphics2D);
    }

    @Override
    public AbstractDensityField calcDensity() {
        return new DensityField2D(this);
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new ScatterLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.boxLines.getDrawLineStyle().drawLine(graphics2D, n, n2, n3, n4);
    }

    public void drawLineNoSet(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.boxLines.getDrawLineStyle().drawLineNoSet(graphics2D, n, n2, n3, n4);
    }

    @Override
    public Font getDescriptionFont() {
        return this.boxLabel.getLabelFont();
    }

    @Override
    public double[] getMinmax(int n) {
        Object object;
        if (this.isSubLayer() && (object = this.getMainLayer()) != null && object != this) {
            return ((AbstractAxisLayer)object).getMinmax(n);
        }
        object = n == 0 ? (Object)this.boxXaxis.getMinmax() : (Object)this.boxYaxis.getMinmax();
        return this.boxStatistics.adjustMinMax(n, (double[])object);
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public boolean isShowLines() {
        return this.showlines;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("shl", this.showlines);
    }

    @Override
    public void setShowLines(boolean bl) {
        this.showlines = bl;
    }

    @Override
    public String toString() {
        return this.layerName;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxXaxis = null;
        this.boxYaxis = null;
        this.boxSize = null;
        this.boxShape = null;
        this.boxLabel = null;
        this.boxLines = null;
        this.boxStatistics = null;
    }

    @Override
    protected void InitLayerChild() {
        PlotInit plotInit = this.getPlotInit();
        if (plotInit.plotSettings.contains("ycalc")) {
            this.boxXaxis = new ComboBoxComponent(this, 0);
        } else {
            this.boxXaxis = new ComboBoxAxis(this, 0);
            this.boxXaxis.addItem(new ComboItem(INDEXSTRING, 4));
            this.boxXaxis.addItem(new ComboItem(INDEXORIGSTRING, 27));
        }
        this.boxXaxis.addItem(new ComboItem(VALUESTRING, 0));
        this.boxXaxis.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxXaxis.getType(), this.boxXaxis);
        if (plotInit.plotSettings.contains("ycalc")) {
            this.boxYaxis = new ComboBoxAxisModel(this, 1);
            ((ComboBoxComponent)this.boxXaxis).setYAxisComboBox((ComboBoxAxisModel)this.boxYaxis);
        } else {
            this.boxYaxis = new ComboBoxAxis(this, 1);
            this.boxYaxis.addItem(new ComboItem(INDEXSTRING, 4));
            this.boxYaxis.addItem(new ComboItem(INDEXORIGSTRING, 27));
        }
        this.boxYaxis.addItem(new ComboItem(VALUESTRING, 0));
        this.boxYaxis.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxYaxis.getType(), this.boxYaxis);
        this.boxSize = new ComboBoxSize(this, 0);
        this.boxSize.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxSize.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxSize.addItem(new ComboItem(VALUESTRING, 0));
        this.boxSize.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxSize.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxSize.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxSize.getType(), this.boxSize);
        this.boxShape = new ComboBoxShape(this, 0);
        this.boxShape.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxShape.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxShape.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxShape.addItem(new ComboItem(DATAIMAGESTRING, 21));
        this.boxShape.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxShape.getType(), this.boxShape);
        this.boxLabel = new ComboBoxDescription(this, 0);
        this.boxLabel.addItem(new ComboItem(NONESTRING, 2));
        this.boxLabel.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxLabel.addItem(new ComboItem(DESCRIPTIONSTRING, 5));
        this.boxLabel.addItem(new ComboItem(VALUESTRING, 0));
        this.boxLabel.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxLabel.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxLabel.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxLabel.getType(), this.boxLabel);
        this.boxLines = new ComboBoxLines(this, 0);
        this.boxLines.addItem(new ComboItem(NONESTRING, 2));
        this.boxLines.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxLines.addItem(new ComboItem(VALUESTRING, 0));
        this.boxLines.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxLines.getType(), this.boxLines);
        this.boxStatistics = new ComboBoxStatistics(this, 0);
        this.boxStatistics.addItem(new ComboItem(NONESTRING, 2));
        this.settingsBoxMap.put(this.boxStatistics.getType(), this.boxStatistics);
    }

    private void jbinit() {
        if (this.isSubLayer()) {
            this.boxXaxis.setEnabled(false);
            this.boxYaxis.setEnabled(false);
        }
        PlotInit plotInit = this.getPlotInit();
        boolean bl = plotInit.plotSettings.contains("ycalc");
        this.add(SettingsBoxHelper.createAxisPanel(this.boxXaxis, bl, this.boxYaxis, null));
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createSizePanel(this.boxSize));
        this.add(SettingsBoxHelper.createShapePanel(this.boxShape));
        this.add(SettingsBoxHelper.createLabelPanel(this.boxLabel));
        this.add(SettingsBoxHelper.createLinesPanel(this.boxLines));
        this.add(SettingsBoxHelper.createStatisticsPanel(this.boxStatistics));
        this.add(SettingsBoxHelper.createCommentPanel(this.boxComment));
    }
}

