/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.scatter.intensity;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.WritableRaster;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractDensityField;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.scatter.intensity.IntensitySelection;
import se.prediktera.map.plot.spectral.AbstractPlotPanel;

public class IntensityHistogramPlot
extends AbstractPlotPanel {
    private final int[] histogram = new int[100];
    private double minThreshold = 0.0;
    private double maxThreshold = 100.0;
    private double min = 0.0;
    private double max = 0.0;
    private byte selected = 0;
    private final IntensitySelection selectionPanel;

    protected static double[] doBucketingAlgorithm(AbstractAxisPlot abstractAxisPlot, int[] nArray) {
        Object object;
        Object object2;
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        int n2 = abstractAxisPlot.getLayerCount();
        for (int i = 0; i < n2; ++i) {
            AbstractAxisLayer abstractAxisLayer = abstractAxisPlot.getLayer(i);
            AbstractDensityField abstractDensityField = abstractAxisLayer.calcDensity();
            object2 = abstractAxisLayer.getRootList();
            for (int j = 0; j < object2.size(); ++j) {
                object = (ZoneLeaf)object2.get(j);
                double d3 = abstractDensityField.getDensityAt((ZoneLeaf)object);
                if (bl) {
                    d = d3;
                    d2 = d3;
                    bl = false;
                    continue;
                }
                if (d > d3) {
                    d = d3;
                }
                if (!(d2 < d3)) continue;
                d2 = d3;
            }
        }
        double d4 = d2 - d;
        for (int i = 0; i < n2; ++i) {
            object2 = abstractAxisPlot.getLayer(i);
            AbstractDensityField abstractDensityField = ((AbstractAxisLayer)object2).calcDensity();
            object = ((AbstractAxisLayer)object2).getRootList();
            for (int j = 0; j < object.size(); ++j) {
                ZoneLeaf zoneLeaf = (ZoneLeaf)object.get(j);
                double d5 = abstractDensityField.getDensityAt(zoneLeaf);
                int n3 = (int)((d5 - d) / d4 * (double)nArray.length);
                if (n3 >= nArray.length) {
                    n3 = nArray.length - 1;
                }
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
                if (n >= nArray[n3]) continue;
                n = nArray[n3];
            }
        }
        return new double[]{d, d2, n};
    }

    public IntensityHistogramPlot(IntensitySelection intensitySelection) {
        this.selectionPanel = intensitySelection;
    }

    public void doBucketing(AbstractAxisPlot abstractAxisPlot) {
        double[] dArray = IntensityHistogramPlot.doBucketingAlgorithm(abstractAxisPlot, this.histogram);
        this.min = dArray[0];
        this.max = dArray[1];
        double d = dArray[2];
        this.setMinMax(0.0 - (double)this.histogram.length * 0.05, (double)this.histogram.length * 1.05, 0.0 - d * 0.05, d * 1.05, 1.0);
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public double getMaxThresholdReal() {
        return this.maxThreshold / 100.0 * (this.max - this.min) + this.min;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getMinThresholdReal() {
        return this.minThreshold / 100.0 * (this.max - this.min) + this.min;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.selected > 0) {
            Point point = mouseEvent.getPoint();
            double[] dArray = new double[2];
            this.Screen2Real(dArray, point.x, point.y);
            double d = (int)dArray[0];
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 100.0) {
                d = 100.0;
            }
            if (this.selected == 1) {
                this.minThreshold = d;
            } else {
                this.maxThreshold = d;
            }
            this.selectionPanel.setThreshold(this.minThreshold, this.maxThreshold);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        Point point = mouseEvent.getPoint();
        double[] dArray = new double[2];
        this.Screen2Real(dArray, point.x, point.y);
        if (this.isInside(dArray[0], this.minThreshold) || this.isInside(dArray[0], this.maxThreshold)) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        Point point = mouseEvent.getPoint();
        double[] dArray = new double[2];
        this.Screen2Real(dArray, point.x, point.y);
        this.selected = this.isInside(dArray[0], this.minThreshold) ? (byte)1 : (this.isInside(dArray[0], this.maxThreshold) ? (byte)2 : (byte)0);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.red);
        graphics2D.setStroke(AbstractPaint.stroke2);
        double[] dArray = new double[2];
        this.Real2Screen(dArray, this.minThreshold, 0.0);
        graphics2D.drawLine((int)dArray[0], this.sy, (int)dArray[0], this.getHeight() - this.ey - 1);
        this.Real2Screen(dArray, this.maxThreshold, 0.0);
        graphics2D.drawLine((int)dArray[0], this.sy, (int)dArray[0], this.getHeight() - this.ey - 1);
    }

    public void setThreshold(double d, double d2) {
        this.minThreshold = d;
        this.maxThreshold = d2;
        this.repaint();
    }

    protected String getNoSpectraDesc() {
        return "No spectra(s) available";
    }

    @Override
    protected String getXaxisDesc() {
        return "Bins";
    }

    @Override
    protected String getYaxisDesc() {
        return "Frequency";
    }

    @Override
    protected void paint(WritableRaster writableRaster, Graphics2D graphics2D, int n, int n2, AbstractPlotPanel.ContentType contentType) {
        if (contentType.equals((Object)AbstractPlotPanel.ContentType.Base)) {
            graphics2D.setColor(Color.black);
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            this.Real2Screen(dArray2, 0.0, 0.0);
            this.Real2ScreenLength(dArray3, 1.0, 1.0);
            for (int i = 0; i < this.histogram.length; ++i) {
                this.Real2Screen(dArray, i, this.histogram[i]);
                graphics2D.fillRect((int)dArray[0], (int)dArray[1], (int)Math.ceil(dArray3[0]), (int)dArray2[1] - (int)dArray[1]);
            }
        }
    }

    private boolean isInside(double d, double d2) {
        return d > d2 - 1.0 && d < d2 + 1.0;
    }
}

