/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.scatter.intensity;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.selection.AbstractSelectionPage;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractDensityField;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.scatter.intensity.IntensityHistogramPlot;

public class IntensitySelection
extends AbstractSelectionPage {
    private final AbstractAxisPlot axisPlot;
    private final IntensityHistogramPlot histogramPlot;
    private final JTextFieldButtonUppDown minThresTextField = new JTextFieldButtonUppDown();
    private final JTextFieldButtonUppDown maxThresTextField = new JTextFieldButtonUppDown();

    public IntensitySelection(AbstractWindow abstractWindow, AbstractAxisPlot abstractAxisPlot) {
        super(abstractWindow);
        this.axisPlot = abstractAxisPlot;
        this.setLayout(new GridBagLayout());
        this.histogramPlot = new IntensityHistogramPlot(this);
        this.minThresTextField.setMinMax(0.0, 100.0);
        this.minThresTextField.setStepSize(1.0);
        this.minThresTextField.setNumber(0.0);
        this.maxThresTextField.setMinMax(0.0, 100.0);
        this.maxThresTextField.setStepSize(1.0);
        this.maxThresTextField.setNumber(100.0);
        this.minThresTextField.setNumberChangedInterface((n, d) -> this.histogramPlot.setThreshold(d, this.maxThresTextField.getNumber()));
        this.maxThresTextField.setNumberChangedInterface((n, d) -> this.histogramPlot.setThreshold(this.minThresTextField.getNumber(), d));
        this.add((Component)this.histogramPlot, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(6, 6, 0, 6), 0, 0));
        this.add((Component)new JLabel("Min value"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        this.add((Component)this.minThresTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 6), 0, 0));
        this.add((Component)new JLabel("Max value"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 6), 0, 0));
        this.add((Component)this.maxThresTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 6, 6), 0, 0));
    }

    @Override
    public void prepareInteraction() {
        double d = this.histogramPlot.getMinThresholdReal();
        double d2 = this.histogramPlot.getMaxThresholdReal();
        Project_GUI project_GUI = this.window.getProject_GUI();
        DataSet dataSet = this.axisPlot.getDataSet();
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        InteractionArray interactionArray = project_GUI.getInteractionArray(dataSet.getCase(), 1, observationInfo.getOriginalSize(), observationInfo.getGroupID());
        int n = this.axisPlot.getLayerCount();
        for (int i = 0; i < n; ++i) {
            AbstractAxisLayer abstractAxisLayer = this.axisPlot.getLayer(i);
            AbstractDensityField abstractDensityField = abstractAxisLayer.calcDensity();
            List<ZoneLeaf> list = abstractAxisLayer.getRootList();
            for (int j = 0; j < list.size(); ++j) {
                ZoneLeaf zoneLeaf = list.get(j);
                double d3 = abstractDensityField.getDensityAt(zoneLeaf);
                if (!(d3 >= d) || !(d3 <= d2)) continue;
                interactionArray.set(zoneLeaf.getPrimaryIndex());
            }
        }
    }

    public void setThreshold(double d, double d2) {
        this.minThresTextField.setNumber(d);
        this.maxThresTextField.setNumber(d2);
    }

    @Override
    protected void doSelection(int n) {
        this.window.getProject_GUI().doInteraction(this);
    }

    @Override
    protected void initPage(AbstractWindow abstractWindow) {
        this.histogramPlot.doBucketing(this.axisPlot);
        this.histogramPlot.contentPaint();
    }
}

