/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.scatter.statistic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.FloatWindowHistogram;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.HistogramClass;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public class HistogramStatisticsInfo
extends AbstractStatisticsInfo {
    private final int[] screenmin = new int[2];
    private final int[] screenmax = new int[2];

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return null;
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (abstractAxisPlot instanceof FloatWindowHistogram) {
            FloatWindowHistogram floatWindowHistogram = (FloatWindowHistogram)abstractAxisPlot;
            AxisRange axisRange = floatWindowHistogram.getRange(0, 0);
            AxisRange axisRange2 = floatWindowHistogram.getRange(1, 0);
            floatWindowHistogram.translateToScreenInt(this.screenmin, axisRange.getMin(), axisRange2.getMin());
            floatWindowHistogram.translateToScreenInt(this.screenmax, axisRange2.getMin(), axisRange2.getMax());
            Font font = graphics2D.getFont();
            ArrayList<HistogramClass> arrayList = floatWindowHistogram.getHistogramClassList();
            if (arrayList.size() > 0) {
                HistogramClass histogramClass = arrayList.get(0);
                Color color = graphics2D.getColor();
                graphics2D.setColor(abstractAxisPlot.getAxisColor());
                graphics2D.setFont(new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * d2 * 0.5)));
                double d3 = d2 * 0.015;
                int n2 = 0;
                graphics2D.drawString("Number = " + NiceDataFormat.toString(histogramClass.getNumber(), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (0.1 + d3 * (double)n2++)));
                graphics2D.drawString("Min = " + NiceDataFormat.toString(histogramClass.getMin(), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (0.1 + d3 * (double)n2++)));
                graphics2D.drawString("Max = " + NiceDataFormat.toString(histogramClass.getMax(), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (0.1 + d3 * (double)n2++)));
                graphics2D.drawString("Mean = " + NiceDataFormat.toString(histogramClass.getMean(), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (0.1 + d3 * (double)n2++)));
                graphics2D.drawString("Median = " + NiceDataFormat.toString(histogramClass.getMedian(), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (0.1 + d3 * (double)n2++)));
                graphics2D.drawString("Std = " + NiceDataFormat.toString(histogramClass.getSd(), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (0.1 + d3 * (double)n2++)));
                graphics2D.drawString("Skew = " + NiceDataFormat.toString(histogramClass.getSkew(), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (0.1 + d3 * (double)n2++)));
                graphics2D.setFont(font);
                graphics2D.setColor(color);
            }
        }
    }

    @Override
    public void drawInBg(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return dataTreeInterface instanceof FloatWindowHistogram;
    }

    @Override
    public String toNiceString() {
        return "Histogram Statistics";
    }

    public String toString() {
        return "[HISTOGRAM STATISTICS]";
    }

    @Override
    protected int getType() {
        return 31;
    }
}

