/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.scatter.statistic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JCheckBox;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;

public class RegressionStatisticsInfo
extends AbstractStatisticsInfo {
    private static final double CONVCRITSQ = 1.0E-12;
    private static final int NITMAX = 200;
    private double k;
    private double m;
    private double r2;
    private double rmse;
    private final int[] screenmin = new int[2];
    private final int[] screenmax = new int[2];
    private boolean showstatistics = false;

    @Override
    public void setProperties(Properties properties) {
        try {
            if (ScriptHelper.hasKey(properties, "showstatistics")) {
                this.showstatistics = ScriptHelper.getPropertyBool(properties, "showstatistics");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Iterator<ZoneLeaf> iterator = abstractAxisLayer.getLeafIterator();
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = iterator.next();
            double d5 = zoneLeaf.getValue((byte)0);
            double d6 = zoneLeaf.getValue((byte)1);
            d2 += d5;
            d3 += d6;
            d4 += 1.0;
        }
        d2 /= d4;
        d3 /= d4;
        double d7 = 0.0;
        double d8 = 0.0;
        iterator = abstractAxisLayer.getLeafIterator();
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = iterator.next();
            double d9 = zoneLeaf.getValue((byte)0);
            double d10 = zoneLeaf.getValue((byte)1);
            d = d9 - d2;
            d7 += d * (d10 - d3);
            d8 += d * d;
        }
        this.k = d7 / d8;
        this.m = d3 - this.k * d2;
        double d11 = 0.0;
        double d12 = 0.0;
        iterator = abstractAxisLayer.getLeafIterator();
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = iterator.next();
            d = zoneLeaf.getValue((byte)0);
            double d13 = zoneLeaf.getValue((byte)1);
            d11 += (d13 - d3) * (d13 - d3);
            double d14 = this.k * d + this.m;
            d12 += (d13 - d14) * (d13 - d14);
        }
        this.r2 = 1.0 - d12 / d11;
        this.rmse = Math.sqrt(d12 / d4);
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return new RegressionSettingsPanel();
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (abstractAxisPlot instanceof FloatWindowScatter) {
            FloatWindowScatter floatWindowScatter = (FloatWindowScatter)abstractAxisPlot;
            Color color = graphics2D.getColor();
            graphics2D.setColor(abstractAxisPlot.getAxisColor());
            AxisRange axisRange = floatWindowScatter.getRange(0, 0);
            double d3 = axisRange.getMin();
            double d4 = axisRange.getMax();
            double d5 = this.k * d3 + this.m;
            double d6 = this.k * d4 + this.m;
            floatWindowScatter.translateToScreenInt(this.screenmin, d3, d5);
            floatWindowScatter.translateToScreenInt(this.screenmax, d4, d6);
            graphics2D.setStroke(AbstractPaint.stroke2);
            graphics2D.setColor(abstractAxisPlot.getAxisColor());
            graphics2D.drawLine(this.screenmin[0], this.screenmin[1], this.screenmax[0], this.screenmax[1]);
            if (this.showstatistics) {
                AxisRange axisRange2 = floatWindowScatter.getRange(1, 0);
                floatWindowScatter.translateToScreenInt(this.screenmin, d3, axisRange2.getMin());
                floatWindowScatter.translateToScreenInt(this.screenmax, d4, axisRange2.getMax());
                Font font = graphics2D.getFont();
                graphics2D.setFont(new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * d2 * 0.6)));
                double d7 = 0.05;
                AbstractModel abstractModel = floatWindowScatter.getPlotLayout().getModel();
                if (abstractModel != null) {
                    ModelMatrix modelMatrix;
                    ModelMatrix modelMatrix2;
                    AbstractDataMatrix abstractDataMatrix2;
                    AbstractPrediction abstractPrediction;
                    int n2 = abstractAxisPlot.getLayer(0).getComboBox((byte)1).getAxisIndex();
                    int n3 = abstractModel.getComponentsInt();
                    graphics2D.drawString("Components = " + n3, (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    ModelMatrix modelMatrix3 = (ModelMatrix)abstractModel.getMatrixByName("rmse_var");
                    if (modelMatrix3 != null) {
                        graphics2D.drawString("RMSEC = " + NiceDataFormat.toString(modelMatrix3.getValue(n3 - 1, n2), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    } else {
                        graphics2D.drawString("RMSEC = " + NiceDataFormat.toString(this.rmse, 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    }
                    ModelMatrix modelMatrix4 = (ModelMatrix)abstractModel.getMatrixByName("rmsecv_var");
                    if (modelMatrix4 != null && modelMatrix4.isVisibleInTree()) {
                        graphics2D.drawString("RMSECV = " + NiceDataFormat.toString(modelMatrix4.getValue(n3 - 1, n2), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    }
                    if ((abstractPrediction = abstractModel.getLocalPredictionNode()) != null && (abstractDataMatrix2 = abstractPrediction.getMatrixByName("RMSEP_var")) != null && abstractDataMatrix2.isVisibleInTree()) {
                        graphics2D.drawString("RMSEP = " + NiceDataFormat.toString(abstractDataMatrix2.getValue(n3 - 1, n2), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    }
                    if ((abstractDataMatrix2 = (ModelMatrix)abstractModel.getMatrixByName("r2y_var_cum")) != null) {
                        graphics2D.drawString("R^2 = " + NiceDataFormat.toString(((ModelMatrix)abstractDataMatrix2).getValue(n3 - 1, n2), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    }
                    if ((modelMatrix2 = (ModelMatrix)abstractModel.getMatrixByName("q2y_var_cum")) != null) {
                        graphics2D.drawString("Q^2 = " + NiceDataFormat.toString(modelMatrix2.getValue(n3 - 1, n2), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    }
                    if (abstractPrediction != null && (modelMatrix = (ModelMatrix)abstractPrediction.getMatrixByName("R2YP_var_cum")) != null && modelMatrix.isVisibleInTree()) {
                        graphics2D.drawString("R^2 Test = " + NiceDataFormat.toString(modelMatrix.getValue(n3 - 1, n2), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    }
                } else {
                    graphics2D.drawString("Y = " + NiceDataFormat.toString(this.k, 5) + "X" + (this.m < 0.0 ? " - " : " + ") + NiceDataFormat.toString(Math.abs(this.m), 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    graphics2D.drawString("R^2 = " + NiceDataFormat.toString(this.r2, 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                    graphics2D.drawString("RMSE = " + NiceDataFormat.toString(this.rmse, 5), (int)((double)this.screenmin[0] * 1.1), (int)((double)this.screenmin[1] * (d7 += 0.05)));
                }
                graphics2D.setFont(font);
            }
            graphics2D.setColor(color);
        }
    }

    @Override
    public void drawInBg(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (abstractAxisPlot instanceof FloatWindowScatter) {
            FloatWindowScatter floatWindowScatter = (FloatWindowScatter)abstractAxisPlot;
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.black);
            AxisRange axisRange = floatWindowScatter.getRange(0, 0);
            double d3 = axisRange.getMin();
            double d4 = axisRange.getMax();
            floatWindowScatter.translateToScreenInt(this.screenmin, d3, d3);
            floatWindowScatter.translateToScreenInt(this.screenmax, d4, d4);
            graphics2D.setStroke(AbstractPaint.dashed);
            graphics2D.setColor(Color.darkGray);
            graphics2D.drawLine(this.screenmin[0], this.screenmin[1], this.screenmax[0], this.screenmax[1]);
            graphics2D.setColor(color);
        }
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
        this.k = mapProperty.getPropertyDouble("k");
        this.m = mapProperty.getPropertyDouble("m");
        this.showstatistics = mapProperty.getPropertyBoolean("showstat", false);
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyDouble("k", this.k);
        randomOutputStream.writePropertyDouble("m", this.m);
        randomOutputStream.writePropertyBoolean("showstat", this.showstatistics);
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return dataTreeInterface instanceof FloatWindowScatter;
    }

    @Override
    public String toNiceString() {
        return "Linear Regression";
    }

    public String toString() {
        return "[LINEAR REGRESSION]";
    }

    @Override
    protected int getType() {
        return 24;
    }

    private void calcRegressionWithPCA(AbstractAxisLayer abstractAxisLayer) {
        double d;
        Iterator<ZoneLeaf> iterator = abstractAxisLayer.getLeafIterator();
        int n = abstractAxisLayer.getListSize();
        DenseMatrix denseMatrix = new DenseMatrix(n, 2);
        int n2 = 0;
        this.xMean = 0.0;
        this.yMean = 0.0;
        iterator = abstractAxisLayer.getLeafIterator();
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = iterator.next();
            this.xMean += zoneLeaf.getValue((byte)0);
            this.yMean += zoneLeaf.getValue((byte)1);
            ++n2;
        }
        this.xMean /= (double)n2;
        this.yMean /= (double)n2;
        int n3 = 0;
        iterator = abstractAxisLayer.getLeafIterator();
        while (iterator.hasNext()) {
            ZoneLeaf zoneLeaf = iterator.next();
            double d2 = zoneLeaf.getValue((byte)0);
            double d3 = zoneLeaf.getValue((byte)1);
            denseMatrix.set(n3, 0, d2 - this.xMean);
            denseMatrix.set(n3, 1, d3 - this.yMean);
            ++n3;
        }
        int n4 = denseMatrix.numRows();
        DenseVector denseVector = new DenseVector(n4);
        for (int i = 0; i < n4; ++i) {
            denseVector.set(i, (denseMatrix.get(i, 0) + denseMatrix.get(i, 1)) / 2.0);
        }
        DenseVector denseVector2 = new DenseVector(n4);
        DenseVector denseVector3 = null;
        DenseVector denseVector4 = new DenseVector(denseMatrix.numColumns());
        int n5 = 0;
        for (double d4 = 42.0; n5 < 200 && d4 > 1.0E-12; d4 /= d, ++n5) {
            denseVector3 = denseVector2;
            denseVector2 = denseVector;
            denseVector = denseVector3;
            MatrixExtensions.transMult(denseVector4, (Matrix)denseMatrix, denseVector2);
            denseVector4.scale(1.0 / denseVector4.norm(Vector.Norm.Two));
            MatrixExtensions.mult(denseVector, (Matrix)denseMatrix, denseVector4);
            d4 = 0.0;
            double[] dArray = denseVector2.getData();
            double[] dArray2 = denseVector.getData();
            d = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < n4; ++i) {
                d5 = dArray2[i];
                d += d5 * d5;
                d4 += (d5 -= dArray[i]) * d5;
            }
        }
        double d6 = denseVector4.get(0);
        d = denseVector4.get(1);
        if (d6 < 0.0) {
            d6 *= -1.0;
            d *= -1.0;
        }
        if (d < 0.0) {
            d6 *= -1.0;
            d *= -1.0;
        }
        this.k = d / d6;
        this.m = this.yMean - this.k * this.xMean;
    }

    private class RegressionSettingsPanel
    extends AbstractSettingsPanel {
        public RegressionSettingsPanel() {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setText("Show linear regression statistics in plot");
            jCheckBox.setSelected(RegressionStatisticsInfo.this.showstatistics);
            jCheckBox.addItemListener(itemEvent -> {
                regressionStatisticsInfo.showstatistics = jCheckBox.isSelected();
            });
            this.northPanel.add((Component)jCheckBox, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

