/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie;

import java.awt.Font;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;

public abstract class AbstractSerieLayer
extends AbstractAxisLayer {
    private static final Font labelFont = new Font("SansSerif", 0, 12);
    protected AbstractPlotSettingsBox boxAxis;
    private boolean showlines;

    public AbstractSerieLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n, String string) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.layerName = string + " " + n;
        this.showlines = false;
    }

    public AbstractSerieLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public Font getDescriptionFont() {
        return labelFont;
    }

    public Font getLabelFont() {
        return this.getDescriptionFont();
    }

    @Override
    public double[] getMinmax(int n) {
        if (this.boxAxis != null) {
            return this.boxAxis.getMinmax();
        }
        return new double[]{1.0, -1.0};
    }

    @Override
    public byte getTreeType() {
        return 1;
    }

    public boolean isShowLines() {
        return this.showlines;
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        super.nodeReplaced(dataTreeEvent);
        DataTreeInterface dataTreeInterface = dataTreeEvent.getReplaceDataTreeInterface();
        if (dataTreeInterface != null) {
            this.layerName = dataTreeInterface.toString();
        }
    }

    @Override
    public void setShowLines(boolean bl) {
        this.showlines = bl;
    }

    @Override
    public String toString() {
        return this.layerName;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxAxis = null;
    }

    @Override
    protected void InitLayer() {
        AbstractDataMatrix abstractDataMatrix = this.getPlotInit().getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxColor.addItem(new ComboItem(VALUESTRING, 0));
        this.boxColor.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxColor.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxComment = new ComboBoxComment(abstractDataMatrix, this);
        this.boxComment.addItem(new ComboItem(NONESTRING, 2));
        this.boxComment.addItem(new ComboItem(CUSTOMSTRING, 1));
        this.boxComment.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxComment.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxComment.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxComment.getType(), this.boxComment);
        this.InitLayerChild();
    }
}

