/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.contribution;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.util.LinkedList;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;

public class ComboBoxAxisContribution
extends ComboBoxAxis {
    private ComboBoxAxis boxContribution;
    private ComboBoxAxis boxWeights1;
    private ComboBoxAxis boxWeights2;
    private final boolean isLeading;
    private final boolean isWeight;
    private final Dimension minimumSize = new Dimension(0, 0);

    public ComboBoxAxisContribution(AbstractAxisLayer abstractAxisLayer, byte by, boolean bl, boolean bl2, boolean bl3) {
        super(abstractAxisLayer, by);
        this.isLeading = bl;
        this.isWeight = bl2;
        this.indexWithDescription = bl3;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.axis == 2) {
            this.dragExit(null);
            return;
        }
        try {
            if (dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.imageFlavor) instanceof LinkedList) {
                LinkedList linkedList = (LinkedList)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.imageFlavor);
                if (linkedList.isEmpty() || linkedList.size() != 1 && linkedList.size() != 3) {
                    this.dragExit(null);
                    return;
                }
                Object object = linkedList.get(0);
                if (object instanceof ZoneArray) {
                    ZoneArray zoneArray = (ZoneArray)object;
                    if (zoneArray.getSelectedChildCount() != 1) {
                        return;
                    }
                    this.handleZoneArray(zoneArray);
                } else {
                    object = (ZoneLeaf)linkedList.get(0);
                    this.handleZoneLeaf((ZoneLeaf)object);
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        dropTargetDropEvent.rejectDrop();
        this.dragExit(null);
    }

    @Override
    public double getAxisValueDataIndex(int n, int n2) {
        if (this.isLeading) {
            double d = this.boxWeights1.getAxisValueDataIndex(n, n2);
            double d2 = super.getAxisValueDataIndex(n, n2);
            double d3 = this.boxContribution.getAxisValueDataIndex(n, n2);
            if (this.boxWeights2.getCurType() != 2) {
                double d4 = this.boxWeights2.getAxisValueDataIndex(n, n2);
                return Math.abs(d) * Math.abs(d4) * (d3 - d2);
            }
            return Math.abs(d) * (d3 - d2);
        }
        return super.getAxisValueDataIndex(n, n2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    @Override
    public byte getType() {
        if (this.isLeading) {
            return super.getType();
        }
        return this.isWeight ? (byte)14 : 11;
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        if (this.isLeading) {
            if (this.boxContribution != null) {
                this.boxContribution.setCreated(abstractWindow_GUI, bl);
            }
            if (this.boxWeights1 != null) {
                this.boxWeights1.setCreated(abstractWindow_GUI, bl);
            }
            if (this.boxWeights2 != null) {
                this.boxWeights2.setCreated(abstractWindow_GUI, bl);
                if (!bl) {
                    this.boxWeights2.setSelected(2, 0);
                }
            }
        }
        super.setCreated(abstractWindow_GUI, bl);
    }

    public void setOtherContributionBoxes(ComboBoxAxis comboBoxAxis, ComboBoxAxis comboBoxAxis2, ComboBoxAxis comboBoxAxis3) {
        this.boxWeights1 = comboBoxAxis;
        this.boxWeights2 = comboBoxAxis2;
        this.boxContribution = comboBoxAxis3;
    }

    @Override
    public void setSelectedChild() {
        if (this.isLeading) {
            super.setSelectedChild();
        } else {
            this.Calculate();
            this.boxContribution.calculateMinMaxMissing();
            if (!this.layer.isSubLayer()) {
                AbstractAxisPlot abstractAxisPlot = this.getAxisPlot();
                abstractAxisPlot.calculateAxisTicksGlobal(this.axis, true, true);
                abstractAxisPlot.repaintPlot((byte)7);
            }
        }
    }

    private int getComboBoxIndex(int n) {
        int[] nArray = this.matrix.getNref();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void handleZoneArray(ZoneArray zoneArray) {
        for (int i = 0; i < zoneArray.getNoChildren(); ++i) {
            if (!zoneArray.isSelected(i)) continue;
            int n = this.matrix.isFoldable() ? zoneArray.getPrimaryIndex(i) * this.matrix.getFoldN() + zoneArray.getSecondaryIndex() : zoneArray.getSecondaryIndex();
            int n2 = this.getComboBoxIndex(n);
            this.setSelectedItem(this.getItemAt(n2 + this.getMainItemCount()));
            return;
        }
    }

    private void handleZoneLeaf(ZoneLeaf zoneLeaf) {
        int n = zoneLeaf.getPrimaryIndex();
        int n2 = this.getComboBoxIndex(n);
        if (n2 != -1) {
            this.setSelectedItem(this.getItemAt(n2 + this.getMainItemCount()));
        }
    }
}

