/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.contribution;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.List;
import javax.swing.ImageIcon;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.PlotAxisLayerPanel;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.serie.contribution.ContributionLayer;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;

public class ContributionDragListener
implements DragSourceListener,
DragGestureListener {
    AbstractAxisPlot plot;
    private final DragSource dragSource;
    private final List<ZoneLeaf> selectionList;

    public ContributionDragListener(AbstractAxisPlot abstractAxisPlot, List<ZoneLeaf> list) {
        this.plot = abstractAxisPlot;
        this.selectionList = list;
        this.dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(abstractAxisPlot, 3, this);
        dragGestureRecognizer.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFEFFF);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.plot.getRubberband() == null) {
            return;
        }
        if (!this.plot.getClass().toString().contains("FloatWindowRgbImage") ? this.plot.getSelectedObjectCount() != 1 : this.plot.getSelectedObjectCount() != 3) {
            return;
        }
        if (!(this.plot.getRubberband() instanceof RubberbandNormal)) {
            return;
        }
        Project_GUI project_GUI = this.plot.getPlotGui().getProject_GUI();
        if (project_GUI != null) {
            Serializable serializable;
            AbstractLayerPanel abstractLayerPanel = project_GUI.getCurrentLayerPanel();
            if (abstractLayerPanel instanceof PlotAxisLayerPanel && !((serializable = (PlotAxisLayerPanel)abstractLayerPanel).getSelectedLayer() instanceof ContributionLayer)) {
                return;
            }
            serializable = new ContourNode(this.selectionList);
            this.dragSource.startDrag(dragGestureEvent, this.getCustomCursor(), (Transferable)((Object)serializable), this);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    private Cursor getCustomCursor() {
        BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        ImageIcon imageIcon = new ImageIcon(Main_GUI.class.getResource("cursor/normal.gif"));
        imageIcon.paintIcon(null, graphics2D, 0, 0);
        ImageIcon imageIcon2 = new ImageIcon(Main_GUI.class.getResource("gif/table.gif"));
        imageIcon2.paintIcon(null, graphics2D, bufferedImage.getWidth() - imageIcon2.getIconWidth() - 3, bufferedImage.getHeight() - imageIcon2.getIconHeight() - 3);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createCustomCursor(bufferedImage, new Point(0, 0), "Custom Drag");
    }

    public static class ContourNode
    implements Transferable,
    Serializable {
        private final List<ZoneLeaf> selList;

        ContourNode(List<ZoneLeaf> list) {
            this.selList = list;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            return this.selList;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return null;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return !dataFlavor.getRepresentationClass().getName().equals("datasetcontainer.TransferNode");
        }
    }
}

