/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.dendogram;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.FloatWindowDendogram;

public class Dendogram
extends AbstractPlotBaseWindow {
    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        new TestDendogram();
    }

    public Dendogram(Plot_GUI plot_GUI, PlotInit plotInit) {
        super(plot_GUI, plotInit);
        try {
            FloatWindowDendogram floatWindowDendogram = new FloatWindowDendogram(this, plotInit, 0.1, 0.1, 0.9, 0.9);
            this.floatPlotWindow = floatWindowDendogram;
            this.addWindow(this.floatPlotWindow, 0, 4);
            floatWindowDendogram.setTitle(plotInit.title);
            floatWindowDendogram.setLabel((byte)1, plotInit.axislable[1]);
            if (plotInit.axislable[0] == null || plotInit.axislable[0].length() == 0) {
                plotInit.axislable[0] = "Series";
            }
            floatWindowDendogram.setLabel((byte)0, plotInit.axislable[0]);
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
        }
    }

    public Dendogram(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    @Override
    protected String getDefaultTitle() {
        return "Dendrogram";
    }

    @Override
    protected String getHelpID() {
        return "evinceDendrogram";
    }

    public static class TestDendogram
    extends JFrame {
        Dendogram dendogram;
        JPanel contentPanel;

        public TestDendogram() {
            try {
                MVmatrix mVmatrix = new MVmatrix(100, 2);
                Random random = new Random(0L);
                for (int i = 0; i < 100; ++i) {
                    mVmatrix.setValue(i, 0, random.nextDouble());
                    mVmatrix.setValue(i, 1, random.nextDouble());
                }
                PlotInit plotInit = new PlotInit(mVmatrix);
                plotInit.axislable = new String[]{"", "", ""};
                Project_GUI project_GUI = new Project_GUI("", 0);
                this.dendogram = new Dendogram(project_GUI.getPlot_GUI(), plotInit);
                this.jbInit();
                this.setSize(500, 500);
                this.setVisible(true);
                this.dendogram.setCreated(project_GUI.getPlot_GUI(), false);
                this.setLocationRelativeTo(null);
                this.setDefaultCloseOperation(3);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }

        private void jbInit() throws Exception {
            this.contentPanel = (JPanel)this.getContentPane();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add((Component)this.dendogram, "Center");
        }
    }
}

