/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.dendogram;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.ZoneTree;
import se.prediktera.map.plot.axisplot.plot2D.serie.AbstractSerieLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.mst.ComboBoxMST;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.mst.ZoneMST;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class DendogramLayer
extends AbstractSerieLayer {
    private ComboBoxDescription boxDescription;

    public DendogramLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n) {
        super(abstractAxisPlot, plotInit, leafList, leafList2, n, "Series");
        this.jbinit();
    }

    public DendogramLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.jbinit();
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new DendogramLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    @Override
    public Font getLabelFont() {
        return this.boxDescription.getLabelFont();
    }

    public ZoneMST getLastNode() {
        return ((ComboBoxMST)this.boxAxis).getLastNode();
    }

    @Override
    public double[] getMinmax(int n) {
        if (this.boxAxis != null) {
            return this.boxAxis.getMinmax(n);
        }
        return new double[]{1.0, -1.0};
    }

    @Override
    public byte getTreeType() {
        return 7;
    }

    public void setLastNode(ZoneMST zoneMST) {
        ((ComboBoxMST)this.boxAxis).setLastNode(zoneMST);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxDescription = null;
    }

    @Override
    protected void InitLayerChild() {
        this.boxColor.setContinuesColor(new PlotContinuousColor("Fixed", Color.black));
        this.boxAxis = new ComboBoxMST(this, 1);
        this.boxAxis.addItem(new ComboItem("[MATRIX]", 10));
        this.settingsBoxMap.put(this.boxAxis.getType(), this.boxAxis);
        this.boxDescription = new ComboBoxDescription(this, 0);
        this.boxDescription.addItem(new ComboItem(NONESTRING, 2));
        this.boxDescription.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxDescription.addItem(new ComboItem(DESCRIPTIONSTRING, 5));
        this.boxDescription.addItem(new ComboItem(VALUESTRING, 0));
        this.boxDescription.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxDescription.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxDescription.addItem(new ComboItem("%SEPARATOR#", 3));
        this.boxDescription.setSelectedIndex(2);
        this.settingsBoxMap.put(this.boxDescription.getType(), this.boxDescription);
    }

    @Override
    protected void loadZoneList(RandomInputStream randomInputStream, byte by) throws IOException {
        this.zoneList = new LeafList();
        this.setLastNode(this.loadLeaf(randomInputStream));
    }

    @Override
    protected void saveZoneList(RandomOutputStream randomOutputStream) throws IOException {
        this.saveLeaf(randomOutputStream, this.getLastNode());
    }

    private void jbinit() {
        if (this.isSubLayer()) {
            this.boxAxis.setEnabled(false);
        }
        this.add(SettingsBoxHelper.createRangePanel((ComboBoxMST)this.boxAxis));
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createLabelPanel(this.boxDescription));
        this.add(SettingsBoxHelper.createCommentPanel(this.boxComment));
    }

    private ZoneMST loadLeaf(RandomInputStream randomInputStream) throws IOException {
        ZoneMST zoneMST;
        ZoneMST zoneMST2 = null;
        ZoneMST zoneMST3 = null;
        if (randomInputStream.ReadBlockBoolean()) {
            zoneMST2 = this.loadLeaf(randomInputStream);
        }
        if (randomInputStream.ReadBlockBoolean()) {
            zoneMST3 = this.loadLeaf(randomInputStream);
        }
        if ((zoneMST = new ZoneMST(randomInputStream, zoneMST2, zoneMST3)).isSelected() && !zoneMST.hasChildren()) {
            this.axisPlot.addToSelectionlist(zoneMST);
        }
        if (zoneMST2 == null && zoneMST3 == null) {
            this.zoneList.add(zoneMST);
        }
        return zoneMST;
    }

    private void saveLeaf(RandomOutputStream randomOutputStream, ZoneTree zoneTree) throws IOException {
        boolean bl = zoneTree.getLeft() != null;
        boolean bl2 = zoneTree.getRight() != null;
        randomOutputStream.WriteBlockBoolean(bl);
        if (bl) {
            this.saveLeaf(randomOutputStream, zoneTree.getLeft());
        }
        randomOutputStream.WriteBlockBoolean(bl2);
        if (bl2) {
            this.saveLeaf(randomOutputStream, zoneTree.getRight());
        }
        zoneTree.Save(randomOutputStream);
    }
}

