/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.dendogram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.AbstractFloatWindowSerie;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.DendogramLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.mst.ZoneMST;

public class FloatWindowDendogram
extends AbstractFloatWindowSerie {
    private int steplength;
    private int steppos;

    public FloatWindowDendogram(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.getRange(1, 0).setMinFactor(0.0);
    }

    public FloatWindowDendogram(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new DendogramLayer(this, plotInit, null, null, n);
    }

    @Override
    public int getHandWidth() {
        return 3;
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneMST zoneMST = (ZoneMST)this.getLeafAtIndex(abstractAxisLayer, n, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneMST != null && zoneMST.getType() == 0) {
            if (abstractAxisLayer != null) {
                stringBuilder.append(abstractAxisLayer).append("\n");
                String string = abstractAxisLayer.getComment(zoneMST);
                if (string != null) {
                    stringBuilder.append(string).append("\n");
                }
                stringBuilder.append("Descr: ").append(zoneMST.getDescription()).append("\n");
            }
            if (zoneMST.hasChildren()) {
                stringBuilder.append("Distance: ").append(NiceDataFormat.toString(zoneMST.getY())).append("\n");
            }
            stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneMST.getValue((byte)0))).append("\n");
            stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneMST.getValue((byte)1))).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public byte getTreeType() {
        return 9;
    }

    @Override
    public void translateToScreenInt(ZoneLeaf zoneLeaf, int[] nArray, int n) {
        this.plotGround.translateToScreenInt(nArray, ((ZoneMST)zoneLeaf).getX(), ((ZoneMST)zoneLeaf).getY(), n);
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PlotDendogram(0.0, 0.0, Color.white);
    }

    @Override
    protected FloatWindowPlot2D.PlotXaxis createXaxis() {
        PlotXserieAxis plotXserieAxis = new PlotXserieAxis(Color.white, 0.0, 0.15);
        plotXserieAxis.setMinHeight(75);
        return plotXserieAxis;
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf instanceof ZoneMST) {
            ZoneMST zoneMST = (ZoneMST)zoneLeaf;
            StringBuilder stringBuilder = new StringBuilder("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            AbstractAxisLayer abstractAxisLayer = zoneLeaf.getLayer();
            if (abstractAxisLayer != null) {
                stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer).append("</th></tr>");
                String string = abstractAxisLayer.getComment(zoneLeaf, "<br>");
                if (string != null) {
                    stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
                }
            }
            stringBuilder.append("<tr><td>Descr:</td><td>").append(zoneLeaf.getDescription()).append("</td></tr>");
            if (zoneMST.hasChildren()) {
                stringBuilder.append("<tr><td>Distance:</td><td>").append(NiceDataFormat.toString(zoneMST.getY())).append("</td></tr>");
            }
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
        double d2;
        double d3 = 0.0;
        this.textXaxisRelative = 1.0;
        graphics2D.setFont(this.AxisFont);
        graphics2D.setStroke(this.axisStroke);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (this.plotXaxis != null) {
            this.serieList.clear();
            int n = this.plotAxisLayerPanel.visibleLayers();
            if (n > 0) {
                double d4 = (double)this.plotGround.getWidth() / this.getRange(0, 0).getAbs();
                this.steppos = this.steplength = Math.max((int)(10.0 / d4), 1);
                int n2 = this.plotAxisLayerPanel.getLayerCount();
                d3 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    List<TickInfo> list;
                    DendogramLayer dendogramLayer = (DendogramLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (!dendogramLayer.isLayerVisible() || !dendogramLayer.isLayerReady()) continue;
                    ((PlotXserieAxis)this.plotXaxis).collectDescriptions(dendogramLayer.getLastNode());
                    List<TickInfo> list2 = list = this.getRange(1, 0).getTickList();
                    synchronized (list2) {
                        for (TickInfo tickInfo : list) {
                            double d5 = fontMetrics.stringWidth(tickInfo.text);
                            if (!(d3 < d5)) continue;
                            d3 = d5;
                        }
                        continue;
                    }
                }
                this.textXaxisRelative = d4 * 0.9 / (double)fontMetrics.getHeight();
                d2 = ((double)this.plotXaxis.getHeight() - 3.0 * d) * 0.9 / d3;
                if (this.textXaxisRelative > d2) {
                    this.textXaxisRelative = d2;
                }
                if (this.textXaxisRelative < 0.9) {
                    this.textXaxisRelative = 0.9;
                }
            }
        }
        this.textRelative = this.textXaxisRelative;
        if (this.plotYaxis != null) {
            List<TickInfo> list;
            d3 = 0.0;
            List<TickInfo> list3 = list = this.getRange(1, 0).getTickList();
            synchronized (list3) {
                for (TickInfo tickInfo : list) {
                    d2 = fontMetrics.stringWidth(tickInfo.text);
                    if (!(d3 < d2)) continue;
                    d3 = d2;
                }
            }
            double d6 = ((double)this.plotYaxis.getWidth() - 5.0 * d) * 0.97 / d3;
            if (this.textRelative > d6) {
                this.textRelative = d6;
            }
        }
        if (this.textRelative > d) {
            this.textRelative = d;
        }
        if (this.textRelative < 1.2) {
            this.textRelative = 1.2;
        }
    }

    private class PlotDendogram
    extends FloatWindowPlot2D.PlotGrid {
        public PlotDendogram(double d, double d2, Color color) {
            super(color, d, d2);
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            int n = FloatWindowDendogram.this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n; ++i) {
                DendogramLayer dendogramLayer = (DendogramLayer)FloatWindowDendogram.this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (!dendogramLayer.isLayerVisible() || !dendogramLayer.isLayerReady()) continue;
                this.addToCollection(linkedList, dArray, dArray2, dendogramLayer.getLastNode());
            }
            return linkedList;
        }

        public DrawNodeClass drawNode(Graphics2D graphics2D, byte by, ZoneMST zoneMST) {
            Color color = zoneMST.getColor();
            boolean bl = false;
            if (zoneMST.hasChildren()) {
                ZoneMST zoneMST2 = (ZoneMST)zoneMST.getLeft();
                ZoneMST zoneMST3 = (ZoneMST)zoneMST.getRight();
                DrawNodeClass drawNodeClass = this.drawNode(graphics2D, by, zoneMST2);
                DrawNodeClass drawNodeClass2 = this.drawNode(graphics2D, by, zoneMST3);
                boolean bl2 = bl = drawNodeClass.selected && drawNodeClass2.selected;
                if (drawNodeClass.color.equals(drawNodeClass2.color)) {
                    color = drawNodeClass.color;
                }
                BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, null, 0.0f);
                graphics2D.setStroke(basicStroke);
                double[] dArray = FloatWindowDendogram.this.plotGround.translateToScreenDouble(zoneMST2.getX(), zoneMST2.getY(), 0);
                double[] dArray2 = FloatWindowDendogram.this.plotGround.translateToScreenDouble(zoneMST3.getX(), zoneMST3.getY(), 0);
                if (bl) {
                    graphics2D.setColor(Color.orange);
                } else {
                    graphics2D.setColor(color);
                }
                double[] dArray3 = FloatWindowDendogram.this.plotGround.translateToScreenDouble(zoneMST.getX(), zoneMST.getY(), 0);
                graphics2D.setColor(Color.black);
                graphics2D.drawLine((int)dArray[0], (int)dArray3[1], (int)dArray2[0], (int)dArray3[1]);
                if (drawNodeClass.selected) {
                    graphics2D.setColor(Color.orange);
                } else {
                    graphics2D.setColor(drawNodeClass.color);
                }
                graphics2D.setColor(Color.black);
                graphics2D.drawLine((int)dArray[0], (int)dArray[1], (int)dArray[0], (int)dArray3[1]);
                if (drawNodeClass2.selected) {
                    graphics2D.setColor(Color.orange);
                } else {
                    graphics2D.setColor(drawNodeClass2.color);
                }
                graphics2D.setColor(Color.black);
                graphics2D.drawLine((int)dArray2[0], (int)dArray2[1], (int)dArray2[0], (int)dArray3[1]);
                drawNodeClass.color = color;
                drawNodeClass.selected = bl;
                return drawNodeClass;
            }
            return new DrawNodeClass(this, color, (by & 2) == 2 && zoneMST.isSelected());
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            if ((by & 1) == 1) {
                super.paint(graphics2D, by, d);
            } else if (FloatWindowDendogram.this.selectionList.isEmpty()) {
                return;
            }
            int n = FloatWindowDendogram.this.plotAxisLayerPanel.visibleMainLayers();
            if (n > 0) {
                AxisRange axisRange = FloatWindowDendogram.this.getRange(0, 0);
                AxisRange axisRange2 = FloatWindowDendogram.this.getRange(1, 0);
                int[] nArray = this.translateToScreenInt(axisRange.getMin(), axisRange2.getMin());
                int[] nArray2 = this.translateToScreenInt(axisRange.getMax(), axisRange2.getMax());
                graphics2D.setClip(nArray[0], nArray2[1], nArray2[0] - nArray[0], nArray[1] - nArray2[1]);
                graphics2D.setFont(FloatWindowDendogram.this.AxisFont);
                graphics2D.setStroke(FloatWindowDendogram.this.axisStroke);
                int n2 = FloatWindowDendogram.this.plotAxisLayerPanel.getMainLayerCount();
                for (int i = 0; i < n2; ++i) {
                    DendogramLayer dendogramLayer = (DendogramLayer)FloatWindowDendogram.this.plotAxisLayerPanel.getMainLayer(i);
                    if (!dendogramLayer.isLayerReady() || !dendogramLayer.isLayerVisible()) continue;
                    this.drawNode(graphics2D, by, dendogramLayer.getLastNode());
                }
                graphics2D.setColor(Color.black);
            }
        }

        private void addToCollection(LinkedList<ZoneLeaf> linkedList, double[] dArray, double[] dArray2, ZoneMST zoneMST) {
            float f = zoneMST.getX();
            float f2 = zoneMST.getY();
            if (dArray[1] > (double)f2) {
                return;
            }
            if (dArray[0] <= (double)f && dArray2[0] >= (double)f && dArray2[1] >= (double)f2) {
                this.addToCollection(linkedList, zoneMST);
                return;
            }
            if (zoneMST.getLeft() != null) {
                this.addToCollection(linkedList, dArray, dArray2, (ZoneMST)zoneMST.getLeft());
            }
            if (zoneMST.getRight() != null) {
                this.addToCollection(linkedList, dArray, dArray2, (ZoneMST)zoneMST.getRight());
            }
        }

        private void addToCollection(LinkedList<ZoneLeaf> linkedList, ZoneMST zoneMST) {
            if (zoneMST == null || !zoneMST.isVisible()) {
                return;
            }
            linkedList.add(zoneMST);
            if (zoneMST.getLeft() != null) {
                this.addToCollection(linkedList, (ZoneMST)zoneMST.getLeft());
            }
            if (zoneMST.getRight() != null) {
                this.addToCollection(linkedList, (ZoneMST)zoneMST.getRight());
            }
        }

        private class DrawNodeClass {
            public Color color;
            public boolean selected;

            public DrawNodeClass(PlotDendogram plotDendogram, Color color, boolean bl) {
                this.color = color;
                this.selected = bl;
            }
        }
    }

    protected class PlotXserieAxis
    extends FloatWindowPlot2D.PlotXaxis {
        public PlotXserieAxis(Color color, double d, double d2) {
            super(color, d, d2);
        }

        public void collectDescriptions(ZoneMST zoneMST) {
            if (zoneMST != null) {
                if (zoneMST.hasChildren()) {
                    this.collectDescriptions((ZoneMST)zoneMST.getLeft());
                    this.collectDescriptions((ZoneMST)zoneMST.getRight());
                } else if (++FloatWindowDendogram.this.steppos >= FloatWindowDendogram.this.steplength) {
                    double[] dArray = FloatWindowDendogram.this.plotGround.translateToScreenDouble(zoneMST.getX(), zoneMST.getY(), 0);
                    FloatWindowDendogram.this.serieList.add(new TickInfo(dArray[0], zoneMST.getDescription()));
                    FloatWindowDendogram.this.steppos = 0;
                }
            }
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            if (!FloatWindowDendogram.this.serieList.isEmpty()) {
                Iterator iterator = FloatWindowDendogram.this.serieList.iterator();
                if (FloatWindowDendogram.this.plotAxisLayerPanel.getLayerCount() > 0) {
                    graphics2D.setFont(((DendogramLayer)FloatWindowDendogram.this.plotAxisLayerPanel.getLayerAtIndex(0)).getLabelFont());
                } else {
                    graphics2D.setFont(FloatWindowDendogram.this.AxisFont);
                }
                graphics2D.setStroke(FloatWindowDendogram.this.axisStroke);
                Line2D.Double double_ = new Line2D.Double(0.0, (double)this.origoY + 3.0 * d, 0.0, this.origoY);
                while (iterator.hasNext()) {
                    TickInfo tickInfo = (TickInfo)iterator.next();
                    int n = (int)tickInfo.pos;
                    if (n <= FloatWindowDendogram.this.plotGround.getOrigoX() || n >= FloatWindowDendogram.this.plotGround.getOrigoX() + FloatWindowDendogram.this.plotGround.getWidth()) continue;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(n, 0);
                    graphics2D.setColor(FloatWindowDendogram.this.gridColor);
                    graphics2D.draw(double_);
                    graphics2D.setColor(FloatWindowDendogram.this.axisColor);
                    graphics2D.translate(0.0, (double)this.origoY + 5.0 * d);
                    graphics2D.rotate(1.5707963267948966);
                    graphics2D.drawString(tickInfo.text, 0, 0);
                    graphics2D.setTransform(affineTransform);
                }
                graphics2D.setPaint(Color.black);
            }
        }

        @Override
        public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        }
    }
}

