/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.mst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.mst.Points;
import se.prediktera.map.plot.axisplot.plot2D.serie.dendogram.mst.ZoneMST;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;

public class ComboBoxMST
extends ComboBoxRange {
    private ZoneMST lastNode;
    private int nbDrawingNodes;
    private final double[][] minmax = new double[2][2];

    private static final Points clustering(Vector<Points> vector, int n, Points points, Points points2, int n2, int n3) {
        Object object;
        Vector<Points> vector2 = new Vector<Points>();
        if (!points.isCluster() && !points2.isCluster()) {
            vector2.addElement(points);
            vector2.addElement(points2);
        } else {
            if (points.isCluster() && !points2.isCluster()) {
                vector2.addElement(points2);
                object = points.getClusterPoints().elements();
                while (object.hasMoreElements()) {
                    vector2.addElement((Points)object.nextElement());
                }
            }
            if (!points.isCluster() && points2.isCluster()) {
                vector2.addElement(points);
                object = points2.getClusterPoints().elements();
                while (object.hasMoreElements()) {
                    vector2.addElement((Points)object.nextElement());
                }
            }
            if (points.isCluster() && points2.isCluster()) {
                object = points.getClusterPoints().elements();
                while (object.hasMoreElements()) {
                    vector2.addElement((Points)object.nextElement());
                }
                Enumeration<Points> enumeration = points2.getClusterPoints().elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(enumeration.nextElement());
                }
            }
        }
        object = new Points(vector2, -n);
        if (n2 < n3) {
            vector.remove(n3);
            vector.remove(n2);
        } else {
            vector.remove(n2);
            vector.remove(n3);
        }
        vector.addElement((Points)object);
        return object;
    }

    public ComboBoxMST(AbstractAxisLayer abstractAxisLayer, byte by) {
        super(abstractAxisLayer.getPlotInit().getMatrix(by), abstractAxisLayer);
        this.axis = by;
    }

    @Override
    public void Calculate() {
        double d;
        Object object;
        int n;
        int n2;
        int n3;
        this.matrix.beginCalculations();
        int n4 = this.getMatrixColumnSize();
        LeafList leafList = this.layer.setZoneList(new LeafList(n4));
        Vector<Points> vector = new Vector<Points>(n4);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n5 = this.getCoordSizePrimary();
        for (n3 = 0; n3 < n5; ++n3) {
            if (!this.showMatrixColumn(n3)) continue;
            vector.add(new Points(n3));
        }
        n3 = vector.size();
        ArrayList<Edge> arrayList = new ArrayList<Edge>(n3 * n3 / 2);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3; ++n) {
                Points points = (Points)vector.elementAt(n);
                object = (Points)vector.elementAt(n2);
                d = this.minDistanceSquared(points, (Points)object);
                arrayList.add(new Edge(d, points, (Points)object));
            }
        }
        arrayList.trimToSize();
        Collections.sort(arrayList, (edge, edge2) -> {
            if (edge.dist < edge2.dist) {
                return 1;
            }
            if (edge.dist > edge2.dist) {
                return -1;
            }
            return 0;
        });
        int n6 = 1;
        d = 0.0;
        for (int i = n3; i >= 2; --i) {
            Object object2;
            Object object3;
            Object object4;
            boolean bl = false;
            block4: do {
                object = (Edge)arrayList.get(arrayList.size() - 1);
                arrayList.remove(arrayList.size() - 1);
                object4 = ((Edge)object).p1;
                object3 = ((Edge)object).p2;
                d = ((Edge)object).dist;
                for (int j = vector.size() - 1; j >= 0; --j) {
                    object2 = (Points)vector.get(j);
                    if (!((Points)object2).isCluster()) {
                        bl = true;
                        continue block4;
                    }
                    if (((Points)object2).contains((Points)object4)) {
                        object4 = object2;
                        boolean bl2 = bl = !((Points)object2).contains((Points)object3);
                        if (!bl) continue block4;
                        while (j >= 0 && ((Points)(object2 = (Points)vector.get(j))).isCluster()) {
                            if (((Points)object2).contains((Points)object3)) {
                                object3 = object2;
                                continue block4;
                            }
                            --j;
                        }
                    } else {
                        if (!((Points)object2).contains((Points)object3)) continue;
                        object3 = object2;
                        boolean bl3 = bl = !((Points)object2).contains((Points)object4);
                        if (!bl) continue block4;
                        while (j >= 0 && ((Points)(object2 = (Points)vector.get(j))).isCluster()) {
                            if (((Points)object2).contains((Points)object4)) {
                                object4 = object2;
                                continue block4;
                            }
                            --j;
                        }
                    }
                    continue block4;
                }
            } while (!bl && arrayList.size() > 0);
            n2 = vector.indexOf(object4);
            n = vector.indexOf(object3);
            ZoneMST zoneMST = (ZoneMST)hashtable.get(object4);
            if (zoneMST == null) {
                zoneMST = new ZoneMST(((Points)object4).getName(this), this.getReferenceIndexPrimary(((Points)object4).getIndex()), this.layer);
                leafList.add(zoneMST);
                this.layer.initLeaf(zoneMST);
                hashtable.put(object4, zoneMST);
            }
            if ((object2 = (ZoneMST)hashtable.get(object3)) == null) {
                object2 = new ZoneMST(((Points)object3).getName(this), this.getReferenceIndexPrimary(((Points)object3).getIndex()), this.layer);
                leafList.add(object2);
                this.layer.initLeaf((ZoneLeaf)object2);
                hashtable.put(object3, object2);
            }
            String string = "N" + n6;
            this.lastNode = new ZoneMST(zoneMST, (ZoneMST)object2, n6, string, (float)Math.sqrt(d), this.layer);
            hashtable.put(ComboBoxMST.clustering(vector, n6, (Points)object4, (Points)object3, n2, n), this.lastNode);
            ++n6;
        }
        this.minmax[0][0] = 0.0;
        this.minmax[0][1] = 0.0;
        this.minmax[1][0] = 0.0;
        this.minmax[1][1] = 0.0;
        this.nbDrawingNodes = 1;
        this.calculateTreeMinmax(this.lastNode);
        this.matrix.endCalculations();
    }

    public ZoneMST getLastNode() {
        return this.lastNode;
    }

    @Override
    public double[] getMinmax(int n) {
        if (n == 0) {
            return this.minmax[0];
        }
        return this.minmax[1];
    }

    @Override
    public boolean hasMultiUpdate() {
        return true;
    }

    @Override
    public void setAllCreated() {
        this.calculateMinMaxMissing();
    }

    public void setLastNode(ZoneMST zoneMST) {
        this.lastNode = zoneMST;
    }

    @Override
    public void updateCalculation(boolean bl) {
    }

    private void calculateTreeMinmax(ZoneMST zoneMST) {
        if (zoneMST != null) {
            float f;
            float f2 = zoneMST.getY();
            if (zoneMST.hasChildren()) {
                ZoneMST zoneMST2 = (ZoneMST)zoneMST.getLeft();
                ZoneMST zoneMST3 = (ZoneMST)zoneMST.getRight();
                this.calculateTreeMinmax(zoneMST2);
                ++this.nbDrawingNodes;
                this.calculateTreeMinmax(zoneMST3);
                f = (zoneMST2.getX() + zoneMST3.getX()) * 0.5f;
            } else {
                f = this.nbDrawingNodes;
                ++this.nbDrawingNodes;
            }
            zoneMST.setX(f);
            if (this.minmax[0][1] < (double)f) {
                this.minmax[0][1] = f;
            }
            if (this.minmax[1][1] < (double)f2) {
                this.minmax[1][1] = f2;
            }
        }
    }

    private final double euclidianDistanceSquared(Points points, Points points2) {
        double d = 0.0;
        int n = this.getCoordSizeSecondary();
        for (int i = 0; i < n; ++i) {
            if (!this.showMatrixRow(i)) continue;
            double d2 = this.getCoord(points.getIndex(), i) - this.getCoord(points2.getIndex(), i);
            d += d2 * d2;
        }
        return d;
    }

    private final double minDistanceSquared(Points points, Points points2) {
        if (!points.isCluster() && !points2.isCluster()) {
            return this.euclidianDistanceSquared(points, points2);
        }
        return 0.0;
    }

    private static class Edge {
        private final double dist;
        private final Points p1;
        private final Points p2;

        Edge(double d, Points points, Points points2) {
            this.dist = d;
            this.p1 = points;
            this.p2 = points2;
        }
    }
}

