/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.histogram;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.AbstractFloatWindowSerie;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.HistogramAccessorPanel;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.HistogramClass;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.HistogramLayer;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.settings.ComboBoxBins;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;

public class FloatWindowHistogram
extends AbstractFloatWindowSerie {
    private double maxinbin;
    private final double bucketratio = 1.0;
    private final boolean showpercent = false;
    private double[] minmaxX;
    private HistogramAccessorPanel histogramAccessorPanel;
    private final ArrayList<HistogramClass> histogramClassList = new ArrayList();
    private boolean calculateStatistics = true;

    private static final int countSelectionContent(ArrayList<ZoneLeaf> arrayList) {
        int n = 0;
        for (ZoneLeaf zoneLeaf : arrayList) {
            if (!zoneLeaf.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public FloatWindowHistogram(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.getRange(1, 0).setDoublePrecition(false);
        this.histogramAccessorPanel = new HistogramAccessorPanel(this, plotInit, null, null, 0, null, null);
        this.setAccessorPanel(this.histogramAccessorPanel);
    }

    public FloatWindowHistogram(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.histogramAccessorPanel = new HistogramAccessorPanel(this, this.getPlotInit(), null, null, 0, randomInputStream, mapProperty);
        this.setAccessorPanel(this.histogramAccessorPanel);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new HistogramLayer(this, plotInit, null, null, n);
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneLeaf zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2);
        int n3 = 0;
        ArrayList arrayList = null;
        for (HistogramClass object : this.histogramClassList) {
            for (n3 = 0; n3 < object.size() && ((arrayList = (ArrayList)object.get(n3)).isEmpty() || arrayList.get(0) != zoneLeaf); ++n3) {
                arrayList = null;
            }
        }
        if (arrayList == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneLeaf);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            stringBuilder.append("Bin: ").append(n3 + 1).append("\n");
            stringBuilder.append("Contains: ").append(arrayList.size()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY>");
        int n = this.selectionList.size();
        stringBuilder.append("<B>Plot - ").append(this.plot).append("</B>");
        stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        for (HistogramClass histogramClass : this.histogramClassList) {
            stringBuilder.append("<TR><TD></TD><TD></TD></TR>");
            stringBuilder.append("<TR><TD><b>Histogram:</b></TD><TD>").append(histogramClass.toString()).append("</TD></TR>");
            double d = histogramClass.getNumber();
            double d2 = Double.compare(d, 0.0) == 0 ? 0.0 : (double)(n * 1000) / d * 0.1;
            stringBuilder.append("<TR><TD>Objects:</TD><TD>").append(d).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Selected:</TD><TD>").append(n).append("</TD></TR>");
            if (this.minmaxX == null) continue;
            stringBuilder.append("<TR><TD>Percentile:</TD><TD>").append(NiceDataFormat.toString(d2)).append("%</TD></TR>");
            stringBuilder.append("<TR><TD><B>Statistics</B></TD><TD></TD></TR>");
            stringBuilder.append("<TR><TD>Min:</TD><TD>").append(NiceDataFormat.toString(this.minmaxX[0])).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Max:</TD><TD>").append(NiceDataFormat.toString(this.minmaxX[1])).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Mean:</TD><TD>").append(NiceDataFormat.toString(histogramClass.getMean())).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Median:</TD><TD>").append(NiceDataFormat.toString(histogramClass.getMedian())).append("</TD></TR>");
            stringBuilder.append("<TR><TD>SD:</TD><TD>").append(NiceDataFormat.toString(histogramClass.getSd())).append("</TD></TR>");
            stringBuilder.append("<TR><TD>Skew:</TD><TD>").append(NiceDataFormat.toString(histogramClass.getSkew())).append("</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        double[] dArray = new double[]{0.0, 0.0};
        if (this.plotAxisLayerPanel == null) {
            return dArray;
        }
        if (n == 0) {
            this.minmaxX = this.getMinmaxX();
            return this.minmaxX;
        }
        if (n == 1) {
            dArray[0] = 0.0;
            dArray[1] = this.maxinbin * 1.0;
        }
        return dArray;
    }

    public double[] getMinMaxHeight() {
        double[] dArray = new double[]{Double.MAX_VALUE, 0.0};
        for (HistogramClass histogramClass : this.histogramClassList) {
            for (ArrayList arrayList : histogramClass) {
                int n = arrayList.size();
                if ((double)n < dArray[0]) {
                    dArray[0] = n;
                }
                if (!((double)n > dArray[1])) continue;
                dArray[1] = n;
            }
        }
        return dArray;
    }

    @Override
    public byte getTreeType() {
        return 8;
    }

    @Override
    public void prepareInteraction() {
        int n = this.getPrimaryMatrixTag();
        int n2 = this.getSecondaryMatrixTag();
        int n3 = this.getGroupID();
        int n4 = this.getSize(n);
        int n5 = this.getSize(n2);
        byte by = this.getParentBaseWindow().getSelectionType();
        if (by == 3) {
            this.getInteractionArray(this.getInteractionRoot(n), n, 0, n3);
            this.getInteractionArray(this.getInteractionRoot(n2), n2, 0, n3);
            return;
        }
        InteractionArray interactionArray = this.getInteractionArray(this.getInteractionRoot(n), n, n4, n3);
        InteractionArray interactionArray2 = this.getInteractionArray(this.getInteractionRoot(n2), n2, n5, n3);
        if (by == 0) {
            for (ZoneLeaf zoneLeaf : this.selectionList) {
                if (!zoneLeaf.isSelected()) continue;
                interactionArray.set(zoneLeaf.getPrimaryIndex());
            }
            if (interactionArray2 != null) {
                for (int i = 0; i < this.plotAxisLayerPanel.getLayerCount(); ++i) {
                    HistogramLayer histogramLayer = (HistogramLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (histogramLayer.isSubLayer()) continue;
                    interactionArray2.set(histogramLayer.getAxisIndex(), true);
                }
            }
        } else if (by == 2) {
            for (int i = 0; i < this.plotAxisLayerPanel.getLayerCount(); ++i) {
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractAxisLayer.isSubLayer()) continue;
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    ZoneLeaf zoneLeaf = list.get(j);
                    if (zoneLeaf.isSelected()) continue;
                    interactionArray.set(zoneLeaf.getPrimaryIndex());
                }
            }
        } else {
            for (int i = 0; i < this.plotAxisLayerPanel.getLayerCount(); ++i) {
                AbstractAxisLayer abstractAxisLayer = this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractAxisLayer.isSubLayer()) continue;
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    interactionArray.set(list.get(j).getPrimaryIndex());
                }
            }
        }
        if (n == 1 && n3 != 0) {
            this.doInteractionGroup(interactionArray);
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        this.histogramAccessorPanel.SaveProperty(randomOutputStream);
    }

    public void setBuckets(int n) {
        this.histogramAccessorPanel.setBuckets(n);
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.histogramAccessorPanel.setCreated(abstractWindow_GUI, bl);
        if (bl) {
            this.minmaxX = this.getMinmaxX();
            this.repaintPlot((byte)7);
        }
    }

    @Override
    public void setInteractionFlag(byte by) {
        super.setInteractionFlag(by);
        this.calculateAxisTicks(0, true, false);
        this.calculateAxisTicks(1, true, true);
        this.contentPaint((byte)7);
    }

    public void setMinMax(double d, double d2) {
        this.histogramAccessorPanel.setMinMax(d, d2);
    }

    @Override
    protected void cleanUpChild() {
        if (this.histogramAccessorPanel != null) {
            this.histogramAccessorPanel.cleanUp();
        }
        this.clearHistogramList();
        super.cleanUpChild();
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PlotHistogram(0.0, 0.0, Color.white);
    }

    protected double[] getMinmaxX() {
        int n = this.getBins();
        double[] dArray = super.getMinmax(0, 0);
        int n2 = this.plotAxisLayerPanel.getLayerCount();
        int n3 = this.plotAxisLayerPanel.visibleLayers();
        this.clearHistogramList();
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                HistogramLayer serializable = (HistogramLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
                HistogramClass histogramClass = new HistogramClass(serializable, this.calculateStatistics);
                this.histogramClassList.add(histogramClass);
            }
        }
        if (this.histogramAccessorPanel != null) {
            ComboBoxBins comboBoxBins = this.histogramAccessorPanel.getBoxBins();
            if (comboBoxBins.hasManualRange()) {
                dArray[0] = comboBoxBins.getMinRange();
                dArray[1] = comboBoxBins.getMaxRange();
            } else {
                comboBoxBins.setMinRange(dArray[0]);
                comboBoxBins.setMaxRange(dArray[1]);
            }
        }
        this.maxinbin = 0.0;
        for (HistogramClass histogramClass : this.histogramClassList) {
            histogramClass.getMinmaxX(dArray, n);
            if (!(this.maxinbin < histogramClass.getMaxinbin())) continue;
            this.maxinbin = histogramClass.getMaxinbin();
        }
        return dArray;
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            int n = 0;
            ArrayList arrayList = null;
            for (HistogramClass serializable2 : this.histogramClassList) {
                for (n = 0; n < serializable2.size() && ((arrayList = (ArrayList)serializable2.get(n)).isEmpty() || arrayList.get(0) != zoneLeaf); ++n) {
                    arrayList = null;
                }
            }
            if (arrayList == null) {
                return null;
            }
            AbstractAxisLayer abstractAxisLayer = zoneLeaf.getLayer();
            StringBuilder stringBuilder = new StringBuilder(240);
            stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
            stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer).append("</th></tr>");
            String string = abstractAxisLayer.getComment(zoneLeaf, "<br>");
            if (string != null) {
                stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>Bin:</td><td>").append(n + 1).append("</td></tr>");
            stringBuilder.append("<tr><td>Contains:</td><td>").append(arrayList.size()).append("</td></tr>");
            stringBuilder.append("</table></html>");
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected void interactiveSelectionFinished(byte by) {
        if (by == 7) {
            this.calculateAxisTicks(0, true, false);
            this.calculateAxisTicks(1, true, true);
        }
        super.interactiveSelectionFinished(by);
    }

    @Override
    protected void setAutoTextX(String string) {
        super.setAutoTextX(this.getBins() + " Bins (" + string + ")");
    }

    private void clearHistogramList() {
        for (HistogramClass histogramClass : this.histogramClassList) {
            histogramClass.clear();
        }
        this.histogramClassList.clear();
    }

    public ArrayList<HistogramClass> getHistogramClassList() {
        return this.histogramClassList;
    }

    private int getBins() {
        return this.histogramAccessorPanel == null ? 1 : this.histogramAccessorPanel.getNumberBins();
    }

    public void setCalculateStatistics(boolean bl) {
        this.calculateStatistics = bl;
    }

    static /* synthetic */ int[][] access$302(FloatWindowHistogram floatWindowHistogram, int[][] nArray) {
        floatWindowHistogram.blockImage = nArray;
        return nArray;
    }

    private class PlotHistogram
    extends FloatWindowPlot2D.PlotGrid {
        public PlotHistogram(double d, double d2, Color color) {
            super(color, d, d2);
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            if (FloatWindowHistogram.this.histogramClassList != null) {
                int n = FloatWindowHistogram.this.histogramClassList.size();
                for (int i = 0; i < n; ++i) {
                    HistogramClass histogramClass = FloatWindowHistogram.this.histogramClassList.get(i);
                    double d = histogramClass.getBinsize();
                    for (int j = 0; j < histogramClass.size(); ++j) {
                        double d2;
                        ArrayList arrayList = (ArrayList)histogramClass.get(j);
                        if (arrayList.size() <= 0) continue;
                        double d3 = (double)j * d + FloatWindowHistogram.this.minmaxX[0] - d / 2.0;
                        double d4 = arrayList.size();
                        double d5 = d4 < 0.0 ? d4 : 0.0;
                        double d6 = d2 = d4 >= 0.0 ? d4 : 0.0;
                        if (!(dArray[0] <= d3 + d) || !(dArray2[0] >= d3) || !(dArray[1] <= d2) || !(dArray2[1] >= d5)) continue;
                        for (ZoneLeaf zoneLeaf : arrayList) {
                            if (!bl && zoneLeaf.isSelected()) continue;
                            linkedList.add(zoneLeaf);
                        }
                    }
                }
            }
            return linkedList;
        }

        @Override
        public ZoneLeaf getLeafAt(Point point) {
            int n;
            int n2 = FloatWindowHistogram.this.getHandWidth();
            int n3 = point.x - n2 / 2;
            LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(n3, n = point.y - n2 / 2, n2, n2, false, AbstractRubberband.RubberType.Normal);
            if (linkedList.isEmpty()) {
                return null;
            }
            return linkedList.get(0);
        }

        @Override
        public boolean hasLeafAt(Point point) {
            int n;
            int n2 = FloatWindowHistogram.this.getHandWidth();
            int n3 = point.x - n2 / 2;
            LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(n3, n = point.y - n2 / 2, n2, n2, false, AbstractRubberband.RubberType.Normal);
            return !linkedList.isEmpty();
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            int[] nArray = this.translateToScreenInt(0.0, 0.0);
            if ((by & 1) == 1) {
                super.paint(graphics2D, by, d);
            } else {
                if ((by & 4) == 4) {
                    if (FloatWindowHistogram.this.histogramClassList != null) {
                        graphics2D.setClip(null);
                        int n = FloatWindowHistogram.this.histogramClassList.size();
                        for (int i = 0; i < n; ++i) {
                            HistogramClass histogramClass = FloatWindowHistogram.this.histogramClassList.get(i);
                            HistogramLayer histogramLayer = histogramClass.getLayer();
                            if (!histogramLayer.hasStatistics()) continue;
                            histogramLayer.drawStatistics(graphics2D, 0.0, d);
                        }
                    }
                    return;
                }
                if (FloatWindowHistogram.this.selectionList.isEmpty()) {
                    return;
                }
            }
            double d2 = FloatWindowHistogram.this.getTryWidth();
            if (FloatWindowHistogram.this.blockImage == null || FloatWindowHistogram.this.blockImage.length != (int)d2) {
                FloatWindowHistogram.access$302(FloatWindowHistogram.this, new int[(int)d2][2]);
            }
            for (int i = 0; i < (int)d2; ++i) {
                ((FloatWindowHistogram)FloatWindowHistogram.this).blockImage[i][0] = nArray[1];
                ((FloatWindowHistogram)FloatWindowHistogram.this).blockImage[i][1] = nArray[1];
            }
            if (FloatWindowHistogram.this.histogramClassList != null && (by & 3) > 0) {
                AxisRange axisRange = FloatWindowHistogram.this.getRange(0, 0);
                AxisRange axisRange2 = FloatWindowHistogram.this.getRange(1, 0);
                int[] nArray2 = this.translateToScreenInt(axisRange.getMin(), axisRange2.getMin());
                int[] nArray3 = this.translateToScreenInt(axisRange.getMax(), axisRange2.getMax());
                graphics2D.setClip(nArray2[0], nArray3[1], nArray3[0] - nArray2[0], nArray2[1] - nArray3[1]);
                AbstractAxisLayer abstractAxisLayer = FloatWindowHistogram.this.plotAxisLayerPanel.getMainLayer(0);
                ComboBoxColor comboBoxColor = (ComboBoxColor)abstractAxisLayer.getSettingsBoxMap().get((byte)3);
                ContinuousColorInterface continuousColorInterface = comboBoxColor.getContinuesColor();
                int n = comboBoxColor.getSelectedType();
                double d3 = 0.0;
                double d4 = 0.0;
                double[] dArray = new double[2];
                double[] dArray2 = new double[2];
                int n2 = FloatWindowHistogram.this.histogramClassList.size();
                for (int i = 0; i < n2; ++i) {
                    HistogramClass histogramClass = FloatWindowHistogram.this.histogramClassList.get(i);
                    double d5 = histogramClass.getBinsize() / (double)n2;
                    for (int j = 0; j < histogramClass.size(); ++j) {
                        Serializable serializable;
                        ArrayList arrayList = (ArrayList)histogramClass.get(j);
                        if (arrayList.size() <= 0) continue;
                        int n3 = 0;
                        if ((by & 2) == 2 && (n3 = FloatWindowHistogram.countSelectionContent(arrayList)) == 0) continue;
                        ZoneLeaf zoneLeaf = (ZoneLeaf)arrayList.get(0);
                        Color color = zoneLeaf.getColor();
                        d3 = (double)(j * n2) * d5 + FloatWindowHistogram.this.minmaxX[0] + (double)i * d5 - (double)n2 * d5 / 2.0;
                        d4 = d3 + d5;
                        this.translateToScreenDouble(dArray, d3, 0.0, 0);
                        if ((by & 2) == 2) {
                            this.translateToScreenDouble(dArray2, d4, (double)n3 * 1.0, 0);
                        } else {
                            this.translateToScreenDouble(dArray2, d4, (double)arrayList.size() * 1.0, 0);
                            if (n == 4) {
                                int n4 = (int)((double)j / (double)histogramClass.size() * (double)continuousColorInterface.getNrColors());
                                color = continuousColorInterface.getColor(n4);
                            } else if (n == 7) {
                                CountRGBClass countRGBClass = null;
                                HashMap<Integer, CountRGBClass> hashMap = new HashMap<Integer, CountRGBClass>();
                                for (ZoneLeaf zoneLeaf2 : arrayList) {
                                    Color color2 = zoneLeaf2.getColor();
                                    serializable = color2.getRGB();
                                    CountRGBClass countRGBClass2 = (CountRGBClass)hashMap.get(serializable);
                                    if (countRGBClass2 == null) {
                                        countRGBClass2 = new CountRGBClass(color2);
                                        hashMap.put((Integer)serializable, countRGBClass2);
                                    }
                                    countRGBClass2.increase();
                                    if (countRGBClass != null && countRGBClass2.count <= countRGBClass.count) continue;
                                    countRGBClass = countRGBClass2;
                                }
                                color = countRGBClass.color;
                            }
                        }
                        double d6 = dArray2[0] - dArray[0];
                        double d7 = Math.abs((double)nArray[1] - dArray2[1]);
                        double d8 = dArray2[1];
                        boolean bl = false;
                        if (dArray[0] > 0.0 && dArray[0] < (double)FloatWindowHistogram.this.blockImage.length) {
                            if (d8 < (double)FloatWindowHistogram.this.blockImage[(int)dArray[0]][0] || d8 + d7 > (double)FloatWindowHistogram.this.blockImage[(int)dArray[0]][1]) {
                                ((FloatWindowHistogram)FloatWindowHistogram.this).blockImage[(int)dArray[0]][0] = (int)d8;
                                ((FloatWindowHistogram)FloatWindowHistogram.this).blockImage[(int)dArray[0]][1] = (int)(d8 + d7);
                            } else {
                                bl = true;
                            }
                        } else if (dArray2[0] < 0.0 || dArray[0] > (double)((int)d2)) {
                            bl = true;
                        }
                        if (bl) continue;
                        serializable = new Rectangle2D.Double(dArray[0], d8, d6, d7);
                        if ((by & 1) == 1) {
                            graphics2D.setStroke(FloatWindowHistogram.this.axisStroke);
                            graphics2D.setColor(color);
                            graphics2D.fill((Shape)((Object)serializable));
                            if (!(d6 > 5.0)) continue;
                            graphics2D.setColor(Color.black);
                            graphics2D.draw((Shape)((Object)serializable));
                            continue;
                        }
                        graphics2D.setColor(FloatWindowHistogram.this.selectionColor);
                        graphics2D.fill((Shape)((Object)serializable));
                        if (!(d6 > 5.0)) continue;
                        graphics2D.setStroke(FloatWindowHistogram.this.selStroke);
                        graphics2D.setColor(Color.black);
                        graphics2D.draw((Shape)((Object)serializable));
                    }
                }
            }
        }
    }

    private static class CountRGBClass {
        public int count = 0;
        public Color color;

        public CountRGBClass(Color color) {
            this.color = color;
        }

        public void increase() {
            ++this.count;
        }
    }
}

