/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.histogram;

import java.awt.Font;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.HistogramLayer;
import se.prediktera.map.plot.axisplot.settings.ComboBoxBins;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;

public class HistogramAccessorPanel
extends AbstractAxisLayer
implements SettingsBoxInterface {
    private ComboBoxBins boxBins;

    public HistogramAccessorPanel(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n, RandomInputStream randomInputStream, MapProperty mapProperty) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        try {
            if (randomInputStream != null) {
                mapProperty.setPrefix(String.valueOf(this.boxBins.getType()));
                this.boxBins.LoadProperty(randomInputStream, mapProperty);
                mapProperty.setPrefix("");
            } else if (plotInit.bins >= 0) {
                this.boxBins.setBinSize(plotInit.bins);
            }
            this.jbInit();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new HistogramLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    public ComboBoxBins getBoxBins() {
        return this.boxBins;
    }

    @Override
    public Font getDescriptionFont() {
        return null;
    }

    @Override
    public double[] getMinmax(int n) {
        return new double[]{1.0, -1.0};
    }

    public int getNumberBins() {
        return this.boxBins.getBinSize();
    }

    @Override
    public byte getTreeType() {
        return 6;
    }

    public boolean isShowLines() {
        return false;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.setPrefix(String.valueOf(this.boxBins.getType()));
        this.boxBins.SaveProperty(randomOutputStream);
        randomOutputStream.setPrefix("");
    }

    public void setBuckets(int n) {
        this.boxBins.setBinSize(n);
    }

    public void setMinMax(double d, double d2) {
        this.boxBins.setManualRange(true);
        this.boxBins.setMinRange(d);
        this.boxBins.setMaxRange(d2);
    }

    @Override
    public void setShowLines(boolean bl) {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxBins = null;
    }

    @Override
    protected void InitLayer() {
        this.boxBins = new ComboBoxBins(this, 0);
        this.boxBins.addItem(new ComboItem("[DEFAULT]", 0, 0));
        this.settingsBoxMap.put(this.boxBins.getType(), this.boxBins);
    }

    @Override
    protected void InitLayerChild() {
    }

    private void jbInit() {
        this.add(SettingsBoxHelper.createBinsPanel(this.boxBins));
    }
}

