/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.histogram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.HistogramLayer;

public class HistogramClass
extends Vector<ArrayList<ZoneLeaf>> {
    public static final byte XAXIS = 0;
    public static final byte YAXIS = 1;
    public static final byte ZAXIS = 2;
    private double binsize;
    private double maxinbin;
    private double min;
    private double max;
    private double mean;
    private double median;
    private double number;
    private double sd;
    private double skew;
    private HistogramLayer histogramlayer;
    private final boolean calculateStatistics;

    public HistogramClass(HistogramLayer histogramLayer, boolean bl) {
        this.histogramlayer = histogramLayer;
        this.calculateStatistics = bl;
    }

    @Override
    public void clear() {
        super.clear();
        this.histogramlayer = null;
    }

    public double ComputeGroupedSD() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.get(i);
            for (ZoneLeaf zoneLeaf : arrayList) {
                d += zoneLeaf.getValue((byte)0) * (double)i;
                d2 += zoneLeaf.getValue((byte)0) * zoneLeaf.getValue((byte)0) * (double)i;
                n += i;
            }
        }
        return Math.sqrt((d2 - d * d / (double)n) / (double)n);
    }

    public double ComputeKurt() {
        double d = this.ComputeGroupedSD();
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.get(i);
            for (ZoneLeaf zoneLeaf : arrayList) {
                d2 += Math.pow(zoneLeaf.getValue((byte)0) - this.mean, 4.0) * (double)i;
                n += i;
            }
        }
        d2 = Double.compare(d, 0.0) == 0 || n < 2 ? 0.0 : d2 / (double)n / Math.pow(d, 4.0) - 3.0;
        return d2;
    }

    public double ComputeMAD() {
        ArrayList arrayList;
        int n;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.size(); ++n) {
            arrayList = (ArrayList)this.get(n);
            for (ZoneLeaf zoneLeaf : arrayList) {
                n2 += n;
                d += zoneLeaf.getValue((byte)0) * (double)n;
            }
        }
        d /= (double)n2;
        for (n = 0; n < this.size(); ++n) {
            arrayList = (ArrayList)this.get(n);
            for (ZoneLeaf zoneLeaf : arrayList) {
                d2 += Math.abs(zoneLeaf.getValue((byte)0) - d) * (double)n;
            }
        }
        return d2 /= (double)n2;
    }

    public double ComputeSkew() {
        double d = this.ComputeGroupedSD();
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.get(i);
            for (ZoneLeaf zoneLeaf : arrayList) {
                d2 += Math.pow(zoneLeaf.getValue((byte)0) - this.mean, 3.0) * (double)i;
                n += i;
            }
        }
        d2 = Double.compare(d, 0.0) == 0 || n < 2 ? 0.0 : d2 / (double)n / Math.pow(d, 3.0);
        return d2;
    }

    public double getBinsize() {
        return this.binsize;
    }

    public HistogramLayer getLayer() {
        return this.histogramlayer;
    }

    public double getMaxinbin() {
        return this.maxinbin;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMedian() {
        return this.median;
    }

    public double getNumber() {
        return this.number;
    }

    public double getSd() {
        return this.sd;
    }

    public double getSkew() {
        return this.skew;
    }

    @Override
    public String toString() {
        String string = this.histogramlayer.getDataDescription((byte)0, false);
        return this.histogramlayer.toString() + " (" + string + ")";
    }

    protected synchronized double[] getMinmaxX(double[] dArray, int n) {
        this.binsize = (dArray[1] - dArray[0]) / (double)n;
        if (Double.compare(this.binsize, 0.0) == 0) {
            this.binsize = dArray[0] * 0.02;
        }
        this.maxinbin = 0.0;
        this.min = 2.147483647E9;
        this.max = 0.0;
        this.mean = 0.0;
        this.median = 0.0;
        this.number = 0.0;
        if (this.size() != n) {
            this.setSize(n);
            for (var3_3 = 0; var3_3 < n; ++var3_3) {
                this.set(var3_3, new ArrayList());
            }
        } else {
            for (var3_3 = 0; var3_3 < n; ++var3_3) {
                ((ArrayList)this.get(var3_3)).clear();
            }
        }
        if (this.binsize > 0.0) {
            if (this.histogramlayer.isLayerVisible() && this.histogramlayer.isLayerReady()) {
                Iterator<ZoneLeaf> iterator = this.histogramlayer.getLeafIterator();
                while (iterator.hasNext()) {
                    double d;
                    ZoneLeaf zoneLeaf = iterator.next();
                    if (!zoneLeaf.isVisible() || zoneLeaf.isMissing() || (d = zoneLeaf.getValue((byte)0)) > dArray[1]) continue;
                    int n2 = (int)((d - dArray[0]) / this.binsize);
                    if (n2 == n) {
                        --n2;
                    }
                    if (n2 < 0 || n2 >= n) continue;
                    this.min = Math.min(d, this.min);
                    this.max = Math.max(d, this.max);
                    this.mean += d;
                    this.number += 1.0;
                    ((ArrayList)this.get(n2)).add(zoneLeaf);
                    if (!(this.maxinbin < (double)((ArrayList)this.get(n2)).size())) continue;
                    this.maxinbin = ((ArrayList)this.get(n2)).size();
                }
            }
            this.mean /= this.number;
            if (this.calculateStatistics) {
                this.calculateStatistics();
            }
        }
        return dArray;
    }

    private void calculateStatistics() {
        if (this.number <= 1.0) {
            this.median = this.mean;
        } else {
            SortHistogramItems sortHistogramItems = new SortHistogramItems();
            int n = (int)(this.number / 2.0) - 1;
            for (int i = 0; i < this.size(); ++i) {
                ArrayList arrayList = (ArrayList)this.get(i);
                if (n < arrayList.size()) {
                    ZoneLeaf zoneLeaf;
                    Collections.sort(arrayList, sortHistogramItems);
                    ZoneLeaf zoneLeaf2 = zoneLeaf = (ZoneLeaf)arrayList.get(n);
                    if (n % 2 != 0) {
                        if (n + 1 == arrayList.size()) {
                            for (int j = i + 1; j < this.size(); ++j) {
                                ArrayList arrayList2 = (ArrayList)this.get(j);
                                if (arrayList2.size() <= 0) continue;
                                Collections.sort(arrayList2, sortHistogramItems);
                                zoneLeaf2 = (ZoneLeaf)arrayList2.get(0);
                            }
                        } else {
                            zoneLeaf2 = (ZoneLeaf)arrayList.get(n + 1);
                        }
                    }
                    this.median = (zoneLeaf.getValue((byte)0) + zoneLeaf2.getValue((byte)0)) / 2.0;
                    break;
                }
                n -= arrayList.size();
            }
        }
        this.sd = this.ComputeGroupedSD();
        this.skew = this.ComputeSkew();
    }

    public static class SortHistogramItems
    implements Comparator<ZoneLeaf> {
        private final HashMap<ZoneLeaf, Double> zoneLeafHashMap = new HashMap();

        @Override
        public int compare(ZoneLeaf zoneLeaf, ZoneLeaf zoneLeaf2) {
            return Double.compare(this.getValue(zoneLeaf), this.getValue(zoneLeaf2));
        }

        private Double getValue(ZoneLeaf zoneLeaf) {
            Double d = this.zoneLeafHashMap.get(zoneLeaf);
            if (d == null) {
                d = zoneLeaf.getValue((byte)0);
                this.zoneLeafHashMap.put(zoneLeaf, d);
            }
            return d;
        }
    }
}

