/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.histogram.bucket;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.AbstractScriptDataClass;
import se.prediktera.map.main.script.ScriptHelper;

public class BucketDataClass
extends AbstractScriptDataClass {
    private final List<AbstractDataMatrix> matrixList;
    private final double[] bucketarray;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    public BucketDataClass(List<AbstractDataMatrix> list, double[] dArray) {
        super("BucketDataClass");
        this.matrixList = list;
        this.bucketarray = dArray;
    }

    public void extendSelection(int[] nArray, InteractionArray interactionArray) {
        int n = 0;
        for (AbstractDataMatrix abstractDataMatrix : this.matrixList) {
            AbstractDataMatrix abstractDataMatrix2 = abstractDataMatrix;
            if (abstractDataMatrix2 instanceof FoldMatrix) {
                FoldMatrix foldMatrix = (FoldMatrix)abstractDataMatrix2;
                n = foldMatrix.getFold();
                abstractDataMatrix2 = foldMatrix.getReferencedMatrix();
            }
            abstractDataMatrix2.beginCalculations();
            boolean bl = abstractDataMatrix2 instanceof ModelMatrix;
            int n2 = bl ? abstractDataMatrix2.getK() : abstractDataMatrix2.getN();
            int[] nArray2 = bl ? abstractDataMatrix2.getKref() : abstractDataMatrix2.getNref();
            double d = this.getBuckets();
            for (int n3 : nArray) {
                double d2 = bl ? abstractDataMatrix2.getValue(n, abstractDataMatrix2.getKrefOrig(n3)) : abstractDataMatrix2.getValue(abstractDataMatrix2.getNrefOrig(n3), n);
                int n4 = (int)((d2 - this.xmin) / (this.xmax - this.xmin) * d);
                if (n4 < 0 || !((double)n4 < d)) continue;
                int n5 = this.getBucket(n4 + 1, true, true, 0.05);
                double d3 = (double)n5 / d * (this.xmax - this.xmin) + this.xmin;
                int n6 = this.getBucket(n4, false, true, 0.05);
                double d4 = (double)n6 / d * (this.xmax - this.xmin) + this.xmin;
                for (int i = 0; i < n2; ++i) {
                    double d5 = bl ? abstractDataMatrix2.getValue(n, i) : abstractDataMatrix2.getValue(i, n);
                    if (!(d5 <= d3) || !(d5 >= d4)) continue;
                    if (nArray2 != null) {
                        interactionArray.set(nArray2[i]);
                        continue;
                    }
                    interactionArray.set(i);
                }
            }
            abstractDataMatrix2.endCalculations();
        }
    }

    @Override
    public Object get(String string) {
        return this.get(string, null);
    }

    public Object get(String string, Properties properties) {
        double d = 0.05;
        if (properties != null && ScriptHelper.hasKey(properties, "percent")) {
            d = ScriptHelper.getPropertyDouble(properties, "percent") / 100.0;
        }
        if (string.equalsIgnoreCase("minvalue")) {
            double d2 = this.getBucket(0, true, false, d);
            d2 = d2 / (double)this.bucketarray.length * (this.xmax - this.xmin) + this.xmin;
            return d2;
        }
        if (string.equalsIgnoreCase("maxvalue")) {
            double d3 = this.getBucket(this.bucketarray.length - 1, false, false, d);
            d3 = d3 / (double)this.bucketarray.length * (this.xmax - this.xmin) + this.xmin;
            return d3;
        }
        if (string.equalsIgnoreCase("bucket")) {
            return this.bucketarray;
        }
        if (string.equalsIgnoreCase("bucketstr")) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.bucketarray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(this.bucketarray[i]);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public int getBucket(int n, boolean bl, boolean bl2, double d) {
        int n2 = this.getBuckets();
        double d2 = this.ymax * d;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                if (!(bl2 ? this.bucketarray[i] <= d2 && (i + 1 >= n2 || this.bucketarray[i + 1] > this.bucketarray[i]) : this.bucketarray[i] > d2)) continue;
                return i;
            }
        }
        double d3 = 0.0;
        for (int i = n; i >= 0; --i) {
            d3 += this.bucketarray[i];
            if (!(bl2 ? this.bucketarray[i] <= d2 && (i - 1 < 0 || this.bucketarray[i - 1] > this.bucketarray[i]) : d3 > d2)) continue;
            return i;
        }
        return 0;
    }

    public double[] getBucketarray() {
        return this.bucketarray;
    }

    public int getBuckets() {
        return this.bucketarray.length;
    }

    public AbstractDataMatrix getMatrix() {
        return this.matrixList.get(0);
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
    }
}

