/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.histogram.bucket2D;

import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Properties;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.script.AbstractScriptDataClass;
import se.prediktera.map.main.script.ScriptHelper;

public class Bucket2DDataClass
extends AbstractScriptDataClass {
    private final AbstractDataMatrix xmatrix;
    private final AbstractDataMatrix ymatrix;
    private final double[][] bucketmatrix;
    private final int xbuckets;
    private final int ybuckets;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double zmin;
    private double zmax;
    private double average;
    private double median;
    private final int[][] cursor_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private int[][] idMatrix;

    public Bucket2DDataClass(AbstractDataMatrix abstractDataMatrix, AbstractDataMatrix abstractDataMatrix2, double[][] dArray, int n, int n2) {
        super("Bucket2DDataClass");
        this.xmatrix = abstractDataMatrix;
        this.ymatrix = abstractDataMatrix2;
        this.bucketmatrix = dArray;
        this.xbuckets = n;
        this.ybuckets = n2;
    }

    public void createIdMatrix(double d) {
        int n;
        int n2 = 0;
        Comparator comparator = (pointId, pointId2) -> Float.compare(pointId.z, pointId2.z);
        this.idMatrix = new int[this.xbuckets][this.ybuckets];
        ArrayList<PointId> arrayList = new ArrayList<PointId>();
        LinkedList<PointId> linkedList = new LinkedList<PointId>();
        for (int i = 0; i < this.xbuckets; ++i) {
            for (int j = 0; j < this.ybuckets; ++j) {
                int n3;
                if (!(this.bucketmatrix[i][j] > 0.0) || (double)(n3 = (int)this.bucketmatrix[i][j]) < this.median) continue;
                int n4 = 1;
                for (int[] nArray : this.cursor_maximum) {
                    int n5 = i + nArray[0];
                    int n6 = j + nArray[1];
                    double d2 = 0.0;
                    if (n5 >= 0 && n5 < this.xbuckets && n6 >= 0 && n6 < this.ybuckets) {
                        d2 = this.bucketmatrix[n5][n6];
                    }
                    if (!((double)n3 < d2)) continue;
                    n4 = 0;
                    break;
                }
                if (n4 == 0) continue;
                if (n2 < n3) {
                    n2 = n3;
                }
                PointId pointId3 = new PointId(arrayList.size() + 1, i, j, n3);
                arrayList.add(pointId3);
                n = Collections.binarySearch(linkedList, pointId3, comparator);
                if (n < 0) {
                    linkedList.add(-n - 1, pointId3);
                } else {
                    linkedList.add(n, pointId3);
                }
                this.idMatrix[i][j] = pointId3.id;
            }
        }
        while (!linkedList.isEmpty()) {
            PointId pointId3 = (PointId)linkedList.removeLast();
            for (int[] nArray : this.cursor_maximum) {
                PointId pointId4;
                n = pointId3.x + nArray[0];
                int n7 = pointId3.y + nArray[1];
                double d3 = 0.0;
                if (n < 0 || n >= this.xbuckets || n7 < 0 || n7 >= this.ybuckets) continue;
                d3 = this.bucketmatrix[n][n7];
                if (this.idMatrix[n][n7] > 0) {
                    pointId4 = (PointId)arrayList.get(this.idMatrix[n][n7] - 1);
                    PointId pointId5 = this.checkPoints(this.idMatrix, pointId3, pointId4, n, n7, d3, d);
                    if (pointId5 == null) continue;
                    linkedList.remove(pointId5);
                    for (int i = 0; i < this.idMatrix.length; ++i) {
                        for (int j = 0; j < this.idMatrix[i].length; ++j) {
                            if (this.idMatrix[i][j] != pointId5.id) continue;
                            this.idMatrix[i][j] = pointId5.rid;
                        }
                    }
                    continue;
                }
                this.idMatrix[n][n7] = pointId3.id;
                pointId4 = new PointId(pointId3.id, n, n7, (int)d3);
                int n8 = Collections.binarySearch(linkedList, pointId4, comparator);
                if (n8 < 0) {
                    linkedList.add(-n8 - 1, pointId4);
                    continue;
                }
                linkedList.add(n8, pointId4);
            }
        }
    }

    public void extendSelection(int[] nArray, InteractionArray interactionArray, Properties properties) {
        int n;
        FoldMatrix foldMatrix;
        AbstractDataMatrix abstractDataMatrix = this.xmatrix;
        AbstractDataMatrix abstractDataMatrix2 = this.ymatrix;
        boolean bl = false;
        double d = 0.2;
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "continues")) {
                bl = ScriptHelper.getPropertyBool(properties, "continues");
            }
            if (ScriptHelper.hasKey(properties, "ratio")) {
                d = ScriptHelper.getPropertyDouble(properties, "ratio");
            }
            if (ScriptHelper.hasKey(properties, "median")) {
                this.median = ScriptHelper.getPropertyDouble(properties, "median");
            }
        }
        int n2 = 0;
        int n3 = 0;
        if (abstractDataMatrix instanceof FoldMatrix) {
            foldMatrix = (FoldMatrix)abstractDataMatrix;
            n2 = foldMatrix.getFold();
            abstractDataMatrix = foldMatrix.getReferencedMatrix();
        }
        abstractDataMatrix.beginCalculations();
        if (abstractDataMatrix2 instanceof FoldMatrix) {
            foldMatrix = (FoldMatrix)abstractDataMatrix2;
            n3 = foldMatrix.getFold();
            abstractDataMatrix2 = foldMatrix.getReferencedMatrix();
        }
        abstractDataMatrix2.beginCalculations();
        boolean bl2 = abstractDataMatrix instanceof ModelMatrix;
        int n4 = bl2 ? abstractDataMatrix.getK() : abstractDataMatrix.getN();
        int[] nArray2 = bl2 ? abstractDataMatrix.getKref() : abstractDataMatrix.getNref();
        this.createIdMatrix(d);
        int n5 = -1;
        int n6 = -1;
        for (int n7 : nArray) {
            double d2;
            double d3;
            int n8;
            if (bl2) {
                n8 = abstractDataMatrix.getKrefOrig(n7);
                d3 = abstractDataMatrix.getValue(n2, n8);
                d2 = abstractDataMatrix2.getValue(n3, n8);
            } else {
                n8 = abstractDataMatrix.getNrefOrig(n7);
                d3 = abstractDataMatrix.getValue(n8, n2);
                d2 = abstractDataMatrix2.getValue(n8, n3);
            }
            n8 = (int)((d3 - this.xmin) / (this.xmax - this.xmin) * (double)this.xbuckets);
            n = (int)((d2 - this.ymin) / (this.ymax - this.ymin) * (double)this.ybuckets);
            if (n8 < 0 || n8 >= this.xbuckets || n < 0 || n >= this.ybuckets) continue;
            n5 = this.idMatrix[n8][n];
            n6 = n7;
            break;
        }
        int n9 = abstractDataMatrix.getFoldN();
        int n10 = abstractDataMatrix.getOrigSize(1);
        int n11 = n10 / n9;
        boolean[] blArray = new boolean[n10];
        for (int i = 0; i < n4; ++i) {
            double d4;
            double d5;
            if (bl2) {
                d5 = abstractDataMatrix.getValue(n2, i);
                d4 = abstractDataMatrix2.getValue(n3, i);
            } else {
                d5 = abstractDataMatrix.getValue(i, n2);
                d4 = abstractDataMatrix2.getValue(i, n3);
            }
            n = (int)((d5 - this.xmin) / (this.xmax - this.xmin) * (double)this.xbuckets);
            int n12 = (int)((d4 - this.ymin) / (this.ymax - this.ymin) * (double)this.ybuckets);
            if (n < 0 || n >= this.xbuckets || n12 < 0 || n12 >= this.ybuckets || this.idMatrix[n][n12] != n5 || !(this.bucketmatrix[n][n12] > 0.0)) continue;
            if (nArray2 != null) {
                blArray[nArray2[i]] = true;
                continue;
            }
            blArray[i] = true;
        }
        boolean[] blArray2 = new boolean[n10];
        if (bl) {
            int n13 = n6 / n9;
            int n14 = n6 % n9;
            this.makeSelection(interactionArray, blArray2, blArray, n9, n10, n13, n14);
        } else {
            for (int i = 0; i < n9; ++i) {
                for (int j = 0; j < n11; ++j) {
                    this.makeSelection(interactionArray, blArray2, blArray, n9, n10, j, i);
                }
            }
        }
        abstractDataMatrix.endCalculations();
        abstractDataMatrix2.endCalculations();
    }

    public Object get(Double[] doubleArray) throws Exception {
        int[] nArray = new int[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            nArray[i] = doubleArray[i].intValue();
        }
        DataSet dataSet = (DataSet)this.xmatrix.get("dataset");
        int n = dataSet.getOriginalMatrix().getN();
        InteractionArray interactionArray = new InteractionArray(null, 0, n);
        this.extendSelection(nArray, interactionArray, null);
        int n2 = interactionArray.getSetCount();
        Double[] doubleArray2 = new Double[n2];
        int n3 = 0;
        for (int i = 0; i < interactionArray.size(); ++i) {
            if (!interactionArray.get(i)) continue;
            doubleArray2[n3++] = (double)i + 1.0;
        }
        return doubleArray2;
    }

    @Override
    public Object get(String string) throws Exception {
        return this.get(string, null);
    }

    public Object get(String string, Properties properties) throws Exception {
        return null;
    }

    public double getAverage() {
        return this.average;
    }

    public double[][] getBucketmatrix() {
        return this.bucketmatrix;
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    @Override
    public byte getTreeType() {
        return 0;
    }

    public int getXBuckets() {
        return this.xbuckets;
    }

    public AbstractDataMatrix getXMatrix() {
        return this.xmatrix;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public int getYBuckets() {
        return this.ybuckets;
    }

    public AbstractDataMatrix getYMatrix() {
        return this.ymatrix;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getZmax() {
        return this.zmax;
    }

    public double getZmin() {
        return this.zmin;
    }

    public void setLimits(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        this.zmin = d5;
        this.zmax = d6;
        this.average = d7;
        this.median = d8;
    }

    @Override
    protected void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
    }

    private PointId checkPoints(int[][] nArray, PointId pointId, PointId pointId2, int n, int n2, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6 = Math.sqrt(this.xbuckets * this.xbuckets + this.ybuckets * this.ybuckets);
        double d7 = pointId.x - n;
        double d8 = pointId.y - n2;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = (d9 + (d5 = Math.sqrt((d4 = (double)(pointId2.x - n)) * d4 + (d3 = (double)(pointId2.y - n2)) * d3))) / d6;
        if (d10 < d2 && d > this.median) {
            if (pointId.z > pointId2.z) {
                pointId2.rid = pointId.id;
                return pointId2;
            }
            pointId.rid = pointId2.id;
            return pointId;
        }
        return null;
    }

    private void makeSelection(InteractionArray interactionArray, boolean[] blArray, boolean[] blArray2, int n, int n2, int n3, int n4) {
        int n5 = n3 * n + n4;
        if (n5 >= 0 && n5 < blArray.length && !blArray[n5] && blArray2[n5]) {
            ArrayList<Point> arrayList = new ArrayList<Point>();
            arrayList.add(new Point(n3, n4));
            for (int i = 0; i < arrayList.size(); ++i) {
                Point point = (Point)arrayList.get(i);
                for (int[] nArray : this.cursor_maximum) {
                    int n6 = point.x + nArray[0];
                    int n7 = point.y + nArray[1];
                    int n8 = n6 * n + n7;
                    if (n8 < 0 || n8 >= n2 || blArray[n8] || !blArray2[n8]) continue;
                    blArray[n8] = true;
                    arrayList.add(new Point(n6, n7));
                }
            }
            if (arrayList.size() > 100) {
                for (Point point : arrayList) {
                    int n9 = point.x * n + point.y;
                    interactionArray.set(n9);
                }
            }
        }
    }

    private static class PointId {
        public int id;
        public int rid;
        public int x;
        public int y;
        public int z;

        public PointId(int n, int n2, int n3, int n4) {
            this.id = n;
            this.x = n2;
            this.y = n3;
            this.z = n4;
        }
    }
}

