/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.serie2D;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.AbstractFloatWindowSerie;
import se.prediktera.map.plot.axisplot.plot2D.serie.AbstractSerieLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.SerieLayer;

public class FloatWindowSerie
extends AbstractFloatWindowSerie {
    private boolean percent = false;
    private boolean stacked = false;
    private double[] sum_min_yc = null;
    private double[] sum_max_yc = null;
    private boolean drawnumber = false;
    private boolean drawpercent = false;

    public FloatWindowSerie(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
    }

    public FloatWindowSerie(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.percent = mapProperty.getPropertyBoolean("perc");
        this.stacked = mapProperty.getPropertyBoolean("stacked", false);
        this.sum_min_yc = mapProperty.getPropertyDoubleArray("sum_min", null);
        this.sum_max_yc = mapProperty.getPropertyDoubleArray("sum_max", null);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new SerieLayer(this, plotInit, null, null, n);
    }

    @Override
    public synchronized double[] getMinmax(int n, int n2) {
        double[] dArray = new double[]{0.0, 0.0};
        if (this.plotAxisLayerPanel == null) {
            return dArray;
        }
        if (n == 1) {
            int n3;
            int n4;
            if (this.stacked) {
                this.sum_min_yc = null;
                this.sum_max_yc = null;
                n4 = this.plotAxisLayerPanel.getLayerCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    AbstractSerieLayer abstractSerieLayer = (AbstractSerieLayer)this.plotAxisLayerPanel.getLayerAtIndex(n3);
                    if (abstractSerieLayer == null || !abstractSerieLayer.isLayerVisible() || !abstractSerieLayer.isLayerReady() || abstractSerieLayer.getZoneList() == null) continue;
                    LeafList leafList = abstractSerieLayer.getZoneList();
                    if (this.sum_min_yc == null || this.sum_min_yc.length != leafList.size()) {
                        this.sum_min_yc = new double[leafList.size()];
                        this.sum_max_yc = new double[leafList.size()];
                    }
                    for (int i = 0; i < leafList.size(); ++i) {
                        double d = ((ZoneLeaf)leafList.get(i)).getValue((byte)1);
                        if (d < 0.0) {
                            int n5 = i;
                            this.sum_min_yc[n5] = this.sum_min_yc[n5] + d;
                            continue;
                        }
                        int n6 = i;
                        this.sum_max_yc[n6] = this.sum_max_yc[n6] + d;
                    }
                }
            }
            if (this.percent) {
                dArray[1] = 1.1;
                dArray[0] = -0.1;
                return dArray;
            }
            if (this.stacked && this.sum_min_yc != null) {
                n4 = 1;
                for (n3 = 0; n3 < this.sum_min_yc.length; ++n3) {
                    if (n4 != 0) {
                        dArray[0] = this.sum_min_yc[n3];
                        dArray[1] = this.sum_max_yc[n3];
                        n4 = 0;
                        continue;
                    }
                    if (dArray[0] > this.sum_min_yc[n3]) {
                        dArray[0] = this.sum_min_yc[n3];
                    }
                    if (!(dArray[1] < this.sum_max_yc[n3])) continue;
                    dArray[1] = this.sum_max_yc[n3];
                }
                dArray[0] = Math.min(dArray[0], 0.0);
            } else {
                dArray = super.getMinmax(n, 0);
                double d = dArray[0] > 0.0 ? 0.0 : dArray[0];
                dArray[0] = d;
                dArray[1] = dArray[1] < 0.0 ? 0.0 : dArray[1];
            }
            return dArray;
        }
        int n7 = this.plotAxisLayerPanel.visibleMainLayers();
        if (n7 != 0) {
            int n8 = 0;
            int n9 = 0;
            boolean bl = true;
            int n10 = this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n10; ++i) {
                LeafList leafList;
                AbstractSerieLayer abstractSerieLayer = (AbstractSerieLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractSerieLayer == null || !abstractSerieLayer.isLayerVisible() || !abstractSerieLayer.isLayerReady() || (leafList = abstractSerieLayer.getZoneList()) == null || leafList.size() <= 0) continue;
                ZoneLeaf zoneLeaf = (ZoneLeaf)leafList.get(0);
                ZoneLeaf zoneLeaf2 = (ZoneLeaf)leafList.get(leafList.size() - 1);
                if (bl || zoneLeaf.getPrimaryIndex() < n8) {
                    n8 = zoneLeaf.getPrimaryIndex();
                }
                if (bl || zoneLeaf2.getPrimaryIndex() > n9) {
                    n9 = zoneLeaf2.getPrimaryIndex();
                }
                bl = false;
            }
            double d = this.stacked ? 1.0 : (double)n7;
            dArray[0] = (double)n8 + 0.5 / d;
            dArray[1] = (double)(n9 + 1) + 0.5 / d;
        }
        return dArray;
    }

    @Override
    public Point getPointAtCordsAt(AbstractAxisLayer abstractAxisLayer, Point point, int n, int n2) {
        Point point2 = super.getPointAtCordsAt(abstractAxisLayer, point, n, n2);
        if (point2 != null && this.plotGround != null) {
            return new Point((int)((double)point2.x + ((PlotSerie)this.plotGround).getSw() / 2.0), point2.y);
        }
        return null;
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("perc", this.percent);
        randomOutputStream.writePropertyBoolean("stacked", this.stacked);
        randomOutputStream.writePropertyDoubleArray("sum_min", this.sum_min_yc);
        randomOutputStream.writePropertyDoubleArray("sum_max", this.sum_max_yc);
    }

    public void setDrawnumber(boolean bl, boolean bl2) {
        this.drawnumber = bl;
        this.drawpercent = bl2;
    }

    public void setPercent(boolean bl) {
        this.percent = bl;
        if (bl) {
            this.getRange(1, 0).setMinFactor(0.0);
            this.getRange(1, 0).setMaxFactor(0.0);
        }
    }

    public void setStacked(boolean bl) {
        this.stacked = bl;
    }

    @Override
    public void translateToScreenInt(int[] nArray, ZoneLeaf zoneLeaf) {
        ((PlotSerie)this.plotGround).translateToScreenInt(nArray, zoneLeaf);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.sum_min_yc = null;
        this.sum_max_yc = null;
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PlotSerie(0.0, 0.0, Color.white);
    }

    @Override
    protected FloatWindowPlot2D.PlotXaxis createXaxis() {
        PlotXserieAxis plotXserieAxis = new PlotXserieAxis(Color.white, 0.0, 0.2);
        plotXserieAxis.setMinHeight(100);
        return plotXserieAxis;
    }

    @Override
    protected float getBlackBorderSize() {
        return 1.0f;
    }

    @Override
    protected float getWhiteBorderSize() {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
        double d2;
        Serializable serializable;
        double d3 = 0.0;
        this.textXaxisRelative = 1.0;
        if (this.plotAxisLayerPanel.getLayerCount() > 0 && this.plotAxisLayerPanel.getLayerAtIndex(0) instanceof SerieLayer) {
            serializable = (SerieLayer)this.plotAxisLayerPanel.getLayerAtIndex(0);
            if (serializable != null) {
                graphics2D.setFont(((SerieLayer)serializable).getLabelFont());
            }
        } else {
            graphics2D.setFont(this.AxisFont);
        }
        serializable = graphics2D.getFontMetrics();
        if (this.plotXaxis != null) {
            int n = this.plotAxisLayerPanel.getLayerCount();
            int n2 = this.plotAxisLayerPanel.visibleMainLayers();
            double d4 = 0.0;
            this.serieList.clear();
            if (n2 > 0) {
                d2 = (double)this.plotGround.getWidth() / this.getRange(0, 0).getAbs();
                if (!this.stacked) {
                    d2 /= (double)n2;
                }
                int n3 = Math.max((int)(20.0 / d2), 1);
                int n4 = -1;
                for (int i = 0; i < n; ++i) {
                    AbstractSerieLayer abstractSerieLayer = (AbstractSerieLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (abstractSerieLayer == null || !abstractSerieLayer.isLayerVisible() || !abstractSerieLayer.isLayerReady() || abstractSerieLayer.isSubLayer()) continue;
                    if (n3 == 1) {
                        n4 = -1;
                    }
                    List<ZoneLeaf> list = abstractSerieLayer.getRootList();
                    for (int j = 0; j < list.size(); ++j) {
                        ZoneLeaf zoneLeaf = list.get(j);
                        if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                        double d5 = zoneLeaf.getValue((byte)1);
                        int n5 = zoneLeaf.getPrimaryIndex();
                        double[] dArray = this.plotGround.translateToScreenDouble(n5, d5, 0);
                        dArray[0] = dArray[0] + (d2 * d4 + d2);
                        if (!(dArray[0] >= (double)n4)) continue;
                        String string = zoneLeaf.getDescription();
                        if (this.stacked) {
                            string = String.valueOf(zoneLeaf.getPrimaryIndex() + 1);
                        }
                        this.serieList.add(new TickInfo(dArray[0], string));
                        double d6 = ((FontMetrics)serializable).stringWidth(string);
                        if (d3 < d6) {
                            d3 = d6;
                        }
                        n4 = (int)dArray[0] + n3;
                    }
                    if (this.stacked) break;
                    d4 += 1.0;
                }
                this.textXaxisRelative = d2 * 0.9 / (double)((FontMetrics)serializable).getHeight();
                double d7 = ((double)this.plotXaxis.getHeight() - 5.0 * d) * 0.9 / d3;
                if (this.textXaxisRelative > d7) {
                    this.textXaxisRelative = d7;
                }
                if (this.textXaxisRelative < 0.9) {
                    this.textXaxisRelative = 0.9;
                }
            }
        }
        this.textRelative = this.textXaxisRelative;
        if (this.plotYaxis != null) {
            List<TickInfo> list;
            d3 = 0.0;
            List<TickInfo> list2 = list = this.getRange(1, 0).getTickList();
            synchronized (list2) {
                for (TickInfo tickInfo : list) {
                    d2 = ((FontMetrics)serializable).stringWidth(tickInfo.text);
                    if (!(d3 < d2)) continue;
                    d3 = d2;
                }
            }
            double d8 = ((double)this.plotYaxis.getWidth() - 5.0 * d) * 0.97 / d3;
            if (this.textRelative > d8) {
                this.textRelative = d8;
            }
        }
        if (this.textRelative > d) {
            this.textRelative = d;
        }
        if (this.textRelative < 1.2) {
            this.textRelative = 1.2;
        }
    }

    static /* synthetic */ int[][] access$1802(FloatWindowSerie floatWindowSerie, int[][] nArray) {
        floatWindowSerie.blockImage = nArray;
        return nArray;
    }

    private class PlotSerie
    extends FloatWindowPlot2D.PlotGrid {
        private double sw;

        public PlotSerie(double d, double d2, Color color) {
            super(color, d, d2);
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            int n = FloatWindowSerie.this.plotAxisLayerPanel.getLayerCount();
            double d = this.sw / (double)this.width * FloatWindowSerie.this.getRange(0, 0).getAbs();
            double d2 = 0.5 * d;
            for (int i = 0; i < n; ++i) {
                AbstractAxisLayer abstractAxisLayer = FloatWindowSerie.this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (abstractAxisLayer.isSubLayer() || !abstractAxisLayer.isLayerVisible() || !abstractAxisLayer.isLayerReady()) continue;
                List<ZoneLeaf> list = abstractAxisLayer.getRootList();
                for (int j = 0; j < list.size(); ++j) {
                    boolean bl2;
                    ZoneLeaf zoneLeaf = list.get(j);
                    if (!zoneLeaf.isVisibleAndNotMissing()) continue;
                    double d3 = (double)zoneLeaf.getPrimaryIndex() + d2;
                    double d4 = zoneLeaf.getValue((byte)1);
                    double d5 = d4 < 0.0 ? d4 : 0.0;
                    double d6 = d4 > 0.0 ? d4 : 0.0;
                    boolean bl3 = dArray[0] <= d3 + d && dArray2[0] >= d3;
                    boolean bl4 = dArray[1] <= d6 && dArray2[1] >= d5;
                    boolean bl5 = bl2 = Double.isNaN(d4) && dArray[1] < 0.0;
                    if (!bl3 || !bl4 && !bl2 || bl && zoneLeaf.isSelected()) continue;
                    linkedList.add(zoneLeaf);
                }
                d2 += d;
            }
            return linkedList;
        }

        public double getSw() {
            return this.sw;
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            int n;
            boolean bl;
            double[] dArray = new double[2];
            this.translateToScreenDouble(dArray, 0.0, 0.0, 0);
            boolean bl2 = bl = (by & 2) == 2;
            if ((by & 1) == 1) {
                super.paint(graphics2D, by, d);
            } else if ((by & 2) == 2 && FloatWindowSerie.this.selectionList.isEmpty()) {
                return;
            }
            double d2 = FloatWindowSerie.this.getTryWidth();
            if (FloatWindowSerie.this.blockImage == null || FloatWindowSerie.this.blockImage.length != (int)d2) {
                FloatWindowSerie.access$1802(FloatWindowSerie.this, new int[(int)d2][2]);
            }
            for (n = 0; n < (int)d2; ++n) {
                ((FloatWindowSerie)FloatWindowSerie.this).blockImage[n][0] = (int)dArray[1];
                ((FloatWindowSerie)FloatWindowSerie.this).blockImage[n][1] = (int)dArray[1];
            }
            n = FloatWindowSerie.this.plotAxisLayerPanel.visibleMainLayers();
            if (n > 0) {
                Object object;
                int n2;
                int n3 = FloatWindowSerie.this.plotAxisLayerPanel.getMainLayerCount();
                AxisRange axisRange = FloatWindowSerie.this.getRange(0, 0);
                AxisRange axisRange2 = FloatWindowSerie.this.getRange(1, 0);
                int[] nArray = this.translateToScreenInt(axisRange.getMin(), axisRange2.getMin());
                int[] nArray2 = this.translateToScreenInt(axisRange.getMax(), axisRange2.getMax());
                if ((by & 0x20) != 32) {
                    graphics2D.setClip(nArray[0], nArray2[1], nArray2[0] - nArray[0], nArray[1] - nArray2[1]);
                }
                this.sw = (double)this.width / axisRange.getAbs();
                if (!FloatWindowSerie.this.stacked) {
                    this.sw /= (double)n;
                }
                double d3 = Math.ceil(this.sw);
                double d4 = this.sw * 0.5;
                if (d3 > 10.0) {
                    d4 += d3 * 0.1;
                    d3 *= 0.8;
                }
                double[] dArray2 = null;
                if (FloatWindowSerie.this.sum_min_yc == null) {
                    FloatWindowSerie.this.stacked = false;
                }
                if (FloatWindowSerie.this.stacked) {
                    dArray2 = new double[FloatWindowSerie.this.sum_min_yc.length];
                    for (n2 = 0; n2 < FloatWindowSerie.this.sum_min_yc.length; ++n2) {
                        double d5 = FloatWindowSerie.this.percent ? 0.0 : FloatWindowSerie.this.sum_min_yc[n2];
                        object = this.translateToScreenDouble(0.0, d5, 0);
                        dArray2[n2] = (double)object[1];
                    }
                }
                n2 = 0;
                if (FloatWindowSerie.this.drawpercent) {
                    for (int i = 0; i < n3; ++i) {
                        AbstractSerieLayer abstractSerieLayer = (AbstractSerieLayer)FloatWindowSerie.this.plotAxisLayerPanel.getMainLayer(i);
                        object = abstractSerieLayer.getRootList();
                        for (int j = 0; j < object.size(); ++j) {
                            n2 = (int)((double)n2 + ((ZoneLeaf)object.get(j)).getValue((byte)1));
                        }
                    }
                }
                if ((by & 3) > 0) {
                    double d6 = 0.0;
                    for (int i = 0; i < n3; ++i) {
                        AbstractSerieLayer abstractSerieLayer = (AbstractSerieLayer)FloatWindowSerie.this.plotAxisLayerPanel.getMainLayer(i);
                        if (!abstractSerieLayer.isLayerReady() || !abstractSerieLayer.isLayerVisible()) continue;
                        InnerColumnBoolean innerColumnBoolean = FloatWindowSerie.this.getIncludeColumn(abstractSerieLayer);
                        AbstractAxisPlot.SelectionList selectionList = abstractSerieLayer.getRootList();
                        if ((by & 2) == 2) {
                            selectionList = FloatWindowSerie.this.selectionList;
                        }
                        int n4 = -1;
                        double d7 = FloatWindowSerie.this.stacked ? d4 : this.sw * d6 + d4;
                        for (int j = 0; j < selectionList.size(); ++j) {
                            ZoneLeaf zoneLeaf = (ZoneLeaf)selectionList.get(j);
                            ++n4;
                            if (zoneLeaf.isMissing() || zoneLeaf.getLayer().getMainLayer() != abstractSerieLayer) continue;
                            double d8 = zoneLeaf.getValue((byte)1);
                            if (FloatWindowSerie.this.stacked && FloatWindowSerie.this.percent) {
                                d8 /= FloatWindowSerie.this.sum_max_yc[n4] - FloatWindowSerie.this.sum_min_yc[n4];
                            }
                            if (FloatWindowSerie.this.stacked && d8 < 0.0) {
                                d8 = Math.abs(d8);
                            }
                            double[] dArray3 = FloatWindowSerie.this.plotGround.translateToScreenDouble(zoneLeaf.getPrimaryIndex(), d8, 0);
                            dArray3[0] = dArray3[0] + d7;
                            double[] dArray4 = new double[]{dArray3[0], dArray3[1]};
                            double d9 = Math.abs(dArray[1] - dArray3[1]);
                            double d10 = dArray4[1];
                            if (FloatWindowSerie.this.stacked) {
                                d10 -= dArray[1];
                                if (n4 < dArray2.length) {
                                    d10 += dArray2[n4];
                                }
                            } else if (d8 < 0.0 || Double.isNaN(d8)) {
                                d10 = dArray[1];
                            }
                            if (zoneLeaf.isVisible() && d9 > 0.0 && d3 > 0.0) {
                                boolean bl3 = false;
                                if (dArray4[0] > 0.0 && dArray4[0] < (double)FloatWindowSerie.this.blockImage.length) {
                                    if (d10 < (double)FloatWindowSerie.this.blockImage[(int)dArray4[0]][0] || d10 + d9 > (double)FloatWindowSerie.this.blockImage[(int)dArray4[0]][1]) {
                                        ((FloatWindowSerie)FloatWindowSerie.this).blockImage[(int)dArray4[0]][0] = (int)d10;
                                        ((FloatWindowSerie)FloatWindowSerie.this).blockImage[(int)dArray4[0]][1] = (int)(d10 + d9);
                                    } else {
                                        bl3 = true;
                                    }
                                } else if (dArray4[0] + d3 < 0.0 || dArray4[0] > (double)((int)d2)) {
                                    bl3 = true;
                                }
                                if (!bl3) {
                                    Rectangle2D.Double double_ = new Rectangle2D.Double(dArray4[0], d10, d3, d9);
                                    if ((by & 1) == 1) {
                                        graphics2D.setStroke(FloatWindowSerie.this.axisStroke);
                                        if (innerColumnBoolean != null && !innerColumnBoolean.getValueBool(zoneLeaf.getPrimaryIndex())) {
                                            graphics2D.setColor(Color.lightGray);
                                        } else {
                                            graphics2D.setColor(zoneLeaf.getColor());
                                        }
                                        graphics2D.fill(double_);
                                        if (this.sw > 5.0) {
                                            graphics2D.setColor(Color.black);
                                            graphics2D.draw(double_);
                                        }
                                        if (FloatWindowSerie.this.drawnumber) {
                                            graphics2D.setFont(new Font(graphics2D.getFont().getFontName(), 1, (int)(10.0 * d)));
                                            FontMetrics fontMetrics = graphics2D.getFontMetrics();
                                            graphics2D.setColor(Color.white);
                                            String string = FloatWindowSerie.this.drawpercent ? NiceDataFormat.toPercent(d8 / (double)n2) : NiceDataFormat.toString(d8);
                                            graphics2D.drawString(string, (int)(dArray4[0] + d3 / 2.0 - (double)(fontMetrics.stringWidth(string) / 2)), (int)(d10 + d9 / 2.0 + (double)(fontMetrics.getHeight() / 2)));
                                        }
                                    } else {
                                        graphics2D.setColor(FloatWindowSerie.this.selectionColor);
                                        graphics2D.fill(double_);
                                    }
                                }
                            }
                            if (!FloatWindowSerie.this.stacked || n4 >= dArray2.length) continue;
                            int n5 = n4;
                            dArray2[n5] = dArray2[n5] - (dArray[1] - dArray4[1]);
                        }
                        if (!abstractSerieLayer.isLayerVisible()) continue;
                        d6 += 1.0;
                    }
                }
                if ((by & 4) == 4) {
                    double d11 = 0.0;
                    graphics2D.setClip(null);
                    for (int i = 0; i < n3; ++i) {
                        AbstractSerieLayer abstractSerieLayer = (AbstractSerieLayer)FloatWindowSerie.this.plotAxisLayerPanel.getMainLayer(i);
                        if (!(abstractSerieLayer instanceof SerieLayer) || !abstractSerieLayer.isLayerReady() || !abstractSerieLayer.isLayerVisible()) continue;
                        abstractSerieLayer.drawStatistics(graphics2D, d3 * d11 + d4, d3, false);
                        d11 += 1.0;
                    }
                }
                if (bl) {
                    FloatWindowSerie.this.markSelectionObjects(graphics2D, FloatWindowSerie.this.selectionColor);
                }
            }
        }

        public void translateToScreenInt(int[] nArray, ZoneLeaf zoneLeaf) {
            int n = FloatWindowSerie.this.plotAxisLayerPanel.getLayerCount();
            double d = this.sw / (double)this.width * FloatWindowSerie.this.getRange(0, 0).getAbs();
            double d2 = 0.5 * d;
            for (int i = 0; i < n && !zoneLeaf.getLayer().equals(FloatWindowSerie.this.plotAxisLayerPanel.getLayerAtIndex(i)); ++i) {
                d2 += d;
            }
            this.translateToScreenInt(nArray, (double)zoneLeaf.getPrimaryIndex() + d2, zoneLeaf.getValue((byte)1), 0);
        }
    }

    protected class PlotXserieAxis
    extends FloatWindowPlot2D.PlotXaxis {
        public PlotXserieAxis(Color color, double d, double d2) {
            super(color, d, d2);
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            if (!FloatWindowSerie.this.serieList.isEmpty()) {
                Iterator iterator = FloatWindowSerie.this.serieList.iterator();
                if (FloatWindowSerie.this.plotAxisLayerPanel.getLayerCount() > 0 && FloatWindowSerie.this.plotAxisLayerPanel.getLayerAtIndex(0) instanceof AbstractSerieLayer) {
                    graphics2D.setFont(((AbstractSerieLayer)FloatWindowSerie.this.plotAxisLayerPanel.getLayerAtIndex(0)).getLabelFont());
                } else {
                    graphics2D.setFont(FloatWindowSerie.this.AxisFont);
                }
                graphics2D.setStroke(FloatWindowSerie.this.axisStroke);
                Color color = FloatWindowSerie.this.getGridColor();
                Color color2 = FloatWindowSerie.this.getAxisColor();
                while (iterator.hasNext()) {
                    TickInfo tickInfo = (TickInfo)iterator.next();
                    int n = (int)tickInfo.pos;
                    if (n <= FloatWindowSerie.this.plotGround.getOrigoX() || n >= FloatWindowSerie.this.plotGround.getOrigoX() + FloatWindowSerie.this.plotGround.getWidth()) continue;
                    Line2D.Double double_ = new Line2D.Double(n, (double)this.origoY + 3.0 * d, n, this.origoY);
                    graphics2D.setColor(color);
                    graphics2D.draw(double_);
                    graphics2D.setColor(color2);
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate((double)n, (double)this.origoY + 5.0 * d);
                    graphics2D.rotate(1.5707963267948966);
                    if (IniManager.isMacOS()) {
                        IniManager.drawImageString(graphics2D, tickInfo.text, color2, FloatWindowSerie.this.textRelative);
                    } else {
                        graphics2D.scale(FloatWindowSerie.this.textRelative, FloatWindowSerie.this.textRelative);
                        graphics2D.drawString(tickInfo.text, 0, 0);
                    }
                    graphics2D.setTransform(affineTransform);
                }
                graphics2D.setPaint(Color.black);
            }
        }

        @Override
        public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        }
    }
}

