/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.serie.statistic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.FloatWindowSerie;
import se.prediktera.map.plot.axisplot.plot2D.spectral.FloatWindowSpectral;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Statistics.AbstractStatisticsInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class LimitsSerieStatisticInfo
extends AbstractStatisticsInfo {
    int[] screenmin = new int[2];
    int[] screenmax = new int[2];
    Color[] colors = new Color[]{Color.red, Color.yellow};
    double[] climits;

    @Override
    public void adjustMinMax(AbstractAxisLayer abstractAxisLayer, int n, double[] dArray) {
    }

    @Override
    public void calculate(AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n) {
        double d = this.calculateMeanAndVariance(abstractAxisLayer);
        if (d > 1.0) {
            double[] dArray = new double[]{4.0, 1.5};
            this.climits = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.climits[i] = Math.sqrt(dArray[i] * 2.0 * (d * d - 1.0) / (d * (d - 2.0)));
            }
        }
    }

    @Override
    public AbstractSettingsPanel createSettingsPanel() {
        return new AbstractSettingsPanel(){};
    }

    @Override
    public void draw(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
    }

    @Override
    public void drawInBg(Graphics2D graphics2D, AbstractAxisPlot abstractAxisPlot, AbstractAxisLayer abstractAxisLayer, AbstractDataMatrix abstractDataMatrix, int n, double d, double d2) {
        if (this.climits != null && abstractAxisPlot instanceof FloatWindowPlot2D) {
            FloatWindowPlot2D floatWindowPlot2D = (FloatWindowPlot2D)abstractAxisPlot;
            AxisRange axisRange = floatWindowPlot2D.getRange(0, 0);
            double d3 = axisRange.getMin();
            double d4 = axisRange.getMax();
            AxisRange axisRange2 = floatWindowPlot2D.getRange(1, 0);
            double d5 = axisRange2.getMin();
            double d6 = axisRange2.getMax();
            floatWindowPlot2D.translateToScreenInt(this.screenmin, d3, d6);
            floatWindowPlot2D.translateToScreenInt(this.screenmax, d4, d5);
            for (int i = this.climits.length - 1; i >= 0; --i) {
                double d7 = this.xMean - this.xVariance * this.climits[i];
                double d8 = this.yMean - this.yVariance * this.climits[i];
                double d9 = this.xMean + this.xVariance * this.climits[i];
                double d10 = this.yMean + this.yVariance * this.climits[i];
                Color color = graphics2D.getColor();
                graphics2D.setColor(Color.black);
                int[] nArray = new int[2];
                int[] nArray2 = new int[2];
                floatWindowPlot2D.translateToScreenInt(nArray, d7, d10);
                floatWindowPlot2D.translateToScreenInt(nArray2, d9, d8);
                nArray2[0] = nArray2[0] - nArray[0];
                nArray2[1] = nArray2[1] - nArray[1];
                Rectangle2D.Double double_ = new Rectangle2D.Double(this.screenmin[0] + 1, this.screenmin[1] + 1, this.screenmax[0], this.screenmax[1]);
                Rectangle2D.Double double_2 = new Rectangle2D.Double(nArray[0], nArray[1], nArray2[0], nArray2[1]);
                Area area = new Area(double_);
                Area area2 = new Area(double_2);
                area.subtract(area2);
                Color color2 = new Color(this.colors[i].getRed(), this.colors[i].getGreen(), this.colors[i].getBlue(), 150);
                graphics2D.setColor(color2);
                graphics2D.fill(area);
                graphics2D.setColor(Color.black);
                graphics2D.draw(double_2);
                graphics2D.setColor(color);
            }
        }
    }

    @Override
    public void load(MapProperty mapProperty) throws IOException {
    }

    @Override
    public void save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public boolean supportData(DataTreeInterface dataTreeInterface) {
        return RegisterKeyManager.isPredikteraDevelopmentLicense() && dataTreeInterface instanceof FloatWindowSerie || dataTreeInterface instanceof FloatWindowSpectral;
    }

    @Override
    public String toNiceString() {
        return "Limits";
    }

    public String toString() {
        return "[LIMITS]";
    }

    @Override
    protected int getType() {
        return 25;
    }
}

