/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.spectral;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot2D.FloatWindowPlot2D;
import se.prediktera.map.plot.axisplot.plot2D.PlotImages;
import se.prediktera.map.plot.axisplot.plot2D.spectral.SpectralAccessorPanel;
import se.prediktera.map.plot.axisplot.plot2D.spectral.SpectralLayer;
import se.prediktera.map.plot.axisplot.plot3D.MatrixFuncs;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Lines.LineStyle;
import se.prediktera.map.plot.axisplot.windows.PlotZoneScroll;
import se.prediktera.map.plot.axisplot.windows.PlotZoneText;

public class FloatWindowSpectral
extends FloatWindowPlot2D {
    private PlotZoneScroll scrollBar;
    protected Font spectraFont = null;
    private final SpectralAccessorPanel accessorPanel;
    private boolean showMultiSpectral = false;
    private boolean hasSameAxisRangeY = true;
    private int visibleRowCount = 4;
    private int textSize = 8;
    private int lineWidth = 1;
    private boolean drawLineSelection = true;

    public FloatWindowSpectral(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.selectionArray = new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
        this.accessorPanel = new SpectralAccessorPanel(this, plotInit, null, null);
        this.setAccessorPanel(this.accessorPanel);
        this.getRange(0, 0).setDoublePrecition(false);
    }

    public FloatWindowSpectral(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.selectionArray = randomInputStream.getSaveVersion() > 89L && mapProperty.hasProperty("selArr") ? new BooleanArray(mapProperty.getLVBooleanArray()) : new BooleanArray(this.getOriginalSize(this.isRowPrimary()));
        this.showMultiSpectral = !mapProperty.getPropertyBoolean("rs", this.showMultiSpectral);
        this.visibleRowCount = mapProperty.getPropertyInt("nr", this.visibleRowCount);
        this.hasSameAxisRangeY = mapProperty.getPropertyBoolean("yrange", this.hasSameAxisRangeY);
        this.lineWidth = mapProperty.getPropertyInt("lw", this.lineWidth);
        this.textSize = mapProperty.getPropertyInt("tsize", this.textSize);
        this.accessorPanel = new SpectralAccessorPanel(this, this.getPlotInit(), randomInputStream, mapProperty);
        this.setAccessorPanel(this.accessorPanel);
        this.getRange(0, 0).setDoublePrecition(false);
    }

    @Override
    public AbstractAxisLayer createLayer(PlotInit plotInit, int n) {
        return new SpectralLayer(this, plotInit, null, null, n);
    }

    public SpectralAccessorPanel getAccessorPanel() {
        return this.accessorPanel;
    }

    @Override
    public Font getDescriptionFontX() {
        return this.accessorPanel.getDescriptionFont();
    }

    @Override
    public int getHandWidth() {
        return 3;
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneArray zoneArray = (ZoneArray)this.getLeafAtIndex(abstractAxisLayer, -1, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneArray != null) {
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneArray);
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            stringBuilder.append("Spectr:").append(abstractAxisLayer.getDescription(0, (byte)1, zoneArray.getSecondaryIndex())).append("\n");
            int n3 = zoneArray.getNoChildren();
            for (int i = 0; i < n3; ++i) {
                if (zoneArray.getPrimaryIndex(i) != n) continue;
                stringBuilder.append("Descr: ").append(abstractAxisLayer.getDescription(0, (byte)0, abstractAxisLayer.getPrimaryIndexArray()[i])).append("\n");
                stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneArray.getValue(i, (byte)0))).append("\n");
                stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneArray.getValue(i, (byte)1))).append("\n");
                break;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public double[] getMinmax(int n, int n2) {
        if (this.getRanges(1).size() <= 1) {
            n2 = -1;
        }
        double[] dArray = new double[]{0.0, 0.0};
        if (this.plotAxisLayerPanel == null) {
            return dArray;
        }
        if (n == 1 || this.hasInteractSecond()) {
            int n3 = this.plotAxisLayerPanel.getLayerCount();
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                SpectralLayer spectralLayer = (SpectralLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (spectralLayer == null || spectralLayer.isSubLayer()) continue;
                spectralLayer.beginCalculations();
                List<ZoneLeaf> list = spectralLayer.getRootList();
                int n4 = -1;
                for (ZoneLeaf zoneLeaf : list) {
                    if (n2 >= 0 && n2 != ++n4) continue;
                    int n5 = zoneLeaf.getNoChildren();
                    for (int j = 0; j < n5; ++j) {
                        double d;
                        if (zoneLeaf.isMissing(j) || Double.isInfinite(d = zoneLeaf.getValue(j, (byte)n)) || Double.isNaN(d)) continue;
                        if (bl) {
                            dArray[0] = d;
                            dArray[1] = d;
                            bl = false;
                            continue;
                        }
                        if (dArray[0] > d) {
                            dArray[0] = d;
                            continue;
                        }
                        if (!(dArray[1] < d)) continue;
                        dArray[1] = d;
                    }
                }
                spectralLayer.endCalculations();
            }
        } else {
            dArray[0] = 0.0;
            int n6 = this.plotAxisLayerPanel.getLayerCount();
            for (int i = 0; i < n6; ++i) {
                SpectralLayer spectralLayer = (SpectralLayer)this.plotAxisLayerPanel.getLayerAtIndex(i);
                if (spectralLayer == null || spectralLayer.isSubLayer()) continue;
                dArray[1] = spectralLayer.getListSize() - 1;
                break;
            }
        }
        return dArray;
    }

    @Override
    public int getSelectedObjectCount() {
        return this.selectionList.size() * this.selectionArray.getSetCount();
    }

    public int getSpectralFontSize() {
        return this.textSize;
    }

    public int getSpectralLineWidth() {
        return this.lineWidth;
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public void modelUpdated() {
        if (this.accessorPanel == null) {
            return;
        }
        Map<Byte, AbstractPlotSettingsBox> map = this.accessorPanel.getSettingsBoxMap();
        if (map != null) {
            for (AbstractPlotSettingsBox abstractPlotSettingsBox : map.values()) {
                abstractPlotSettingsBox.forceUpdate();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isLayoutEnable()) {
            this.scrollBar.mouseDragged(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.scrollBar.isInside(mouseEvent.getX(), mouseEvent.getY()) && !this.isLayoutEnable()) {
            this.scrollBar.mousePressed(mouseEvent);
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isLayoutEnable()) {
            this.scrollBar.mouseReleased(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.rubberband != null && !mouseEvent.isConsumed()) {
                this.rubberbandEnded(this.rubberband, mouseEvent.getModifiersEx(), mouseEvent);
                this.rubberband.clear();
                mouseEvent.consume();
            }
            super.mouseReleased(mouseEvent);
        }
    }

    public void rubberbandEnded(AbstractRubberband abstractRubberband, int n, MouseEvent mouseEvent) {
        boolean bl;
        Rectangle rectangle = abstractRubberband.getBoundingBox();
        boolean bl2 = (n & 0x40) == 64;
        boolean bl3 = bl = (n & 0x80) == 128;
        if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            if (!bl && !bl2) {
                this.selectedItems(this.selectionList, false, false);
            }
            LinkedList<ZoneLeaf> linkedList = this.collectRectangleFromScreen(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false, abstractRubberband.getRubberType());
            Iterator iterator = linkedList.iterator();
            int[] nArray = new int[2];
            while (iterator.hasNext()) {
                ZoneLeaf zoneLeaf = (ZoneLeaf)iterator.next();
                if (this.hasInteractSecond()) {
                    ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                    int n2 = zoneArray.getSecondaryIndex();
                    boolean bl4 = false;
                    int n3 = zoneArray.getFirstTagged();
                    while (n3 >= 0) {
                        int n4 = zoneArray.getPrimaryIndex(n3);
                        this.plotGround.translateToScreenInt(nArray, (double)n3 + 1.0, zoneArray.getValue(n3, n4, n2, (byte)1), 0);
                        if (!this.mustBeBoundedInSelection() || abstractRubberband.isInside(nArray[0], nArray[1])) {
                            if (bl && this.selectionArray.get(n3)) {
                                if (bl2) {
                                    this.selectionArray.set(n4, false);
                                }
                            } else if (!(bl && bl2 || !zoneArray.isVisible(n3))) {
                                this.selectionArray.set(n4);
                                if (!bl4 && !this.selectionList.contains(zoneArray)) {
                                    this.selectionList.add(zoneArray);
                                }
                                bl4 = true;
                            }
                        }
                        n3 = zoneArray.getNextTagged(n3);
                    }
                    continue;
                }
                if (this.mustBeBoundedInSelection() && !abstractRubberband.isInside(nArray[0], nArray[1])) continue;
                if (bl && bl2) {
                    this.selectionList.remove(zoneLeaf);
                    continue;
                }
                if (!zoneLeaf.isVisible() || this.selectionList.contains(zoneLeaf)) continue;
                this.selectionList.add(zoneLeaf);
            }
            this.selectedItems(this.selectionList, true, true);
            this.repaintPlot((byte)2);
        } else if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Zoom) {
            if (abstractRubberband instanceof RubberbandNormal) {
                RubberbandNormal rubberbandNormal = (RubberbandNormal)abstractRubberband;
                double d = rubberbandNormal.getBWidth() == 0 ? -3.0 : 3.0;
                double[] dArray = this.translateToPlot(rectangle.x, rectangle.y);
                int n5 = this.plotGround.getPlotUnderCoords(rectangle.x, rectangle.y);
                this.ZoomContinues(dArray[0], dArray[1], d, n5);
            } else {
                double[] dArray;
                int n6 = rectangle.x;
                int n7 = rectangle.y == mouseEvent.getY() ? rectangle.y + rectangle.height - 1 : rectangle.y;
                int n8 = this.plotGround.getPlotUnderCoords(n6, n7);
                double[] dArray2 = this.translateToPlot(rectangle.x, rectangle.y + rectangle.height, n8);
                if (Double.compare(dArray2[0], (dArray = this.translateToPlot(rectangle.x + rectangle.width, rectangle.y, n8))[0]) == 0 || Double.compare(dArray2[1], dArray[1]) == 0) {
                    double d = bl2 || bl ? 3.0 : -3.0;
                    double[] dArray3 = this.translateToPlot(rectangle.x, rectangle.y);
                    this.ZoomContinues(dArray3[0], dArray3[1], d, n8);
                } else {
                    this.getRange(0, n8).setMinMax(dArray2[0], dArray[0]);
                    this.getRange(1, n8).setMinMax(dArray2[1], dArray[1]);
                }
            }
            this.calculateAndRepaintSetAxis(true, false);
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBooleanArray("selArr", this.selectionArray.getInternalArray());
        randomOutputStream.writePropertyBoolean("rs", !this.showMultiSpectral);
        randomOutputStream.writePropertyInt("nr", this.visibleRowCount);
        randomOutputStream.writePropertyBoolean("yrange", this.hasSameAxisRangeY);
        randomOutputStream.writePropertyInt("lw", this.lineWidth);
        randomOutputStream.writePropertyInt("tsize", this.textSize);
        this.accessorPanel.SaveProperty(randomOutputStream);
    }

    public void scrollToFirstSelected() {
        ((PlotSpectral)this.plotGround).scrollToFirstSelected();
    }

    @Override
    public void selectedItems(AbstractAxisPlot.SelectionList selectionList, boolean bl, boolean bl2) {
        if (this.hasInteractSecond()) {
            for (ZoneArray zoneArray : selectionList) {
                zoneArray.setSelected(bl);
            }
            if (!bl) {
                for (int i = 0; i < this.selectionArray.size(); ++i) {
                    this.selectionArray.set(i, false);
                }
                selectionList.clear();
            }
            if (bl2 && this.selectionList != null && this.plot.hasInteractivity()) {
                this.plot.getPlot_GUI().getProject_GUI().doInteraction(this);
            }
        } else {
            super.selectedItems(selectionList, bl, bl2);
        }
    }

    @Override
    public void selectNnearest(int n, int n2) {
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.accessorPanel.setCreated(abstractWindow_GUI, bl);
    }

    @Override
    public void setSettingBoxOption(byte by, Object[] objectArray) {
        super.setSettingBoxOption(by, objectArray);
        this.accessorPanel.setSettingsBoxOption(by, objectArray);
    }

    public void setShowMultiSpectral(boolean bl) {
        this.showMultiSpectral = bl;
        ArrayList<AxisRange> arrayList = this.getRanges(1);
        if ((!this.showMultiSpectral || this.hasSameAxisRangeY) && arrayList.size() > 1) {
            AxisRange axisRange = arrayList.get(0);
            arrayList.clear();
            arrayList.add(axisRange);
        }
        this.calculateAxisTicks(1, true, true);
    }

    public void setSpectralFontSize(int n) {
        this.textSize = n;
        if (this.spectraFont == null || this.spectraFont.getSize() != this.textSize) {
            this.spectraFont = new Font("SansSerif", 0, this.textSize);
        }
    }

    public void setSpectralLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setSpectrasHaveSameAxisRangeY(boolean bl) {
        this.hasSameAxisRangeY = bl;
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = n;
    }

    public boolean showMultiSpectral() {
        return this.showMultiSpectral;
    }

    public boolean spectrasHaveSameAxisRangeY() {
        return this.hasSameAxisRangeY;
    }

    @Override
    public void translateToScreenInt(int[] nArray, ZoneLeaf zoneLeaf) {
        if (zoneLeaf instanceof ZoneArray) {
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            int n = zoneLeaf.getSecondaryIndex();
            int n2 = zoneArray.getFirstTagged();
            if (n2 < 0) {
                return;
            }
            int n3 = zoneLeaf.getPrimaryIndex(n2);
            this.plotGround.translateToScreenInt(nArray, (double)n2 + 1.0, zoneArray.getValue(n2, n3, n, (byte)1), 0);
        }
    }

    @Override
    public void updateLables() {
    }

    @Override
    protected void cleanUpChild() {
        if (this.accessorPanel != null) {
            this.accessorPanel.cleanUp();
        }
        super.cleanUpChild();
    }

    @Override
    protected FloatWindowPlot2D.PlotGrid createPlotGround() {
        return new PlotSpectral(0.0, 0.0, Color.white);
    }

    @Override
    protected void doQuickInteraction(ZoneLeaf zoneLeaf) {
        Project_GUI project_GUI = this.plot.getPlot_GUI().getProject_GUI();
        if (project_GUI != null) {
            if (zoneLeaf instanceof ZoneArray) {
                ZoneArray zoneArray = (ZoneArray)zoneLeaf;
                int n = zoneArray.getFirstTagged();
                int n2 = this.getPrimaryMatrixTag();
                int n3 = zoneArray.getSecondaryIndex();
                int n4 = this.getSecondaryMatrixTag();
                int n5 = zoneArray.getPrimaryIndex(n);
                project_GUI.doQuickInteraction(this, n2, n3, n4, n5);
            } else {
                project_GUI.doQuickInteraction(this, -1, -1, -1, -1);
            }
        }
    }

    @Override
    protected float getBlackBorderSize() {
        return 1.5f;
    }

    protected String getDescription(int n) {
        return this.accessorPanel.getDescription(n);
    }

    protected int getDescriptionCount() {
        return this.accessorPanel.getDescriptionCount();
    }

    @Override
    protected int getPlotHeight() {
        return ((PlotSpectral)this.plotGround).getPlotHeight();
    }

    @Override
    protected int getPlotWidth() {
        return ((PlotSpectral)this.plotGround).getPlotWidth();
    }

    @Override
    protected String getToolTip(ZoneLeaf zoneLeaf) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        AbstractAxisLayer abstractAxisLayer = zoneLeaf.getLayer();
        stringBuilder.append("<tr><th colspan=\"2\">").append(abstractAxisLayer.toString()).append("</th></tr>");
        String string = abstractAxisLayer.getComment(zoneLeaf, "<br>");
        if (string != null) {
            stringBuilder.append("<tr><td colspan=\"2\">").append(string).append("</td></tr>");
        }
        stringBuilder.append("<tr><td>Spectr:</td><td>").append(abstractAxisLayer.getDescription(0, (byte)1, zoneLeaf.getSecondaryIndex())).append("</td></tr>");
        if (zoneLeaf instanceof ZoneArray) {
            ZoneArray zoneArray = (ZoneArray)zoneLeaf;
            int n = zoneArray.getFirstTagged();
            for (int i = 0; i < abstractAxisLayer.getDescriptionCount(); ++i) {
                stringBuilder.append("<tr><td>" + abstractAxisLayer.getDescriptionTitle(i) + ":</td><td>").append(abstractAxisLayer.getDescription(i, (byte)0, abstractAxisLayer.getPrimaryIndexArray()[n])).append("</td></tr>");
            }
            stringBuilder.append("<tr><td>X:</td><td>").append(NiceDataFormat.toString(zoneArray.getValue(n, (byte)0))).append("</td></tr>");
            stringBuilder.append("<tr><td>Y:</td><td>").append(NiceDataFormat.toString(zoneArray.getValue(n, (byte)1))).append("</td></tr>");
        }
        stringBuilder.append("</table></html>");
        return stringBuilder.toString();
    }

    @Override
    protected float getWhiteBorderSize() {
        return 0.0f;
    }

    @Override
    protected boolean hasZoneArray() {
        return true;
    }

    @Override
    protected void init() {
        this.plotGround = this.createPlotGround();
        this.addPlotZone(this.plotGround, 4);
        this.scrollBar = new PlotZoneScroll(this, Color.white, 0.1, 0.8888888888888888, true);
        this.addPlotZone(this.scrollBar, 3);
        this.scrollBar.show(false);
        this.addPlotZone(new PlotZoneText(Color.white, 0.0, 0.1, false), 0);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    protected void interactiveSelectionFinished(byte by) {
        this.scrollToFirstSelected();
        super.interactiveSelectionFinished((byte)7);
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preparePaint(Graphics2D graphics2D, double d) {
        List<TickInfo> list;
        super.preparePaint(graphics2D, d);
        int n = -1;
        double d2 = this.getXmax();
        double d3 = 0.0;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        AxisRange axisRange = this.getRange(0, 0);
        List<TickInfo> list2 = list = axisRange.getTickList();
        synchronized (list2) {
            Iterator<TickInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                TickInfo tickInfo = iterator.next();
                int n2 = (int)(iterator.hasNext() ? tickInfo.pos : d2);
                if (n2 != n && n2 >= 0 && tickInfo.pos < d2) {
                    tickInfo.pos = n2;
                    tickInfo.text = this.getDescription(n2);
                    double d4 = NiceDataFormat.toNumber(tickInfo.text);
                    if (!Double.isNaN(d4)) {
                        tickInfo.text = NiceDataFormat.toString(d4, 4);
                    }
                    n = n2;
                    double d5 = fontMetrics.stringWidth(tickInfo.text);
                    if (!(d3 < d5)) continue;
                    d3 = d5;
                    continue;
                }
                if (Double.compare(tickInfo.pos, 0.0) == 0) continue;
                iterator.remove();
            }
        }
        double d6 = this.plotGround.translateToScreenDouble(this.xGap, 0.0, 0)[0] - this.plotGround.translateToScreenDouble(0.0, 0.0, 0)[0];
        double d7 = d6 * 0.9 / d3;
        if (this.textRelative > d7) {
            this.textRelative = d7;
        }
        if (this.textRelative > (d7 = ((double)this.plotXaxis.getHeight() - 5.0 * d) * 0.97 / (double)fontMetrics.getHeight())) {
            this.textRelative = d7;
        }
        if (this.textRelative > d) {
            this.textRelative = d;
        }
        if (this.textRelative < 1.2) {
            this.textRelative = 1.2;
        }
    }

    public void setDrawLineSelection(boolean bl) {
        this.drawLineSelection = bl;
    }

    private class PlotSpectral
    extends FloatWindowPlot2D.PlotGrid {
        private int plotHeight;
        private int plotsToShow;
        private int fullWidth;
        private int fullHeight;
        private final double[] sMin;
        private final double[] sMax;

        public PlotSpectral(double d, double d2, Color color) {
            super(color, d, d2);
            this.plotsToShow = -1;
            this.fullWidth = 0;
            this.fullHeight = 0;
            this.sMin = new double[2];
            this.sMax = new double[2];
            FloatWindowSpectral.this.plotXaxis = FloatWindowSpectral.this.createXaxis();
            FloatWindowSpectral.this.plotYaxis = new FloatWindowPlot2D.PlotYaxis(Color.white, 0.1, 1.0);
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl) {
            return this.collectRectangleFromData(dArray, dArray2, bl, -1, AbstractRubberband.RubberType.Normal);
        }

        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl, int n, AbstractRubberband.RubberType rubberType) {
            return this.collectRectangleFromData(dArray, dArray2, bl, n, rubberType, FloatWindowSpectral.this.getRange(0, 0), FloatWindowSpectral.this.getRange(1, 0));
        }

        public LinkedList<ZoneLeaf> collectRectangleFromData(double[] dArray, double[] dArray2, boolean bl, int n, AbstractRubberband.RubberType rubberType, AxisRange axisRange, AxisRange axisRange2) {
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            LinkedList<ZoneLeaf> linkedList2 = new LinkedList<ZoneLeaf>();
            try {
                int n2;
                int n3 = (int)dArray[0] - 1;
                if (n3 < 0) {
                    n3 = 0;
                }
                if ((n2 = (int)Math.ceil(dArray2[0])) < 0) {
                    n2 = 0;
                }
                float[] fArray = new float[]{(float)(dArray2[0] + dArray[0]) * 0.5f, (float)(dArray2[1] + dArray[1]) * 0.5f, 0.0f};
                float[] fArray2 = new float[3];
                float[] fArray3 = new float[3];
                int n4 = FloatWindowSpectral.this.plotAxisLayerPanel.getLayerCount();
                for (int i = 0; i < n4; ++i) {
                    SpectralLayer spectralLayer = (SpectralLayer)FloatWindowSpectral.this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (spectralLayer == null || spectralLayer.isSubLayer() || !spectralLayer.isLayerReady()) continue;
                    int n5 = 0;
                    List<ZoneLeaf> list = spectralLayer.getRootList();
                    for (int j = 0; j < list.size(); ++j) {
                        int n6;
                        ZoneLeaf zoneLeaf = list.get(j);
                        if (n >= 0 && ++n5 != n) continue;
                        if (zoneLeaf instanceof ZoneArray) {
                            int n7;
                            n6 = zoneLeaf.getNoChildren();
                            boolean bl2 = false;
                            boolean bl3 = false;
                            int n8 = -1;
                            for (n7 = 0; n7 < n3 && n7 < n6; ++n7) {
                                zoneLeaf.setTagged(n7, false);
                            }
                            for (n7 = n2; n7 < n6; ++n7) {
                                zoneLeaf.setTagged(n7, false);
                            }
                            for (n7 = n3; n7 < n2 && n7 < n6; ++n7) {
                                fArray2[0] = (float)n7 + 1.0f;
                                fArray2[1] = (float)zoneLeaf.getValue(n7, (byte)1);
                                if (!(!zoneLeaf.isVisibleAndNotMissing(n7) || FloatWindowSpectral.this.selectionArray.get(zoneLeaf.getPrimaryIndex(n7)) && bl)) {
                                    boolean bl4;
                                    boolean bl5 = bl4 = (double)fArray2[0] >= dArray[0] && (double)fArray2[0] <= dArray2[0] && (double)fArray2[1] >= dArray[1] && (double)fArray2[1] <= dArray2[1];
                                    if (bl4 && !bl2) {
                                        if (bl3) {
                                            linkedList2.clear();
                                            bl3 = false;
                                        }
                                        linkedList.add(zoneLeaf);
                                        bl2 = true;
                                    }
                                    zoneLeaf.setTagged(n7, bl4);
                                    if (n8 >= 0 && linkedList.isEmpty()) {
                                        float[] fArray4 = MatrixFuncs.minus(fArray2, fArray3);
                                        float[] fArray5 = MatrixFuncs.minus(fArray, fArray3);
                                        float f = MatrixFuncs.dot(fArray5, fArray4) / MatrixFuncs.dot(fArray4, fArray4);
                                        if (f >= 0.0f && f <= 1.0f) {
                                            float[] fArray6 = MatrixFuncs.plus(fArray3, MatrixFuncs.scale(fArray4, f));
                                            float[] fArray7 = MatrixFuncs.minus(fArray, fArray6);
                                            fArray7[0] = (float)((double)fArray7[0] * axisRange.getDivAbs());
                                            fArray7[1] = (float)((double)fArray7[1] * axisRange2.getDivAbs());
                                            fArray7[0] = fArray7[0] * (float)this.width;
                                            fArray7[1] = fArray7[1] * (float)this.height;
                                            float f2 = (float)Math.sqrt(fArray7[0] * fArray7[0] + fArray7[1] * fArray7[1]);
                                            if (f2 <= 5.0f) {
                                                if (!bl3) {
                                                    linkedList2.add(zoneLeaf);
                                                    bl3 = true;
                                                }
                                                if (f < 0.5f) {
                                                    zoneLeaf.setTagged(n8, true);
                                                } else {
                                                    zoneLeaf.setTagged(n7, true);
                                                }
                                            }
                                        }
                                    }
                                    float[] fArray8 = fArray3;
                                    fArray3 = fArray2;
                                    fArray2 = fArray8;
                                    n8 = n7;
                                    continue;
                                }
                                zoneLeaf.setTagged(n7, false);
                            }
                            continue;
                        }
                        fArray2[0] = n5;
                        fArray2[1] = (float)zoneLeaf.getValue((byte)1);
                        n6 = 0;
                        if (zoneLeaf.isVisibleAndNotMissing() || !bl) {
                            int n9 = n6 = (double)fArray2[0] >= dArray[0] && (double)fArray2[0] <= dArray2[0] && (double)fArray2[1] >= dArray[1] && (double)fArray2[1] <= dArray2[1] ? 1 : 0;
                            if (n6 != 0) {
                                linkedList.add(zoneLeaf);
                            }
                        }
                        zoneLeaf.setSelected(n6 != 0);
                    }
                }
            }
            catch (Exception exception) {
                Logg.error(exception.getMessage(), new Object[0]);
            }
            if (linkedList.isEmpty()) {
                return linkedList2;
            }
            return linkedList;
        }

        @Override
        public LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType) {
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            if (this.plotsToShow < 1) {
                AxisRange axisRange = FloatWindowSpectral.this.getRange(0, 0);
                AxisRange axisRange2 = FloatWindowSpectral.this.getRange(1, 0);
                this.translateToPlot(dArray, n, n2 + n4, 0, axisRange, axisRange2);
                this.translateToPlot(dArray2, n + n3, n2, 0, axisRange, axisRange2);
                return this.collectRectangleFromData(dArray, dArray2, bl, -1, rubberType, axisRange, axisRange2);
            }
            LinkedList<ZoneLeaf> linkedList = new LinkedList<ZoneLeaf>();
            int n5 = 0;
            int n6 = this.origoY;
            while (n5 < this.plotsToShow) {
                int n7 = n2;
                int n8 = n2 + n4;
                if (n7 < n6 + this.plotHeight && n8 >= n6) {
                    int n9;
                    int n10;
                    if (n7 < n6) {
                        n7 = n6;
                    }
                    if (n8 >= n6 + this.plotHeight) {
                        n8 = n6 + this.plotHeight - 1;
                    }
                    if ((n10 = this.getSecondaryIndex(n9 = n5 + FloatWindowSpectral.this.scrollBar.getBarPos())) >= 0) {
                        AxisRange axisRange = FloatWindowSpectral.this.getRange(0, n9);
                        AxisRange axisRange3 = FloatWindowSpectral.this.getRange(1, n9);
                        this.translateToPlot(dArray, n, n8, n9, axisRange, axisRange3);
                        this.translateToPlot(dArray2, n + n3, n7, n9, axisRange, axisRange3);
                        linkedList.addAll(this.collectRectangleFromData(dArray, dArray2, bl, n9, rubberType, axisRange, axisRange3));
                    }
                }
                ++n5;
                n6 += this.plotHeight;
            }
            return linkedList;
        }

        @Override
        public int getOrigoY(int n) {
            return this.origoY + this.plotHeight * (n - FloatWindowSpectral.this.scrollBar.getBarPos());
        }

        public int getPlotHeight() {
            return FloatWindowSpectral.this.plotYaxis.getHeight();
        }

        @Override
        public int getPlotUnderCoords(double d, double d2) {
            if (this.plotsToShow < 1) {
                return 0;
            }
            return (int)((d2 - (double)this.origoY) / (double)this.plotHeight) + FloatWindowSpectral.this.scrollBar.getBarPos();
        }

        public int getPlotWidth() {
            return FloatWindowSpectral.this.plotXaxis.getWidth();
        }

        public int[] getVisibilityArray() {
            int n;
            int n2;
            int n3 = FloatWindowSpectral.this.plotAxisLayerPanel.getLayerCount();
            if (n3 == 0) {
                return null;
            }
            AbstractAxisLayer abstractAxisLayer = FloatWindowSpectral.this.plotAxisLayerPanel.getLayerAtIndex(0);
            if (abstractAxisLayer == null) {
                return null;
            }
            int n4 = abstractAxisLayer.getNrObjects();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n4);
            ArrayList<Iterator<ZoneLeaf>> arrayList2 = new ArrayList<Iterator<ZoneLeaf>>(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(FloatWindowSpectral.this.plotAxisLayerPanel.getLayerAtIndex(n2).getRootList().iterator());
            }
            for (n2 = 0; n2 < n4; ++n2) {
                n = 0;
                int n5 = n2;
                for (int i = 0; i < n3 && n == 0; ++i) {
                    Iterator iterator;
                    AbstractAxisLayer abstractAxisLayer2 = FloatWindowSpectral.this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (abstractAxisLayer2 == null || abstractAxisLayer2.isSubLayer() || !(iterator = (Iterator)arrayList2.get(i)).hasNext()) continue;
                    ZoneLeaf zoneLeaf = (ZoneLeaf)iterator.next();
                    int n6 = n = n != 0 || zoneLeaf.isVisible() ? 1 : 0;
                    if (n == 0) continue;
                    n5 = zoneLeaf.getSecondaryIndex();
                    break;
                }
                if (n == 0) continue;
                arrayList.add(n5);
            }
            int[] nArray = new int[arrayList.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            return nArray;
        }

        @Override
        public boolean isInside(int n, int n2) {
            return n >= this.origoX && n < this.origoX + this.fullWidth && n2 >= this.origoY && n2 < this.origoY + this.fullHeight;
        }

        @Override
        public void paint(Graphics2D graphics2D, byte by, double d) {
            ArrayList<AxisRange> arrayList = FloatWindowSpectral.this.getRanges(1);
            if (FloatWindowSpectral.this.plotAxisLayerPanel.getLayerCount() <= 0) {
                return;
            }
            if (FloatWindowSpectral.this.showMultiSpectral && !FloatWindowSpectral.this.hasSameAxisRangeY && arrayList.size() <= 1) {
                try {
                    for (int i = 1; i < FloatWindowSpectral.this.plotAxisLayerPanel.getLayerAtIndex(0).getNrObjects(); ++i) {
                        arrayList.add((AxisRange)arrayList.get(0).clone());
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    ErrorHandler.logAndShowEvinceErrorDialogForException(cloneNotSupportedException);
                }
                FloatWindowSpectral.this.calculateAxisTicks(1, true, true);
            }
            PlotImages.setBorderColor(FloatWindowSpectral.this.getObjectBorderColor());
            int[] nArray = null;
            if (FloatWindowSpectral.this.showMultiSpectral) {
                int n = FloatWindowSpectral.this.visibleRowCount;
                FloatWindowSpectral.this.scrollBar.setBarSize(n);
                FloatWindowSpectral.this.scrollBar.show(true);
                nArray = this.getVisibilityArray();
                if (nArray != null) {
                    FloatWindowSpectral.this.scrollBar.setNsteps(nArray.length);
                }
                if (n != this.plotsToShow) {
                    this.plotsToShow = n;
                    this.setPlotSize(this.origoX, this.origoY, this.fullWidth, this.fullHeight);
                }
            } else if (this.plotsToShow > 0) {
                this.plotsToShow = -1;
                FloatWindowSpectral.this.scrollBar.show(false);
                FloatWindowSpectral.this.scrollBar.setBarPos(0);
                this.setPlotSize(this.origoX, this.origoY, this.fullWidth, this.fullHeight);
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.plotsToShow > 0 && nArray != null) {
                int n;
                for (int i = n = FloatWindowSpectral.this.scrollBar.getBarPos(); i < n + this.plotsToShow && i < nArray.length; ++i) {
                    this.paint(graphics2D, by, d, i, nArray[i]);
                    graphics2D.translate(0, this.plotHeight);
                }
            } else {
                this.paint(graphics2D, by, d, -1, -1);
                graphics2D.translate(0, this.plotHeight);
            }
            if ((by & 1) == 1) {
                graphics2D.translate(FloatWindowSpectral.this.plotYaxis.getWidth(), 0);
                FloatWindowSpectral.this.plotXaxis.paintZone(graphics2D, by, d);
            }
            graphics2D.setTransform(affineTransform);
        }

        public void paint(Graphics2D graphics2D, byte by, double d, int n, int n2) {
            this.resolveResourceNode();
            graphics2D.setClip(null);
            AffineTransform affineTransform = graphics2D.getTransform();
            boolean bl = (by & 1) == 1;
            boolean bl2 = (by & 2) == 2;
            double d2 = FloatWindowSpectral.this.getTryWidth();
            double d3 = FloatWindowSpectral.this.getTryHeight();
            if (bl) {
                if (n >= 0) {
                    if (FloatWindowSpectral.this.spectraFont == null) {
                        FloatWindowSpectral.this.spectraFont = new Font("SansSerif", 0, FloatWindowSpectral.this.textSize);
                    }
                    graphics2D.setFont(FloatWindowSpectral.this.spectraFont);
                }
                FloatWindowSpectral.this.plotYaxis.paint(graphics2D, by, d, n);
                graphics2D.translate(FloatWindowSpectral.this.plotYaxis.getWidth(), 0);
                super.paint(graphics2D, by, d, n);
                PlotImages.setBlockImage((int)d2, (int)d3);
            } else {
                graphics2D.translate(FloatWindowSpectral.this.plotYaxis.getWidth(), 0);
            }
            boolean bl3 = FloatWindowSpectral.this.showBorders();
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            int n3 = FloatWindowSpectral.this.plotAxisLayerPanel.visibleLayers();
            if (n3 > 0) {
                int n4;
                int n5;
                ZoneLeaf zoneLeaf = new ZoneLeaf(Color.red, 0, 0, 0, null);
                AxisRange axisRange = FloatWindowSpectral.this.getRange(0, n);
                AxisRange axisRange2 = FloatWindowSpectral.this.getRange(1, n);
                this.translateToScreenDouble(this.sMin, axisRange.getMin(), axisRange2.getMin(), axisRange, axisRange2);
                this.translateToScreenDouble(this.sMax, axisRange.getMax(), axisRange2.getMax(), axisRange, axisRange2);
                if ((by & 0x20) != 32) {
                    graphics2D.setClip((int)this.sMin[0], (int)this.sMax[1], (int)(this.sMax[0] - this.sMin[0]), (int)(this.sMin[1] - this.sMax[1]));
                }
                if ((n5 = (int)axisRange.getMin() - 1) < 0) {
                    n5 = 0;
                }
                if ((n4 = (int)axisRange.getMax() + 1) < 0) {
                    n4 = 0;
                }
                int n6 = FloatWindowSpectral.this.plotAxisLayerPanel.getMainLayerCount();
                for (int i = 0; i < n6; ++i) {
                    SpectralLayer spectralLayer = (SpectralLayer)FloatWindowSpectral.this.plotAxisLayerPanel.getMainLayer(i);
                    if (!spectralLayer.isLayerReady()) continue;
                    LineStyle lineStyle = spectralLayer.getLineStyle();
                    graphics2D.setStroke(lineStyle.getStroke());
                    spectralLayer.beginCalculations();
                    PlotImages.incBlockIndex();
                    int n7 = spectralLayer.hasShapes() ? 2 : 1;
                    for (int j = 0; j < n7; ++j) {
                        boolean bl4 = true;
                        int n8 = n5;
                        int n9 = 0;
                        List<ZoneLeaf> list = spectralLayer.getRootList();
                        for (int k = 0; k < list.size(); ++k) {
                            ZoneLeaf zoneLeaf2 = list.get(k);
                            int n10 = zoneLeaf2.getSecondaryIndex();
                            if (n2 >= 0 && n10 > n2) break;
                            if (n2 >= 0 && n10 < n2) continue;
                            if (n2 >= 0 && bl) {
                                graphics2D.setColor(Color.gray);
                                AffineTransform affineTransform2 = graphics2D.getTransform();
                                graphics2D.translate(this.origoX, this.origoY);
                                graphics2D.scale(d, d);
                                graphics2D.drawString(spectralLayer.getDescription(0, (byte)1, zoneLeaf2.getSecondaryIndex()), 4, 10 + FloatWindowSpectral.this.spectraFont.getSize() / 2);
                                graphics2D.setTransform(affineTransform2);
                                graphics2D.setFont(FloatWindowSpectral.this.AxisFont);
                            }
                            int n11 = zoneLeaf2.getNoChildren();
                            if (zoneLeaf2 instanceof ZoneArray) {
                                bl4 = true;
                                n8 = n5;
                                n9 = 0;
                            } else {
                                n11 = n8 + 1;
                                if (zoneLeaf2.getPrimaryIndex() < n5) continue;
                            }
                            if (zoneLeaf2.isSelected()) {
                                n9 = 2;
                            }
                            while (n8 < n4 && n8 < n11) {
                                SpectralLayer spectralLayer2 = (SpectralLayer)zoneLeaf2.getLayer(n8);
                                if (zoneLeaf2.isVisibleAndNotMissing(n8) && spectralLayer2.isLayerVisible()) {
                                    int n12 = zoneLeaf2.getPrimaryIndex(n8);
                                    this.translateToScreenDouble(dArray, n8, zoneLeaf2.getValue(n8, n12, n10, (byte)1), axisRange, axisRange2);
                                    if (FloatWindowSpectral.this.hasInteractSecond() && bl2 && FloatWindowSpectral.this.selectionArray.get(n12)) {
                                        n9 = 2;
                                    }
                                    if (j == 0) {
                                        if (!bl4) {
                                            if (bl) {
                                                graphics2D.setColor(zoneLeaf2.getColor(n8));
                                                graphics2D.drawLine((int)dArray2[0], (int)dArray2[1], (int)dArray[0], (int)dArray[1]);
                                            } else if (bl2 && n9 > 0 && FloatWindowSpectral.this.drawLineSelection) {
                                                graphics2D.setColor(FloatWindowSpectral.this.selectionColor);
                                                graphics2D.drawLine((int)dArray2[0], (int)dArray2[1], (int)dArray[0], (int)dArray[1]);
                                            }
                                        }
                                    } else {
                                        zoneLeaf.setLayer(spectralLayer2);
                                        zoneLeaf.setIndex(n12, n10);
                                        zoneLeaf.setColor(zoneLeaf2.getColor(n8));
                                        spectralLayer2.initLeaf(zoneLeaf);
                                        int[] nArray = new int[]{(int)dArray[0], (int)dArray[1]};
                                        if (bl) {
                                            PlotImages.drawAccelerated(this.getResourceNode(zoneLeaf), graphics2D, zoneLeaf, nArray, d, bl3);
                                        } else if (bl2 && n9 == 2 && dArray[0] > 2.0 && dArray[1] > 2.0 && dArray[0] < this.sMax[0] && dArray[1] < this.sMin[1]) {
                                            PlotImages.drawSelection(graphics2D, zoneLeaf, nArray, d, FloatWindowSpectral.this.selectionColor, false);
                                        }
                                    }
                                    bl4 = false;
                                    dArray2[0] = dArray[0];
                                    dArray2[1] = dArray[1];
                                    --n9;
                                }
                                ++n8;
                            }
                        }
                        spectralLayer.endCalculations();
                    }
                }
                if (bl2) {
                    graphics2D.setTransform(affineTransform);
                    FloatWindowSpectral.this.markSelectionObjects(graphics2D, FloatWindowSpectral.this.selectionColor);
                }
            }
            graphics2D.setTransform(affineTransform);
        }

        public void scrollToFirstSelected() {
            if (this.plotsToShow < 1) {
                return;
            }
            int n = -1;
            int n2 = FloatWindowSpectral.this.plotAxisLayerPanel.getLayerCount();
            int n3 = FloatWindowSpectral.this.plotAxisLayerPanel.visibleLayers();
            if (n3 > 0) {
                block0: for (int i = 0; i < n2; ++i) {
                    SpectralLayer spectralLayer = (SpectralLayer)FloatWindowSpectral.this.plotAxisLayerPanel.getLayerAtIndex(i);
                    if (!spectralLayer.isLayerVisible() || !spectralLayer.isLayerReady()) continue;
                    int n4 = -1;
                    List<ZoneLeaf> list = spectralLayer.getRootList();
                    for (int j = 0; j < list.size(); ++j) {
                        if (!list.get(j).isSelected() || n >= 0 && ++n4 >= n) continue;
                        n = n4;
                        continue block0;
                    }
                }
            }
            if (n >= 0 && n != FloatWindowSpectral.this.scrollBar.getBarPos()) {
                FloatWindowSpectral.this.scrollBar.setBarPos(n);
            }
        }

        @Override
        public boolean setPlotSize(int n, int n2, int n3, int n4) {
            this.fullWidth = n3;
            this.fullHeight = n4;
            this.plotHeight = n4 * 8 / 9;
            if (this.plotsToShow > 0) {
                this.plotHeight /= this.plotsToShow;
            }
            super.setPlotSize(n, n2, n3 * 8 / 9, this.plotHeight - 2);
            FloatWindowSpectral.this.plotXaxis.setPlotSize(n, n2, n3 * 8 / 9, n4 / 9);
            FloatWindowSpectral.this.plotYaxis.setPlotSize(n, n2, n3 / 9, this.plotHeight - 2);
            return false;
        }

        @Override
        public double[] translateToPlot(double d, double d2, int n) {
            return this.translateToPlot(new double[2], d, d2, n, FloatWindowSpectral.this.getRange(0, n), FloatWindowSpectral.this.getRange(1, n));
        }

        public double[] translateToPlot(double[] dArray, double d, double d2, int n, AxisRange axisRange, AxisRange axisRange2) {
            if (n > 0) {
                d2 -= (double)(this.plotHeight * (n - FloatWindowSpectral.this.scrollBar.getBarPos()));
            }
            dArray[0] = axisRange.transform((d - (double)(this.origoX + this.width / 8)) / (double)this.width);
            dArray[1] = axisRange2.transform(((double)(this.height + this.origoY) - d2) / (double)this.height);
            return dArray;
        }

        @Override
        public void translateToScreenInt(int[] nArray, double d, double d2, int n) {
            super.translateToScreenInt(nArray, d, d2, n);
            nArray[0] = nArray[0] + FloatWindowSpectral.this.plotYaxis.getWidth();
        }

        private int getSecondaryIndex(int n) {
            int[] nArray;
            int[] nArray2 = this.getVisibilityArray();
            if (0 <= n && n < nArray2.length && (nArray = this.getVisibilityArray()) != null) {
                return nArray[n];
            }
            return -1;
        }
    }
}

