/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.spectral;

import java.awt.Font;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.plot2D.spectral.SpectralLayer;
import se.prediktera.map.plot.axisplot.settings.ComboBoxDescription;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;

public class SpectralAccessorPanel
extends AbstractAxisLayer
implements SettingsBoxInterface {
    private ComboBoxDescription boxLabel;

    public SpectralAccessorPanel(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, RandomInputStream randomInputStream, MapProperty mapProperty) {
        super(plotInit, abstractAxisPlot, null, null, 1);
        if (randomInputStream != null) {
            try {
                mapProperty.setPrefix(String.valueOf(this.boxLabel.getType()));
                this.boxLabel.LoadProperty(randomInputStream, mapProperty);
                mapProperty.setPrefix("");
            }
            catch (IOException iOException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
            }
        }
        this.add(SettingsBoxHelper.createAxisLabelPanel(this.boxLabel, "X"));
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new SpectralLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    public String getDescription(int n) {
        if (n < 0) {
            return "";
        }
        return this.boxLabel.getDescription(this.boxLabel.getReferenceIndexPrimary(n), 0);
    }

    public ComboBoxDescription getDescriptionBox() {
        return this.boxLabel;
    }

    @Override
    public int getDescriptionCount() {
        return this.boxLabel.getCoordSizePrimary();
    }

    @Override
    public Font getDescriptionFont() {
        return this.boxLabel.getLabelFont();
    }

    @Override
    public double[] getMinmax(int n) {
        return new double[]{1.0, -1.0};
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.setPrefix(String.valueOf(this.boxLabel.getType()));
        this.boxLabel.SaveProperty(randomOutputStream);
        randomOutputStream.setPrefix("");
    }

    @Override
    public void setShowLines(boolean bl) {
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxLabel = null;
    }

    @Override
    protected void InitLayer() {
        this.boxLabel = new ComboBoxDescription(this, 0);
        this.boxLabel.addItem(new ComboItem(NONESTRING, 2));
        this.boxLabel.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxLabel.addItem(new ComboItem(DESCRIPTIONSTRING, 5));
        this.boxLabel.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxLabel.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxLabel.addItem(new ComboItem(VALUESTRING, 0));
        this.boxLabel.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put((byte)6, this.boxLabel);
        this.boxLabel.setSelected(5, 0);
    }

    @Override
    protected void InitLayerChild() {
    }
}

