/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.spectral;

import java.awt.Font;
import java.io.IOException;
import java.util.List;
import se.prediktera.map.common.ComplexName;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.LeafList;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.settings.ComboBoxAxis;
import se.prediktera.map.plot.axisplot.settings.ComboBoxColor;
import se.prediktera.map.plot.axisplot.settings.ComboBoxComment;
import se.prediktera.map.plot.axisplot.settings.ComboBoxLines;
import se.prediktera.map.plot.axisplot.settings.ComboBoxRange;
import se.prediktera.map.plot.axisplot.settings.ComboBoxShape;
import se.prediktera.map.plot.axisplot.settings.ComboBoxSize;
import se.prediktera.map.plot.axisplot.settings.ComboBoxStatistics;
import se.prediktera.map.plot.axisplot.settings.Lines.LineStyle;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxHelper;

public class SpectralLayer
extends AbstractAxisLayer {
    private ComboBoxRange boxRange;
    private ComboBoxAxis boxAxis;
    private ComboBoxSize boxSize;
    private ComboBoxShape boxShape;
    private ComboBoxLines boxLines;

    public SpectralLayer(AbstractAxisPlot abstractAxisPlot, PlotInit plotInit, LeafList leafList, LeafList leafList2, int n) {
        super(plotInit, abstractAxisPlot, leafList, leafList2, n);
        this.layerName = "Spectral " + n;
        this.jbinit();
    }

    public SpectralLayer(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.jbinit();
    }

    @Override
    public AbstractAxisLayer createSubLayer(LeafList leafList, int n, PlotInit plotInit) {
        return new SpectralLayer(this.axisPlot, plotInit, this.zoneList, leafList, n);
    }

    public double getAxisValue(byte by, int n, int n2, int n3) {
        if (this.boxRange != null) {
            return this.boxRange.getAxisValue(by, n, n2, n3);
        }
        return super.getAxisValue(by, n, n2);
    }

    @Override
    public Font getDescriptionFont() {
        return null;
    }

    public LineStyle getLineStyle() {
        return this.boxLines.getDrawLineStyle();
    }

    @Override
    public double[] getMinmax(int n) {
        if (this.boxRange != null) {
            return this.boxRange.getMinmax();
        }
        return this.boxAxis.getMinmax();
    }

    @Override
    public int getNrObjects() {
        if (this.zoneList != null) {
            int[] nArray = this.getPrimaryIndexArray();
            int n = nArray == null ? 0 : nArray.length;
            return this.zoneList.size() * n;
        }
        return 0;
    }

    @Override
    public int getNrVisibleObjects() {
        int n = 0;
        if (this.zoneList != null) {
            int[] nArray = this.getPrimaryIndexArray();
            int n2 = nArray == null ? 0 : nArray.length;
            for (ZoneLeaf zoneLeaf : this.zoneList) {
                if (!zoneLeaf.isVisible()) continue;
                n += n2;
            }
        }
        return n;
    }

    @Override
    public byte getTreeType() {
        return 3;
    }

    public final boolean hasShapes() {
        return this.boxShape.getSelectedType() != 2;
    }

    @Override
    public void includePoints(List<ZoneLeaf> list, AbstractAxisLayer abstractAxisLayer) {
        for (int i = 0; i < list.size(); ++i) {
            ZoneArray zoneArray = (ZoneArray)list.get(i);
            int n = zoneArray.getFirstTagged();
            while (n >= 0) {
                zoneArray.setLayer(n, this);
                n = zoneArray.getNextTagged(n);
            }
            zoneArray.checkLayerArray();
        }
        this.updateCalculations(null, true);
        if (this.isCreated) {
            this.axisPlot.contentPaint((byte)7);
        }
    }

    @Override
    public final void initLeaf(ZoneLeaf zoneLeaf) {
        this.boxShape.initLeaf(zoneLeaf);
        this.boxSize.initLeaf(zoneLeaf);
    }

    public boolean isShowLines() {
        return false;
    }

    @Override
    public void setAxisRange() {
        this.boxColor.setSelectedChild();
    }

    @Override
    public void setShowLines(boolean bl) {
    }

    @Override
    public String toString() {
        return this.layerName;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.boxRange = null;
        this.boxAxis = null;
        this.boxSize = null;
        this.boxShape = null;
        this.boxLines = null;
        this.boxStatistics = null;
    }

    @Override
    protected void InitLayer() {
        PlotInit plotInit = this.getPlotInit();
        boolean bl = plotInit.plotType == 1;
        ComplexName complexName = bl ? OBSCATEGORYSTRING : VARCATEGORYSTRING;
        ComplexName complexName2 = bl ? VARCATEGORYSTRING : OBSCATEGORYSTRING;
        AbstractDataMatrix abstractDataMatrix = plotInit.getMatrix(0);
        this.boxColor = new ComboBoxColor(abstractDataMatrix, this);
        this.boxColor.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxColor.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxColor.addItem(new ComboItem(VECTORSTRING, 18));
        this.boxColor.addItem(new ComboItem(VALUESTRING, 0));
        this.boxColor.addItem(new ComboItem(complexName, 7));
        if (plotInit.isSecondaryMatrixTagObsVar()) {
            this.boxColor.addItem(new ComboItem(complexName2, 101));
        }
        if (bl) {
            this.boxColor.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        }
        this.boxColor.addItem(new ComboItem(AMPLITUDESTRING, 11));
        this.boxColor.addItem(new ComboItem("%SEPARATOR#", 3));
        this.boxColor.setAltitudeAxis((byte)1);
        this.settingsBoxMap.put(this.boxColor.getType(), this.boxColor);
        this.boxComment = new ComboBoxComment(abstractDataMatrix, this);
        this.boxComment.addItem(new ComboItem(NONESTRING, 2));
        this.boxComment.addItem(new ComboItem(CUSTOMSTRING, 1));
        this.boxComment.addItem(new ComboItem(CATEGORYSTRING, 7));
        this.boxComment.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        this.boxComment.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxComment.getType(), this.boxComment);
        this.InitLayerChild();
    }

    @Override
    protected void InitLayerChild() {
        int n;
        PlotInit plotInit = this.getPlotInit();
        boolean bl = this.axisPlot.hasZoneArrayGlobal();
        if (bl) {
            if (!this.isSubLayer()) {
                this.boxRange = new ComboBoxRange(this);
                this.boxRange.addItem(new ComboItem("[MATRIX]", 10));
                this.settingsBoxMap.put(this.boxRange.getType(), this.boxRange);
            }
        } else {
            n = plotInit.axisType;
            this.boxAxis = new ComboBoxAxis(this, 1);
            if (n == 0) {
                this.boxAxis.addItem(new ComboItem(INDEXSTRING, 4));
                this.boxAxis.addItem(new ComboItem(VALUESTRING, 0));
                this.boxAxis.addItem(new ComboItem(AVERAGESTRING, 12));
                this.boxAxis.addItem(new ComboItem(SUMSTRING, 13));
            } else {
                this.boxAxis.addItem(new ComboItem(VALUESTRING, 0));
            }
            this.boxAxis.addItem(new ComboItem("%SEPARATOR#", 3));
            this.settingsBoxMap.put(this.boxAxis.getType(), this.boxAxis);
        }
        n = plotInit.plotType == 1 ? 1 : 0;
        ComplexName complexName = n != 0 ? OBSCATEGORYSTRING : VARCATEGORYSTRING;
        ComplexName complexName2 = n != 0 ? VARCATEGORYSTRING : OBSCATEGORYSTRING;
        this.boxSize = new ComboBoxSize(this, 0);
        this.boxSize.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxSize.addItem(new ComboItem(INDEXSTRING, 4));
        this.boxSize.addItem(new ComboItem(VALUESTRING, 0));
        this.boxSize.addItem(new ComboItem(complexName, 7));
        if (plotInit.isSecondaryMatrixTagObsVar()) {
            this.boxSize.addItem(new ComboItem(complexName2, 101));
        }
        if (n != 0) {
            this.boxSize.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        }
        this.boxSize.addItem(new ComboItem("%SEPARATOR#", 3));
        this.boxSize.setMinValue(1);
        this.boxSize.setEnabled(false);
        this.settingsBoxMap.put(this.boxSize.getType(), this.boxSize);
        this.boxShape = new ComboBoxShape(this, 0);
        this.boxShape.addItem(new ComboItem(NONESTRING, 2));
        this.boxShape.addItem(new ComboItem(FIXEDSTRING, 1));
        this.boxShape.addItem(new ComboItem(complexName, 7));
        if (plotInit.isSecondaryMatrixTagObsVar()) {
            this.boxShape.addItem(new ComboItem(complexName2, 101));
        }
        if (n != 0) {
            this.boxShape.addItem(new ComboItem(PREDICTIONCATEGORYSTRING, 19));
        }
        this.boxShape.addItem(new ComboItem("%SEPARATOR#", 3));
        this.settingsBoxMap.put(this.boxShape.getType(), this.boxShape);
        this.boxShape.setSelected(2, 0);
        this.boxShape.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                ComboItem comboItem = (ComboItem)itemEvent.getItem();
                this.boxSize.setEnabled(comboItem.getType() != 2);
            }
        });
        this.boxLines = new ComboBoxLines(this, 0);
        this.boxLines.addItem(new ComboItem(INDEXSTRING, 4));
        this.settingsBoxMap.put(this.boxLines.getType(), this.boxLines);
        this.boxStatistics = new ComboBoxStatistics(this, 0);
        this.boxStatistics.addItem(new ComboItem(NONESTRING, 2));
        this.settingsBoxMap.put(this.boxStatistics.getType(), this.boxStatistics);
    }

    private void jbinit() {
        if (this.boxRange != null) {
            if (!this.isSubLayer()) {
                this.add(SettingsBoxHelper.createRangePanel(this.boxRange));
            }
        } else {
            if (this.isSubLayer()) {
                this.boxAxis.setEnabled(false);
            }
            this.add(SettingsBoxHelper.createAxisPanel(null, this.boxAxis, null));
        }
        this.add(SettingsBoxHelper.createColorPanel(this.boxColor));
        this.add(SettingsBoxHelper.createSizePanel(this.boxSize));
        this.add(SettingsBoxHelper.createShapePanel(this.boxShape));
        this.add(SettingsBoxHelper.createLinesPanel(this.boxLines));
        this.add(SettingsBoxHelper.createCommentPanel(this.boxComment));
        this.add(SettingsBoxHelper.createStatisticsPanel(this.boxStatistics));
    }
}

