/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot2D.spectral.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.plot2D.spectral.FloatWindowSpectral;
import se.prediktera.map.plot.axisplot.properties.AxisProperties;

public class SettingsSpectralPanel
extends JPanel {
    private final JRadioButton radioSingleSpectral = new JRadioButton();
    private final JRadioButton radioMultiSpectral = new JRadioButton();
    private final JTextFieldButtonUppDown nrSpectra = new JTextFieldButtonUppDown(1.0, 30.0, false);
    private final JTextFieldButtonUppDown textSize = new JTextFieldButtonUppDown(5.0, 30.0, false);
    private final JTextFieldButtonUppDown lineWidth = new JTextFieldButtonUppDown(1.0, 10.0, false);
    private final JRadioButton radioSameYaxisRange = new JRadioButton();
    private final JRadioButton radioStretch = new JRadioButton();
    private PlotInit plotInit;
    private AxisProperties axisProperties = null;

    public SettingsSpectralPanel() {
        super(new BorderLayout());
        this.textSize.setNumber(8.0);
        this.nrSpectra.setNumber(4.0);
        this.radioSameYaxisRange.setSelected(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.radioSingleSpectral.setText("Show all vectors in the same plot");
        this.radioMultiSpectral.setText("Use multiple plots to separate each vector");
        ItemChanged itemChanged = new ItemChanged();
        this.radioMultiSpectral.addItemListener(itemChanged);
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Layout settings"));
        this.nrSpectra.setPreferredSize(new Dimension(80, 21));
        this.nrSpectra.setNumberChangedInterface((n, d) -> {
            if (this.plotInit != null) {
                this.plotInit.spektral_stacked_size = this.showMultiSpectral() ? (int)this.nrSpectra.getNumber() : 0;
            }
        });
        this.radioSameYaxisRange.setText("Use same y-axis range for all vectors");
        this.radioSameYaxisRange.addItemListener(itemChanged);
        this.radioStretch.setText("Stretch y-axis for each vector");
        this.lineWidth.setPreferredSize(new Dimension(80, 20));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioSingleSpectral);
        buttonGroup.add(this.radioMultiSpectral);
        this.add((Component)jPanel, "Center");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.radioSameYaxisRange);
        buttonGroup2.add(this.radioStretch);
        jPanel.add((Component)this.radioMultiSpectral, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Line width:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)this.radioSingleSpectral, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.lineWidth, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)this.radioSameYaxisRange, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 15, 0, new Insets(0, 28, 0, 62), 0, 0));
        jPanel.add((Component)this.radioStretch, new GridBagConstraints(0, 6, 2, 1, 0.0, 1.0, 18, 0, new Insets(0, 28, 0, 31), 0, 0));
        jPanel.add((Component)this.textSize, new GridBagConstraints(2, 4, 1, 4, 0.0, 0.0, 18, 0, new Insets(-2, -15, 8, 3), 56, -4));
        jPanel.add((Component)this.nrSpectra, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(-1, -15, 3, 3), 112, -4));
        jPanel.add((Component)new JLabel("Vector label text size:"), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 16, 0, new Insets(0, 50, 0, 0), 30, 0));
        jPanel.add((Component)new JLabel("Number of visible plots:"), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 50, 0, 0), 0, 0));
        itemChanged.itemStateChanged(null);
    }

    public SettingsSpectralPanel(FloatWindowSpectral floatWindowSpectral, AxisProperties axisProperties) {
        this();
        this.axisProperties = axisProperties;
        if (floatWindowSpectral != null) {
            this.textSize.setNumber(floatWindowSpectral.getSpectralFontSize());
            this.radioSingleSpectral.setSelected(!floatWindowSpectral.showMultiSpectral());
            this.radioMultiSpectral.setSelected(floatWindowSpectral.showMultiSpectral());
            this.nrSpectra.setNumber(floatWindowSpectral.getVisibleRowCount());
            this.radioSameYaxisRange.setSelected(floatWindowSpectral.spectrasHaveSameAxisRangeY());
            this.radioStretch.setSelected(!floatWindowSpectral.spectrasHaveSameAxisRangeY());
            this.lineWidth.setNumber(floatWindowSpectral.getSpectralLineWidth());
        }
    }

    public void applyChanges(FloatWindowSpectral floatWindowSpectral) {
        floatWindowSpectral.setSpectralFontSize((int)this.textSize.getNumber());
        floatWindowSpectral.setSpectralLineWidth((int)this.lineWidth.getNumber());
        floatWindowSpectral.setSpectrasHaveSameAxisRangeY(this.radioSameYaxisRange.isSelected());
        floatWindowSpectral.setVisibleRowCount((int)this.nrSpectra.getNumber());
        floatWindowSpectral.setShowMultiSpectral(this.radioMultiSpectral.isSelected());
    }

    public void beginWizard(PlotInit plotInit) {
        if (plotInit.spektral_stacked_size == 0) {
            this.radioSingleSpectral.setSelected(true);
        } else {
            this.radioMultiSpectral.setSelected(true);
            this.nrSpectra.setNumber(plotInit.spektral_stacked_size);
        }
        if (plotInit.spektral_same_yaxis_range) {
            this.radioSameYaxisRange.setSelected(true);
        } else {
            this.radioStretch.setSelected(true);
        }
        this.plotInit = plotInit;
    }

    private boolean hasSameYaxisRange() {
        return this.radioSameYaxisRange.isSelected();
    }

    private boolean showMultiSpectral() {
        return this.radioMultiSpectral.isSelected();
    }

    class ItemChanged
    implements ItemListener {
        ItemChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            SettingsSpectralPanel.this.nrSpectra.setEnabled(SettingsSpectralPanel.this.showMultiSpectral());
            SettingsSpectralPanel.this.radioSameYaxisRange.setEnabled(SettingsSpectralPanel.this.showMultiSpectral());
            SettingsSpectralPanel.this.radioStretch.setEnabled(SettingsSpectralPanel.this.showMultiSpectral());
            SettingsSpectralPanel.this.textSize.setEnabled(SettingsSpectralPanel.this.showMultiSpectral());
            if (SettingsSpectralPanel.this.plotInit != null) {
                SettingsSpectralPanel.this.plotInit.spektral_stacked_size = SettingsSpectralPanel.this.showMultiSpectral() ? (int)SettingsSpectralPanel.this.nrSpectra.getNumber() : 0;
                SettingsSpectralPanel.this.plotInit.spektral_same_yaxis_range = SettingsSpectralPanel.this.radioSameYaxisRange.isSelected();
            }
            if (SettingsSpectralPanel.this.axisProperties != null) {
                SettingsSpectralPanel.this.axisProperties.setAxisPanelEnabled(1, !SettingsSpectralPanel.this.showMultiSpectral() || SettingsSpectralPanel.this.hasSameYaxisRange());
            }
        }
    }
}

