/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.gl2.GLUT;
import se.prediktera.map.common.tools3d.Utility;
import se.prediktera.map.plot.axisplot.plot3D.FloatWindowPlot3D;
import se.prediktera.map.plot.axisplot.plot3D.MatrixFuncs;

public final class AxisBox {
    private final float[][] corners = new float[8][];
    private final float[][] axis = new float[3][];
    private final Side[] sides = new Side[6];

    public AxisBox() {
        this(0.5f);
    }

    public AxisBox(float f) {
        this.corners[0] = new float[]{-f, f, -f};
        this.corners[1] = new float[]{-f, -f, -f};
        this.corners[2] = new float[]{f, -f, -f};
        this.corners[3] = new float[]{f, f, -f};
        this.corners[4] = new float[]{f, f, f};
        this.corners[5] = new float[]{f, -f, f};
        this.corners[6] = new float[]{-f, -f, f};
        this.corners[7] = new float[]{-f, f, f};
        this.axis[0] = MatrixFuncs.minus(this.corners[2], this.corners[1]);
        this.axis[1] = MatrixFuncs.minus(this.corners[0], this.corners[1]);
        this.axis[2] = MatrixFuncs.minus(this.corners[6], this.corners[1]);
        this.sides[0] = new Side(this, 0, 1, 2);
        this.sides[1] = new Side(this, 4, 5, 6);
        this.sides[2] = new Side(this, 3, 2, 5);
        this.sides[3] = new Side(this, 7, 6, 1);
        this.sides[4] = new Side(this, 3, 4, 7);
        this.sides[5] = new Side(this, 5, 2, 1);
    }

    public void boxCoordToWorld(float[] fArray, float[] fArray2, int n) {
        this.sides[n].boxCoordToWorld(fArray, fArray2);
    }

    public void getExtents(float[] fArray, float[] fArray2, int n, float[] fArray3, float[] fArray4) {
        this.sides[n].getXYZ(fArray, fArray3);
        this.sides[n].getXYZ(fArray2, fArray4);
        for (int i = 0; i < 3; ++i) {
            if (!((double)fArray3[i] < 0.0) && !((double)fArray4[i] < 0.0)) continue;
            fArray3[i] = 1.0f + fArray3[i];
            fArray4[i] = 1.0f + fArray4[i];
        }
    }

    public void renderAxis(GL2 gL2, GLUT gLUT, int n, float[] fArray, FloatWindowPlot3D floatWindowPlot3D) {
        if (floatWindowPlot3D == null) {
            return;
        }
        String string = floatWindowPlot3D.getLabel((byte)0);
        String string2 = floatWindowPlot3D.getLabel((byte)1);
        String string3 = floatWindowPlot3D.getLabel((byte)2);
        int n2 = floatWindowPlot3D.getFontSize((byte)0) / 2;
        int n3 = floatWindowPlot3D.getFontSize((byte)1) / 2;
        int n4 = floatWindowPlot3D.getFontSize((byte)2) / 2;
        double[] dArray = floatWindowPlot3D.getViewTransformation();
        boolean bl = dArray[0] > 0.0;
        boolean bl2 = dArray[4] > 0.0;
        boolean bl3 = dArray[8] > 0.0;
        gL2.glLineWidth(2.0f);
        if (n < 0) {
            this.renderSingleAxis(gL2, gLUT, 0, fArray, string, n2, bl);
            this.renderSingleAxis(gL2, gLUT, 1, fArray, string2, n3, bl2);
            this.renderSingleAxis(gL2, gLUT, 2, fArray, string3, n4, bl3);
        } else if (n == 0 || n == 1) {
            this.renderSingleAxis(gL2, gLUT, 2, fArray, string3, n4, bl3);
            gL2.glLineWidth(3.0f);
            this.renderSingleAxis(gL2, gLUT, 0, fArray, string, n2, bl);
            gL2.glLineWidth(3.0f);
            this.renderSingleAxis(gL2, gLUT, 1, fArray, string2, n3, bl2);
        } else if (n == 2 || n == 3) {
            this.renderSingleAxis(gL2, gLUT, 0, fArray, string, n2, bl);
            gL2.glLineWidth(3.0f);
            this.renderSingleAxis(gL2, gLUT, 1, fArray, string2, n3, bl2);
            gL2.glLineWidth(3.0f);
            this.renderSingleAxis(gL2, gLUT, 2, fArray, string3, n4, bl3);
        } else {
            this.renderSingleAxis(gL2, gLUT, 1, fArray, string2, n3, bl2);
            gL2.glLineWidth(3.0f);
            this.renderSingleAxis(gL2, gLUT, 0, fArray, string, n2, bl);
            gL2.glLineWidth(3.0f);
            this.renderSingleAxis(gL2, gLUT, 2, fArray, string3, n4, bl3);
        }
        gL2.glLineWidth(1.0f);
    }

    public void renderBox(GL2 gL2) {
        gL2.glLineWidth(1.0f);
        gL2.glBegin(2);
        gL2.glVertex3fv(this.corners[0], 0);
        gL2.glVertex3fv(this.corners[1], 0);
        gL2.glVertex3fv(this.corners[2], 0);
        gL2.glVertex3fv(this.corners[3], 0);
        gL2.glVertex3fv(this.corners[4], 0);
        gL2.glVertex3fv(this.corners[5], 0);
        gL2.glVertex3fv(this.corners[6], 0);
        gL2.glVertex3fv(this.corners[7], 0);
        gL2.glEnd();
        gL2.glBegin(1);
        gL2.glVertex3fv(this.corners[1], 0);
        gL2.glVertex3fv(this.corners[6], 0);
        gL2.glVertex3fv(this.corners[2], 0);
        gL2.glVertex3fv(this.corners[5], 0);
        gL2.glVertex3fv(this.corners[0], 0);
        gL2.glVertex3fv(this.corners[3], 0);
        gL2.glVertex3fv(this.corners[4], 0);
        gL2.glVertex3fv(this.corners[7], 0);
        gL2.glEnd();
    }

    public void renderSingleAxis(GL2 gL2, GLUT gLUT, int n, float[] fArray, String string, int n2, boolean bl) {
        if (fArray != null) {
            gL2.glColor4fv(fArray, 0);
        }
        switch (n) {
            case 0: {
                gL2.glBegin(1);
                gL2.glVertex3fv(this.corners[1], 0);
                gL2.glVertex3f(this.corners[2][0] + 0.05f, this.corners[2][1], this.corners[2][2]);
                gL2.glVertex3f(this.corners[2][0] + 0.05f, this.corners[2][1], this.corners[2][2]);
                gL2.glVertex3f(this.corners[2][0] + 0.05f - 0.02f, this.corners[2][1] + 0.015f, this.corners[2][2]);
                gL2.glVertex3f(this.corners[2][0] + 0.05f, this.corners[2][1], this.corners[2][2]);
                gL2.glVertex3f(this.corners[2][0] + 0.05f - 0.02f, this.corners[2][1] - 0.015f, this.corners[2][2]);
                gL2.glEnd();
                gL2.glLineWidth(2.0f);
                Utility.renderStrokeString(gL2, gLUT, this.corners[2][0] + 0.075f, this.corners[2][1], this.corners[2][2], bl, string, n2, fArray);
                break;
            }
            case 1: {
                gL2.glBegin(1);
                gL2.glVertex3fv(this.corners[1], 0);
                gL2.glVertex3f(this.corners[0][0], this.corners[0][1] + 0.05f, this.corners[0][2]);
                gL2.glVertex3f(this.corners[0][0], this.corners[0][1] + 0.05f, this.corners[0][2]);
                gL2.glVertex3f(this.corners[0][0] + 0.015f, this.corners[0][1] + 0.05f - 0.02f, this.corners[0][2]);
                gL2.glVertex3f(this.corners[0][0], this.corners[0][1] + 0.05f, this.corners[0][2]);
                gL2.glVertex3f(this.corners[0][0] - 0.015f, this.corners[0][1] + 0.05f - 0.02f, this.corners[0][2]);
                gL2.glEnd();
                gL2.glLineWidth(2.0f);
                Utility.renderStrokeString(gL2, gLUT, this.corners[0][0], this.corners[0][1] + 0.075f, this.corners[0][2], bl, string, n2, fArray);
                break;
            }
            case 2: {
                gL2.glBegin(1);
                gL2.glVertex3fv(this.corners[1], 0);
                gL2.glVertex3f(this.corners[6][0], this.corners[6][1], this.corners[6][2] + 0.05f);
                gL2.glVertex3f(this.corners[6][0], this.corners[6][1], this.corners[6][2] + 0.05f);
                gL2.glVertex3f(this.corners[6][0] + 0.015f, this.corners[6][1], this.corners[6][2] + 0.05f - 0.02f);
                gL2.glVertex3f(this.corners[6][0], this.corners[6][1], this.corners[6][2] + 0.05f);
                gL2.glVertex3f(this.corners[6][0] - 0.015f, this.corners[6][1], this.corners[6][2] + 0.05f - 0.02f);
                gL2.glEnd();
                gL2.glLineWidth(2.0f);
                Utility.renderStrokeString(gL2, gLUT, this.corners[6][0], this.corners[6][1], this.corners[6][2] + 0.075f, bl, string, n2, fArray);
            }
        }
    }

    public int sideHit(float[] fArray, float[] fArray2, int n, float[] fArray3) {
        if (n >= 0) {
            if (this.sides[n].isHit(fArray, fArray2, fArray3)) {
                return n;
            }
            return -1;
        }
        for (int i = 0; i < 6; ++i) {
            if (!this.sides[i].isHit(fArray, fArray2, fArray3)) continue;
            return i;
        }
        return -1;
    }

    public final class Side {
        private final float[] normal;
        private final float[] origin;
        private float[] xvec = new float[3];
        private float[] yvec = new float[3];
        private final float[][] boxToAxis;

        public Side(AxisBox axisBox, int n, int n2, int n3) {
            this.origin = axisBox.corners[n2];
            this.xvec = MatrixFuncs.minus(axisBox.corners[n], this.origin);
            this.yvec = MatrixFuncs.minus(axisBox.corners[n3], this.origin);
            this.normal = MatrixFuncs.crossProduct(this.xvec, this.yvec);
            MatrixFuncs.normalize(this.normal);
            this.boxToAxis = new float[][]{{MatrixFuncs.dot(this.xvec, axisBox.axis[0]), MatrixFuncs.dot(this.yvec, axisBox.axis[0])}, {MatrixFuncs.dot(this.xvec, axisBox.axis[1]), MatrixFuncs.dot(this.yvec, axisBox.axis[1])}, {MatrixFuncs.dot(this.xvec, axisBox.axis[2]), MatrixFuncs.dot(this.yvec, axisBox.axis[2])}};
        }

        public void boxCoordToWorld(float[] fArray, float[] fArray2) {
            fArray[0] = this.origin[0] + fArray2[0] * this.xvec[0] + fArray2[1] * this.yvec[0];
            fArray[1] = this.origin[1] + fArray2[0] * this.xvec[1] + fArray2[1] * this.yvec[1];
            fArray[2] = this.origin[2] + fArray2[0] * this.xvec[2] + fArray2[1] * this.yvec[2];
        }

        public void getXYZ(float[] fArray, float[] fArray2) {
            fArray2[0] = this.boxToAxis[0][0] * fArray[0] + this.boxToAxis[0][1] * fArray[1];
            fArray2[1] = this.boxToAxis[1][0] * fArray[0] + this.boxToAxis[1][1] * fArray[1];
            fArray2[2] = this.boxToAxis[2][0] * fArray[0] + this.boxToAxis[2][1] * fArray[1];
            fArray2[1] = -fArray2[1];
        }

        public boolean isHit(float[] fArray, float[] fArray2, float[] fArray3) {
            float f = MatrixFuncs.dot(fArray2, this.normal);
            if (f >= 0.0f) {
                return false;
            }
            float[] fArray4 = new float[]{this.origin[0] - fArray[0], this.origin[1] - fArray[1], this.origin[2] - fArray[2]};
            float f2 = MatrixFuncs.dot(fArray4, this.normal);
            float f3 = f2 / f;
            if ((double)f3 < 0.0 || (double)f3 > 1.0) {
                return false;
            }
            float[] fArray5 = new float[]{fArray[0] + f3 * fArray2[0] - this.origin[0], fArray[1] + f3 * fArray2[1] - this.origin[1], fArray[2] + f3 * fArray2[2] - this.origin[2]};
            double d = Math.abs(this.xvec[0]);
            double d2 = Math.abs(this.xvec[1]);
            double d3 = Math.abs(this.xvec[2]);
            double d4 = Math.abs(this.yvec[0]);
            double d5 = Math.abs(this.yvec[1]);
            double d6 = Math.abs(this.yvec[2]);
            float f4 = d > d2 && d > d3 ? fArray5[0] * this.xvec[0] : (d2 > d3 ? fArray5[1] * this.xvec[1] : fArray5[2] * this.xvec[2]);
            float f5 = d4 > d5 && d4 > d6 ? fArray5[0] * this.yvec[0] : (d5 > d6 ? fArray5[1] * this.yvec[1] : fArray5[2] * this.yvec[2]);
            if ((double)f4 < 0.0 || (double)f4 > 1.0 || (double)f5 < 0.0 || (double)f5 > 1.0) {
                return false;
            }
            if (fArray3 != null) {
                fArray3[0] = f4;
                fArray3[1] = f5;
            }
            return true;
        }
    }
}

