/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D;

import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractDensityField;
import se.prediktera.map.plot.axisplot.ZoneLeaf;

public class DensityField3D
extends AbstractDensityField {
    private static final int RESOLUTION = 100;
    private final int[][][] densities = new int[100][100][100];
    private final double xMin;
    private final double xAbs;
    private final double yMin;
    private final double yAbs;
    private final double zMin;
    private final double zAbs;
    private double currentX;
    private double currentY;
    private double currentZ;

    public DensityField3D(AbstractAxisLayer abstractAxisLayer) {
        double[] dArray = abstractAxisLayer.getMinmax(0);
        double[] dArray2 = abstractAxisLayer.getMinmax(1);
        double[] dArray3 = abstractAxisLayer.getMinmax(2);
        this.xMin = Math.min(dArray[0], dArray[1]);
        this.yMin = Math.min(dArray2[0], dArray2[1]);
        this.zMin = Math.min(dArray3[0], dArray3[1]);
        this.xAbs = 1.0 / Math.abs(dArray[0] - dArray[1]);
        this.yAbs = 1.0 / Math.abs(dArray2[0] - dArray2[1]);
        this.zAbs = 1.0 / Math.abs(dArray3[0] - dArray3[1]);
        this.addFromLayer(abstractAxisLayer);
    }

    @Override
    public void addValue(ZoneLeaf zoneLeaf) {
        int n;
        if (zoneLeaf.isMissing()) {
            return;
        }
        this.getXYZ(zoneLeaf);
        int n2 = (int)this.currentY;
        int n3 = (int)this.currentX;
        int n4 = (int)this.currentZ;
        int[] nArray = this.densities[n2][n3];
        int n5 = n4;
        nArray[n5] = nArray[n5] + 1;
        int n6 = this.densities[n2][n3][n4];
        if (n6 > this.maxDensity) {
            this.maxDensity = n6;
        }
        if (n2 < this.densities.length - 1) {
            int[] nArray2 = this.densities[n2 + 1][n3];
            int n7 = n4;
            nArray2[n7] = nArray2[n7] + 1;
            n = this.densities[n2 + 1][n3][n4];
            if (n > this.maxDensity) {
                this.maxDensity = n;
            }
        }
        if (n2 < this.densities.length - 1 && n3 < this.densities[0].length - 1) {
            int[] nArray3 = this.densities[n2 + 1][n3 + 1];
            int n8 = n4;
            nArray3[n8] = nArray3[n8] + 1;
            n = this.densities[n2 + 1][n3 + 1][n4];
            if (n > this.maxDensity) {
                this.maxDensity = n;
            }
        }
        if (n3 < this.densities[0].length - 1) {
            int[] nArray4 = this.densities[n2][n3 + 1];
            int n9 = n4;
            nArray4[n9] = nArray4[n9] + 1;
            n = this.densities[n2][n3 + 1][n4];
            if (n > this.maxDensity) {
                this.maxDensity = n;
            }
        }
        if (n4 < this.densities[0][0].length - 1) {
            int n10;
            int[] nArray5 = this.densities[n2][n3];
            int n11 = n4 + 1;
            nArray5[n11] = nArray5[n11] + 1;
            n = this.densities[n2][n3][n4 + 1];
            if (n > this.maxDensity) {
                this.maxDensity = n;
            }
            if (n2 < this.densities.length - 1) {
                int[] nArray6 = this.densities[n2 + 1][n3];
                int n12 = n4 + 1;
                nArray6[n12] = nArray6[n12] + 1;
                n10 = this.densities[n2 + 1][n3][n4 + 1];
                if (n10 > this.maxDensity) {
                    this.maxDensity = n10;
                }
            }
            if (n2 < this.densities.length - 1 && n3 < this.densities[0].length - 1) {
                int[] nArray7 = this.densities[n2 + 1][n3 + 1];
                int n13 = n4 + 1;
                nArray7[n13] = nArray7[n13] + 1;
                n10 = this.densities[n2 + 1][n3 + 1][n4 + 1];
                if (n10 > this.maxDensity) {
                    this.maxDensity = n10;
                }
            }
            if (n3 < this.densities[0].length - 1) {
                int[] nArray8 = this.densities[n2][n3 + 1];
                int n14 = n4 + 1;
                nArray8[n14] = nArray8[n14] + 1;
                n10 = this.densities[n2][n3 + 1][n4 + 1];
                if (n10 > this.maxDensity) {
                    this.maxDensity = n10;
                }
            }
        }
    }

    @Override
    public double getDensityAt(ZoneLeaf zoneLeaf) {
        if (zoneLeaf.isMissing()) {
            return 0.0;
        }
        this.getXYZ(zoneLeaf);
        int n = (int)this.currentY;
        int n2 = (int)this.currentX;
        int n3 = (int)this.currentZ;
        double d = this.currentY - (double)n;
        double d2 = this.currentX - (double)n2;
        double d3 = this.currentZ - (double)n3;
        double d4 = (1.0 - d) * (1.0 - d2) * (1.0 - d3) * (double)this.densities[n][n2][n3];
        if (n < 99) {
            d4 += d * (1.0 - d2) * (1.0 - d3) * (double)this.densities[n + 1][n2][n3];
        }
        if (n < 99 && n2 < 99) {
            d4 += d * d2 * (1.0 - d3) * (double)this.densities[n + 1][n2 + 1][n3];
        }
        if (n2 < 99) {
            d4 += (1.0 - d) * d2 * (1.0 - d3) * (double)this.densities[n][n2 + 1][n3];
        }
        if (n3 < 99) {
            d4 += (1.0 - d) * (1.0 - d2) * d3 * (double)this.densities[n][n2][n3 + 1];
            if (n < 99) {
                d4 += d * (1.0 - d2) * d3 * (double)this.densities[n + 1][n2][n3 + 1];
            }
            if (n < 99 && n2 < 99) {
                d4 += d * d2 * d3 * (double)this.densities[n + 1][n2 + 1][n3 + 1];
            }
            if (n2 < 99) {
                d4 += (1.0 - d) * d2 * d3 * (double)this.densities[n][n2 + 1][n3 + 1];
            }
        }
        return d4;
    }

    private void getXYZ(ZoneLeaf zoneLeaf) {
        this.currentX = 99.0 * (zoneLeaf.getValue((byte)0) - this.xMin) * this.xAbs;
        this.currentY = 99.0 * (zoneLeaf.getValue((byte)1) - this.yMin) * this.yAbs;
        this.currentZ = 99.0 * (zoneLeaf.getValue((byte)2) - this.zMin) * this.zAbs;
        this.currentX = Math.max(0.0, Math.min(this.currentX, 99.0));
        this.currentY = Math.max(0.0, Math.min(this.currentY, 99.0));
        this.currentZ = Math.max(0.0, Math.min(this.currentZ, 99.0));
    }
}

