/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.plot.axisplot.plot3D;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.ExtensionFilter;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.tools3d.Camera;
import se.prediktera.map.common.tools3d.Utility;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractPlotBaseWindow;
import se.prediktera.map.plot.axisplot.AxisPlotRubberband;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.ZoneArray;
import se.prediktera.map.plot.axisplot.ZoneLeaf;
import se.prediktera.map.plot.axisplot.plot3D.AxisBox;
import se.prediktera.map.plot.axisplot.plot3D.GLFuncX3D;
import se.prediktera.map.plot.axisplot.plot3D.MatrixFuncs;
import se.prediktera.map.plot.axisplot.plot3D.Plot3DToolbar;
import se.prediktera.map.plot.axisplot.plot3D.VirtualDrawable;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandNormal;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;

public abstract class FloatWindowPlot3D
extends AxisPlotRubberband {
    private static GLCapabilities glCapabilities = new GLCapabilities(GLProfile.getDefault());
    private GLJPanel panel3d = new GLJPanel((GLCapabilitiesImmutable)glCapabilities);
    protected PlotRenderer renderer;
    private Plot3DToolbar plot3DToolbar;
    private boolean wireframe = false;
    private boolean flatShade = false;
    private boolean enableLights = true;
    private double tickDensityZ = 1.0;
    protected boolean isrotate = false;

    public static boolean isHardwareAccelerated() {
        return glCapabilities.getHardwareAccelerated();
    }

    public static void setHardwareAcceleration(boolean bl) {
        glCapabilities.setHardwareAccelerated(bl);
    }

    public FloatWindowPlot3D(AbstractPlotBaseWindow abstractPlotBaseWindow, PlotInit plotInit, double d, double d2, double d3, double d4) {
        super(abstractPlotBaseWindow, plotInit, d, d2, d3, d4);
        this.init((MapProperty)null);
    }

    public FloatWindowPlot3D(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.wireframe = mapProperty.getPropertyBoolean("wireframe", false);
        this.flatShade = mapProperty.getPropertyBoolean("shading", false);
        this.enableLights = mapProperty.getPropertyBoolean("lights", true);
        this.tickDensityZ = mapProperty.getPropertyDouble("zden", this.tickDensityZ);
        this.init(mapProperty);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        jPopupMenu.add(new CMenuItem("Export As...", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Export Plot", IniManager.getMainFrame());
                jopensaveDialog2.addExtension("x3d", "X3D files (*.x3d)");
                jopensaveDialog2.setCurrentDirectory(IniManager.getWorkDir((byte)2));
                if (jopensaveDialog2.saveshow()) {
                    IniManager.setWorkDir((byte)2, jopensaveDialog2.getCurrentDirectory());
                    File file = jopensaveDialog2.getSelectedFile();
                    FileFilter fileFilter = jopensaveDialog2.getFileFilter();
                    if (fileFilter instanceof ExtensionFilter) {
                        FloatWindowPlot3D.this.exportPlot(file, ((ExtensionFilter)fileFilter).getExtension(0));
                    }
                }
            }
        });
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        return true;
    }

    @Override
    public String getInfoAtCords(AbstractAxisLayer abstractAxisLayer, int n, int n2) {
        if (abstractAxisLayer == null) {
            abstractAxisLayer = this.getLayer(0);
        }
        ZoneLeaf zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2);
        StringBuilder stringBuilder = new StringBuilder(20);
        if (zoneLeaf != null && zoneLeaf.getType() == 0) {
            stringBuilder.append(abstractAxisLayer).append("\n");
            String string = abstractAxisLayer.getComment(zoneLeaf, "<br>");
            if (string != null) {
                stringBuilder.append(string).append("\n");
            }
            int n3 = abstractAxisLayer.getDescriptionCount();
            for (int i = 0; i < n3; ++i) {
                String string2 = abstractAxisLayer.getDescriptionTitle(i);
                String string3 = abstractAxisLayer.getDescription(i, zoneLeaf);
                stringBuilder.append(string2).append(": ");
                stringBuilder.append(string3).append("\n");
            }
            stringBuilder.append("X: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)0))).append("\n");
            stringBuilder.append("Y: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)1))).append("\n");
            stringBuilder.append("Z: ").append(NiceDataFormat.toString(zoneLeaf.getValue((byte)2))).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Point getPointAtCordsAt(AbstractAxisLayer abstractAxisLayer, Point point, int n, int n2) {
        ZoneLeaf zoneLeaf;
        if (point == null) {
            point = new Point();
        }
        if ((zoneLeaf = this.getLeafAtIndex(abstractAxisLayer, n, n2)) != null) {
            int[] nArray = new int[3];
            this.translateToScreenInt(zoneLeaf, nArray, 0);
            point.x = (int)((double)nArray[0] + this.getTryOrigoX());
            point.y = (int)((double)nArray[1] + this.getTryOrigoY());
        }
        return point;
    }

    @Override
    public double getTickDensity(byte by) {
        if (by == 2) {
            return this.tickDensityZ;
        }
        return super.getTickDensity(by);
    }

    @Override
    public void getToolbars(Vector<JToolBar> vector) {
        vector.add(this.plotSelectionToolbar);
        vector.add(this.zoomToolbar);
        vector.add(this.plot3DToolbar);
    }

    public double[] getViewTransformation() {
        return this.renderer.getViewTransformation();
    }

    public boolean isFlatShade() {
        return this.flatShade;
    }

    @Override
    public boolean isOverPlot(int n, int n2) {
        return this.renderer.isOverPlot(n, n2);
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public boolean lightsEnabled() {
        return this.enableLights;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.hasRedirectPanel() && !this.baseWindow.getProject_GUI().isTakingScreenshot()) {
            super.paint(graphics);
        }
    }

    @Override
    public void rubberbandEnded(AbstractRubberband abstractRubberband, int n) {
        if (abstractRubberband.getType() == AbstractRubberband.RubberAction.Selection) {
            super.rubberbandEnded(abstractRubberband, n);
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        this.renderer.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyBoolean("wireframe", this.wireframe);
        randomOutputStream.writePropertyBoolean("shading", this.flatShade);
        randomOutputStream.writePropertyBoolean("lights", this.enableLights);
        randomOutputStream.writePropertyDouble("zden", this.tickDensityZ);
    }

    @Override
    public void selectNnearest(int n, int n2) {
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        return switch (by) {
            case 4 -> this.plot3DToolbar.SendGlobalMessage(by2);
            default -> super.SendGlobalMessage(by, by2);
        };
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.panel3d != null) {
            this.panel3d.setCursor(cursor);
        }
    }

    public void setFlatShading(boolean bl) {
        this.flatShade = bl;
    }

    @Override
    public void setKeepAspectRatio(boolean bl) {
        super.setKeepAspectRatio(bl);
        this.panel3d.reshape(this.panel3d.getX(), this.panel3d.getY(), this.panel3d.getWidth(), this.panel3d.getHeight());
    }

    public void setLights(boolean bl) {
        this.enableLights = bl;
    }

    @Override
    public void setTickDensity(byte by, double d) {
        if (by == 2) {
            this.tickDensityZ = d;
        } else {
            super.setTickDensity(by, d);
        }
    }

    public void setWireFrame(boolean bl) {
        this.wireframe = bl;
    }

    @Override
    public void setZooming(byte by) {
        super.setZooming(by);
        if (this.renderer != null) {
            this.renderer.zoomtype = by;
        }
    }

    public void translateToPlot(int n, int n2, int n3, double[] dArray, AxisRange axisRange, AxisRange axisRange2, AxisRange axisRange3) {
        this.renderer.translateToPlot(n, n2, n3, dArray, axisRange, axisRange2, axisRange3);
    }

    @Override
    protected void adjustToAspectRatio() {
        double d;
        AxisRange axisRange = this.getRange(0, 0);
        AxisRange axisRange2 = this.getRange(1, 0);
        double d2 = axisRange.getAbs();
        double d3 = axisRange2.getAbs();
        if (Double.compare(d2, 0.0) == 0 || Double.compare(d3, 0.0) == 0) {
            return;
        }
        double d4 = axisRange.getDataAbs();
        double d5 = axisRange2.getDataAbs();
        if (d4 < d2) {
            axisRange.zoomAll();
            d2 = d4;
        }
        if (d5 < d3) {
            axisRange2.zoomAll();
            d3 = d5;
        }
        if ((d = d2 / d3) > 1.0) {
            axisRange2.zoomNoAdjust(0.5 * d - 0.5);
        } else {
            axisRange.zoomNoAdjust(0.5 / d - 0.5);
        }
        this.calculateAxisTicks((byte)0);
        this.calculateAxisTicks((byte)1);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.panel3d != null) {
            this.panel3d = null;
        }
        if (this.renderer != null) {
            this.renderer.cleanUp();
            this.renderer = null;
        }
    }

    @Override
    protected LinkedList<ZoneLeaf> collectRectangleFromScreen(int n, int n2, int n3, int n4, boolean bl, AbstractRubberband.RubberType rubberType) {
        return this.collectRectangleFromScreen(n, n2, n3, n4, bl, rubberType, false, false);
    }

    protected abstract LinkedList<ZoneLeaf> collectRectangleFromScreen(int var1, int var2, int var3, int var4, boolean var5, AbstractRubberband.RubberType var6, boolean var7, boolean var8);

    protected void component_resized() {
    }

    protected abstract PlotRenderer createRenderer(MapProperty var1) throws IOException;

    @Override
    protected ZoneLeaf getLeafAt(Point point) {
        return this.renderer.getLeafAt(point);
    }

    @Override
    protected int getPlotDepth() {
        return (this.getWidth() + this.getHeight()) / 2;
    }

    @Override
    protected int getPlotHeight() {
        return this.getHeight();
    }

    @Override
    protected int getPlotWidth() {
        return this.getWidth();
    }

    @Override
    protected boolean hasAutoText(byte by) {
        if (by == 2) {
            FloatTextWindow floatTextWindow = this.getLabelWindow(by);
            if (floatTextWindow == null) {
                return true;
            }
            return floatTextWindow.hasAutoText();
        }
        return super.hasAutoText(by);
    }

    @Override
    protected boolean mustBeBoundedInSelection() {
        return true;
    }

    @Override
    protected double[] translateToPlot(double d, double d2, int n) {
        return null;
    }

    protected void translateToPlot(int n, int n2, int n3, double[] dArray) {
        this.renderer.translateToPlot(n, n2, n3, dArray);
    }

    protected void translateToScreenInt(ZoneArray zoneArray, int n, int[] nArray, int n2) {
        this.renderer.translateToScreenInt(zoneArray.getValue(n, (byte)0), zoneArray.getValue(n, (byte)1), zoneArray.getValue(n, (byte)2), nArray);
    }

    @Override
    protected void translateToScreenInt(ZoneLeaf zoneLeaf, int[] nArray, int n) {
        this.renderer.translateToScreenInt(zoneLeaf.getValue((byte)0), zoneLeaf.getValue((byte)1), zoneLeaf.getValue((byte)2), nArray);
    }

    private void exportPlot(File file, String string) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            GLFuncX3D gLFuncX3D = new GLFuncX3D(bufferedWriter, 0.0, 0.0, 3.5);
            VirtualDrawable virtualDrawable = new VirtualDrawable(gLFuncX3D);
            PlotRenderer plotRenderer = this.createRenderer(null);
            virtualDrawable.addGLEventListener(plotRenderer);
            plotRenderer.transfZ = 0.0f;
            plotRenderer.camera = new Camera(gLFuncX3D.getGLU());
            plotRenderer.firstInit = false;
            this.repaint();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init(MapProperty mapProperty) {
        this.setPanel((JPanel)this.panel3d);
        try {
            this.renderer = this.createRenderer(mapProperty);
            this.panel3d.addGLEventListener((GLEventListener)this.renderer);
            this.addMouseListener(this.renderer);
            this.addMouseMotionListener(this.renderer);
        }
        catch (IOException iOException) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
        }
        if (this.plot != null) {
            this.plot3DToolbar = new Plot3DToolbar(this, this.renderer, this.plot.getButtonGroup());
        }
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public abstract class PlotRenderer
    extends CleanUpClass
    implements GLEventListener,
    MouseListener,
    MouseMotionListener {
        private int prevMouseX;
        private int prevMouseY;
        protected GLUT glut = null;
        private GLU glu = null;
        private int box;
        protected AxisBox axisBox = new AxisBox();
        private int selectedBoxSide = -1;
        protected double[] viewTransf = new double[16];
        protected double[] projectTransf = new double[16];
        protected int[] viewPort = new int[4];
        protected int realViewHeight = 0;
        protected float transfX = 0.0f;
        protected float transfY = 0.0f;
        protected float transfZ = 0.0f;
        protected float flipX = 0.5f;
        protected float flipY = 0.5f;
        protected float flipZ = 0.5f;
        public float gridLenX = 1.0f;
        public float gridLenY = 1.0f;
        public float gridLenZ = 1.0f;
        protected boolean canrotate = false;
        private boolean drawRubberBox = false;
        protected byte zoomtype = (byte)-1;
        private final float[][] rubberCoords = new float[2][2];
        protected Camera camera;
        private boolean firstInit = true;
        private MapProperty mapProperty;

        public PlotRenderer(MapProperty mapProperty) throws IOException {
            if (mapProperty != null && mapProperty.getPropertyBoolean("save")) {
                this.mapProperty = mapProperty;
                this.transfX = mapProperty.getPropertyFloat("tfX");
                this.transfY = mapProperty.getPropertyFloat("tfY");
                this.transfZ = mapProperty.getPropertyFloat("tfZ");
            }
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = (GL2)gLAutoDrawable.getGL();
            Color color = FloatWindowPlot3D.this.getBackground();
            gL2.glClearColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
            gL2.glClear(16640);
            if (FloatWindowPlot3D.this.isOptimize3D || FloatWindowPlot3D.this.isCreated()) {
                gL2.glLoadIdentity();
                gL2.glTranslatef(this.transfX, this.transfY, this.transfZ);
                this.camera.viewNoMove();
                gL2.glGetDoublev(2982, this.viewTransf, 0);
                gL2.glPushMatrix();
                this.enableLights((GL)gL2, false);
                gL2.glColor3f((float)FloatWindowPlot3D.this.axisColor.getRed() / 255.0f, (float)FloatWindowPlot3D.this.axisColor.getGreen() / 255.0f, (float)FloatWindowPlot3D.this.axisColor.getBlue() / 255.0f);
                gL2.glEnable(3042);
                if (!this.getClass().toString().contains("Contour3D")) {
                    this.axisBox.renderAxis(gL2, this.glut, this.selectedBoxSide, null, FloatWindowPlot3D.this);
                }
                gL2.glColor3f(0.0f, 0.0f, 0.0f);
                gL2.glCallList(this.box);
                gL2.glDisable(3042);
                this.enableLights((GL)gL2, FloatWindowPlot3D.this.lightsEnabled());
                if (FloatWindowPlot3D.this.wireframe) {
                    gL2.glPolygonMode(1032, 6913);
                } else if (FloatWindowPlot3D.this.flatShade) {
                    gL2.glShadeModel(7424);
                }
                this.paint(gL2, this.glu, this.glut);
                if (FloatWindowPlot3D.this.wireframe) {
                    gL2.glPolygonMode(1032, 6914);
                } else if (FloatWindowPlot3D.this.flatShade) {
                    gL2.glShadeModel(7425);
                }
                if (this.drawRubberBox && this.selectedBoxSide >= 0) {
                    gL2.glEnable(3042);
                    this.drawRubberBox(gL2);
                    gL2.glDisable(3042);
                }
                gL2.glPopMatrix();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawGrid(GL2 gL2) {
            gL2.glDepthMask(false);
            gL2.glLineWidth(1.0f);
            this.feedbackGrid();
            float[] fArray = new float[]{(float)FloatWindowPlot3D.this.gridColor.getRed() / 255.0f, (float)FloatWindowPlot3D.this.gridColor.getGreen() / 255.0f, (float)FloatWindowPlot3D.this.gridColor.getBlue() / 255.0f, 1.0f};
            float[] fArray2 = new float[]{(float)FloatWindowPlot3D.this.axisColor.getRed() / 255.0f, (float)FloatWindowPlot3D.this.axisColor.getGreen() / 255.0f, (float)FloatWindowPlot3D.this.axisColor.getBlue() / 255.0f, 1.0f};
            AxisRange axisRange = FloatWindowPlot3D.this.getRange(0, 0);
            List<TickInfo> list = axisRange.getTickList();
            Object object = list;
            synchronized (object) {
                for (TickInfo object2 : list) {
                    float tickInfo = (float)(axisRange.invTransform(object2.pos) - 0.5);
                    gL2.glColor4fv(fArray, 0);
                    gL2.glBegin(1);
                    gL2.glVertex3f(tickInfo, -0.5f, this.flipZ);
                    gL2.glVertex3f(tickInfo, 0.5f, this.flipZ);
                    gL2.glVertex3f(tickInfo, this.flipY, -0.5f);
                    gL2.glVertex3f(tickInfo, this.flipY, 0.5f);
                    gL2.glVertex3f(tickInfo, this.flipY, -this.flipZ * 1.0f);
                    gL2.glVertex3f(tickInfo, this.flipY, -this.flipZ * 1.1f);
                    gL2.glEnd();
                    Utility.renderStrokeString(gL2, this.glut, tickInfo, this.flipY, -this.flipZ * 1.2f, object2.text, 9, fArray2);
                }
            }
            this.drawGridY(gL2, fArray, fArray2);
            object = FloatWindowPlot3D.this.getRange(2, 0);
            list = ((AxisRange)object).getTickList();
            List<TickInfo> list2 = list;
            synchronized (list2) {
                for (TickInfo tickInfo : list) {
                    float f = (float)(((AxisRange)object).invTransform(tickInfo.pos) - 0.5);
                    gL2.glColor4fv(fArray, 0);
                    gL2.glBegin(1);
                    gL2.glVertex3f(-0.5f, this.flipY, f);
                    gL2.glVertex3f(0.5f, this.flipY, f);
                    gL2.glVertex3f(this.flipX, -0.5f, f);
                    gL2.glVertex3f(this.flipX, 0.5f, f);
                    gL2.glVertex3f(-this.flipX * 1.0f, this.flipY, f);
                    gL2.glVertex3f(-this.flipX * 1.1f, this.flipY, f);
                    gL2.glEnd();
                    Utility.renderStrokeString(gL2, this.glut, -this.flipX * 1.2f, this.flipY, f, tickInfo.text, 9, fArray2);
                }
            }
            gL2.glDepthMask(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawGridY(GL2 gL2, float[] fArray, float[] fArray2) {
            List<TickInfo> list;
            AxisRange axisRange = FloatWindowPlot3D.this.getRange(1, 0);
            List<TickInfo> list2 = list = axisRange.getTickList();
            synchronized (list2) {
                for (TickInfo tickInfo : list) {
                    float f = (float)(axisRange.invTransform(tickInfo.pos) - 0.5);
                    gL2.glColor4fv(fArray, 0);
                    gL2.glBegin(1);
                    gL2.glVertex3f(this.flipX, f, -0.5f);
                    gL2.glVertex3f(this.flipX, f, 0.5f);
                    gL2.glVertex3f(-0.5f, f, this.flipZ);
                    gL2.glVertex3f(0.5f, f, this.flipZ);
                    gL2.glVertex3f(this.flipX, f, -this.flipZ * 1.0f);
                    gL2.glVertex3f(this.flipX, f, -this.flipZ * 1.1f);
                    gL2.glEnd();
                    Utility.renderStrokeString(gL2, this.glut, this.flipX, f, -this.flipZ * 1.2f, tickInfo.text, 9, fArray2);
                }
            }
        }

        public void drawZeroLine(GL2 gL2) {
            gL2.glLineWidth(1.0f);
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            gL2.glColor3f((float)FloatWindowPlot3D.this.zeroColor.getRed() / 255.0f, (float)FloatWindowPlot3D.this.zeroColor.getGreen() / 255.0f, (float)FloatWindowPlot3D.this.zeroColor.getBlue() / 255.0f);
            AxisRange axisRange = FloatWindowPlot3D.this.getRange(0, 0);
            AxisRange axisRange2 = FloatWindowPlot3D.this.getRange(1, 0);
            AxisRange axisRange3 = FloatWindowPlot3D.this.getRange(2, 0);
            if (axisRange.getAbs() > 0.0) {
                f = (float)(axisRange.invTransform(0.0) - 0.5);
            }
            if (axisRange2.getAbs() > 0.0) {
                f2 = (float)(axisRange2.invTransform(0.0) - 0.5);
            }
            if (axisRange3.getAbs() > 0.0) {
                f3 = (float)(axisRange3.invTransform(0.0) - 0.5);
            }
            if (f < 0.5f && f >= -0.5f && f2 < 0.5f && f2 >= -0.5f) {
                gL2.glBegin(1);
                gL2.glVertex3f(f, f2, -0.5f);
                gL2.glVertex3f(f, f2, 0.5f);
                gL2.glEnd();
            }
            if (f3 < 0.5f && f3 >= -0.5f && f2 < 0.5f && f2 >= -0.5f) {
                gL2.glBegin(1);
                gL2.glVertex3f(-0.5f, f2, f3);
                gL2.glVertex3f(0.5f, f2, f3);
                gL2.glEnd();
            }
            if (f3 < 0.5f && f3 >= -0.5f && f < 0.5f && f >= -0.5f) {
                gL2.glBegin(1);
                gL2.glVertex3f(f, -0.5f, f3);
                gL2.glVertex3f(f, 0.5f, f3);
                gL2.glEnd();
            }
        }

        public void feedbackGrid() {
            double d = this.viewTransf[0] * this.viewTransf[12] + this.viewTransf[1] * this.viewTransf[13] + this.viewTransf[2] * this.viewTransf[14];
            double d2 = this.viewTransf[4] * this.viewTransf[12] + this.viewTransf[5] * this.viewTransf[13] + this.viewTransf[6] * this.viewTransf[14];
            double d3 = this.viewTransf[8] * this.viewTransf[12] + this.viewTransf[9] * this.viewTransf[13] + this.viewTransf[10] * this.viewTransf[14];
            this.flipX = d < 0.0 ? -0.5f : 0.5f;
            this.flipY = d2 < 0.0 ? -0.5f : 0.5f;
            this.flipZ = d3 < 0.0 ? -0.5f : 0.5f;
        }

        public double getEyeX() {
            return -(this.viewTransf[12] * this.viewTransf[0] + this.viewTransf[13] * this.viewTransf[1] + this.viewTransf[14] * this.viewTransf[2]);
        }

        public double getEyeY() {
            return -(this.viewTransf[12] * this.viewTransf[4] + this.viewTransf[13] * this.viewTransf[5] + this.viewTransf[14] * this.viewTransf[6]);
        }

        public double getEyeZ() {
            return -(this.viewTransf[12] * this.viewTransf[8] + this.viewTransf[13] * this.viewTransf[9] + this.viewTransf[14] * this.viewTransf[10]);
        }

        public ZoneLeaf getLeafAt(Point point) {
            int n = FloatWindowPlot3D.this.getHandWidth();
            LinkedList<ZoneLeaf> linkedList = FloatWindowPlot3D.this.collectRectangleFromScreen(point.x - n / 2, point.y - n / 2, n, n, false, AbstractRubberband.RubberType.Normal, true, true);
            if (linkedList.isEmpty()) {
                return null;
            }
            return linkedList.getFirst();
        }

        public double[] getViewTransformation() {
            return this.viewTransf;
        }

        public boolean hasLeafAt(Point point) {
            int n = FloatWindowPlot3D.this.getHandWidth();
            LinkedList<ZoneLeaf> linkedList = FloatWindowPlot3D.this.collectRectangleFromScreen(point.x - n / 2, point.y - n / 2, n, n, false, AbstractRubberband.RubberType.Normal, true, false);
            return !linkedList.isEmpty();
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = (GL2)gLAutoDrawable.getGL();
            this.glu = new GLU();
            if (this.firstInit) {
                if (this.mapProperty == null) {
                    this.resetView();
                } else {
                    try {
                        this.camera = new Camera(this.mapProperty);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.mapProperty = null;
                }
                this.firstInit = false;
            } else {
                this.camera.setGLU();
            }
            this.glut = new GLUT();
            float[] fArray = new float[]{5.0f, -5.0f, 10.0f, 0.0f};
            gL2.glLightfv(16384, 4611, fArray, 0);
            gL2.glLightModeli(2898, 1);
            gL2.glLightModeli(2897, 0);
            gL2.glEnable(2884);
            gL2.glEnable(2929);
            gL2.glDepthFunc(515);
            this.enableLights((GL)gL2, FloatWindowPlot3D.this.lightsEnabled());
            gL2.glEnable(2832);
            gL2.glBlendFunc(770, 771);
            gL2.glEnable(3008);
            gL2.glAlphaFunc(516, 0.05f);
            gL2.glHint(3153, 4354);
            gL2.glEnable(32826);
            gL2.glEnable(2848);
            gL2.glPolygonMode(1032, 6914);
            gL2.glColorMaterial(1032, 4609);
            this.box = gL2.glGenLists(1);
            gL2.glNewList(this.box, 4864);
            this.axisBox.renderBox(gL2);
            gL2.glEndList();
            this.localInit(gL2, this.glu);
        }

        public boolean isOverPlot(int n, int n2) {
            return this.sideHit(n, n2, null, -1) >= 0;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (FloatWindowPlot3D.this.panview) {
                    this.panView(mouseEvent);
                } else if (this.zoomtype == 0) {
                    this.zoomViewBegun(mouseEvent);
                }
            }
            if (this.canrotate && SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                this.rotateView(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (FloatWindowPlot3D.this.rubberband instanceof RubberbandNormal) {
                if (this.hasLeafAt(mouseEvent.getPoint())) {
                    FloatWindowPlot3D.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    FloatWindowPlot3D.this.setCursor(Cursor.getDefaultCursor());
                }
            }
            if (this.zoomtype != -1 || FloatWindowPlot3D.this.panview) {
                this.selectedBoxSide = this.sideHit(mouseEvent.getX(), mouseEvent.getY(), this.rubberCoords[0], -1);
                this.repaintPlot(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            this.prevMouseX = mouseEvent.getX();
            this.prevMouseY = mouseEvent.getY();
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.zoomtype == 0 && this.selectedBoxSide >= 0) {
                this.drawRubberBox = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (FloatWindowPlot3D.this.isrotate) {
                this.repaintPlot(false);
                FloatWindowPlot3D.this.isrotate = false;
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.zoomtype != -1 && this.selectedBoxSide >= 0) {
                if (this.zoomtype == 0) {
                    this.zoomViewEnded(mouseEvent);
                } else if (this.zoomtype == 1 || this.zoomtype == 2) {
                    this.zoomView(mouseEvent);
                }
                FloatWindowPlot3D.this.calculateAndRepaintSetAxis(true, false);
            }
        }

        public void repaintPlot(boolean bl) {
            if (bl) {
                FloatWindowPlot3D.this.calculateAndRepaintSetAxis(true, false);
            } else {
                FloatWindowPlot3D.this.repaintPlot((byte)7);
            }
        }

        public void resetView() {
            this.resetView((byte)0);
        }

        public void resetView(byte by) {
            this.transfY = 0.0f;
            this.transfX = 0.0f;
            this.transfZ = -3.7f;
            switch (by) {
                case 1: {
                    this.camera = new Camera(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                    break;
                }
                case 2: {
                    this.camera = new Camera(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
                    break;
                }
                case 3: {
                    this.camera = new Camera(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0);
                    break;
                }
                case 4: {
                    this.camera = new Camera(0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                    break;
                }
                case 5: {
                    this.camera = new Camera(0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0);
                    break;
                }
                case 6: {
                    this.camera = new Camera();
                    break;
                }
                default: {
                    this.camera = new Camera();
                    this.camera.rotateView(-0.2617993877991494, 1.0, 0.0, 0.0);
                    this.camera.rotateView(0.4363323129985824, 0.0, 1.0, 0.0);
                }
            }
            this.repaintPlot(false);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL2 gL2 = (GL2)gLAutoDrawable.getGL();
            this.glu = new GLU();
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            double d = 1.0;
            if (FloatWindowPlot3D.this.getKeepAspectRatio()) {
                if (n4 > n3) {
                    gL2.glViewport(n, n2 + (n4 - n3) / 2, n3, n3);
                } else {
                    d = (double)n3 / (double)n4;
                }
            }
            this.glu.gluPerspective(29.0, d, 1.0, 20.0);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            gL2.glGetDoublev(2983, this.projectTransf, 0);
            gL2.glGetIntegerv(2978, this.viewPort, 0);
            this.realViewHeight = n4;
        }

        public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
            randomOutputStream.writePropertyBoolean("save", true);
            randomOutputStream.writePropertyFloat("tfX", this.transfX);
            randomOutputStream.writePropertyFloat("tfY", this.transfY);
            randomOutputStream.writePropertyFloat("tfZ", this.transfZ);
            if (this.camera == null && this.mapProperty != null) {
                try {
                    this.camera = new Camera(this.mapProperty);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.camera != null) {
                this.camera.SaveProperty(randomOutputStream);
            }
        }

        public void setCanRotate(boolean bl) {
            this.canrotate = bl;
        }

        public void translateToPlot(int n, int n2, int n3, double[] dArray) {
            this.translateToPlot(n, n2, n3, dArray, FloatWindowPlot3D.this.getRange(0, 0), FloatWindowPlot3D.this.getRange(1, 0), FloatWindowPlot3D.this.getRange(2, 0));
        }

        public void translateToPlot(int n, int n2, int n3, double[] dArray, AxisRange axisRange, AxisRange axisRange2, AxisRange axisRange3) {
            if (this.glu == null) {
                return;
            }
            this.glu.gluUnProject((double)n, (double)(this.realViewHeight - n2), (double)n3 * 0.001, this.viewTransf, 0, this.projectTransf, 0, this.viewPort, 0, dArray, 0);
            dArray[0] = axisRange.transform(dArray[0] + 0.5);
            dArray[1] = axisRange2.transform(dArray[1] + 0.5);
            dArray[2] = axisRange3.transform(dArray[2] + 0.5);
        }

        public void translateToScreenInt(double d, double d2, double d3, int[] nArray) {
            this.translateToScreenInt(d, d2, d3, nArray, FloatWindowPlot3D.this.getRange(0, 0), FloatWindowPlot3D.this.getRange(1, 0), FloatWindowPlot3D.this.getRange(2, 0));
        }

        public void translateToScreenInt(double d, double d2, double d3, int[] nArray, AxisRange axisRange, AxisRange axisRange2, AxisRange axisRange3) {
            if (this.glu == null) {
                return;
            }
            double[] dArray = new double[3];
            if (axisRange.getAbs() > 0.0) {
                dArray[0] = axisRange.invTransform(d) - 0.5;
            }
            if (axisRange2.getAbs() > 0.0) {
                dArray[1] = axisRange2.invTransform(d2) - 0.5;
            }
            if (axisRange3.getAbs() > 0.0) {
                dArray[2] = axisRange3.invTransform(d3) - 0.5;
            }
            double[] dArray2 = new double[3];
            this.glu.gluProject(dArray[0], dArray[1], dArray[2], this.viewTransf, 0, this.projectTransf, 0, this.viewPort, 0, dArray2, 0);
            nArray[0] = (int)dArray2[0];
            nArray[1] = this.realViewHeight - (int)dArray2[1];
            nArray[2] = (int)(dArray2[2] * 1000.0);
        }

        @Override
        protected void cleanUpChild() {
            this.glut = null;
            this.glu = null;
            if (this.camera != null) {
                this.camera.cleanUp();
                this.camera = null;
            }
            if (FloatWindowPlot3D.this.plot3DToolbar != null) {
                FloatWindowPlot3D.this.plot3DToolbar.cleanUp();
                FloatWindowPlot3D.this.plot3DToolbar = null;
            }
        }

        protected void enableLights(GL gL, boolean bl) {
            if (!FloatWindowPlot3D.this.wireframe && bl) {
                gL.glEnable(2896);
                gL.glEnable(16384);
                gL.glEnable(2903);
            } else {
                gL.glDisable(2896);
                gL.glDisable(16384);
                gL.glDisable(2903);
            }
        }

        protected abstract void localInit(GL2 var1, GLU var2);

        protected void paint(GL2 gL2, GLU gLU, GLUT gLUT) {
            this.enableLights((GL)gL2, false);
            gL2.glEnable(3042);
            if (FloatWindowPlot3D.this.showGrid()) {
                this.drawGrid(gL2);
            }
            if (FloatWindowPlot3D.this.showZeroLines()) {
                this.drawZeroLine(gL2);
            }
            gL2.glDisable(3042);
            this.enableLights((GL)gL2, FloatWindowPlot3D.this.lightsEnabled());
        }

        private void drawRubberBox(GL2 gL2) {
            float[][] fArray = new float[4][3];
            float[][] fArrayArray = new float[][]{{this.rubberCoords[0][0], this.rubberCoords[0][1]}, {this.rubberCoords[1][0], this.rubberCoords[0][1]}, {this.rubberCoords[1][0], this.rubberCoords[1][1]}, {this.rubberCoords[0][0], this.rubberCoords[1][1]}};
            this.axisBox.boxCoordToWorld(fArray[0], fArrayArray[0], this.selectedBoxSide);
            this.axisBox.boxCoordToWorld(fArray[1], fArrayArray[1], this.selectedBoxSide);
            this.axisBox.boxCoordToWorld(fArray[2], fArrayArray[2], this.selectedBoxSide);
            this.axisBox.boxCoordToWorld(fArray[3], fArrayArray[3], this.selectedBoxSide);
            this.enableLights((GL)gL2, false);
            gL2.glColor3f(0.0f, 0.0f, 0.0f);
            gL2.glEnable(2852);
            gL2.glLineStipple(2, (short)240);
            gL2.glBegin(2);
            gL2.glVertex3fv(fArray[0], 0);
            gL2.glVertex3fv(fArray[1], 0);
            gL2.glVertex3fv(fArray[2], 0);
            gL2.glVertex3fv(fArray[3], 0);
            gL2.glEnd();
            gL2.glLineStipple(1, (short)192);
            if (this.selectedBoxSide == 0 || this.selectedBoxSide == 1) {
                gL2.glBegin(2);
                gL2.glVertex3f(fArray[0][0], fArray[0][1], -fArray[0][2]);
                gL2.glVertex3f(fArray[1][0], fArray[1][1], -fArray[1][2]);
                gL2.glVertex3f(fArray[2][0], fArray[2][1], -fArray[2][2]);
                gL2.glVertex3f(fArray[3][0], fArray[3][1], -fArray[3][2]);
                gL2.glEnd();
                gL2.glBegin(1);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], fArray[0][1], -fArray[0][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(fArray[1][0], fArray[1][1], -fArray[1][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(fArray[2][0], fArray[2][1], -fArray[2][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(fArray[3][0], fArray[3][1], -fArray[3][2]);
                gL2.glEnd();
                gL2.glColor4f(1.0f, 1.0f, 0.5f, 0.5f);
                gL2.glBegin(5);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], fArray[0][1], -fArray[0][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(fArray[1][0], fArray[1][1], -fArray[1][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(fArray[2][0], fArray[2][1], -fArray[2][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(fArray[3][0], fArray[3][1], -fArray[3][2]);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], fArray[0][1], -fArray[0][2]);
                gL2.glEnd();
                gL2.glColor4f(0.5f, 0.5f, 1.0f, 0.5f);
                gL2.glBegin(5);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], fArray[0][1], -fArray[0][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(fArray[3][0], fArray[3][1], -fArray[3][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(fArray[2][0], fArray[2][1], -fArray[2][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(fArray[1][0], fArray[1][1], -fArray[1][2]);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], fArray[0][1], -fArray[0][2]);
                gL2.glEnd();
            } else if (this.selectedBoxSide == 2 || this.selectedBoxSide == 3) {
                gL2.glBegin(2);
                gL2.glVertex3f(-fArray[0][0], fArray[0][1], fArray[0][2]);
                gL2.glVertex3f(-fArray[1][0], fArray[1][1], fArray[1][2]);
                gL2.glVertex3f(-fArray[2][0], fArray[2][1], fArray[2][2]);
                gL2.glVertex3f(-fArray[3][0], fArray[3][1], fArray[3][2]);
                gL2.glEnd();
                gL2.glBegin(1);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(-fArray[0][0], fArray[0][1], fArray[0][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(-fArray[1][0], fArray[1][1], fArray[1][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(-fArray[2][0], fArray[2][1], fArray[2][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(-fArray[3][0], fArray[3][1], fArray[3][2]);
                gL2.glEnd();
                gL2.glColor4f(1.0f, 1.0f, 0.5f, 0.5f);
                gL2.glBegin(5);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(-fArray[0][0], fArray[0][1], fArray[0][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(-fArray[1][0], fArray[1][1], fArray[1][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(-fArray[2][0], fArray[2][1], fArray[2][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(-fArray[3][0], fArray[3][1], fArray[3][2]);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(-fArray[0][0], fArray[0][1], fArray[0][2]);
                gL2.glEnd();
                gL2.glColor4f(0.5f, 0.5f, 1.0f, 0.5f);
                gL2.glBegin(5);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(-fArray[0][0], fArray[0][1], fArray[0][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(-fArray[3][0], fArray[3][1], fArray[3][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(-fArray[2][0], fArray[2][1], fArray[2][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(-fArray[1][0], fArray[1][1], fArray[1][2]);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(-fArray[0][0], fArray[0][1], fArray[0][2]);
                gL2.glEnd();
            } else {
                gL2.glBegin(2);
                gL2.glVertex3f(fArray[0][0], -fArray[0][1], fArray[0][2]);
                gL2.glVertex3f(fArray[1][0], -fArray[1][1], fArray[1][2]);
                gL2.glVertex3f(fArray[2][0], -fArray[2][1], fArray[2][2]);
                gL2.glVertex3f(fArray[3][0], -fArray[3][1], fArray[3][2]);
                gL2.glEnd();
                gL2.glBegin(1);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], -fArray[0][1], fArray[0][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(fArray[1][0], -fArray[1][1], fArray[1][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(fArray[2][0], -fArray[2][1], fArray[2][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(fArray[3][0], -fArray[3][1], fArray[3][2]);
                gL2.glEnd();
                gL2.glColor4f(1.0f, 1.0f, 0.5f, 0.5f);
                gL2.glBegin(5);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], -fArray[0][1], fArray[0][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(fArray[1][0], -fArray[1][1], fArray[1][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(fArray[2][0], -fArray[2][1], fArray[2][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(fArray[3][0], -fArray[3][1], fArray[3][2]);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], -fArray[0][1], fArray[0][2]);
                gL2.glEnd();
                gL2.glColor4f(0.5f, 0.5f, 1.0f, 0.5f);
                gL2.glBegin(5);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], -fArray[0][1], fArray[0][2]);
                gL2.glVertex3fv(fArray[3], 0);
                gL2.glVertex3f(fArray[3][0], -fArray[3][1], fArray[3][2]);
                gL2.glVertex3fv(fArray[2], 0);
                gL2.glVertex3f(fArray[2][0], -fArray[2][1], fArray[2][2]);
                gL2.glVertex3fv(fArray[1], 0);
                gL2.glVertex3f(fArray[1][0], -fArray[1][1], fArray[1][2]);
                gL2.glVertex3fv(fArray[0], 0);
                gL2.glVertex3f(fArray[0][0], -fArray[0][1], fArray[0][2]);
                gL2.glEnd();
            }
            gL2.glDisable(2852);
            this.enableLights((GL)gL2, FloatWindowPlot3D.this.lightsEnabled());
        }

        private void panView(MouseEvent mouseEvent) {
            if (this.selectedBoxSide >= 0) {
                this.sideHit(mouseEvent.getX(), mouseEvent.getY(), this.rubberCoords[1], this.selectedBoxSide);
                float[] fArray = new float[3];
                float[] fArray2 = new float[3];
                this.axisBox.getExtents(this.rubberCoords[0], this.rubberCoords[1], this.selectedBoxSide, fArray, fArray2);
                float[] fArray3 = MatrixFuncs.minus(fArray, fArray2);
                FloatWindowPlot3D.this.getRange(0, 0).pan(FloatWindowPlot3D.this.getRange(0, 0).scale(fArray3[0]));
                FloatWindowPlot3D.this.getRange(1, 0).pan(FloatWindowPlot3D.this.getRange(1, 0).scale(fArray3[1]));
                FloatWindowPlot3D.this.getRange(2, 0).pan(FloatWindowPlot3D.this.getRange(2, 0).scale(fArray3[2]));
                this.rubberCoords[0][0] = this.rubberCoords[1][0];
                this.rubberCoords[0][1] = this.rubberCoords[1][1];
                FloatWindowPlot3D.this.calculateAndRepaintSetAxis(true, false);
            }
        }

        private void rotateView(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            float f = (float)(n - this.prevMouseX) / (float)FloatWindowPlot3D.this.getSize().width;
            float f2 = (float)(n2 - this.prevMouseY) / (float)FloatWindowPlot3D.this.getSize().height;
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.transfZ += Math.abs(f) > Math.abs(f2) ? f : f2;
                } else {
                    this.transfX += f;
                    this.transfY -= f2;
                }
            } else {
                FloatWindowPlot3D.this.isrotate = true;
                this.camera.rotateByMouse(180.0f * f, 180.0f * f2);
            }
            this.prevMouseX = n;
            this.prevMouseY = n2;
            this.repaintPlot(false);
            mouseEvent.consume();
        }

        private int sideHit(int n, int n2, float[] fArray, int n3) {
            if (this.glu == null) {
                return -1;
            }
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            int n4 = this.realViewHeight - n2;
            this.glu.gluUnProject((double)n, (double)n4, 0.0, this.viewTransf, 0, this.projectTransf, 0, this.viewPort, 0, dArray, 0);
            this.glu.gluUnProject((double)n, (double)n4, 1.0, this.viewTransf, 0, this.projectTransf, 0, this.viewPort, 0, dArray2, 0);
            float[] fArray2 = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2]};
            float[] fArray3 = new float[]{(float)(dArray2[0] - dArray[0]), (float)(dArray2[1] - dArray[1]), (float)(dArray2[2] - dArray[2])};
            return this.axisBox.sideHit(fArray2, fArray3, n3, fArray);
        }

        private void zoomView(MouseEvent mouseEvent) {
            int n;
            int n2 = switch (this.selectedBoxSide) {
                case 0, 1 -> {
                    n = 0;
                    yield 2;
                }
                case 2, 3 -> {
                    n = 1;
                    yield 2;
                }
                default -> {
                    n = 0;
                    yield 1;
                }
            };
            AxisRange axisRange = FloatWindowPlot3D.this.getRange(n, 0);
            AxisRange axisRange2 = FloatWindowPlot3D.this.getRange(n2, 0);
            if (this.zoomtype == 1) {
                axisRange.zoom(-0.1);
                axisRange2.zoom(-0.1);
            } else {
                axisRange.zoom(0.1);
                axisRange2.zoom(0.1);
            }
        }

        private void zoomViewBegun(MouseEvent mouseEvent) {
            if (this.selectedBoxSide >= 0 && this.sideHit(mouseEvent.getX(), mouseEvent.getY(), this.rubberCoords[1], this.selectedBoxSide) < 0) {
                if (this.rubberCoords[1][0] < 0.0f) {
                    this.rubberCoords[1][0] = 0.0f;
                } else if (this.rubberCoords[1][0] > 1.0f) {
                    this.rubberCoords[1][0] = 1.0f;
                }
                if (this.rubberCoords[1][1] < 0.0f) {
                    this.rubberCoords[1][1] = 0.0f;
                } else if (this.rubberCoords[1][1] > 1.0f) {
                    this.rubberCoords[1][1] = 1.0f;
                }
            }
            this.repaintPlot(false);
            mouseEvent.consume();
        }

        private void zoomViewEnded(MouseEvent mouseEvent) {
            float[] fArray = new float[3];
            float[] fArray2 = new float[3];
            this.axisBox.getExtents(this.rubberCoords[0], this.rubberCoords[1], this.selectedBoxSide, fArray, fArray2);
            for (int i = 0; i < 3; ++i) {
                if (fArray[i] > fArray2[i]) {
                    float f = fArray[i];
                    fArray[i] = fArray2[i];
                    fArray2[i] = f;
                    continue;
                }
                if (!((double)Math.abs(fArray[i] - fArray2[i]) < 0.01)) continue;
                fArray[i] = 0.0f;
                fArray2[i] = 1.0f;
            }
            FloatWindowPlot3D.this.getRange(0, 0).setMinMaxFromCoords(fArray[0], fArray2[0]);
            FloatWindowPlot3D.this.getRange(1, 0).setMinMaxFromCoords(fArray[1], fArray2[1]);
            FloatWindowPlot3D.this.getRange(2, 0).setMinMaxFromCoords(fArray[2], fArray2[2]);
            this.drawRubberBox = false;
        }
    }
}

